/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.features.implementation.conservation;

import com.univocity.parsers.tsv.TsvParser;
import com.univocity.parsers.tsv.TsvParserSettings;
import cz.siret.prank.domain.Protein;
import cz.siret.prank.domain.Residue;
import cz.siret.prank.domain.labeling.ResidueLabeling;
import cz.siret.prank.features.implementation.conservation.ResidueNumberWrapper;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import cz.siret.prank.utils.Futils;
import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.Structure;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConservationScore
implements Parametrized,
GroovyObject {
    public static final String CONSERV_LOADED_KEY = "CONSERVATION_LOADED";
    public static final String CONSERV_SCORE_KEY = "CONSERVATION_SCORE";
    public static final String CONSERV_PATH_FUNCTION_KEY = "CONSERVATION_PATH_FUNCTION";
    private Map<ResidueNumberWrapper, Double> scores;
    private final transient Logger logger;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    private ConservationScore(Map<ResidueNumberWrapper, Double> scores) {
        MetaClass metaClass;
        CallSite[] callSiteArray = ConservationScore.$getCallSiteArray();
        Object object = callSiteArray[0].call(LoggerFactory.class, callSiteArray[1].callCurrent((GroovyObject)this));
        this.logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        callSiteArray[2].call(Parametrized.Trait.Helper.class, (Object)this);
        Map<ResidueNumberWrapper, Double> map = scores;
        this.scores = (Map)ScriptBytecodeAdapter.castToType(map, Map.class);
    }

    public static String scoreFileForPdbFile(String fileName, String chainId, String origin) {
        CallSite[] callSiteArray = ConservationScore.$getCallSiteArray();
        String baseName = null;
        String extension = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call((Object)fileName, (Object)".pdb.gz")) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call((Object)fileName, (Object)"ent.gz"))) {
            Object object = callSiteArray[5].call((Object)fileName, (Object)0, callSiteArray[6].call(callSiteArray[7].call((Object)fileName), (Object)7));
            baseName = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[8].call((Object)fileName, callSiteArray[9].call(callSiteArray[10].call((Object)fileName), (Object)7));
            extension = ShortTypeHandling.castToString((Object)object2);
        } else {
            int dotIndex = DefaultTypeTransformation.intUnbox((Object)callSiteArray[11].call((Object)fileName, (Object)"."));
            Object object = callSiteArray[12].call((Object)fileName, (Object)0, (Object)dotIndex);
            baseName = ShortTypeHandling.castToString((Object)object);
            Object object3 = callSiteArray[13].call((Object)fileName, (Object)dotIndex);
            extension = ShortTypeHandling.castToString((Object)object3);
            Object object4 = callSiteArray[14].call((Object)baseName, (Object)0, (Object)4);
            baseName = ShortTypeHandling.castToString((Object)object4);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[15].call(callSiteArray[16].call(callSiteArray[17].call(callSiteArray[18].call((Object)baseName, (Object)chainId), (Object)"."), (Object)origin), (Object)".hom.gz"));
    }

    public double getScoreForResidue(ResidueNumber residueNum) {
        CallSite[] callSiteArray = ConservationScore.$getCallSiteArray();
        return DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[19].callCurrent((GroovyObject)this, callSiteArray[20].callConstructor(ResidueNumberWrapper.class, (Object)residueNum)));
    }

    public double getScoreForResidue(ResidueNumberWrapper residueNum) {
        CallSite[] callSiteArray = ConservationScore.$getCallSiteArray();
        Double res = (Double)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].call(this.scores, (Object)residueNum), Double.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)res, null)) {
            return 0.0;
        }
        return DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[22].call((Object)res));
    }

    public ResidueLabeling<Double> toDoubleLabeling(Protein p) {
        CallSite[] callSiteArray = ConservationScore.$getCallSiteArray();
        ResidueLabeling labeling = (ResidueLabeling)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].callConstructor(ResidueLabeling.class, callSiteArray[24].call(callSiteArray[25].callGroovyObjectGetProperty((Object)p))), ResidueLabeling.class);
        Residue r = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[26].call(callSiteArray[27].callGroovyObjectGetProperty((Object)p)), Iterator.class);
        while (iterator.hasNext()) {
            r = (Residue)ScriptBytecodeAdapter.castToType(iterator.next(), Residue.class);
            callSiteArray[28].call((Object)labeling, (Object)r, callSiteArray[29].callCurrent((GroovyObject)this, callSiteArray[30].callGroovyObjectGetProperty((Object)r)));
        }
        return labeling;
    }

    public Map<ResidueNumberWrapper, Double> getScoreMap() {
        CallSite[] callSiteArray = ConservationScore.$getCallSiteArray();
        return this.scores;
    }

    public int size() {
        CallSite[] callSiteArray = ConservationScore.$getCallSiteArray();
        return DefaultTypeTransformation.intUnbox((Object)callSiteArray[31].call(this.scores));
    }

    private static List<AA> loadScoreFile(File scoreFile, ScoreFormat format) {
        CallSite[] callSiteArray = ConservationScore.$getCallSiteArray();
        TsvParserSettings settings = (TsvParserSettings)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].callConstructor(TsvParserSettings.class), TsvParserSettings.class);
        callSiteArray[33].call((Object)settings, (Object)true);
        TsvParser parser = (TsvParser)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].callConstructor(TsvParser.class, (Object)settings), TsvParser.class);
        List lines = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].call((Object)parser, callSiteArray[36].call(Futils.class, (Object)scoreFile)), List.class);
        List result = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].callConstructor(ArrayList.class, callSiteArray[38].call((Object)lines)), List.class);
        String[] line = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].call((Object)lines), Iterator.class);
        while (iterator.hasNext()) {
            double d;
            line = (String[])ScriptBytecodeAdapter.castToType(iterator.next(), String[].class);
            int index = -1;
            double score = 0.0;
            String letter = "-";
            ScoreFormat scoreFormat = format;
            if (ScriptBytecodeAdapter.isCase((Object)((Object)scoreFormat), (Object)callSiteArray[40].callGetProperty(ScoreFormat.class))) {
                Object object = callSiteArray[41].call(Integer.class, callSiteArray[42].call((Object)line, (Object)0));
                index = DefaultTypeTransformation.intUnbox((Object)object);
                Object object2 = callSiteArray[43].call((Object)line, (Object)1);
                letter = ShortTypeHandling.castToString((Object)object2);
                Object object3 = callSiteArray[44].call(Double.class, callSiteArray[45].call((Object)line, (Object)2));
                score = DefaultTypeTransformation.doubleUnbox((Object)object3);
            } else if (ScriptBytecodeAdapter.isCase((Object)((Object)scoreFormat), (Object)callSiteArray[46].callGetProperty(ScoreFormat.class))) {
                Object object = callSiteArray[47].call(Integer.class, callSiteArray[48].call((Object)line, (Object)0));
                index = DefaultTypeTransformation.intUnbox((Object)object);
                Object object4 = callSiteArray[49].call(Double.class, callSiteArray[50].call((Object)line, (Object)1));
                score = DefaultTypeTransformation.doubleUnbox((Object)object4);
                Object object5 = callSiteArray[51].call(callSiteArray[52].call((Object)line, (Object)2), (Object)0, (Object)1);
                letter = ShortTypeHandling.castToString((Object)object5);
            }
            score = d = score < 0.0 ? 0.0 : score;
            if (!ScriptBytecodeAdapter.compareNotEqual((Object)letter, (Object)"-")) continue;
            callSiteArray[53].call((Object)result, callSiteArray[54].callConstructor(AA.class, (Object)letter, (Object)score, (Object)index));
        }
        return result;
    }

    public static ConservationScore fromFiles(Structure structure, Function<String, File> scoresFiles) throws FileNotFoundException {
        CallSite[] callSiteArray = ConservationScore.$getCallSiteArray();
        return (ConservationScore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].callStatic(ConservationScore.class, (Object)structure, scoresFiles, callSiteArray[56].callGetProperty(ScoreFormat.class)), ConservationScore.class);
    }

    public static void matchSequences(List<Group> chain, List<AA> chainScores, Map<ResidueNumberWrapper, Double> outResult) {
        CallSite[] callSiteArray = ConservationScore.$getCallSiteArray();
        public final class _matchSequences_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _matchSequences_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _matchSequences_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object ch) {
                CallSite[] callSiteArray = _matchSequences_closure1.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(ch)));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _matchSequences_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "toUpperCase";
                stringArray[1] = "getOne_letter_code";
                stringArray[2] = "getChemComp";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _matchSequences_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_matchSequences_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _matchSequences_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        String pdbChain = ShortTypeHandling.castToString((Object)callSiteArray[57].call(callSiteArray[58].call(callSiteArray[59].call(chain), (Object)new _matchSequences_closure1(ConservationScore.class, ConservationScore.class)), callSiteArray[60].call(Collectors.class)));
        public final class _matchSequences_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _matchSequences_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _matchSequences_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object ch) {
                CallSite[] callSiteArray = _matchSequences_closure2.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(ch));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _matchSequences_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "toUpperCase";
                stringArray[1] = "letter";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _matchSequences_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_matchSequences_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _matchSequences_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        String scoreChain = ShortTypeHandling.castToString((Object)callSiteArray[61].call(callSiteArray[62].call(callSiteArray[63].call(chainScores), (Object)new _matchSequences_closure2(ConservationScore.class, ConservationScore.class)), callSiteArray[64].call(Collectors.class)));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[65].call((Object)pdbChain, (Object)scoreChain))) {
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                int i = 0;
                while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[66].call(chainScores))) {
                    callSiteArray[67].call(outResult, callSiteArray[68].callConstructor(ResidueNumberWrapper.class, callSiteArray[69].call(callSiteArray[70].call(chain, (Object)i))), callSiteArray[71].callGetProperty(callSiteArray[72].call(chainScores, (Object)i)));
                    int n = i;
                    i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[73].call((Object)n));
                }
            } else {
                int i = 0;
                while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[74].call(chainScores))) {
                    callSiteArray[75].call(outResult, callSiteArray[76].callConstructor(ResidueNumberWrapper.class, callSiteArray[77].call(callSiteArray[78].call(chain, (Object)i))), callSiteArray[79].callGetProperty(callSiteArray[80].call(chainScores, (Object)i)));
                    int n = i;
                    int cfr_ignored_0 = n + 1;
                }
            }
            return;
        }
        callSiteArray[81].call((Object)log, (Object)"Matching chains using LCS");
        int[][] lcs = (int[][])ScriptBytecodeAdapter.castToType((Object)callSiteArray[82].callStatic(ConservationScore.class, chain, chainScores), int[][].class);
        int i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[83].call(chain));
        int j = DefaultTypeTransformation.intUnbox((Object)callSiteArray[84].call(chainScores));
        while (i > 0 && j > 0) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[85].call(callSiteArray[86].call(callSiteArray[87].call(callSiteArray[88].call(callSiteArray[89].call(chain, callSiteArray[90].call((Object)i, (Object)1))))), callSiteArray[91].call(callSiteArray[92].callGetProperty(callSiteArray[93].call(chainScores, callSiteArray[94].call((Object)j, (Object)1))))))) {
                callSiteArray[95].call(outResult, callSiteArray[96].callConstructor(ResidueNumberWrapper.class, callSiteArray[97].call(callSiteArray[98].call(chain, callSiteArray[99].call((Object)i, (Object)1)))), callSiteArray[100].callGetProperty(callSiteArray[101].call(chainScores, callSiteArray[102].call((Object)j, (Object)1))));
                int n = i;
                i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[103].call((Object)n));
                int n2 = j;
                j = DefaultTypeTransformation.intUnbox((Object)callSiteArray[104].call((Object)n2));
                continue;
            }
            if (DefaultTypeTransformation.intUnbox((Object)callSiteArray[105].call(callSiteArray[106].call((Object)lcs, (Object)i), callSiteArray[107].call((Object)j, (Object)1))) > DefaultTypeTransformation.intUnbox((Object)callSiteArray[108].call(callSiteArray[109].call((Object)lcs, callSiteArray[110].call((Object)i, (Object)1)), (Object)j))) {
                int n = j;
                j = DefaultTypeTransformation.intUnbox((Object)callSiteArray[111].call((Object)n));
                continue;
            }
            int n = i;
            i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[112].call((Object)n));
        }
    }

    public static int[][] calcLongestCommonSubSequence(List<Group> chain, List<AA> chainScores) {
        CallSite[] callSiteArray = ConservationScore.$getCallSiteArray();
        int[][] lcs = new int[DefaultTypeTransformation.intUnbox((Object)callSiteArray[113].call(callSiteArray[114].call(chain), (Object)1))][DefaultTypeTransformation.intUnbox((Object)callSiteArray[115].call(callSiteArray[116].call(chainScores), (Object)1))];
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            int i = 0;
            while (ScriptBytecodeAdapter.compareLessThanEqual((Object)i, (Object)callSiteArray[117].call(chain))) {
                int n = 0;
                callSiteArray[118].call(callSiteArray[119].call((Object)lcs, (Object)i), (Object)0, (Object)n);
                int n2 = i;
                i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[120].call((Object)n2));
            }
        } else {
            int i = 0;
            while (ScriptBytecodeAdapter.compareLessThanEqual((Object)i, (Object)callSiteArray[121].call(chain))) {
                int n = 0;
                BytecodeInterface8.intArraySet((int[])((int[])ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])lcs, (int)i), int[].class)), (int)0, (int)n);
                int n3 = i;
                int cfr_ignored_0 = n3 + 1;
            }
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            int j = 0;
            while (ScriptBytecodeAdapter.compareLessThanEqual((Object)j, (Object)callSiteArray[122].call(chainScores))) {
                int n = 0;
                callSiteArray[123].call(callSiteArray[124].call((Object)lcs, (Object)0), (Object)j, (Object)n);
                int n4 = j;
                j = DefaultTypeTransformation.intUnbox((Object)callSiteArray[125].call((Object)n4));
            }
        } else {
            int j = 0;
            while (ScriptBytecodeAdapter.compareLessThanEqual((Object)j, (Object)callSiteArray[126].call(chainScores))) {
                int n = 0;
                BytecodeInterface8.intArraySet((int[])((int[])ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])lcs, (int)0), int[].class)), (int)j, (int)n);
                int n5 = j;
                int cfr_ignored_1 = n5 + 1;
            }
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            int i = 1;
            while (ScriptBytecodeAdapter.compareLessThanEqual((Object)i, (Object)callSiteArray[127].call(chain))) {
                int j = 1;
                while (ScriptBytecodeAdapter.compareLessThanEqual((Object)j, (Object)callSiteArray[128].call(chainScores))) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[129].call(callSiteArray[130].call(callSiteArray[131].call(callSiteArray[132].call(callSiteArray[133].call(chain, callSiteArray[134].call((Object)i, (Object)1))))), callSiteArray[135].call(callSiteArray[136].callGetProperty(callSiteArray[137].call(chainScores, callSiteArray[138].call((Object)j, (Object)1))))))) {
                        Object object = callSiteArray[139].call(callSiteArray[140].call(callSiteArray[141].call((Object)lcs, callSiteArray[142].call((Object)i, (Object)1)), callSiteArray[143].call((Object)j, (Object)1)), (Object)1);
                        callSiteArray[144].call(callSiteArray[145].call((Object)lcs, (Object)i), (Object)j, object);
                    } else {
                        Object object = callSiteArray[146].call(Math.class, callSiteArray[147].call(callSiteArray[148].call((Object)lcs, callSiteArray[149].call((Object)i, (Object)1)), (Object)j), callSiteArray[150].call(callSiteArray[151].call((Object)lcs, (Object)i), callSiteArray[152].call((Object)j, (Object)1)));
                        callSiteArray[153].call(callSiteArray[154].call((Object)lcs, (Object)i), (Object)j, object);
                    }
                    int n = j;
                    j = DefaultTypeTransformation.intUnbox((Object)callSiteArray[155].call((Object)n));
                }
                int n = i;
                i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[156].call((Object)n));
            }
        } else {
            int i = 1;
            while (ScriptBytecodeAdapter.compareLessThanEqual((Object)i, (Object)callSiteArray[157].call(chain))) {
                int j = 1;
                while (ScriptBytecodeAdapter.compareLessThanEqual((Object)j, (Object)callSiteArray[158].call(chainScores))) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[159].call(callSiteArray[160].call(callSiteArray[161].call(callSiteArray[162].call(callSiteArray[163].call(chain, (Object)(i - 1))))), callSiteArray[164].call(callSiteArray[165].callGetProperty(callSiteArray[166].call(chainScores, (Object)(j - 1))))))) {
                        int n = BytecodeInterface8.intArrayGet((int[])((int[])ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])lcs, (int)(i - 1)), int[].class)), (int)(j - 1)) + 1;
                        BytecodeInterface8.intArraySet((int[])((int[])ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])lcs, (int)i), int[].class)), (int)j, (int)n);
                    } else {
                        Object object = callSiteArray[167].call(Math.class, (Object)BytecodeInterface8.intArrayGet((int[])((int[])ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])lcs, (int)(i - 1)), int[].class)), (int)j), (Object)BytecodeInterface8.intArrayGet((int[])((int[])ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])lcs, (int)i), int[].class)), (int)(j - 1)));
                        BytecodeInterface8.intArraySet((int[])((int[])ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])lcs, (int)i), int[].class)), (int)j, (int)DefaultTypeTransformation.intUnbox((Object)object));
                    }
                    int n = j;
                    int cfr_ignored_2 = n + 1;
                }
                int n = i;
                int cfr_ignored_3 = n + 1;
            }
        }
        return lcs;
    }

    public static ConservationScore fromFiles(Structure structure, Function<String, File> scoreFiles, ScoreFormat format) throws FileNotFoundException {
        CallSite[] callSiteArray = ConservationScore.$getCallSiteArray();
        Map scores = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[168].callConstructor(HashMap.class), Map.class);
        Chain chain = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[169].call(callSiteArray[170].call((Object)structure)), Iterator.class);
        while (iterator.hasNext()) {
            String string;
            chain = (Chain)ScriptBytecodeAdapter.castToType(iterator.next(), Chain.class);
            if (ScriptBytecodeAdapter.compareLessThanEqual((Object)callSiteArray[171].call(callSiteArray[172].call((Object)chain, callSiteArray[173].callGetProperty(GroupType.class))), (Object)0)) continue;
            String chainId = ShortTypeHandling.castToString((Object)callSiteArray[174].call((Object)chain));
            chainId = string = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[175].call(callSiteArray[176].call((Object)chainId))) ? "A" : chainId;
            List chainScores = null;
            try {
                File scoreFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[177].call(scoreFiles, (Object)chainId), File.class);
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[178].call((Object)scoreFile))) {
                    Object object = callSiteArray[179].call(ConservationScore.class, (Object)scoreFile, (Object)format);
                    chainScores = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
                } else {
                    callSiteArray[180].call((Object)log, (Object)"Score file doesn't exist [{}]", (Object)scoreFile);
                }
                public final class _fromFiles_closure3
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _fromFiles_closure3(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _fromFiles_closure3.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _fromFiles_closure3.$getCallSiteArray();
                        return new GStringImpl(new Object[]{callSiteArray[0].callGetProperty(it), callSiteArray[1].callGetProperty(it), callSiteArray[2].callGetProperty(it)}, new String[]{"", " ", " ", ""});
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _fromFiles_closure3.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _fromFiles_closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "index";
                        stringArray[1] = "letter";
                        stringArray[2] = "score";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[3];
                        _fromFiles_closure3.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_fromFiles_closure3.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _fromFiles_closure3.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[181].call((Object)log)) ? callSiteArray[182].call((Object)log, callSiteArray[183].call((Object)"loaded chain scores:\n", callSiteArray[184].call(callSiteArray[185].call((Object)chainScores, (Object)new _fromFiles_closure3(ConservationScore.class, ConservationScore.class)), (Object)"\n"))) : null;
                callSiteArray[186].callStatic(ConservationScore.class, callSiteArray[187].call((Object)chain, callSiteArray[188].callGetProperty(GroupType.class)), (Object)chainScores, (Object)scores);
            }
            catch (Exception e) {
                callSiteArray[189].call((Object)log, (Object)"Failed to load conservation file.", (Object)e);
            }
        }
        return (ConservationScore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[190].callConstructor(ConservationScore.class, (Object)scores), ConservationScore.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ConservationScore.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        CallSite[] callSiteArray = ConservationScore.$getCallSiteArray();
        return (Params)ScriptBytecodeAdapter.castToType((Object)callSiteArray[191].call(Parametrized.Trait.Helper.class, (Object)this), Params.class);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        CallSite[] callSiteArray = ConservationScore.$getCallSiteArray();
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)callSiteArray[192].callStatic(InvokerHelper.class, callSiteArray[193].call((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class))), (Object)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        Object object = ConservationScore.$getCallSiteArray()[194].call(LoggerFactory.class, (Object)"cz.siret.prank.features.implementation.conservation.ConservationScore");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        Parametrized.Trait.Helper.$static$init$(ConservationScore.class);
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = ConservationScore.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ConservationScore.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = ConservationScore.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ConservationScore.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = ConservationScore.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ConservationScore.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getLogger";
        stringArray[1] = "getClass";
        stringArray[2] = "$init$";
        stringArray[3] = "endsWith";
        stringArray[4] = "endsWith";
        stringArray[5] = "substring";
        stringArray[6] = "minus";
        stringArray[7] = "length";
        stringArray[8] = "substring";
        stringArray[9] = "minus";
        stringArray[10] = "length";
        stringArray[11] = "lastIndexOf";
        stringArray[12] = "substring";
        stringArray[13] = "substring";
        stringArray[14] = "substring";
        stringArray[15] = "plus";
        stringArray[16] = "plus";
        stringArray[17] = "plus";
        stringArray[18] = "plus";
        stringArray[19] = "getScoreForResidue";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "get";
        stringArray[22] = "doubleValue";
        stringArray[23] = "<$constructor$>";
        stringArray[24] = "size";
        stringArray[25] = "residues";
        stringArray[26] = "iterator";
        stringArray[27] = "residues";
        stringArray[28] = "add";
        stringArray[29] = "getScoreForResidue";
        stringArray[30] = "residueNumber";
        stringArray[31] = "size";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "setLineSeparatorDetectionEnabled";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "parseAll";
        stringArray[36] = "inputStream";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "size";
        stringArray[39] = "iterator";
        stringArray[40] = "ConCavityFormat";
        stringArray[41] = "parseInt";
        stringArray[42] = "getAt";
        stringArray[43] = "getAt";
        stringArray[44] = "parseDouble";
        stringArray[45] = "getAt";
        stringArray[46] = "JSDFormat";
        stringArray[47] = "parseInt";
        stringArray[48] = "getAt";
        stringArray[49] = "parseDouble";
        stringArray[50] = "getAt";
        stringArray[51] = "substring";
        stringArray[52] = "getAt";
        stringArray[53] = "add";
        stringArray[54] = "<$constructor$>";
        stringArray[55] = "fromFiles";
        stringArray[56] = "JSDFormat";
        stringArray[57] = "collect";
        stringArray[58] = "map";
        stringArray[59] = "stream";
        stringArray[60] = "joining";
        stringArray[61] = "collect";
        stringArray[62] = "map";
        stringArray[63] = "stream";
        stringArray[64] = "joining";
        stringArray[65] = "equals";
        stringArray[66] = "size";
        stringArray[67] = "put";
        stringArray[68] = "<$constructor$>";
        stringArray[69] = "getResidueNumber";
        stringArray[70] = "get";
        stringArray[71] = "score";
        stringArray[72] = "get";
        stringArray[73] = "next";
        stringArray[74] = "size";
        stringArray[75] = "put";
        stringArray[76] = "<$constructor$>";
        stringArray[77] = "getResidueNumber";
        stringArray[78] = "get";
        stringArray[79] = "score";
        stringArray[80] = "get";
        stringArray[81] = "info";
        stringArray[82] = "calcLongestCommonSubSequence";
        stringArray[83] = "size";
        stringArray[84] = "size";
        stringArray[85] = "equals";
        stringArray[86] = "toUpperCase";
        stringArray[87] = "getOne_letter_code";
        stringArray[88] = "getChemComp";
        stringArray[89] = "get";
        stringArray[90] = "minus";
        stringArray[91] = "toUpperCase";
        stringArray[92] = "letter";
        stringArray[93] = "get";
        stringArray[94] = "minus";
        stringArray[95] = "put";
        stringArray[96] = "<$constructor$>";
        stringArray[97] = "getResidueNumber";
        stringArray[98] = "get";
        stringArray[99] = "minus";
        stringArray[100] = "score";
        stringArray[101] = "get";
        stringArray[102] = "minus";
        stringArray[103] = "previous";
        stringArray[104] = "previous";
        stringArray[105] = "getAt";
        stringArray[106] = "getAt";
        stringArray[107] = "minus";
        stringArray[108] = "getAt";
        stringArray[109] = "getAt";
        stringArray[110] = "minus";
        stringArray[111] = "previous";
        stringArray[112] = "previous";
        stringArray[113] = "plus";
        stringArray[114] = "size";
        stringArray[115] = "plus";
        stringArray[116] = "size";
        stringArray[117] = "size";
        stringArray[118] = "putAt";
        stringArray[119] = "getAt";
        stringArray[120] = "next";
        stringArray[121] = "size";
        stringArray[122] = "size";
        stringArray[123] = "putAt";
        stringArray[124] = "getAt";
        stringArray[125] = "next";
        stringArray[126] = "size";
        stringArray[127] = "size";
        stringArray[128] = "size";
        stringArray[129] = "equals";
        stringArray[130] = "toUpperCase";
        stringArray[131] = "getOne_letter_code";
        stringArray[132] = "getChemComp";
        stringArray[133] = "get";
        stringArray[134] = "minus";
        stringArray[135] = "toUpperCase";
        stringArray[136] = "letter";
        stringArray[137] = "get";
        stringArray[138] = "minus";
        stringArray[139] = "plus";
        stringArray[140] = "getAt";
        stringArray[141] = "getAt";
        stringArray[142] = "minus";
        stringArray[143] = "minus";
        stringArray[144] = "putAt";
        stringArray[145] = "getAt";
        stringArray[146] = "max";
        stringArray[147] = "getAt";
        stringArray[148] = "getAt";
        stringArray[149] = "minus";
        stringArray[150] = "getAt";
        stringArray[151] = "getAt";
        stringArray[152] = "minus";
        stringArray[153] = "putAt";
        stringArray[154] = "getAt";
        stringArray[155] = "next";
        stringArray[156] = "next";
        stringArray[157] = "size";
        stringArray[158] = "size";
        stringArray[159] = "equals";
        stringArray[160] = "toUpperCase";
        stringArray[161] = "getOne_letter_code";
        stringArray[162] = "getChemComp";
        stringArray[163] = "get";
        stringArray[164] = "toUpperCase";
        stringArray[165] = "letter";
        stringArray[166] = "get";
        stringArray[167] = "max";
        stringArray[168] = "<$constructor$>";
        stringArray[169] = "iterator";
        stringArray[170] = "getChains";
        stringArray[171] = "size";
        stringArray[172] = "getAtomGroups";
        stringArray[173] = "AMINOACID";
        stringArray[174] = "getChainID";
        stringArray[175] = "isEmpty";
        stringArray[176] = "trim";
        stringArray[177] = "apply";
        stringArray[178] = "exists";
        stringArray[179] = "loadScoreFile";
        stringArray[180] = "error";
        stringArray[181] = "isDebugEnabled";
        stringArray[182] = "debug";
        stringArray[183] = "plus";
        stringArray[184] = "join";
        stringArray[185] = "collect";
        stringArray[186] = "matchSequences";
        stringArray[187] = "getAtomGroups";
        stringArray[188] = "AMINOACID";
        stringArray[189] = "warn";
        stringArray[190] = "<$constructor$>";
        stringArray[191] = "getParams";
        stringArray[192] = "invokeMethod";
        stringArray[193] = "getProxyTarget";
        stringArray[194] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[195];
        ConservationScore.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ConservationScore.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ConservationScore.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static class AA
    implements GroovyObject {
        public String letter;
        public double score;
        public int index;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public AA(String letter, double score, int index) {
            MetaClass metaClass;
            CallSite[] callSiteArray = AA.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            String string = letter;
            this.letter = ShortTypeHandling.castToString((Object)string);
            double d = score;
            this.score = DefaultTypeTransformation.doubleUnbox((Object)d);
            int n = index;
            this.index = DefaultTypeTransformation.intUnbox((Object)n);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AA.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AA.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AA.class, ConservationScore.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AA.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AA.class, ConservationScore.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AA.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ConservationScore.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AA.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ConservationScore.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = AA.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AA.class, ConservationScore.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = AA.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AA.class, ConservationScore.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(AA.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = AA.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static final class ScoreFormat
    extends Enum<ScoreFormat>
    implements GroovyObject {
        public static final /* enum */ ScoreFormat ConCavityFormat;
        public static final /* enum */ ScoreFormat JSDFormat;
        public static final ScoreFormat MIN_VALUE;
        public static final ScoreFormat MAX_VALUE;
        private static final /* synthetic */ ScoreFormat[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public ScoreFormat(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            CallSite[] callSiteArray = ScoreFormat.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (ScriptBytecodeAdapter.compareEqual((Object)__namedArgs, null)) {
                throw (Throwable)callSiteArray[0].callConstructor(IllegalArgumentException.class, (Object)"One of the enum constants for enum cz.siret.prank.features.implementation.conservation.ConservationScore$ScoreFormat was initialized with null. Please use a non-null value or define your own constructor.");
            }
            callSiteArray[1].callStatic(ImmutableASTTransformation.class, (Object)this, (Object)__namedArgs);
        }

        @Generated
        public ScoreFormat() {
            CallSite[] callSiteArray = ScoreFormat.$getCallSiteArray();
            this((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(LinkedHashMap.class), LinkedHashMap.class));
        }

        public static final ScoreFormat[] values() {
            CallSite[] callSiteArray = ScoreFormat.$getCallSiteArray();
            return (ScoreFormat[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), ScoreFormat[].class);
        }

        public /* synthetic */ ScoreFormat next() {
            CallSite[] callSiteArray = ScoreFormat.$getCallSiteArray();
            Object ordinal = callSiteArray[3].call(callSiteArray[4].callCurrent((GroovyObject)this));
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)callSiteArray[5].call((Object)$VALUES))) {
                Integer n = 0;
                ordinal = n;
            }
            return (ScoreFormat)ShortTypeHandling.castToEnum((Object)callSiteArray[6].call((Object)$VALUES, ordinal), ScoreFormat.class);
        }

        public /* synthetic */ ScoreFormat previous() {
            CallSite[] callSiteArray = ScoreFormat.$getCallSiteArray();
            Object ordinal = callSiteArray[7].call(callSiteArray[8].callCurrent((GroovyObject)this));
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Object object;
                ordinal = object = callSiteArray[9].call(callSiteArray[10].call((Object)$VALUES), (Object)1);
            }
            return (ScoreFormat)ShortTypeHandling.castToEnum((Object)callSiteArray[11].call((Object)$VALUES, ordinal), ScoreFormat.class);
        }

        public static ScoreFormat valueOf(String name) {
            CallSite[] callSiteArray = ScoreFormat.$getCallSiteArray();
            return (ScoreFormat)ShortTypeHandling.castToEnum((Object)callSiteArray[12].callStatic(ScoreFormat.class, ScoreFormat.class, (Object)name), ScoreFormat.class);
        }

        public static final /* synthetic */ ScoreFormat $INIT(Object ... para) {
            ScoreFormat scoreFormat;
            CallSite[] callSiteArray = ScoreFormat.$getCallSiteArray();
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, ScoreFormat.class)) {
                case -1348271900: {
                    ScoreFormat scoreFormat2;
                    scoreFormat = scoreFormat2;
                    Object[] objectArray2 = objectArray;
                    scoreFormat2 = new ScoreFormat();
                    break;
                }
                case -242181752: {
                    ScoreFormat scoreFormat2;
                    scoreFormat = scoreFormat2;
                    Object[] objectArray2 = objectArray;
                    scoreFormat2 = new ScoreFormat((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return scoreFormat;
        }

        static {
            ScoreFormat scoreFormat;
            ScoreFormat scoreFormat2;
            Object object = ScoreFormat.$getCallSiteArray()[13].callStatic(ScoreFormat.class, (Object)"ConCavityFormat", (Object)0);
            ConCavityFormat = (ScoreFormat)ShortTypeHandling.castToEnum((Object)object, ScoreFormat.class);
            Object object2 = ScoreFormat.$getCallSiteArray()[14].callStatic(ScoreFormat.class, (Object)"JSDFormat", (Object)1);
            JSDFormat = (ScoreFormat)ShortTypeHandling.castToEnum((Object)object2, ScoreFormat.class);
            MIN_VALUE = scoreFormat2 = ConCavityFormat;
            MAX_VALUE = scoreFormat = JSDFormat;
            ScoreFormat[] scoreFormatArray = new ScoreFormat[]{ConCavityFormat, JSDFormat};
            $VALUES = scoreFormatArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != ScoreFormat.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "<$constructor$>";
            stringArray[1] = "checkPropNames";
            stringArray[2] = "<$constructor$>";
            stringArray[3] = "next";
            stringArray[4] = "ordinal";
            stringArray[5] = "size";
            stringArray[6] = "getAt";
            stringArray[7] = "previous";
            stringArray[8] = "ordinal";
            stringArray[9] = "minus";
            stringArray[10] = "size";
            stringArray[11] = "getAt";
            stringArray[12] = "valueOf";
            stringArray[13] = "$INIT";
            stringArray[14] = "$INIT";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[15];
            ScoreFormat.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(ScoreFormat.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ScoreFormat.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

