/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.features.implementation.conservation;

import cz.siret.prank.domain.Protein;
import cz.siret.prank.features.api.AtomFeatureCalculationContext;
import cz.siret.prank.features.api.AtomFeatureCalculator;
import cz.siret.prank.features.api.ProcessedItemContext;
import cz.siret.prank.features.implementation.conservation.ConservationScore;
import groovy.lang.MetaClass;
import java.math.BigDecimal;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class ConservationFeature
extends AtomFeatureCalculator {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ConservationFeature() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public String getName() {
        return "conservation";
    }

    @Override
    public void preProcessProtein(Protein protein, ProcessedItemContext itemContext) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)protein.getSecondaryData().getOrDefault(ConservationScore.CONSERV_LOADED_KEY, false)) && itemContext.getAuxData().getOrDefault(ConservationScore.CONSERV_SCORE_KEY, null) != null) {
            protein.loadConservationScores(itemContext);
        }
    }

    @Override
    public double[] calculateForAtom(Atom proteinSurfaceAtom, AtomFeatureCalculationContext protein) {
        Group parentAA = proteinSurfaceAtom.getGroup();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)parentAA.getType(), (Object)GroupType.AMINOACID)) {
            return new double[]{DefaultTypeTransformation.doubleUnbox((Object)$const$0)};
        }
        ConservationScore score = (ConservationScore)ScriptBytecodeAdapter.castToType((Object)protein.getProtein().getSecondaryData().get(ConservationScore.CONSERV_SCORE_KEY), ConservationScore.class);
        if (score == null) {
            return new double[]{DefaultTypeTransformation.doubleUnbox((Object)$const$0)};
        }
        double value = score.getScoreForResidue(parentAA.getResidueNumber());
        return new double[]{value};
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ConservationFeature.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        $const$0 = bigDecimal = new BigDecimal("0.0");
    }

    static {
        ConservationFeature.__$swapInit();
    }
}

