/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.features.implementation.conservation;

import cz.siret.prank.domain.Protein;
import cz.siret.prank.features.api.ProcessedItemContext;
import cz.siret.prank.features.api.SasFeatureCalculationContext;
import cz.siret.prank.features.api.SasFeatureCalculator;
import cz.siret.prank.features.implementation.conservation.ConservationScore;
import cz.siret.prank.geom.Atoms;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import cz.siret.prank.utils.PerfUtils;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.math.BigDecimal;
import java.util.Iterator;
import org.biojava.nbio.structure.Atom;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.transform.trait.Traits;

public class ConservationCloudScaledFeature
extends SasFeatureCalculator
implements Parametrized {
    private static final String NAME = "conservationcloudscaled";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ BigDecimal $const$1;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ConservationCloudScaledFeature() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void preProcessProtein(Protein protein, ProcessedItemContext itemContext) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)protein.getSecondaryData().getOrDefault(ConservationScore.CONSERV_LOADED_KEY, false))) {
            protein.loadConservationScores(itemContext);
        }
    }

    @Override
    public double[] calculateForSasPoint(Atom sasPoint, SasFeatureCalculationContext context) {
        ConservationScore score = (ConservationScore)ScriptBytecodeAdapter.castToType((Object)context.getProtein().getSecondaryData().get(ConservationScore.CONSERV_SCORE_KEY), ConservationScore.class);
        if (score == null) {
            return new double[]{DefaultTypeTransformation.doubleUnbox((Object)$const$0)};
        }
        Atoms surroundingAtoms = context.getExtractor().getDeepLayer().cutoutSphere(sasPoint, this.getParams().getProtrusion_radius());
        double value = 0.0;
        Atom atom = null;
        Iterator<Atom> iterator = surroundingAtoms.iterator();
        while (iterator.hasNext()) {
            atom = (Atom)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Atom.class);
            double scale = DefaultTypeTransformation.doubleUnbox((Object)NumberNumberDiv.div((Number)$const$1, (Number)PerfUtils.sqrDist(sasPoint.getCoords(), atom.getCoords())));
            double cfr_ignored_0 = value + scale * score.getScoreForResidue(atom.getGroup().getResidueNumber());
        }
        return new double[]{value};
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ConservationCloudScaledFeature.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(SasFeatureCalculator.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        ConservationCloudScaledFeature.__$swapInit();
        Parametrized.Trait.Helper.$static$init$(ConservationCloudScaledFeature.class);
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        $const$0 = bigDecimal2 = new BigDecimal("0.0");
        $const$1 = bigDecimal = new BigDecimal("1.0");
    }

    @Generated
    public static String getNAME() {
        return NAME;
    }
}

