/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.features.implementation.chem;

import cz.siret.prank.features.implementation.chem.ChemDefaults;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Element;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChemVector
implements Cloneable,
GroovyObject {
    private double hydrophobic;
    private double hydrophilic;
    private double hydrophatyIndex;
    private double aliphatic;
    private double aromatic;
    private double sulfur;
    private double hydroxyl;
    private double basic;
    private double acidic;
    private double amide;
    private double posCharge;
    private double negCharge;
    private double hBondDonor;
    private double hBondAcceptor;
    private double hBondDonorAcceptor;
    private double polar;
    private double ionizable;
    private double atoms;
    private double atomDensity;
    private double atomC;
    private double atomO;
    private double atomN;
    private double hDonorAtoms;
    private double hAcceptorAtoms;
    private static final List<String> HEADER;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ChemVector() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static List<String> getHeader() {
        return HEADER;
    }

    private void setFromResidueAtom(Atom atom, String residueCode) {
        boolean bl = true;
        this.atomDensity = (double)bl;
        String an = atom.getName();
        if (!ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Ala")) {
            if (ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Arg")) {
                if (ScriptBytecodeAdapter.createList((Object[])new Object[]{"NE", "NH1", "NH2"}).contains(an)) {
                    double d = this.hDonorAtoms;
                    this.hDonorAtoms = d + 1.0;
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Asn")) {
                if (ScriptBytecodeAdapter.compareEqual((Object)an, (Object)"ND2")) {
                    double d = this.hDonorAtoms;
                    this.hDonorAtoms = d + 1.0;
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)an, (Object)"OD1")) {
                    double d = this.hAcceptorAtoms;
                    this.hAcceptorAtoms = d + 1.0;
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Asp")) {
                if (ScriptBytecodeAdapter.createList((Object[])new Object[]{"OD1", "OD2"}).contains(an)) {
                    double d = this.hAcceptorAtoms;
                    this.hAcceptorAtoms = d + 1.0;
                }
            } else if (!ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Cys")) {
                if (ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Gln")) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)an, (Object)"NE2")) {
                        double d = this.hDonorAtoms;
                        this.hDonorAtoms = d + 1.0;
                    }
                    if (ScriptBytecodeAdapter.compareEqual((Object)an, (Object)"OE1")) {
                        double d = this.hAcceptorAtoms;
                        this.hAcceptorAtoms = d + 1.0;
                    }
                } else if (ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Glu")) {
                    if (ScriptBytecodeAdapter.createList((Object[])new Object[]{"OE1", "OE2"}).contains(an)) {
                        double d = this.hAcceptorAtoms;
                        this.hAcceptorAtoms = d + 1.0;
                    }
                } else if (!ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Gly")) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"His")) {
                        if (ScriptBytecodeAdapter.createList((Object[])new Object[]{"ND1", "NE2"}).contains(an)) {
                            double d = this.hDonorAtoms;
                            this.hDonorAtoms = d + 1.0;
                            double d2 = this.hAcceptorAtoms;
                            this.hAcceptorAtoms = d2 + 1.0;
                        }
                    } else if (!ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Ile") && !ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Leu")) {
                        if (ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Lys")) {
                            if (ScriptBytecodeAdapter.compareEqual((Object)an, (Object)"NZ")) {
                                double d = this.hDonorAtoms;
                                this.hDonorAtoms = d + 1.0;
                            }
                        } else if (!(ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Met") || ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Phe") || ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Pro"))) {
                            if (ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Ser")) {
                                if (ScriptBytecodeAdapter.createList((Object[])new Object[]{"OG"}).contains(an)) {
                                    double d = this.hDonorAtoms;
                                    this.hDonorAtoms = d + 1.0;
                                    double d3 = this.hAcceptorAtoms;
                                    this.hAcceptorAtoms = d3 + 1.0;
                                }
                            } else if (ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Thr")) {
                                if (ScriptBytecodeAdapter.createList((Object[])new Object[]{"OG1"}).contains(an)) {
                                    double d = this.hDonorAtoms;
                                    this.hDonorAtoms = d + 1.0;
                                    double d4 = this.hAcceptorAtoms;
                                    this.hAcceptorAtoms = d4 + 1.0;
                                }
                            } else if (ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Trp")) {
                                if (ScriptBytecodeAdapter.compareEqual((Object)an, (Object)"NE1")) {
                                    double d = this.hDonorAtoms;
                                    this.hDonorAtoms = d + 1.0;
                                }
                            } else if (ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Tyr")) {
                                if (ScriptBytecodeAdapter.createList((Object[])new Object[]{"OH"}).contains(an)) {
                                    double d = this.hDonorAtoms;
                                    this.hDonorAtoms = d + 1.0;
                                    double d5 = this.hAcceptorAtoms;
                                    this.hAcceptorAtoms = d5 + 1.0;
                                }
                            } else if (!ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"Val") && !ChemDefaults.AACODES.contains(residueCode)) {
                                Object v0;
                                if (log.isDebugEnabled()) {
                                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{residueCode}, new String[]{"!! masking unknown residue code:  ", ""})));
                                    v0 = null;
                                } else {
                                    v0 = null;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static ChemVector forAtom(Atom atom, String residueCode) {
        ChemVector p;
        block1: {
            block5: {
                block4: {
                    block3: {
                        block2: {
                            block0: {
                                ChemVector chemVector;
                                ChemVector chemVector2;
                                p = null;
                                ChemVector proto = (ChemVector)ScriptBytecodeAdapter.castToType((Object)ChemDefaults.AA_DEFAULTS.get(residueCode), ChemVector.class);
                                p = proto != null ? (chemVector2 = (ChemVector)ScriptBytecodeAdapter.castToType((Object)proto.clone(), ChemVector.class)) : (chemVector = new ChemVector());
                                p.setFromResidueAtom(atom, residueCode);
                                if (!ScriptBytecodeAdapter.compareEqual((Object)atom.getElement(), (Object)Element.C)) break block0;
                                boolean bl = true;
                                p.setAtomC((double)bl);
                                break block1;
                            }
                            if (!ScriptBytecodeAdapter.compareEqual((Object)atom.getElement(), (Object)Element.O)) break block2;
                            boolean bl = true;
                            p.setAtomO((double)bl);
                            break block1;
                        }
                        if (!ScriptBytecodeAdapter.compareEqual((Object)atom.getElement(), (Object)Element.N)) break block3;
                        boolean bl = true;
                        p.setAtomN((double)bl);
                        break block1;
                    }
                    if (!atom.getName().startsWith("C")) break block4;
                    boolean bl = true;
                    p.setAtomC((double)bl);
                    break block1;
                }
                if (!atom.getName().startsWith("O")) break block5;
                boolean bl = true;
                p.setAtomO((double)bl);
                break block1;
            }
            if (!atom.getName().startsWith("N")) break block1;
            boolean bl = true;
            p.setAtomN((double)bl);
        }
        return p;
    }

    public double[] toArray() {
        return new double[]{this.hydrophobic, this.hydrophilic, this.hydrophatyIndex, this.aliphatic, this.aromatic, this.sulfur, this.hydroxyl, this.basic, this.acidic, this.amide, this.posCharge, this.negCharge, this.hBondDonor, this.hBondAcceptor, this.hBondDonorAcceptor, this.polar, this.ionizable, this.atoms, this.atomDensity, this.atomC, this.atomO, this.atomN, this.hDonorAtoms, this.hAcceptorAtoms};
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ChemVector.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        List list;
        HEADER = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"hydrophobic", "hydrophilic", "hydrophatyIndex", "aliphatic", "aromatic", "sulfur", "hydroxyl", "basic", "acidic", "amide", "posCharge", "negCharge", "hBondDonor", "hBondAcceptor", "hBondDonorAcceptor", "polar", "ionizable", "atoms", "atomDensity", "atomC", "atomO", "atomN", "hDonorAtoms", "hAcceptorAtoms"});
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.features.implementation.chem.ChemVector");
    }

    @Generated
    public double getHydrophobic() {
        return this.hydrophobic;
    }

    @Generated
    public void setHydrophobic(double d) {
        this.hydrophobic = d;
    }

    @Generated
    public double getHydrophilic() {
        return this.hydrophilic;
    }

    @Generated
    public void setHydrophilic(double d) {
        this.hydrophilic = d;
    }

    @Generated
    public double getHydrophatyIndex() {
        return this.hydrophatyIndex;
    }

    @Generated
    public void setHydrophatyIndex(double d) {
        this.hydrophatyIndex = d;
    }

    @Generated
    public double getAliphatic() {
        return this.aliphatic;
    }

    @Generated
    public void setAliphatic(double d) {
        this.aliphatic = d;
    }

    @Generated
    public double getAromatic() {
        return this.aromatic;
    }

    @Generated
    public void setAromatic(double d) {
        this.aromatic = d;
    }

    @Generated
    public double getSulfur() {
        return this.sulfur;
    }

    @Generated
    public void setSulfur(double d) {
        this.sulfur = d;
    }

    @Generated
    public double getHydroxyl() {
        return this.hydroxyl;
    }

    @Generated
    public void setHydroxyl(double d) {
        this.hydroxyl = d;
    }

    @Generated
    public double getBasic() {
        return this.basic;
    }

    @Generated
    public void setBasic(double d) {
        this.basic = d;
    }

    @Generated
    public double getAcidic() {
        return this.acidic;
    }

    @Generated
    public void setAcidic(double d) {
        this.acidic = d;
    }

    @Generated
    public double getAmide() {
        return this.amide;
    }

    @Generated
    public void setAmide(double d) {
        this.amide = d;
    }

    @Generated
    public double getPosCharge() {
        return this.posCharge;
    }

    @Generated
    public void setPosCharge(double d) {
        this.posCharge = d;
    }

    @Generated
    public double getNegCharge() {
        return this.negCharge;
    }

    @Generated
    public void setNegCharge(double d) {
        this.negCharge = d;
    }

    @Generated
    public double gethBondDonor() {
        return this.hBondDonor;
    }

    @Generated
    public void sethBondDonor(double d) {
        this.hBondDonor = d;
    }

    @Generated
    public double gethBondAcceptor() {
        return this.hBondAcceptor;
    }

    @Generated
    public void sethBondAcceptor(double d) {
        this.hBondAcceptor = d;
    }

    @Generated
    public double gethBondDonorAcceptor() {
        return this.hBondDonorAcceptor;
    }

    @Generated
    public void sethBondDonorAcceptor(double d) {
        this.hBondDonorAcceptor = d;
    }

    @Generated
    public double getPolar() {
        return this.polar;
    }

    @Generated
    public void setPolar(double d) {
        this.polar = d;
    }

    @Generated
    public double getIonizable() {
        return this.ionizable;
    }

    @Generated
    public void setIonizable(double d) {
        this.ionizable = d;
    }

    @Generated
    public double getAtoms() {
        return this.atoms;
    }

    @Generated
    public void setAtoms(double d) {
        this.atoms = d;
    }

    @Generated
    public double getAtomDensity() {
        return this.atomDensity;
    }

    @Generated
    public void setAtomDensity(double d) {
        this.atomDensity = d;
    }

    @Generated
    public double getAtomC() {
        return this.atomC;
    }

    @Generated
    public void setAtomC(double d) {
        this.atomC = d;
    }

    @Generated
    public double getAtomO() {
        return this.atomO;
    }

    @Generated
    public void setAtomO(double d) {
        this.atomO = d;
    }

    @Generated
    public double getAtomN() {
        return this.atomN;
    }

    @Generated
    public void setAtomN(double d) {
        this.atomN = d;
    }

    @Generated
    public double gethDonorAtoms() {
        return this.hDonorAtoms;
    }

    @Generated
    public void sethDonorAtoms(double d) {
        this.hDonorAtoms = d;
    }

    @Generated
    public double gethAcceptorAtoms() {
        return this.hAcceptorAtoms;
    }

    @Generated
    public void sethAcceptorAtoms(double d) {
        this.hAcceptorAtoms = d;
    }

    @Generated
    public static List<String> getHEADER() {
        return HEADER;
    }
}

