/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.features.implementation;

import cz.siret.prank.domain.Protein;
import cz.siret.prank.features.api.ProcessedItemContext;
import cz.siret.prank.features.api.SasFeatureCalculationContext;
import cz.siret.prank.features.api.SasFeatureCalculator;
import cz.siret.prank.geom.Atoms;
import cz.siret.prank.geom.Point;
import cz.siret.prank.geom.Struct;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;

public class PyramidFeature
extends SasFeatureCalculator
implements Parametrized {
    private static final String NAME = "pyramid";
    private final List<String> HEADER;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public PyramidFeature() {
        MetaClass metaClass;
        ArrayList<String> arrayList = new ArrayList<String>();
        this.HEADER = arrayList;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
        Integer pi = null;
        Iterator iterator = ScriptBytecodeAdapter.createList((Object[])new Object[]{1, 2, 3, 4}).iterator();
        while (iterator.hasNext()) {
            pi = (Integer)ScriptBytecodeAdapter.castToType(iterator.next(), Integer.class);
            String ft = null;
            Iterator iterator2 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"dc", "surf"}).iterator();
            while (iterator2.hasNext()) {
                ft = ShortTypeHandling.castToString(iterator2.next());
                this.HEADER.add(new GStringImpl(new Object[]{this.getName(), pi, ft}, new String[]{"", "_", "_", ""}).toString());
            }
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getHeader() {
        return this.HEADER;
    }

    @Override
    public void preProcessProtein(Protein protein, ProcessedItemContext context) {
        protein.getExposedAtoms().buildKdTree();
    }

    @Override
    public double[] calculateForSasPoint(Atom sasPoint, SasFeatureCalculationContext context) {
        Atoms nearest = context.getProtein().getExposedAtoms().getKdTree().findNearestNAtoms(sasPoint, 9, true);
        Pyramid p1 = new Pyramid(sasPoint, (Atom)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Iterable)nearest, (int)0), Atom.class), (Atom)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Iterable)nearest, (int)1), Atom.class), (Atom)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Iterable)nearest, (int)2), Atom.class));
        Pyramid p2 = new Pyramid(sasPoint, (Atom)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Iterable)nearest, (int)3), Atom.class), (Atom)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Iterable)nearest, (int)4), Atom.class), (Atom)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Iterable)nearest, (int)5), Atom.class));
        Pyramid p3 = new Pyramid(sasPoint, (Atom)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Iterable)nearest, (int)0), Atom.class), (Atom)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Iterable)nearest, (int)2), Atom.class), (Atom)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Iterable)nearest, (int)4), Atom.class));
        Pyramid p4 = new Pyramid(sasPoint, (Atom)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Iterable)nearest, (int)6), Atom.class), (Atom)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Iterable)nearest, (int)7), Atom.class), (Atom)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Iterable)nearest, (int)8), Atom.class));
        double p1_dc = Struct.dist(sasPoint, p1.getCentroid());
        double p2_dc = Struct.dist(sasPoint, p2.getCentroid());
        double p3_dc = Struct.dist(sasPoint, p3.getCentroid());
        double p4_dc = Struct.dist(sasPoint, p4.getCentroid());
        return new double[]{p1_dc, p1.getSurface(), p2_dc, p2.getSurface(), p3_dc, p3.getSurface(), p4_dc, p4.getSurface()};
    }

    public Point point(Atom a) {
        return new Point(a.getCoords());
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PyramidFeature.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(SasFeatureCalculator.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        Parametrized.Trait.Helper.$static$init$(PyramidFeature.class);
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(PyramidFeature.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, PyramidFeature.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(PyramidFeature.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    public static String getNAME() {
        return NAME;
    }

    @Generated
    public final List<String> getHEADER() {
        return this.HEADER;
    }

    public static class Pyramid
    implements GroovyObject {
        private Atom a;
        private Atom b;
        private Atom c;
        private Atom d;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ BigDecimal $const$0;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public Pyramid(Atom a, Atom b, Atom c, Atom d) {
            Atom atom;
            Atom atom2;
            Atom atom3;
            Atom atom4;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.a = atom4 = a;
            this.b = atom3 = b;
            this.c = atom2 = c;
            this.d = atom = d;
        }

        public Atom getCentroid() {
            return Atoms.copyPoints(this.a, this.b, this.c, this.d).getCenterOfMass();
        }

        public double getSurface() {
            return Pyramid.pyramidSurface(this.a, this.b, this.c, this.d);
        }

        public static double tsurf(double sa, double sb, double sc) {
            double s = (sa + sb + sc) / (double)2;
            return Math.sqrt(s * (s - sa) * (s - sb) * (s - sc)) * DefaultTypeTransformation.doubleUnbox((Object)$const$0);
        }

        public static double pyramidSurface(Atom a, Atom b, Atom c, Atom d) {
            double ab = Struct.dist(a, b);
            double ac = Struct.dist(a, c);
            double ad = Struct.dist(a, d);
            double bc = Struct.dist(b, c);
            double bd = Struct.dist(b, d);
            double cd = Struct.dist(c, d);
            return Pyramid.tsurf(ab, ac, bc) + Pyramid.tsurf(ab, ad, bd) + Pyramid.tsurf(bc, bd, cd) + Pyramid.tsurf(ac, ad, cd);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Pyramid.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Pyramid.class, PyramidFeature.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Pyramid.class, PyramidFeature.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PyramidFeature.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PyramidFeature.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Pyramid.class, PyramidFeature.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Pyramid.class, PyramidFeature.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
            BigDecimal bigDecimal;
            $const$0 = bigDecimal = new BigDecimal("0.5");
        }

        static {
            Pyramid.__$swapInit();
        }

        @Generated
        public Atom getA() {
            return this.a;
        }

        @Generated
        public void setA(Atom atom) {
            this.a = atom;
        }

        @Generated
        public Atom getB() {
            return this.b;
        }

        @Generated
        public void setB(Atom atom) {
            this.b = atom;
        }

        @Generated
        public Atom getC() {
            return this.c;
        }

        @Generated
        public void setC(Atom atom) {
            this.c = atom;
        }

        @Generated
        public Atom getD() {
            return this.d;
        }

        @Generated
        public void setD(Atom atom) {
            this.d = atom;
        }
    }
}

