/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.features.implementation;

import cz.siret.prank.domain.Residue;
import cz.siret.prank.features.api.SasFeatureCalculationContext;
import cz.siret.prank.features.api.SasFeatureCalculator;
import cz.siret.prank.geom.Struct;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.util.List;
import org.biojava.nbio.structure.AminoAcid;
import org.biojava.nbio.structure.Atom;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactResidue1PositionFeature
extends SasFeatureCalculator
implements Parametrized {
    private static String NAME;
    private final List<String> HEADER;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ContactResidue1PositionFeature() {
        MetaClass metaClass;
        List list;
        this.HEADER = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"CA", "CB", "Closest", "Center", "CAmCB", "CAdClosest", "CAdCenter"});
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getHeader() {
        return this.HEADER;
    }

    @Override
    public double[] calculateForSasPoint(Atom sasPoint, SasFeatureCalculationContext context) {
        Residue res = context.getProtein().getResidues().findNearest(sasPoint);
        AminoAcid aa = res.getAminoAcid();
        Atom center = res.getAtoms().getCenterOfMass();
        Atom ca = aa.getCA();
        Atom cb = aa.getCB();
        double dcenter = Struct.dist(sasPoint, center);
        double dclosest = res.getAtoms().dist(sasPoint);
        double dca = 0.0;
        double dcb = 0.0;
        double CAmCB = 0.0;
        double CAdClosest = 1.0;
        double CAdCenter = 1.0;
        if (ca != null) {
            double d;
            double d2;
            double d3;
            dca = d3 = Struct.dist(sasPoint, ca);
            CAdClosest = d2 = dca / dclosest;
            CAdCenter = d = dca / dcenter;
            if (cb != null) {
                double d4;
                CAmCB = d4 = dca - dcb;
            }
        } else {
            log.debug("WARN: CA atom not found in residue [{}]!", (Object)res);
        }
        if (cb != null) {
            double d;
            dcb = d = Struct.dist(sasPoint, cb);
        } else {
            log.debug("WARN: CB atom not found in residue [{}]!", (Object)res);
        }
        return new double[]{dca, dcb, dcenter, dclosest, CAmCB, CAdClosest, CAdCenter};
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ContactResidue1PositionFeature.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(SasFeatureCalculator.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        Logger logger;
        String string;
        NAME = string = "cr1pos";
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.features.implementation.ContactResidue1PositionFeature");
        Parametrized.Trait.Helper.$static$init$(ContactResidue1PositionFeature.class);
    }

    @Generated
    public static String getNAME() {
        return NAME;
    }

    @Generated
    public static void setNAME(String string) {
        NAME = string;
    }

    @Generated
    public final List<String> getHEADER() {
        return this.HEADER;
    }
}

