/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.features.implementation;

import cz.siret.prank.domain.Protein;
import cz.siret.prank.features.api.ProcessedItemContext;
import cz.siret.prank.features.api.SasFeatureCalculationContext;
import cz.siret.prank.features.api.SasFeatureCalculator;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.asa.AsaCalculator;
import org.biojava.nbio.structure.asa.GroupAsa;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsaResiduesFeature
extends SasFeatureCalculator
implements Parametrized {
    private static final String NAME = "asares";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AsaResiduesFeature() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void preProcessProtein(Protein protein, ProcessedItemContext context) {
        double probeRadius = this.getParams().getFeat_asa_probe_radius();
        int nSpherePoints = AsaCalculator.DEFAULT_N_SPHERE_POINTS;
        int threads = 1;
        boolean hetAtoms = false;
        AsaCalculator asaCalculator = new AsaCalculator(protein.getStructure(), probeRadius, nSpherePoints, threads, hetAtoms);
        List asas = DefaultGroovyMethods.toList((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)asaCalculator.getGroupAsas(), Object[].class)));
        protein.getSecondaryData().put("prot_asa", new ProtAsa(protein, asas));
    }

    @Override
    public double[] calculateForSasPoint(Atom sasPoint, SasFeatureCalculationContext context) {
        List<Group> groups = context.getProtein().getExposedAtoms().cutoutSphere(sasPoint, this.getParams().getFeat_asa_neigh_radius()).getDistinctGroupsSorted();
        Reference protAsa = new Reference((Object)((ProtAsa)ScriptBytecodeAdapter.castToType((Object)context.getProtein().getSecondaryData().get("prot_asa"), ProtAsa.class)));
        public final class _calculateForSasPoint_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference protAsa;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateForSasPoint_closure1(Object _outerInstance, Object _thisObject, Reference protAsa) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.protAsa = reference = protAsa;
            }

            public Object doCall(Group g) {
                Double d = ((ProtAsa)this.protAsa.get()).getGroupAsaMap().get(g.getResidueNumber());
                Double d2 = (Double)ScriptBytecodeAdapter.castToType((Object)d, Double.class);
                return DefaultTypeTransformation.booleanUnbox((Object)d) ? d2 : (Double)ScriptBytecodeAdapter.castToType((Object)0, Double.class);
            }

            public Object call(Group g) {
                return this.doCall(g);
            }

            public ProtAsa getProtAsa() {
                return (ProtAsa)ScriptBytecodeAdapter.castToType((Object)this.protAsa.get(), ProtAsa.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateForSasPoint_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        double localAsa = DefaultTypeTransformation.doubleUnbox((Object)DefaultGroovyMethods.sum((Iterable)DefaultGroovyMethods.collect(groups, (Closure)new _calculateForSasPoint_closure1(this, this, protAsa)), (Object)0));
        return new double[]{localAsa};
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AsaResiduesFeature.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(SasFeatureCalculator.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.features.implementation.AsaResiduesFeature");
        Parametrized.Trait.Helper.$static$init$(AsaResiduesFeature.class);
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AsaResiduesFeature.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AsaResiduesFeature.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AsaResiduesFeature.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    public static String getNAME() {
        return NAME;
    }

    public static class ProtAsa
    implements GroovyObject {
        private Protein protein;
        private List<GroupAsa> groupAsas;
        private Map<ResidueNumber, Double> groupAsaMap;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public ProtAsa(Protein protein, List<GroupAsa> groupAsas) {
            Protein protein2;
            MetaClass metaClass;
            HashMap<ResidueNumber, Double> hashMap = new HashMap<ResidueNumber, Double>();
            this.groupAsaMap = hashMap;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.protein = protein2 = protein;
            List<GroupAsa> list = groupAsas;
            this.groupAsas = list;
            GroupAsa gasa = null;
            Iterator<GroupAsa> iterator = groupAsas.iterator();
            while (iterator.hasNext()) {
                gasa = (GroupAsa)ScriptBytecodeAdapter.castToType((Object)iterator.next(), GroupAsa.class);
                double asa = gasa.getAsaC();
                GroupAsa groupAsa = gasa;
                Group group = groupAsa != null ? groupAsa.getGroup() : null;
                ResidueNumber resNum = group != null ? group.getResidueNumber() : null;
                if (!(resNum != null)) continue;
                this.groupAsaMap.put(resNum, asa);
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ProtAsa.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ProtAsa.class, AsaResiduesFeature.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ProtAsa.class, AsaResiduesFeature.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AsaResiduesFeature.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AsaResiduesFeature.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ProtAsa.class, AsaResiduesFeature.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ProtAsa.class, AsaResiduesFeature.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Protein getProtein() {
            return this.protein;
        }

        @Generated
        public void setProtein(Protein protein) {
            this.protein = protein;
        }

        @Generated
        public List<GroupAsa> getGroupAsas() {
            return this.groupAsas;
        }

        @Generated
        public void setGroupAsas(List<GroupAsa> list) {
            this.groupAsas = list;
        }

        @Generated
        public Map<ResidueNumber, Double> getGroupAsaMap() {
            return this.groupAsaMap;
        }

        @Generated
        public void setGroupAsaMap(Map<ResidueNumber, Double> map) {
            this.groupAsaMap = map;
        }
    }
}

