/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.features.implementation;

import cz.siret.prank.domain.Protein;
import cz.siret.prank.features.api.ProcessedItemContext;
import cz.siret.prank.features.api.SasFeatureCalculationContext;
import cz.siret.prank.features.api.SasFeatureCalculator;
import cz.siret.prank.geom.Atoms;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import cz.siret.prank.utils.Writable;
import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.asa.AsaCalculator;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Asa2Feature
extends SasFeatureCalculator
implements Parametrized,
Writable {
    private static final String NAME = "asa2";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public Asa2Feature() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Writable.Trait.Helper.$init$(this);
        Parametrized.Trait.Helper.$init$(this);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getHeader() {
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{"asa2.1", "asa2.2"});
    }

    public ProtAsa calcProtAsa(Protein protein, double probeRadius) {
        int nSpherePoints = AsaCalculator.DEFAULT_N_SPHERE_POINTS;
        int threads = 1;
        boolean hetAtoms = false;
        Object[] protAtoms = StructureTools.getAllNonHAtomArray((Structure)protein.getStructure(), (boolean)hetAtoms);
        AsaCalculator asaCalculator = new AsaCalculator(protein.getStructure(), probeRadius, nSpherePoints, threads, hetAtoms);
        double[] atomAsas = asaCalculator.calculateAsas();
        ((Atom)BytecodeInterface8.objectArrayGet((Object[])protAtoms, (int)0)).getPDBserial();
        HashMap<Integer, Double> asaByAtom = new HashMap<Integer, Double>();
        int i = 0;
        while (i != protAtoms.length) {
            asaByAtom.put(((Atom)BytecodeInterface8.objectArrayGet((Object[])protAtoms, (int)i)).getPDBserial(), BytecodeInterface8.dArrayGet((double[])atomAsas, (int)i));
            int cfr_ignored_0 = i + 1;
        }
        return new ProtAsa(protein, asaByAtom);
    }

    @Override
    public void preProcessProtein(Protein protein, ProcessedItemContext context) {
        if (!protein.getSecondaryData().containsKey("prot_atom_asa")) {
            protein.getSecondaryData().put("prot_atom_asa", this.calcProtAsa(protein, this.getParams().getFeat_asa_probe_radius()));
        }
        if (!protein.getSecondaryData().containsKey("prot_atom_asa2")) {
            protein.getSecondaryData().put("prot_atom_asa2", this.calcProtAsa(protein, this.getParams().getFeat_asa_probe_radius2()));
        }
    }

    @Override
    public double[] calculateForSasPoint(Atom sasPoint, SasFeatureCalculationContext context) {
        Atoms localAtoms = context.getProtein().getExposedAtoms().cutoutSphere(sasPoint, this.getParams().getFeat_asa_neigh_radius());
        Reference protAsa = new Reference((Object)((ProtAsa)ScriptBytecodeAdapter.castToType((Object)context.getProtein().getSecondaryData().get("prot_atom_asa"), ProtAsa.class)));
        public final class _calculateForSasPoint_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference protAsa;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateForSasPoint_closure1(Object _outerInstance, Object _thisObject, Reference protAsa) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.protAsa = reference = protAsa;
            }

            public Object doCall(Atom a) {
                Double d = ((ProtAsa)this.protAsa.get()).getAsaByAtom().get(a.getPDBserial());
                Double d2 = (Double)ScriptBytecodeAdapter.castToType((Object)d, Double.class);
                return DefaultTypeTransformation.booleanUnbox((Object)d) ? d2 : (Double)ScriptBytecodeAdapter.castToType((Object)0, Double.class);
            }

            public Object call(Atom a) {
                return this.doCall(a);
            }

            public ProtAsa getProtAsa() {
                return (ProtAsa)ScriptBytecodeAdapter.castToType((Object)this.protAsa.get(), ProtAsa.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateForSasPoint_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        double localAsa = DefaultTypeTransformation.doubleUnbox((Object)DefaultGroovyMethods.sum((Iterable)DefaultGroovyMethods.collect((Iterable)localAtoms, (Closure)new _calculateForSasPoint_closure1(this, this, protAsa)), (Object)0));
        Reference protAsa2 = new Reference((Object)((ProtAsa)ScriptBytecodeAdapter.castToType((Object)context.getProtein().getSecondaryData().get("prot_atom_asa2"), ProtAsa.class)));
        public final class _calculateForSasPoint_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference protAsa2;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateForSasPoint_closure2(Object _outerInstance, Object _thisObject, Reference protAsa2) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.protAsa2 = reference = protAsa2;
            }

            public Object doCall(Atom a) {
                Double d = ((ProtAsa)this.protAsa2.get()).getAsaByAtom().get(a.getPDBserial());
                Double d2 = (Double)ScriptBytecodeAdapter.castToType((Object)d, Double.class);
                return DefaultTypeTransformation.booleanUnbox((Object)d) ? d2 : (Double)ScriptBytecodeAdapter.castToType((Object)0, Double.class);
            }

            public Object call(Atom a) {
                return this.doCall(a);
            }

            public ProtAsa getProtAsa2() {
                return (ProtAsa)ScriptBytecodeAdapter.castToType((Object)this.protAsa2.get(), ProtAsa.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateForSasPoint_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        double localAsa2 = DefaultTypeTransformation.doubleUnbox((Object)DefaultGroovyMethods.sum((Iterable)DefaultGroovyMethods.collect((Iterable)localAtoms, (Closure)new _calculateForSasPoint_closure2(this, this, protAsa2)), (Object)0));
        return new double[]{localAsa, localAsa2};
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Asa2Feature.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;Lorg/slf4j/Logger;)V")
    public static void write(String arg1, Logger arg2) {
        ScriptBytecodeAdapter.invokeMethodN(Asa2Feature.class, Writable.Trait.Helper.class, (String)"write", (Object[])new Object[]{Asa2Feature.class, arg1, arg2});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;Ljava/lang/Throwable;)V")
    public static void writeError(String arg1, Throwable arg2) {
        ScriptBytecodeAdapter.invokeMethodN(Asa2Feature.class, Writable.Trait.Helper.class, (String)"writeError", (Object[])new Object[]{Asa2Feature.class, arg1, arg2});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;)V")
    public static void write(String arg1) {
        ScriptBytecodeAdapter.invokeMethodN(Asa2Feature.class, Writable.Trait.Helper.class, (String)"write", (Object[])new Object[]{Asa2Feature.class, arg1});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;)V")
    public static void writeError(String arg1) {
        ScriptBytecodeAdapter.invokeMethodN(Asa2Feature.class, Writable.Trait.Helper.class, (String)"writeError", (Object[])new Object[]{Asa2Feature.class, arg1});
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.features.implementation.Asa2Feature");
        Writable.Trait.Helper.$static$init$(Asa2Feature.class);
        Parametrized.Trait.Helper.$static$init$(Asa2Feature.class);
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(SasFeatureCalculator.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(Asa2Feature.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Asa2Feature.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(Asa2Feature.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    public static String getNAME() {
        return NAME;
    }

    public static class ProtAsa
    implements GroovyObject {
        private Protein protein;
        private Map<Integer, Double> asaByAtom;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public ProtAsa(Protein protein, Map<Integer, Double> asaByAtom) {
            Protein protein2;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.protein = protein2 = protein;
            Map<Integer, Double> map = asaByAtom;
            this.asaByAtom = map;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ProtAsa.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ProtAsa.class, Asa2Feature.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ProtAsa.class, Asa2Feature.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Asa2Feature.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Asa2Feature.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ProtAsa.class, Asa2Feature.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ProtAsa.class, Asa2Feature.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Protein getProtein() {
            return this.protein;
        }

        @Generated
        public void setProtein(Protein protein) {
            this.protein = protein;
        }

        @Generated
        public Map<Integer, Double> getAsaByAtom() {
            return this.asaByAtom;
        }

        @Generated
        public void setAsaByAtom(Map<Integer, Double> map) {
            this.asaByAtom = map;
        }
    }
}

