/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.features;

import cz.siret.prank.features.FeatureSetup;
import cz.siret.prank.features.FeatureVector;
import cz.siret.prank.features.PrankFeatureExtractor;
import cz.siret.prank.features.api.AtomFeatureCalculationContext;
import cz.siret.prank.features.generic.GenericHeader;
import cz.siret.prank.features.generic.GenericVector;
import cz.siret.prank.features.tables.PropertyTable;
import cz.siret.prank.program.params.Params;
import cz.siret.prank.utils.Futils;
import cz.siret.prank.utils.PdbUtils;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.util.Iterator;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrankFeatureVector
extends FeatureVector
implements Cloneable {
    private static final PropertyTable aa5FactorsTable;
    private static final PropertyTable aa5PropensitiesTable;
    private static final PropertyTable aaPropertyTable;
    private static final PropertyTable atomPropertyTable;
    public GenericVector valueVector;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public PrankFeatureVector() {
        this(GenericHeader.EMPTY);
    }

    public PrankFeatureVector(GenericHeader header) {
        GenericVector genericVector;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.valueVector = genericVector = new GenericVector(header);
    }

    @Override
    public double[] getArray() {
        return (double[])ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getGroovyObjectField(PrankFeatureVector.class, (GroovyObject)this.valueVector, (String)"data"), double[].class);
    }

    @Override
    public final List<Double> getVector() {
        return this.valueVector.toList();
    }

    @Override
    public List<String> getHeader() {
        return this.valueVector.getHeader().getColNames();
    }

    public static PrankFeatureVector forAtom(Atom atom, PrankFeatureExtractor extractor) {
        String residueCode = PdbUtils.normAAcode(PdbUtils.getCorrectedAtomResidueCode(atom));
        PrankFeatureVector p = new PrankFeatureVector();
        GenericVector genericVector = new GenericVector(extractor.getHeaderAdditionalFeatures());
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)genericVector, PrankFeatureVector.class, (GroovyObject)p, (String)"valueVector");
        p.setFromResidueAtom(atom, residueCode, extractor);
        return p;
    }

    private void setFromResidueAtom(Atom atom, String residueCode, PrankFeatureExtractor extractor) {
        double ATOM_POW = DefaultTypeTransformation.doubleUnbox((Object)ScriptBytecodeAdapter.getField(PrankFeatureVector.class, (Object)Params.INSTANCE, (String)"atom_table_feat_pow"));
        boolean KEEP_SGN = DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.getField(PrankFeatureVector.class, (Object)Params.INSTANCE, (String)"atom_table_feat_keep_sgn"));
        String property = null;
        Iterator<String> iterator = extractor.getAtomTableFeatures().iterator();
        while (iterator.hasNext()) {
            property = ShortTypeHandling.castToString((Object)iterator.next());
            double val = PrankFeatureVector.getAtomTableValue(atom, property);
            double pval = val;
            if (ATOM_POW != 1.0) {
                double d;
                double d2;
                pval = KEEP_SGN ? (d2 = Math.signum(val) * Math.abs(Math.pow(val, ATOM_POW))) : (d = Math.pow(val, ATOM_POW));
            }
            this.valueVector.set(property, pval);
        }
        String property2 = null;
        Iterator<String> iterator2 = extractor.getResidueTableFeatures().iterator();
        while (iterator2.hasNext()) {
            property2 = ShortTypeHandling.castToString((Object)iterator2.next());
            double val = PrankFeatureVector.getResidueTableValue(atom, property2);
            this.valueVector.set(property2, val);
        }
        AtomFeatureCalculationContext context = new AtomFeatureCalculationContext(extractor.getProtein(), residueCode);
        FeatureSetup.Feature feature = null;
        Iterator<FeatureSetup.Feature> iterator3 = extractor.getFeatureSetup().getEnabledAtomFeatures().iterator();
        while (iterator3.hasNext()) {
            feature = (FeatureSetup.Feature)ScriptBytecodeAdapter.castToType((Object)iterator3.next(), FeatureSetup.Feature.class);
            double[] values = feature.getCalculator().calculateForAtom(atom, context);
            this.valueVector.setValues(feature.getStartIndex(), values);
        }
    }

    private static Double getAtomTableValue(Atom atom, String property) {
        String atomName = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)PdbUtils.getCorrectedAtomResidueCode(atom), (CharSequence)"."), (CharSequence)atom.getName());
        Double val = atomPropertyTable.getValue(atomName, property);
        return val == null ? Double.valueOf(0.0) : val;
    }

    private static Double getResidueTableValue(Atom atom, String property) {
        Double val = aaPropertyTable.getValue(PdbUtils.getCorrectedAtomResidueCode(atom), property);
        return val == null ? Double.valueOf(0.0) : val;
    }

    public PrankFeatureVector copy() {
        return new PrankFeatureVector().copyFrom(this);
    }

    public PrankFeatureVector copyFrom(PrankFeatureVector p) {
        GenericVector genericVector;
        this.valueVector = genericVector = p.valueVector.copy();
        return this;
    }

    public PrankFeatureVector multiply(double a) {
        this.valueVector.multiply(a);
        return this;
    }

    public PrankFeatureVector add(PrankFeatureVector p) {
        this.valueVector.add(p.valueVector);
        return this;
    }

    public String toString() {
        return DefaultGroovyMethods.toListString(this.getVector());
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PrankFeatureVector.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        PropertyTable propertyTable;
        PropertyTable propertyTable2;
        PropertyTable propertyTable3;
        PropertyTable propertyTable4;
        aa5FactorsTable = propertyTable4 = PropertyTable.parse(Futils.readResource("/tables/aa-5factors.csv"));
        aa5PropensitiesTable = propertyTable3 = PropertyTable.parse(Futils.readResource("/tables/aa-propensities.csv"));
        aaPropertyTable = propertyTable2 = aa5FactorsTable.join(aa5PropensitiesTable);
        atomPropertyTable = propertyTable = PropertyTable.parse(Futils.readResource("/tables/atomic-properties.csv"));
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.features.PrankFeatureVector");
    }

    @Generated
    public static PropertyTable getAa5FactorsTable() {
        return aa5FactorsTable;
    }

    @Generated
    public static PropertyTable getAa5PropensitiesTable() {
        return aa5PropensitiesTable;
    }

    @Generated
    public static PropertyTable getAaPropertyTable() {
        return aaPropertyTable;
    }

    @Generated
    public static PropertyTable getAtomPropertyTable() {
        return atomPropertyTable;
    }
}

