/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.features;

import cz.siret.prank.domain.Pocket;
import cz.siret.prank.domain.Protein;
import cz.siret.prank.features.FeatureExtractor;
import cz.siret.prank.features.FeatureSetup;
import cz.siret.prank.features.FeatureVector;
import cz.siret.prank.features.PrankFeatureVector;
import cz.siret.prank.features.api.ProcessedItemContext;
import cz.siret.prank.features.api.SasFeatureCalculationContext;
import cz.siret.prank.features.generic.GenericHeader;
import cz.siret.prank.features.implementation.chem.ChemFeature;
import cz.siret.prank.features.weight.WeightFun;
import cz.siret.prank.geom.Atoms;
import cz.siret.prank.geom.Struct;
import cz.siret.prank.geom.samplers.PointSampler;
import cz.siret.prank.program.PrankException;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.structure.Atom;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrankFeatureExtractor
extends FeatureExtractor<PrankFeatureVector>
implements Parametrized {
    private Map<Integer, FeatureVector> properties;
    private Map<Integer, FeatureVector> smoothRepresentations;
    private GenericHeader headerAdditionalFeatures;
    private List<String> extraFeaturesHeader;
    private List<String> atomTableFeatures;
    private List<String> residueTableFeatures;
    private PointSampler pocketPointSampler;
    private boolean MASK_UNKNOWN_RESIDUES;
    private double NEIGH_CUTOFF_DIST;
    private boolean DO_SMOOTH_REPRESENTATION;
    private double SMOOTHING_CUTOFF_DIST;
    private final boolean AVERAGE_FEAT_VECTORS;
    private final boolean AVG_WEIGHTED;
    private final boolean CHECK_VECTORS;
    private final WeightFun weightFun;
    private Pocket pocket;
    private Atoms surfaceLayerAtoms;
    private Atoms deepLayer;
    private Atoms sampledPoints;
    private FeatureSetup featureSetup;
    private double AVG_POW;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public PrankFeatureExtractor() {
        MetaClass metaClass;
        WeightFun weightFun;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        HashMap<Integer, FeatureVector> hashMap = new HashMap<Integer, FeatureVector>();
        this.properties = hashMap;
        HashMap<Integer, FeatureVector> hashMap2 = new HashMap<Integer, FeatureVector>();
        this.smoothRepresentations = hashMap2;
        this.MASK_UNKNOWN_RESIDUES = bl5 = this.getParams().getMask_unknown_residues();
        double d = this.getParams().getNeighbourhood_radius();
        this.NEIGH_CUTOFF_DIST = d;
        this.DO_SMOOTH_REPRESENTATION = bl4 = this.getParams().getSmooth_representation();
        double d2 = this.getParams().getSmoothing_radius();
        this.SMOOTHING_CUTOFF_DIST = d2;
        this.AVERAGE_FEAT_VECTORS = bl3 = this.getParams().getAverage_feat_vectors();
        this.AVG_WEIGHTED = bl2 = this.getParams().getAvg_weighted();
        this.CHECK_VECTORS = bl = this.getParams().getCheck_vectors();
        this.weightFun = weightFun = WeightFun.create(this.getParams().getWeight_function());
        double d3 = this.getParams().getAvg_pow();
        this.AVG_POW = d3;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
        this.initHeader();
    }

    private PrankFeatureExtractor(Protein protein) {
        super(protein);
        MetaClass metaClass;
        WeightFun weightFun;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        HashMap<Integer, FeatureVector> hashMap = new HashMap<Integer, FeatureVector>();
        this.properties = hashMap;
        HashMap<Integer, FeatureVector> hashMap2 = new HashMap<Integer, FeatureVector>();
        this.smoothRepresentations = hashMap2;
        this.MASK_UNKNOWN_RESIDUES = bl5 = this.getParams().getMask_unknown_residues();
        double d = this.getParams().getNeighbourhood_radius();
        this.NEIGH_CUTOFF_DIST = d;
        this.DO_SMOOTH_REPRESENTATION = bl4 = this.getParams().getSmooth_representation();
        double d2 = this.getParams().getSmoothing_radius();
        this.SMOOTHING_CUTOFF_DIST = d2;
        this.AVERAGE_FEAT_VECTORS = bl3 = this.getParams().getAverage_feat_vectors();
        this.AVG_WEIGHTED = bl2 = this.getParams().getAvg_weighted();
        this.CHECK_VECTORS = bl = this.getParams().getCheck_vectors();
        this.weightFun = weightFun = WeightFun.create(this.getParams().getWeight_function());
        double d3 = this.getParams().getAvg_pow();
        this.AVG_POW = d3;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
        this.initHeader();
    }

    private PrankFeatureExtractor(Protein protein, Pocket pocket, PrankFeatureExtractor proteinPrototype) {
        Map<Integer, FeatureVector> map;
        Map<Integer, FeatureVector> map2;
        Atoms atoms;
        Atoms atoms2;
        FeatureSetup featureSetup;
        PointSampler pointSampler;
        GenericHeader genericHeader;
        boolean bl;
        Pocket pocket2;
        MetaClass metaClass;
        WeightFun weightFun;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        HashMap<Integer, FeatureVector> hashMap = new HashMap<Integer, FeatureVector>();
        this.properties = hashMap;
        HashMap<Integer, FeatureVector> hashMap2 = new HashMap<Integer, FeatureVector>();
        this.smoothRepresentations = hashMap2;
        this.MASK_UNKNOWN_RESIDUES = bl6 = this.getParams().getMask_unknown_residues();
        double d = this.getParams().getNeighbourhood_radius();
        this.NEIGH_CUTOFF_DIST = d;
        this.DO_SMOOTH_REPRESENTATION = bl5 = this.getParams().getSmooth_representation();
        double d2 = this.getParams().getSmoothing_radius();
        this.SMOOTHING_CUTOFF_DIST = d2;
        this.AVERAGE_FEAT_VECTORS = bl4 = this.getParams().getAverage_feat_vectors();
        this.AVG_WEIGHTED = bl3 = this.getParams().getAvg_weighted();
        this.CHECK_VECTORS = bl2 = this.getParams().getCheck_vectors();
        this.weightFun = weightFun = WeightFun.create(this.getParams().getWeight_function());
        double d3 = this.getParams().getAvg_pow();
        this.AVG_POW = d3;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
        Protein protein2 = protein;
        this.setProtein(protein2);
        this.pocket = pocket2 = pocket;
        this.MASK_UNKNOWN_RESIDUES = bl = proteinPrototype.MASK_UNKNOWN_RESIDUES;
        this.headerAdditionalFeatures = genericHeader = proteinPrototype.getHeaderAdditionalFeatures();
        this.pocketPointSampler = pointSampler = proteinPrototype.pocketPointSampler;
        List<String> list = proteinPrototype.getExtraFeaturesHeader();
        this.extraFeaturesHeader = list;
        List<String> list2 = proteinPrototype.getAtomTableFeatures();
        this.atomTableFeatures = list2;
        List<String> list3 = proteinPrototype.getResidueTableFeatures();
        this.residueTableFeatures = list3;
        boolean bl7 = proteinPrototype.getTrainingExtractor();
        this.setTrainingExtractor(bl7);
        this.featureSetup = featureSetup = proteinPrototype.getFeatureSetup();
        this.deepLayer = atoms2 = proteinPrototype.getDeepLayer();
        this.surfaceLayerAtoms = atoms = proteinPrototype.getSurfaceLayerAtoms();
        this.properties = map2 = proteinPrototype.properties;
        this.smoothRepresentations = map = proteinPrototype.smoothRepresentations;
    }

    private void initHeader() {
        GenericHeader genericHeader;
        FeatureSetup featureSetup;
        this.featureSetup = featureSetup = new FeatureSetup(this.getParams().getExtra_features());
        List<String> list = this.featureSetup.getJointHeader();
        this.extraFeaturesHeader = list;
        List<String> list2 = this.getParams().getAtom_table_features();
        this.atomTableFeatures = list2;
        List<String> list3 = this.getParams().getResidue_table_features();
        this.residueTableFeatures = list3;
        this.headerAdditionalFeatures = genericHeader = new GenericHeader(ScriptBytecodeAdapter.createList((Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{this.extraFeaturesHeader, this.atomTableFeatures, this.residueTableFeatures}, (int[])new int[]{0, 0, 0})));
    }

    @Override
    public FeatureExtractor createPrototypeForProtein(Protein protein, ProcessedItemContext context) {
        PrankFeatureExtractor res = new PrankFeatureExtractor(protein);
        boolean bl = this.getTrainingExtractor();
        res.setTrainingExtractor(bl);
        protein.calcuateSurfaceAndExposedAtoms();
        double thickness = Math.max(this.getParams().getProtrusion_radius(), this.getParams().getPair_hist_radius());
        Atoms atoms = protein.getProteinAtoms().cutoutShell(protein.getExposedAtoms(), thickness).buildKdTree();
        res.setDeepLayer(atoms);
        FeatureSetup.Feature feature = null;
        Iterator<FeatureSetup.Feature> iterator = this.featureSetup.getEnabledFeatures().iterator();
        while (iterator.hasNext()) {
            feature = (FeatureSetup.Feature)ScriptBytecodeAdapter.castToType((Object)iterator.next(), FeatureSetup.Feature.class);
            feature.getCalculator().preProcessProtein(protein, context);
        }
        return res;
    }

    @Override
    public void prepareProteinPrototypeForPockets() {
        Object v1;
        Atoms atoms;
        Atoms atoms2;
        PointSampler pointSampler;
        this.pocketPointSampler = pointSampler = PointSampler.create(this.getProtein(), this.getTrainingExtractor());
        this.surfaceLayerAtoms = this.getParams().getDeep_surrounding() ? (atoms2 = this.deepLayer) : (atoms = this.getProtein().getExposedAtoms());
        if (log.isDebugEnabled()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.surfaceLayerAtoms.getCount();
            Pocket pocket = this.pocket;
            Atoms atoms3 = pocket != null ? pocket.getSurfaceAtoms() : null;
            objectArray[1] = atoms3 != null ? Integer.valueOf(atoms3.getCount()) : null;
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(objectArray, new String[]{"surfaceLayerAtoms:", " (surfaceAtoms: ", ") "})));
            v1 = null;
        } else {
            v1 = null;
        }
        this.preEvaluateProperties(this.surfaceLayerAtoms);
        if (this.DO_SMOOTH_REPRESENTATION) {
            this.preEvaluateSmoothRepresentations(this.surfaceLayerAtoms);
        }
    }

    @Override
    public FeatureExtractor createInstanceForPocket(Pocket pocket) {
        PrankFeatureExtractor res = new PrankFeatureExtractor(this.getProtein(), pocket, this);
        if (pocket.getSurfaceAtoms().getCount() == 0) {
            Object v0;
            if (log.isErrorEnabled()) {
                log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getProtein().getName()}, new String[]{"pocket with no surface atoms! [", "]"})));
                v0 = null;
            } else {
                v0 = null;
            }
        }
        res.initForPocket();
        return res;
    }

    private void initForPocket() {
        Object v2;
        Atoms atoms;
        Object v1;
        Object v0;
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.pocket.getName()}, new String[]{"extractorFactory initForPocket for pocket ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.surfaceLayerAtoms.getCount(), this.pocket.getSurfaceAtoms().getCount()}, new String[]{"surfaceLayerAtoms:", " (surfaceAtoms: ", ") "})));
            v1 = null;
        } else {
            v1 = null;
        }
        this.sampledPoints = atoms = this.pocketPointSampler.samplePointsForPocket(this.pocket);
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.pocket.getName(), this.sampledPoints.getCount()}, new String[]{"", " - points sampled: ", ""})));
            v2 = null;
        } else {
            v2 = null;
        }
    }

    public FeatureExtractor createInstanceForWholeProtein(Atoms sampledPoints) {
        Object v0;
        PrankFeatureExtractor res = new PrankFeatureExtractor(this.getProtein(), null, this);
        this.getProtein().calcuateSurfaceAndExposedAtoms();
        Atoms atoms = this.getProtein().getExposedAtoms();
        res.setSurfaceLayerAtoms(atoms);
        res.preEvaluateProperties(res.getSurfaceLayerAtoms());
        if (this.DO_SMOOTH_REPRESENTATION) {
            res.preEvaluateSmoothRepresentations(this.surfaceLayerAtoms);
        }
        if (sampledPoints == null) {
            Atoms atoms2;
            sampledPoints = atoms2 = this.getProtein().getSurface(this.getTrainingExtractor()).getPoints();
        }
        Atoms atoms3 = sampledPoints;
        res.setSampledPoints(atoms3);
        if (log.isInfoEnabled()) {
            log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getProtein().getProteinAtoms().getCount(), res.getSurfaceLayerAtoms().getCount(), res.getDeepLayer().getCount(), res.getSampledPoints().getCount()}, new String[]{"P2R protein:", "  exposedAtoms:", "  deepLayer:", " sasPoints:", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        return res;
    }

    @Override
    public void finalizeProteinPrototype() {
        FeatureSetup.Feature feature = null;
        Iterator<FeatureSetup.Feature> iterator = this.featureSetup.getEnabledFeatures().iterator();
        while (iterator.hasNext()) {
            feature = (FeatureSetup.Feature)ScriptBytecodeAdapter.castToType((Object)iterator.next(), FeatureSetup.Feature.class);
            feature.getCalculator().postProcessProtein(this.getProtein());
        }
    }

    @Override
    public Atoms getSampledPoints() {
        return this.sampledPoints;
    }

    public void preEvaluateProperties(Atoms atoms) {
        Atom a = null;
        Iterator<Atom> iterator = atoms.list.iterator();
        while (iterator.hasNext()) {
            a = (Atom)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Atom.class);
            PrankFeatureVector p = this.calcAtomProperties(a);
            this.properties.put(a.getPDBserial(), p);
        }
    }

    public void preEvaluateSmoothRepresentations(Atoms atoms) {
        Atom a = null;
        Iterator<Atom> iterator = atoms.list.iterator();
        while (iterator.hasNext()) {
            a = (Atom)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Atom.class);
            PrankFeatureVector p = this.calcSmoothRepresentation(a);
            this.smoothRepresentations.put(a.getPDBserial(), p);
        }
    }

    private PrankFeatureVector calcFeatVectorFromVectors(Atom point, Atoms neighbourhoodAtoms, Map<Integer, FeatureVector> fromVectors) {
        PrankFeatureVector res = new PrankFeatureVector(this.headerAdditionalFeatures);
        if (neighbourhoodAtoms.isEmpty()) {
            throw (Throwable)new PrankException("No neighbourhood atoms. Cannot calculate feature vector. (Isn't neighbourhood_radius too small?)");
        }
        int n = neighbourhoodAtoms.getCount();
        double weightSum = 0.0;
        Atom a = null;
        Iterator<Atom> iterator = neighbourhoodAtoms.iterator();
        while (iterator.hasNext()) {
            a = (Atom)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Atom.class);
            PrankFeatureVector props = (PrankFeatureVector)ScriptBytecodeAdapter.castToType((Object)fromVectors.get(a.getPDBserial()), PrankFeatureVector.class);
            double dist = Struct.dist(point, a);
            double weight = this.calcWeight(dist);
            double cfr_ignored_0 = weightSum + weight;
            res.add(props.copy().multiply(weight));
        }
        if (this.AVERAGE_FEAT_VECTORS) {
            double base = n;
            if (this.AVG_WEIGHTED) {
                double d;
                base = d = weightSum;
            }
            double multip = Math.pow(base, this.AVG_POW);
            res.multiply(1.0 / multip);
            if (this.featureSetup.getEnabledFeatureNames().contains(ChemFeature.getNAME())) {
                res.valueVector.multiply("chem.atomDensity", multip);
                res.valueVector.multiply("chem.hDonorAtoms", multip);
                res.valueVector.multiply("chem.hAcceptorAtoms", multip);
            }
        }
        if (this.featureSetup.getEnabledFeatureNames().contains(ChemFeature.getNAME())) {
            res.valueVector.set("chem.atoms", n);
        }
        SasFeatureCalculationContext context = new SasFeatureCalculationContext(this.getProtein(), neighbourhoodAtoms, this);
        FeatureSetup.Feature feature = null;
        Iterator<FeatureSetup.Feature> iterator2 = this.featureSetup.getEnabledSasFeatures().iterator();
        while (iterator2.hasNext()) {
            feature = (FeatureSetup.Feature)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), FeatureSetup.Feature.class);
            double[] values = feature.getCalculator().calculateForSasPoint(point, context);
            res.valueVector.setValues(feature.getStartIndex(), values);
        }
        return res;
    }

    private PrankFeatureVector calcFeatureVectorFromAtoms(Atom point, boolean useSmoothRepresentations, Atoms neighbourhoodAtoms) {
        Map<Integer, FeatureVector> fromVectors = null;
        if (useSmoothRepresentations) {
            Map<Integer, FeatureVector> map;
            fromVectors = map = this.smoothRepresentations;
        } else {
            Map<Integer, FeatureVector> map = this.properties;
            fromVectors = map;
        }
        if (fromVectors == null || fromVectors.isEmpty()) {
            log.error("!!! can't calculate representation from no vectors");
        }
        return this.calcFeatVectorFromVectors(point, neighbourhoodAtoms, fromVectors);
    }

    private double calcWeight(double dist) {
        return this.weightFun.weight(dist);
    }

    private PrankFeatureVector calcSmoothRepresentation(Atom atom) {
        Atoms neighbourhood = this.surfaceLayerAtoms.cutoutSphere(atom, this.SMOOTHING_CUTOFF_DIST);
        return this.calcFeatureVectorFromAtoms(atom, false, neighbourhood);
    }

    private PrankFeatureVector calcAtomProperties(Atom atom) {
        return PrankFeatureVector.forAtom(atom, this);
    }

    @Override
    public PrankFeatureVector calcFeatureVector(Atom point) {
        Atoms neighbourhood = this.surfaceLayerAtoms.cutoutSphere(point, this.NEIGH_CUTOFF_DIST);
        PrankFeatureVector vector = this.calcFeatureVectorFromAtoms(point, this.DO_SMOOTH_REPRESENTATION, neighbourhood);
        return vector;
    }

    @Override
    public List<String> getVectorHeader() {
        return new PrankFeatureVector(this.headerAdditionalFeatures).getHeader();
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PrankFeatureExtractor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(FeatureExtractor.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.features.PrankFeatureExtractor");
        Parametrized.Trait.Helper.$static$init$(PrankFeatureExtractor.class);
    }

    @Generated
    public FeatureExtractor createInstanceForWholeProtein() {
        return this.createInstanceForWholeProtein(null);
    }

    @Generated
    public GenericHeader getHeaderAdditionalFeatures() {
        return this.headerAdditionalFeatures;
    }

    @Generated
    public void setHeaderAdditionalFeatures(GenericHeader genericHeader) {
        this.headerAdditionalFeatures = genericHeader;
    }

    @Generated
    public List<String> getExtraFeaturesHeader() {
        return this.extraFeaturesHeader;
    }

    @Generated
    public void setExtraFeaturesHeader(List<String> list) {
        this.extraFeaturesHeader = list;
    }

    @Generated
    public List<String> getAtomTableFeatures() {
        return this.atomTableFeatures;
    }

    @Generated
    public void setAtomTableFeatures(List<String> list) {
        this.atomTableFeatures = list;
    }

    @Generated
    public List<String> getResidueTableFeatures() {
        return this.residueTableFeatures;
    }

    @Generated
    public void setResidueTableFeatures(List<String> list) {
        this.residueTableFeatures = list;
    }

    @Generated
    public Pocket getPocket() {
        return this.pocket;
    }

    @Generated
    public void setPocket(Pocket pocket) {
        this.pocket = pocket;
    }

    @Generated
    public Atoms getSurfaceLayerAtoms() {
        return this.surfaceLayerAtoms;
    }

    @Generated
    public void setSurfaceLayerAtoms(Atoms atoms) {
        this.surfaceLayerAtoms = atoms;
    }

    @Generated
    public Atoms getDeepLayer() {
        return this.deepLayer;
    }

    @Generated
    public void setDeepLayer(Atoms atoms) {
        this.deepLayer = atoms;
    }

    @Generated
    public void setSampledPoints(Atoms atoms) {
        this.sampledPoints = atoms;
    }

    @Generated
    public FeatureSetup getFeatureSetup() {
        return this.featureSetup;
    }

    @Generated
    public void setFeatureSetup(FeatureSetup featureSetup) {
        this.featureSetup = featureSetup;
    }

    @Generated
    public double getAVG_POW() {
        return this.AVG_POW;
    }

    @Generated
    public void setAVG_POW(double d) {
        this.AVG_POW = d;
    }
}

