/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.domain.labeling;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import cz.siret.prank.domain.AA;
import cz.siret.prank.domain.Protein;
import cz.siret.prank.domain.Residue;
import cz.siret.prank.domain.ResidueChain;
import cz.siret.prank.domain.Residues;
import cz.siret.prank.domain.labeling.BinaryLabeling;
import cz.siret.prank.domain.labeling.ResidueLabeler;
import cz.siret.prank.domain.labeling.ResidueLabeling;
import cz.siret.prank.program.PrankException;
import cz.siret.prank.utils.Futils;
import cz.siret.prank.utils.Writable;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprintLabelingLoader
extends ResidueLabeler<Boolean>
implements Writable {
    private List<LabeledChain> elements;
    private Map<String, LabeledChain> elementsByCode;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    private SprintLabelingLoader(List<LabeledChain> elements) {
        ImmutableMap immutableMap;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Writable.Trait.Helper.$init$(this);
        List<LabeledChain> list = elements;
        this.elements = list;
        this.elementsByCode = immutableMap = Maps.uniqueIndex(elements, (Function)((Function)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure1(this, this)), Function.class)));
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public ResidueLabeling<Double> getDoubleLabeling() {
        return (ResidueLabeling)ScriptBytecodeAdapter.castToType(null, ResidueLabeling.class);
    }

    public String toElementCode(Protein protein, ResidueChain chain) {
        String protCode = protein.getName().substring(0, 4);
        String chainId = chain.getId();
        return StringGroovyMethods.plus((String)protCode, (CharSequence)chainId);
    }

    @Override
    public ResidueLabeling<Boolean> labelResidues(Residues residues, Protein protein) {
        HashMap<Residue.Key, Boolean> labelMap = new HashMap<Residue.Key, Boolean>();
        boolean foundOneChain = false;
        ResidueChain chain = null;
        Iterator<ResidueChain> iterator = protein.getResidueChains().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            chain = (ResidueChain)ScriptBytecodeAdapter.castToType((Object)iterator.next(), ResidueChain.class);
            String chainCode = this.toElementCode(protein, chain);
            LabeledChain element = (LabeledChain)ScriptBytecodeAdapter.castToType((Object)this.elementsByCode.get(chainCode), LabeledChain.class);
            if (element == null) {
                log.info("Labels for chain [{}] not found in labeling file", (Object)chainCode);
                continue;
            }
            foundOneChain = bl = true;
            if (chain.getLength() != element.getLength()) {
                throw (Throwable)new PrankException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{chainCode, chain.getLength(), element.getLength()}, new String[]{"Chain lengths do not match for [", "] (structure: ", ", labeling file: ", ")"})));
            }
            int i = 0;
            Residue residue = null;
            Iterator<Residue> iterator2 = chain.getResidues().iterator();
            while (iterator2.hasNext()) {
                residue = (Residue)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), Residue.class);
                char eleChar = element.getChain().charAt(i);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)residue.getCodeChar(), (Object)Character.valueOf(eleChar))) {
                    throw (Throwable)new PrankException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{chainCode, i, residue.getCodeChar(), Character.valueOf(eleChar)}, new String[]{"Residue code mismatch in [", "] at position [", "] (structure: ", ", labeling file: ", ")"})));
                }
                boolean value = element.getLabels().charAt(i) != DefaultTypeTransformation.charUnbox((Object)ScriptBytecodeAdapter.asType((Object)"0", Character.TYPE));
                labelMap.put(residue.getKey(), value);
                int n = i;
                int cfr_ignored_0 = n + 1;
            }
        }
        if (!foundOneChain) {
            throw (Throwable)new PrankException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{protein.getName()}, new String[]{"Labeling not defined for any chain of protein [", "]"})));
        }
        BinaryLabeling result = new BinaryLabeling(residues.getCount());
        Residue residue = null;
        Iterator<Residue> iterator3 = residues.getList().iterator();
        while (iterator3.hasNext()) {
            residue = (Residue)ScriptBytecodeAdapter.castToType((Object)iterator3.next(), Residue.class);
            result.add(residue, labelMap.get(residue.getKey()));
        }
        return result;
    }

    public static SprintLabelingLoader loadFromFile(String fname) {
        List<String> lines = Futils.readLines(fname);
        ArrayList<LabeledChain> elements = new ArrayList<LabeledChain>();
        int i = 0;
        while (i != lines.size()) {
            String line = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt(lines, (int)i));
            if (line.startsWith(">")) {
                String code = line.substring(1);
                String chain = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt(lines, (int)(i + 1)));
                String labels = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt(lines, (int)(i + 2)));
                elements.add(new LabeledChain(code, chain, labels));
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return new SprintLabelingLoader(elements);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SprintLabelingLoader.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;Lorg/slf4j/Logger;)V")
    public static void write(String arg1, Logger arg2) {
        ScriptBytecodeAdapter.invokeMethodN(SprintLabelingLoader.class, Writable.Trait.Helper.class, (String)"write", (Object[])new Object[]{SprintLabelingLoader.class, arg1, arg2});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;Ljava/lang/Throwable;)V")
    public static void writeError(String arg1, Throwable arg2) {
        ScriptBytecodeAdapter.invokeMethodN(SprintLabelingLoader.class, Writable.Trait.Helper.class, (String)"writeError", (Object[])new Object[]{SprintLabelingLoader.class, arg1, arg2});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;)V")
    public static void write(String arg1) {
        ScriptBytecodeAdapter.invokeMethodN(SprintLabelingLoader.class, Writable.Trait.Helper.class, (String)"write", (Object[])new Object[]{SprintLabelingLoader.class, arg1});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;)V")
    public static void writeError(String arg1) {
        ScriptBytecodeAdapter.invokeMethodN(SprintLabelingLoader.class, Writable.Trait.Helper.class, (String)"writeError", (Object[])new Object[]{SprintLabelingLoader.class, arg1});
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.domain.labeling.SprintLabelingLoader");
        Writable.Trait.Helper.$static$init$(SprintLabelingLoader.class);
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(SprintLabelingLoader.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, SprintLabelingLoader.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(SprintLabelingLoader.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    public List<LabeledChain> getElements() {
        return this.elements;
    }

    @Generated
    public void setElements(List<LabeledChain> list) {
        this.elements = list;
    }

    @Generated
    public Map<String, LabeledChain> getElementsByCode() {
        return this.elementsByCode;
    }

    @Generated
    public void setElementsByCode(Map<String, LabeledChain> map) {
        this.elementsByCode = map;
    }

    static class LabeledChain
    implements GroovyObject {
        private String code;
        private String chain;
        private String labels;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public LabeledChain(String code, String chain, String labels) {
            String string;
            String string2;
            String string3;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.code = string3 = code;
            this.chain = string2 = chain;
            this.labels = string = labels;
            this.checkValidity();
        }

        public int getLength() {
            return this.chain.length();
        }

        public void checkValidity() {
            ValueRecorder valueRecorder = new ValueRecorder();
            try {
                String string = this.chain;
                valueRecorder.record((Object)string, 8);
                valueRecorder.record((Object)string, 8);
                int n = StringGroovyMethods.size((String)string);
                valueRecorder.record((Object)n, 14);
                String string2 = this.labels;
                valueRecorder.record((Object)string2, 24);
                valueRecorder.record((Object)string2, 24);
                int n2 = StringGroovyMethods.size((String)string2);
                valueRecorder.record((Object)n2, 31);
                boolean bl = n == n2;
                valueRecorder.record((Object)bl, 21);
                if (bl) {
                    valueRecorder.clear();
                } else {
                    ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert chain.size() == labels.size()", (ValueRecorder)valueRecorder), null);
                }
            }
            catch (Throwable throwable) {
                valueRecorder.clear();
                throw throwable;
            }
            ValueRecorder valueRecorder2 = new ValueRecorder();
            try {
                String string = this.labels;
                valueRecorder2.record((Object)string, 8);
                valueRecorder2.record((Object)string, 8);
                Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)string, (Object)"[01]*");
                valueRecorder2.record((Object)matcher, 15);
                if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                    valueRecorder2.clear();
                } else {
                    ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert labels =~ /[01]*/", (ValueRecorder)valueRecorder2), null);
                }
            }
            catch (Throwable throwable) {
                valueRecorder2.clear();
                throw throwable;
            }
            ValueRecorder valueRecorder3 = new ValueRecorder();
            try {
                String string = this.chain;
                valueRecorder3.record((Object)string, 8);
                valueRecorder3.record((Object)string, 8);
                Object[] objectArray = new Object[1];
                String string3 = AA.getALL_CODE_CHARS();
                valueRecorder3.record((Object)string3, -1);
                valueRecorder3.record((Object)string3, 24);
                objectArray[0] = string3;
                Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)string, (Object)new GStringImpl(objectArray, new String[]{"[", "]*"}));
                valueRecorder3.record((Object)matcher, 14);
                if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                    valueRecorder3.clear();
                } else {
                    ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert chain =~ /[${AA.ALL_CODE_CHARS}]*/", (ValueRecorder)valueRecorder3), null);
                }
            }
            catch (Throwable throwable) {
                valueRecorder3.clear();
                throw throwable;
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != LabeledChain.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(LabeledChain.class, SprintLabelingLoader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(LabeledChain.class, SprintLabelingLoader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, SprintLabelingLoader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, SprintLabelingLoader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(LabeledChain.class, SprintLabelingLoader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(LabeledChain.class, SprintLabelingLoader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public void setCode(String string) {
            this.code = string;
        }

        @Generated
        public String getChain() {
            return this.chain;
        }

        @Generated
        public void setChain(String string) {
            this.chain = string;
        }

        @Generated
        public String getLabels() {
            return this.labels;
        }

        @Generated
        public void setLabels(String string) {
            this.labels = string;
        }
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            return ((LabeledChain)it).getCode();
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

