/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.domain.labeling;

import cz.siret.prank.domain.Protein;
import cz.siret.prank.domain.Residue;
import cz.siret.prank.domain.labeling.BinaryLabeling;
import cz.siret.prank.domain.labeling.LabeledPoint;
import cz.siret.prank.domain.labeling.PointLabeler;
import cz.siret.prank.geom.Atoms;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResidueBasedPointLabeler
extends PointLabeler {
    private BinaryLabeling residueLabeling;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ResidueBasedPointLabeler(BinaryLabeling residueLabeling) {
        BinaryLabeling binaryLabeling;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.residueLabeling = binaryLabeling = residueLabeling;
    }

    @Override
    public List<LabeledPoint> labelPoints(Atoms points, Protein protein) {
        ArrayList<LabeledPoint> res = new ArrayList<LabeledPoint>(DefaultGroovyMethods.size((Iterable)points));
        Atom point = null;
        Iterator<Atom> iterator = points.iterator();
        while (iterator.hasNext()) {
            point = (Atom)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Atom.class);
            Residue nearestRes = protein.getResidues().findNearest(point);
            Boolean label = (Boolean)ScriptBytecodeAdapter.castToType(this.residueLabeling.getLabel(nearestRes), Boolean.class);
            boolean observed = false;
            if (label != null) {
                Boolean bl = label;
                observed = DefaultTypeTransformation.booleanUnbox((Object)bl);
            } else {
                boolean bl;
                Object v0;
                if (log.isWarnEnabled()) {
                    log.warn("Label for residue [{}] not found. This shouldn't happen!", (Object)nearestRes.getKey());
                    v0 = null;
                } else {
                    v0 = null;
                }
                observed = bl = false;
            }
            res.add(new LabeledPoint(point, observed));
        }
        return res;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ResidueBasedPointLabeler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.domain.labeling.ResidueBasedPointLabeler");
    }

    @Generated
    public BinaryLabeling getResidueLabeling() {
        return this.residueLabeling;
    }

    @Generated
    public void setResidueLabeling(BinaryLabeling binaryLabeling) {
        this.residueLabeling = binaryLabeling;
    }
}

