/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.domain.labeling;

import cz.siret.prank.domain.Protein;
import cz.siret.prank.domain.Residue;
import cz.siret.prank.domain.Residues;
import cz.siret.prank.domain.labeling.BinaryLabeling;
import cz.siret.prank.domain.labeling.LabeledPoint;
import cz.siret.prank.domain.labeling.LabeledResidue;
import cz.siret.prank.domain.labeling.ModelBasedPointLabeler;
import cz.siret.prank.domain.labeling.ResidueLabeler;
import cz.siret.prank.domain.labeling.ResidueLabeling;
import cz.siret.prank.features.api.ProcessedItemContext;
import cz.siret.prank.geom.Atoms;
import cz.siret.prank.prediction.metrics.ClassifierStats;
import cz.siret.prank.prediction.pockets.PointScoreCalculator;
import cz.siret.prank.program.ml.Model;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import cz.siret.prank.utils.Cutils;
import cz.siret.prank.utils.Formatter;
import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelBasedResidueLabeler
extends ResidueLabeler<Boolean>
implements Parametrized {
    private Model model;
    private Atoms sasPoints;
    private ProcessedItemContext context;
    private List<LabeledPoint> labeledPoints;
    private List<LabeledPoint> observedPoints;
    private ClassifierStats classifierStats;
    private ResidueLabeling<Double> doubleLabeling;
    private final PointScoreCalculator pointScoreCalculator;
    private double SCORE_THRESHOLD;
    private double RADIUS;
    private double SUM_TO_AVG_POW;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ModelBasedResidueLabeler(Model model, Atoms sasPoints, ProcessedItemContext context) {
        ProcessedItemContext processedItemContext;
        Atoms atoms;
        Model model2;
        MetaClass metaClass;
        PointScoreCalculator pointScoreCalculator;
        Object var4_4 = null;
        this.observedPoints = (List)ScriptBytecodeAdapter.castToType(var4_4, List.class);
        this.pointScoreCalculator = pointScoreCalculator = new PointScoreCalculator();
        double d = this.getParams().getResidue_score_threshold();
        this.SCORE_THRESHOLD = d;
        double d2 = this.getParams().getSasCutoffDist() + this.getParams().getResidue_score_extra_dist();
        this.RADIUS = d2;
        double d3 = this.getParams().getResidue_score_sum_to_avg();
        this.SUM_TO_AVG_POW = d3;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
        this.model = model2 = model;
        this.sasPoints = atoms = sasPoints;
        this.context = processedItemContext = context;
    }

    public ModelBasedResidueLabeler withObserved(List<LabeledPoint> observedPoints) {
        List<LabeledPoint> list = observedPoints;
        this.observedPoints = list;
        return this;
    }

    public List<LabeledPoint> getLabeledPoints() {
        return this.labeledPoints;
    }

    public ClassifierStats getClassifierStats() {
        return this.classifierStats;
    }

    @Override
    public ResidueLabeling<Double> getDoubleLabeling() {
        return this.doubleLabeling;
    }

    @Override
    public ResidueLabeling<Boolean> labelResidues(Residues residues, Protein protein) {
        ClassifierStats classifierStats;
        ModelBasedPointLabeler predictor = new ModelBasedPointLabeler(this.model, this.context).withObserved(this.observedPoints);
        if (this.getParams().getHopt_train_only_once()) {
            if (protein.getSecondaryData().containsKey("saved_labeled_points")) {
                List list;
                this.labeledPoints = list = (List)ScriptBytecodeAdapter.castToType((Object)protein.getSecondaryData().get("saved_labeled_points"), List.class);
            } else {
                List<LabeledPoint> list = predictor.labelPoints(this.sasPoints, protein);
                this.labeledPoints = list;
                protein.getSecondaryData().put("saved_labeled_points", this.labeledPoints);
            }
        } else {
            List<LabeledPoint> list = predictor.labelPoints(this.sasPoints, protein);
            this.labeledPoints = list;
        }
        this.classifierStats = classifierStats = predictor.getClassifierStats();
        return this.calculateLabeling(residues, this.labeledPoints, protein);
    }

    public BinaryLabeling calculateLabeling(Residues residues, List<LabeledPoint> labeledPoints, Protein protein) {
        Atoms points = new Atoms(labeledPoints);
        Residues exposed = protein.getExposedResidues();
        ResidueLabeling<Double> resScores = new ResidueLabeling<Double>(residues.getCount());
        Residue res = null;
        Iterator<Residue> iterator = residues.iterator();
        while (iterator.hasNext()) {
            Object v0;
            res = (Residue)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Residue.class);
            List pscores = Collections.emptyList();
            if (exposed.contains(res)) {
                List list;
                public final class _calculateLabeling_closure1
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _calculateLabeling_closure1(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ((LabeledPoint)ScriptBytecodeAdapter.asType((Object)it, LabeledPoint.class)).getScore();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _calculateLabeling_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                pscores = list = DefaultGroovyMethods.asList((Iterable)DefaultGroovyMethods.collect((Iterable)points.cutoutShell(res.getAtoms(), this.RADIUS), (Closure)new _calculateLabeling_closure1(this, this)));
            }
            double score = this.aggregateScore(pscores);
            if (log.isDebugEnabled()) {
                log.debug("RES[{}] (score={}) pscores(n={}): {}", new Object[]{res, Formatter.format(score, 2), pscores.size(), Formatter.formatNumbers(pscores, 2)});
                v0 = null;
            } else {
                v0 = null;
            }
            resScores.add(res, score);
        }
        ResidueLabeling<Double> residueLabeling = resScores;
        this.doubleLabeling = residueLabeling;
        BinaryLabeling resLabels = new BinaryLabeling(residues.getCount());
        LabeledResidue it = null;
        Iterator iterator2 = resScores.getLabeledResidues().iterator();
        while (iterator2.hasNext()) {
            it = (LabeledResidue)ScriptBytecodeAdapter.castToType(iterator2.next(), LabeledResidue.class);
            resLabels.add(it.getResidue(), this.binaryLabel(DefaultTypeTransformation.doubleUnbox(it.getLabel())));
        }
        return resLabels;
    }

    private boolean binaryLabel(double score) {
        return !(score < this.SCORE_THRESHOLD);
    }

    private double aggregateScore(List<Double> scores) {
        double d;
        if (scores.isEmpty()) {
            return 0.0;
        }
        int limit = this.getParams().getScore_point_limit();
        if (limit > 0 && scores.size() > limit) {
            List list = Cutils.head(limit, DefaultGroovyMethods.toSorted(scores));
            scores = list;
        }
        public final class _aggregateScore_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _aggregateScore_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((ModelBasedResidueLabeler)this.getThisObject()).pointScoreCalculator.transformScore(DefaultTypeTransformation.doubleUnbox((Object)it));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _aggregateScore_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List transformedScores = DefaultGroovyMethods.asList((Iterable)DefaultGroovyMethods.collect(scores, (Closure)new _aggregateScore_closure2(this, this)));
        double sum = Cutils.sum(transformedScores);
        double base = scores.size();
        base = d = Math.pow(base, this.SUM_TO_AVG_POW);
        double score = sum / base;
        return score;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ModelBasedResidueLabeler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(ResidueLabeler.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.domain.labeling.ModelBasedResidueLabeler");
        Parametrized.Trait.Helper.$static$init$(ModelBasedResidueLabeler.class);
    }
}

