/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.domain;

import com.google.common.base.Function;
import cz.siret.prank.domain.Residue;
import cz.siret.prank.geom.Atoms;
import cz.siret.prank.utils.Cutils;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Group;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Residues
implements Iterable<Residue>,
GroovyObject {
    private List<Residue> list;
    private Atoms atoms;
    private Map<Residue.Key, Residue> indexByKey;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public Residues(List<Residue> list) {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        List<Residue> list2 = list;
        this.list = list2;
        Map map = Cutils.mapWithIndex(list, (Function)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure1(this, this)), Function.class));
        this.indexByKey = map;
        if (this.indexByKey.size() < list.size()) {
            Object v0;
            if (log.isWarnEnabled()) {
                log.warn("Multiple residues with same label! [{}]", (Object)DefaultGroovyMethods.join(Cutils.findDuplicates((Iterable)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(Residues.class, list, (String)"key"), Iterable.class)), (String)","));
                v0 = null;
            } else {
                v0 = null;
            }
        }
    }

    public List<Residue> getList() {
        return this.list;
    }

    public Atoms getAtoms() {
        if (this.atoms == null) {
            Atoms atoms;
            public final class _getAtoms_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getAtoms_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ((Residue)it).getAtoms();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getAtoms_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            this.atoms = atoms = Atoms.join(DefaultGroovyMethods.collect(this.list, (Closure)new _getAtoms_closure2(this, this)));
        }
        return this.atoms;
    }

    public boolean contains(Residue residue) {
        return this.indexByKey.containsKey(residue.getKey());
    }

    public int getCount() {
        return this.list.size();
    }

    @Nullable
    public Residue getResidue(Residue.Key key) {
        return (Residue)ScriptBytecodeAdapter.castToType((Object)this.indexByKey.get(key), Residue.class);
    }

    @Nullable
    public Residue getResidueForAtom(Atom a) {
        return this.getResidue((Residue.Key)ScriptBytecodeAdapter.asType((Object)Residue.Key.forAtom(a), Residue.Key.class));
    }

    @Nullable
    public Residue getResidueForGroup(Group g) {
        Group group = g;
        List list = group != null ? group.getAtoms() : null;
        return this.getResidue((Residue.Key)ScriptBytecodeAdapter.asType((Object)Residue.Key.forAtom((Atom)ScriptBytecodeAdapter.castToType((Object)(list != null ? DefaultGroovyMethods.first((List)list) : null), Atom.class)), Residue.Key.class));
    }

    public List<Residue> getDistinctForAtoms(Atoms atoms) {
        public final class _getDistinctForAtoms_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getDistinctForAtoms_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((Residues)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), Residues.class)).getResidueForGroup((Group)ScriptBytecodeAdapter.castToType((Object)it, Group.class));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDistinctForAtoms_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _getDistinctForAtoms_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getDistinctForAtoms_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return it != null;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDistinctForAtoms_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.asList((Iterable)DefaultGroovyMethods.findAll((List)DefaultGroovyMethods.collect(atoms.getDistinctGroups(), (Closure)new _getDistinctForAtoms_closure3(this, this)), (Closure)new _getDistinctForAtoms_closure4(this, this)));
    }

    public Residue findNearest(Atom point) {
        Atom nearestAtom = this.getAtoms().withKdTree().getKdTree().findNearest(point);
        return this.getResidueForAtom(nearestAtom);
    }

    @Override
    public Iterator<Residue> iterator() {
        return this.list.iterator();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Residues.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.domain.Residues");
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            return ((Residue)it).getKey();
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

