/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.domain;

import cz.siret.prank.domain.AA;
import cz.siret.prank.domain.ResidueChain;
import cz.siret.prank.geom.Atoms;
import cz.siret.prank.geom.Struct;
import cz.siret.prank.program.PrankException;
import cz.siret.prank.utils.PdbUtils;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.biojava.nbio.structure.AminoAcid;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.secstruc.SecStrucInfo;
import org.biojava.nbio.structure.secstruc.SecStrucType;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Residue
implements GroovyObject {
    @Nonnull
    private Key key;
    @Nonnull
    private Group group;
    private Atoms atoms;
    private Atoms headAtoms;
    private Atoms sideChainAtoms;
    private boolean exposed;
    private ResidueChain chain;
    private int posInChain;
    @Nullable
    private Residue previousInChain;
    @Nullable
    private Residue nextInChain;
    @Nullable
    private SsInfo ss;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public Residue(Group group) {
        Key key;
        Group group2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.group = group2 = group;
        this.key = key = new Key(group.getResidueNumber());
    }

    public static Residue fromGroup(Group group) {
        if (!(Struct.isAminoAcidGroup(group) || group.getPDBName().startsWith("UNK"))) {
            throw (Throwable)new PrankException(StringGroovyMethods.plus((CharSequence)"Trying to create residue from non amino acid group: ", (Object)group));
        }
        return new Residue(group);
    }

    public AminoAcid getAminoAcid() {
        return (AminoAcid)ScriptBytecodeAdapter.castToType((Object)this.group, AminoAcid.class);
    }

    public Key getKey() {
        return this.key;
    }

    @Nullable
    public String getChainId() {
        return this.group.getChainId();
    }

    public ResidueNumber getResidueNumber() {
        return this.group.getResidueNumber();
    }

    public Atoms getAtoms() {
        if (this.atoms == null) {
            Atoms atoms;
            this.atoms = atoms = Atoms.allFromGroup(this.group);
        }
        return this.atoms;
    }

    private Object splitAtoms() {
        Atoms atoms;
        Atoms atoms2;
        this.getAtoms();
        this.headAtoms = atoms2 = new Atoms(4);
        this.sideChainAtoms = atoms = new Atoms(this.atoms.getCount());
        Atom a = null;
        Iterator<Atom> iterator = this.atoms.iterator();
        while (iterator.hasNext()) {
            a = (Atom)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Atom.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)(ScriptBytecodeAdapter.createList((Object[])new Object[]{"CA", "C", "O", "N"}) == null ? Boolean.valueOf(a.getName() == null) : Boolean.valueOf(DefaultGroovyMethods.isCase((Collection)ScriptBytecodeAdapter.createList((Object[])new Object[]{"CA", "C", "O", "N"}), (Object)a.getName()))))) {
                this.headAtoms.add(a);
                continue;
            }
            this.sideChainAtoms.add(a);
        }
        return null;
    }

    public Atoms getHeadAtoms() {
        if (this.headAtoms == null) {
            this.splitAtoms();
        }
        return this.headAtoms;
    }

    public Atoms getSideChainAtoms() {
        if (this.headAtoms == null) {
            this.splitAtoms();
        }
        return this.sideChainAtoms;
    }

    @Nullable
    public String getCode() {
        return PdbUtils.getResidueCode(this.group);
    }

    @Nullable
    public String getCorrectedCode() {
        return PdbUtils.getCorrectedResidueCode(this.group);
    }

    @Nullable
    public AA getAa() {
        return AA.forName(this.getCorrectedCode());
    }

    public Character getCodeChar() {
        AA aA = this.getAa();
        return aA != null ? Character.valueOf(aA.getCodeChar()) : null;
    }

    public String toString() {
        return this.key.toString();
    }

    public SecStrucInfo getSectStructInfo() {
        SecStrucInfo ss = (SecStrucInfo)ScriptBytecodeAdapter.castToType((Object)this.group.getProperty(Group.SEC_STRUC), SecStrucInfo.class);
        return ss;
    }

    public SecStrucType getSecStruct() {
        SecStrucInfo secStrucInfo = this.getSectStructInfo();
        return secStrucInfo != null ? secStrucInfo.getType() : null;
    }

    public static String safe1Code(Residue res) {
        if (res == null) {
            return "_";
        }
        if (res.getAa() == null) {
            return "?";
        }
        return Character.valueOf(res.getAa().getCodeChar()).toString();
    }

    public static String safeOrderedCode2(Residue res1, Residue res2) {
        return StringGroovyMethods.plus((String)Residue.safe1Code(res1), (CharSequence)Residue.safe1Code(res2));
    }

    public static String safeSorted3Code(Residue res1, Residue res2, Residue res3) {
        String code = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)Residue.safe1Code(res1), (CharSequence)Residue.safe1Code(res2)), (CharSequence)Residue.safe1Code(res3));
        if (code.charAt(0) > code.charAt(2)) {
            String string;
            code = string = StringGroovyMethods.reverse((CharSequence)code);
        }
        return code;
    }

    public static String safeSorted3CodeFor(Residue res) {
        return Residue.safeSorted3Code(res.getPreviousInChain(), res, res.getNextInChain());
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Residue.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(Residue.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Residue.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(Residue.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.domain.Residue");
    }

    @Generated
    public boolean getExposed() {
        return this.exposed;
    }

    @Generated
    public boolean isExposed() {
        return this.exposed;
    }

    @Generated
    public void setExposed(boolean bl) {
        this.exposed = bl;
    }

    @Generated
    public ResidueChain getChain() {
        return this.chain;
    }

    @Generated
    public void setChain(ResidueChain residueChain) {
        this.chain = residueChain;
    }

    @Generated
    public int getPosInChain() {
        return this.posInChain;
    }

    @Generated
    public void setPosInChain(int n) {
        this.posInChain = n;
    }

    @Generated
    public Residue getPreviousInChain() {
        return this.previousInChain;
    }

    @Generated
    public void setPreviousInChain(Residue residue) {
        this.previousInChain = residue;
    }

    @Generated
    public Residue getNextInChain() {
        return this.nextInChain;
    }

    @Generated
    public void setNextInChain(Residue residue) {
        this.nextInChain = residue;
    }

    @Generated
    public SsInfo getSs() {
        return this.ss;
    }

    @Generated
    public void setSs(SsInfo ssInfo) {
        this.ss = ssInfo;
    }

    public static final class Key
    implements GroovyObject {
        private ResidueNumber residueNumber;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public Key(ResidueNumber residueNumber) {
            ResidueNumber residueNumber2;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Objects.requireNonNull(residueNumber);
            this.residueNumber = residueNumber2 = residueNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (ScriptBytecodeAdapter.compareNotEqual(this.getClass(), o.getClass())) {
                return false;
            }
            Key key = (Key)ScriptBytecodeAdapter.castToType((Object)o, Key.class);
            return !ScriptBytecodeAdapter.compareNotEqual((Object)this.residueNumber, (Object)key.residueNumber);
        }

        public int hashCode() {
            return this.residueNumber.hashCode();
        }

        public static Object forAtom(Atom atom) {
            Atom atom2 = atom;
            Group group = atom2 != null ? atom2.getGroup() : null;
            ResidueNumber rn = group != null ? group.getResidueNumber() : null;
            if (rn != null) {
                return new Key(rn);
            }
            return null;
        }

        public String toString() {
            return this.residueNumber.printFull();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Key.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Key.class, Residue.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Key.class, Residue.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Residue.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Residue.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Key.class, Residue.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Key.class, Residue.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    public static class SsInfo
    implements GroovyObject {
        private SsSection section;
        private int posInSection;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public SsInfo(SsSection section, int posInSection) {
            int n;
            SsSection ssSection;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.section = ssSection = section;
            this.posInSection = n = posInSection;
        }

        public int getPosInSection() {
            return this.posInSection;
        }

        public double getRelativePosInSection() {
            int n = this.section.getLength() - 1;
            if (n == 0) {
                return 0.0;
            }
            return (double)this.posInSection / (double)n;
        }

        public SecStrucType getType() {
            return this.section.getType();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != SsInfo.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(SsInfo.class, Residue.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(SsInfo.class, Residue.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Residue.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Residue.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(SsInfo.class, Residue.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(SsInfo.class, Residue.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public SsSection getSection() {
            return this.section;
        }

        @Generated
        public void setSection(SsSection ssSection) {
            this.section = ssSection;
        }

        @Generated
        public void setPosInSection(int n) {
            this.posInSection = n;
        }
    }

    public static class SsSection
    implements GroovyObject {
        private SecStrucType type;
        private int startPos;
        private int length;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public SsSection(SecStrucType type, int startPos, int length) {
            int n;
            int n2;
            SecStrucType secStrucType;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.type = secStrucType = type;
            this.startPos = n2 = startPos;
            this.length = n = length;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != SsSection.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(SsSection.class, Residue.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(SsSection.class, Residue.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Residue.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Residue.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(SsSection.class, Residue.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(SsSection.class, Residue.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public SecStrucType getType() {
            return this.type;
        }

        @Generated
        public void setType(SecStrucType secStrucType) {
            this.type = secStrucType;
        }

        @Generated
        public int getStartPos() {
            return this.startPos;
        }

        @Generated
        public void setStartPos(int n) {
            this.startPos = n;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public void setLength(int n) {
            this.length = n;
        }
    }
}

