/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.domain;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import cz.siret.prank.domain.Ligand;
import cz.siret.prank.domain.Ligands;
import cz.siret.prank.domain.Pocket;
import cz.siret.prank.domain.Residue;
import cz.siret.prank.domain.ResidueChain;
import cz.siret.prank.domain.Residues;
import cz.siret.prank.domain.labeling.ResidueLabeling;
import cz.siret.prank.domain.loaders.LoaderParams;
import cz.siret.prank.features.api.ProcessedItemContext;
import cz.siret.prank.features.implementation.conservation.ConservationScore;
import cz.siret.prank.geom.Atoms;
import cz.siret.prank.geom.SecondaryStructureUtils;
import cz.siret.prank.geom.Struct;
import cz.siret.prank.geom.Surface;
import cz.siret.prank.program.PrankException;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import cz.siret.prank.utils.Futils;
import cz.siret.prank.utils.PdbUtils;
import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.print.PrintException;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.secstruc.SecStrucType;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Protein
implements Parametrized,
GroovyObject {
    private String name;
    private Structure structure;
    private Structure fullStructure;
    private Atoms allAtoms;
    private Atoms proteinAtoms;
    private Atoms exposedAtoms;
    private Surface accessibleSurface;
    private Surface trainSurface;
    private List<Ligand> ligands;
    private List<Ligand> smallLigands;
    private List<Ligand> ignoredLigands;
    private List<Ligand> distantLigands;
    private List<ResidueChain> peptides;
    private Map<String, ResidueChain> residueChainsMap;
    private Residues residues;
    private Residues exposedResidues;
    private Map<String, Object> secondaryData;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public Protein() {
        MetaClass metaClass;
        ArrayList<Ligand> arrayList = new ArrayList<Ligand>();
        this.ligands = arrayList;
        ArrayList<Ligand> arrayList2 = new ArrayList<Ligand>();
        this.smallLigands = arrayList2;
        ArrayList<Ligand> arrayList3 = new ArrayList<Ligand>();
        this.ignoredLigands = arrayList3;
        ArrayList<Ligand> arrayList4 = new ArrayList<Ligand>();
        this.distantLigands = arrayList4;
        ArrayList<ResidueChain> arrayList5 = new ArrayList<ResidueChain>();
        this.peptides = arrayList5;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.secondaryData = hashMap;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
    }

    public int getLigandCount() {
        return this.ligands.size();
    }

    public void calcuateSurfaceAndExposedAtoms() {
        if (this.exposedAtoms == null) {
            Object v1;
            Object v0;
            Atoms atoms;
            if (this.proteinAtoms.isEmpty()) {
                throw (Throwable)new PrankException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.name}, new String[]{"Protein with no chain atoms [", "]!"})));
            }
            this.exposedAtoms = atoms = this.getAccessibleSurface().computeExposedAtoms(this.proteinAtoms);
            if (log.isInfoEnabled()) {
                log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.accessibleSurface.getPoints().getCount()}, new String[]{"SAS points: ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            if (log.isInfoEnabled()) {
                log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.exposedAtoms.getCount(), this.proteinAtoms.getCount()}, new String[]{"exposed protein atoms: ", " of ", ""})));
                v1 = null;
            } else {
                v1 = null;
            }
        }
    }

    public ConservationScore loadConservationScores(ProcessedItemContext itemContext) {
        Object v0;
        if (log.isInfoEnabled()) {
            log.info("Loading conservation scores for [{}]", (Object)itemContext.getItem().getLabel());
            v0 = null;
        } else {
            v0 = null;
        }
        java.util.function.Function pathFunction = (java.util.function.Function)ScriptBytecodeAdapter.castToType((Object)itemContext.getAuxData().get(ConservationScore.CONSERV_PATH_FUNCTION_KEY), java.util.function.Function.class);
        ConservationScore score = ConservationScore.fromFiles(this.structure, pathFunction);
        this.secondaryData.put(ConservationScore.CONSERV_SCORE_KEY, score);
        this.secondaryData.put(ConservationScore.CONSERV_LOADED_KEY, true);
        return score;
    }

    public void ensureConservationLoaded(ProcessedItemContext itemContext) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.secondaryData.getOrDefault(ConservationScore.CONSERV_LOADED_KEY, false)) && itemContext.getAuxData().getOrDefault(ConservationScore.CONSERV_SCORE_KEY, null) != null) {
            this.loadConservationScores(itemContext);
        }
    }

    @Nullable
    public ConservationScore getConservationScore() {
        return (ConservationScore)ScriptBytecodeAdapter.castToType((Object)this.secondaryData.get(ConservationScore.CONSERV_SCORE_KEY), ConservationScore.class);
    }

    @Nullable
    public ResidueLabeling<Double> getConservationLabeling() {
        ConservationScore score = this.getConservationScore();
        return (ResidueLabeling)ScriptBytecodeAdapter.castToType(score == null ? null : score.toDoubleLabeling(this), ResidueLabeling.class);
    }

    public Atoms getExposedAtoms() {
        this.calcuateSurfaceAndExposedAtoms();
        return this.exposedAtoms;
    }

    public Surface getSurface(boolean train) {
        if (train) {
            return this.getTrainSurface();
        }
        return this.getAccessibleSurface();
    }

    public Surface getAccessibleSurface() {
        if (this.accessibleSurface == null) {
            Surface surface;
            this.accessibleSurface = surface = Surface.computeAccessibleSurface(this.proteinAtoms, this.getParams().getSolvent_radius(), this.getParams().getTessellation());
        }
        return this.accessibleSurface;
    }

    public Surface getTrainSurface() {
        if (this.trainSurface == null) {
            boolean shouldBeDistinct = this.getParams().getTessellation() != this.getParams().getTrain_tessellation();
            if (shouldBeDistinct) {
                Object v0;
                Surface surface;
                this.trainSurface = surface = Surface.computeAccessibleSurface(this.proteinAtoms, this.getParams().getSolvent_radius(), this.getParams().getTrain_tessellation());
                if (log.isInfoEnabled()) {
                    log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.trainSurface.getPoints().getCount()}, new String[]{"train SAS points: ", ""})));
                    v0 = null;
                } else {
                    v0 = null;
                }
            } else {
                Surface surface;
                this.trainSurface = surface = this.accessibleSurface;
            }
        }
        return this.trainSurface;
    }

    public void clearSecondaryData() {
        Object var1_1 = null;
        this.accessibleSurface = (Surface)ScriptBytecodeAdapter.castToType(var1_1, Surface.class);
        Object var2_2 = null;
        this.trainSurface = (Surface)ScriptBytecodeAdapter.castToType(var2_2, Surface.class);
        Object var3_3 = null;
        this.exposedAtoms = (Atoms)ScriptBytecodeAdapter.castToType(var3_3, Atoms.class);
        this.secondaryData.clear();
        public final class _clearSecondaryData_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _clearSecondaryData_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                Object var2_2 = null;
                ((Ligand)it).setSasPoints((Atoms)ScriptBytecodeAdapter.castToType(var2_2, Atoms.class));
                Object var3_3 = null;
                ((Ligand)it).setPredictedPocket((Pocket)ScriptBytecodeAdapter.castToType(var3_3, Pocket.class));
                return null;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _clearSecondaryData_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.ligands, (Closure)new _clearSecondaryData_closure1(this, this));
        this.clearResidues();
    }

    public Atoms getAllLigandAtoms() {
        Atoms res = new Atoms();
        Ligand lig = null;
        Iterator<Ligand> iterator = this.ligands.iterator();
        while (iterator.hasNext()) {
            lig = (Ligand)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Ligand.class);
            res.addAll(lig.getAtoms());
        }
        return res;
    }

    public void calculateResidues() {
        Residues residues;
        ImmutableMap immutableMap;
        public final class _calculateResidues_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateResidues_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((ResidueChain)it).getId();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateResidues_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        this.residueChainsMap = immutableMap = Maps.uniqueIndex(Struct.residueChainsFromStructure(this.structure), (Function)((Function)ScriptBytecodeAdapter.castToType((Object)((Object)new _calculateResidues_closure2(this, this)), Function.class)));
        public final class _calculateResidues_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateResidues_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((ResidueChain)it).getResidues();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateResidues_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        this.residues = residues = new Residues(DefaultGroovyMethods.flatten((List)DefaultGroovyMethods.asList((Iterable)DefaultGroovyMethods.collect(this.getResidueChains(), (Closure)new _calculateResidues_closure3(this, this)))));
    }

    public void checkResiduesCalculated() {
        if (this.residueChainsMap == null) {
            this.calculateResidues();
        }
    }

    public void clearResidues() {
        Object var1_1 = null;
        this.residues = (Residues)ScriptBytecodeAdapter.castToType(var1_1, Residues.class);
        Object var2_2 = null;
        this.exposedResidues = (Residues)ScriptBytecodeAdapter.castToType(var2_2, Residues.class);
        Object var3_3 = null;
        this.residueChainsMap = (Map)ScriptBytecodeAdapter.castToType(var3_3, Map.class);
    }

    public Residues getResidues() {
        this.checkResiduesCalculated();
        return this.residues;
    }

    public Atoms getResidueAtoms() {
        return this.getResidues().getAtoms();
    }

    public Residues getExposedResidues() {
        this.checkResiduesCalculated();
        if (this.exposedResidues == null) {
            this.calculateExposedResidues();
        }
        return this.exposedResidues;
    }

    public List<ResidueChain> getResidueChains() {
        this.checkResiduesCalculated();
        return DefaultGroovyMethods.asList(this.residueChainsMap.values());
    }

    public ResidueChain getResidueChain(String id) {
        this.checkResiduesCalculated();
        return (ResidueChain)ScriptBytecodeAdapter.castToType((Object)this.residueChainsMap.get(id), ResidueChain.class);
    }

    @Nullable
    public Residue getResidueForAtom(Atom a) {
        return this.getResidues().getResidueForAtom(a);
    }

    private void calculateExposedResidues() {
        Residues residues;
        this.checkResiduesCalculated();
        public final class _calculateExposedResidues_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateExposedResidues_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                Residue res = ((Protein)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), Protein.class)).getResidueForAtom((Atom)ScriptBytecodeAdapter.castToType((Object)it, Atom.class));
                if (res != null) {
                    boolean bl = true;
                    res.setExposed(bl);
                    return true;
                }
                return null;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateExposedResidues_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Iterable)this.getExposedAtoms(), (Closure)new _calculateExposedResidues_closure4(this, this));
        public final class _calculateExposedResidues_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateExposedResidues_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((Residue)it).getExposed();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateExposedResidues_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        this.exposedResidues = residues = new Residues(DefaultGroovyMethods.asList((Iterable)DefaultGroovyMethods.findAll(this.residues.getList(), (Closure)new _calculateExposedResidues_closure5(this, this))));
    }

    public void assignSecondaryStructure() {
        SecondaryStructureUtils.assignSecondaryStructure(this.structure);
        this.checkResiduesCalculated();
        ResidueChain chain = null;
        Iterator<ResidueChain> iterator = this.getResidueChains().iterator();
        while (iterator.hasNext()) {
            chain = (ResidueChain)ScriptBytecodeAdapter.castToType((Object)iterator.next(), ResidueChain.class);
            int pos = 0;
            while (pos != chain.getLength()) {
                Residue res = (Residue)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(chain.getResidues(), (int)pos), Residue.class);
                if (!(res.getSs() != null)) {
                    SecStrucType type = res.getSecStruct();
                    int pos2 = pos + 1;
                    while (pos2 < chain.getResidues().size() && ScriptBytecodeAdapter.compareEqual((Object)((Residue)DefaultGroovyMethods.getAt(chain.getResidues(), (int)pos2)).getSecStruct(), (Object)type)) {
                        int n = pos2;
                        int cfr_ignored_0 = n + 1;
                    }
                    int secLength = pos2 - pos;
                    Residue.SsSection section = new Residue.SsSection(type, pos, secLength);
                    int i = 0;
                    while (i != secLength) {
                        Residue.SsInfo ssInfo;
                        new Residue.SsInfo(section, i);
                        ((Residue)DefaultGroovyMethods.getAt(chain.getResidues(), (int)(pos + i))).setSs(ssInfo);
                        int n = i;
                        int cfr_ignored_1 = n + 1;
                    }
                }
                int n = pos;
                int cfr_ignored_2 = n + 1;
            }
        }
    }

    public String saveToPdbFile(String fileName, boolean compressed) {
        if (compressed) {
            String string;
            fileName = string = StringGroovyMethods.plus((String)fileName, (CharSequence)".gz");
            Futils.writeGzip(fileName, this.structure.toPDB());
        } else {
            Futils.writeFile(fileName, this.structure.toPDB());
        }
        return fileName;
    }

    public static Protein load(String pdbFileName, LoaderParams loaderParams) {
        Protein res = new Protein();
        res.loadFile(pdbFileName, loaderParams, null);
        return res;
    }

    public static Protein loadReduced(String pdbFileName, LoaderParams loaderParams, List<String> onlyChains) {
        Protein res = new Protein();
        res.loadFile(pdbFileName, loaderParams, onlyChains);
        return res;
    }

    private void loadFile(String pdbFileName, LoaderParams loaderParams, @Nullable List<String> onlyChains) {
        Object v3;
        Object v2;
        Atoms atoms;
        Atoms atoms2;
        Structure structure;
        Structure structure2;
        String string;
        Object v0;
        if (log.isInfoEnabled()) {
            log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Futils.absPath(pdbFileName)}, new String[]{"loading protein [", "]"})));
            v0 = null;
        } else {
            v0 = null;
        }
        this.name = string = Futils.shortName(pdbFileName);
        this.structure = structure2 = PdbUtils.loadFromFile(pdbFileName);
        if (this.structure.nrModels() > 1) {
            Structure structure3;
            log.info("protein [{}] contains multiple models, reducing to model 0");
            this.structure = structure3 = Struct.reduceStructureToModel0(this.structure);
        }
        this.fullStructure = structure = this.structure;
        if (onlyChains != null) {
            Structure structure4;
            String string2;
            Object v1;
            if (log.isInfoEnabled()) {
                log.info("reducing protein [{}] to chains [{}]", (Object)this.name, (Object)DefaultGroovyMethods.join(onlyChains, (String)","));
                v1 = null;
            } else {
                v1 = null;
            }
            if (onlyChains.size() > 1) {
                throw (Throwable)new PrintException("Reducing structure to multiple chains is not supported yet!");
            }
            String chainId = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.first(onlyChains));
            this.name = string2 = StringGroovyMethods.plus((String)this.name, (CharSequence)chainId);
            this.structure = structure4 = StructureTools.getReducedStructure((Structure)this.structure, (String)ShortTypeHandling.castToString((Object)DefaultGroovyMethods.first(onlyChains)));
        }
        this.allAtoms = atoms2 = Atoms.allFromStructure(this.structure).withIndex();
        this.proteinAtoms = atoms = Atoms.onlyProteinAtoms(this.structure).withoutHydrogens();
        if (log.isInfoEnabled()) {
            log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.allAtoms.getCount()}, new String[]{"structure atoms: ", ""})));
            v2 = null;
        } else {
            v2 = null;
        }
        if (log.isInfoEnabled()) {
            log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.proteinAtoms.getCount()}, new String[]{"protein   atoms: ", ""})));
            v3 = null;
        } else {
            v3 = null;
        }
        if (this.proteinAtoms.isEmpty()) {
            Object v4;
            if (log.isErrorEnabled()) {
                log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.name}, new String[]{"protein with no chain atoms! [", "]"})));
                v4 = null;
            } else {
                v4 = null;
            }
            throw (Throwable)new PrankException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.name}, new String[]{"Protein with no chain atoms [", "]!"})));
        }
        if (!loaderParams.getIgnoreLigands()) {
            Ligands categorizedLigands = new Ligands().loadForProtein(this, loaderParams, pdbFileName);
            List<Ligand> list = categorizedLigands.getRelevantLigands();
            this.ligands = list;
            List<Ligand> list2 = categorizedLigands.getSmallLigands();
            this.smallLigands = list2;
            List<Ligand> list3 = categorizedLigands.getDistantLigands();
            this.distantLigands = list3;
            List<Ligand> list4 = categorizedLigands.getIgnoredLigands();
            this.ignoredLigands = list4;
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Protein.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.domain.Protein");
        Parametrized.Trait.Helper.$static$init$(Protein.class);
    }

    @Generated
    public String saveToPdbFile(String fileName) {
        return this.saveToPdbFile(fileName, false);
    }

    @Generated
    public static Protein load(String pdbFileName) {
        return Protein.load(pdbFileName, new LoaderParams());
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String string) {
        this.name = string;
    }

    @Generated
    public Structure getStructure() {
        return this.structure;
    }

    @Generated
    public void setStructure(Structure structure) {
        this.structure = structure;
    }

    @Generated
    public Structure getFullStructure() {
        return this.fullStructure;
    }

    @Generated
    public void setFullStructure(Structure structure) {
        this.fullStructure = structure;
    }

    @Generated
    public Atoms getAllAtoms() {
        return this.allAtoms;
    }

    @Generated
    public void setAllAtoms(Atoms atoms) {
        this.allAtoms = atoms;
    }

    @Generated
    public Atoms getProteinAtoms() {
        return this.proteinAtoms;
    }

    @Generated
    public void setProteinAtoms(Atoms atoms) {
        this.proteinAtoms = atoms;
    }

    @Generated
    public void setExposedAtoms(Atoms atoms) {
        this.exposedAtoms = atoms;
    }

    @Generated
    public void setAccessibleSurface(Surface surface) {
        this.accessibleSurface = surface;
    }

    @Generated
    public void setTrainSurface(Surface surface) {
        this.trainSurface = surface;
    }

    @Generated
    public List<Ligand> getLigands() {
        return this.ligands;
    }

    @Generated
    public void setLigands(List<Ligand> list) {
        this.ligands = list;
    }

    @Generated
    public List<Ligand> getSmallLigands() {
        return this.smallLigands;
    }

    @Generated
    public void setSmallLigands(List<Ligand> list) {
        this.smallLigands = list;
    }

    @Generated
    public List<Ligand> getIgnoredLigands() {
        return this.ignoredLigands;
    }

    @Generated
    public void setIgnoredLigands(List<Ligand> list) {
        this.ignoredLigands = list;
    }

    @Generated
    public List<Ligand> getDistantLigands() {
        return this.distantLigands;
    }

    @Generated
    public void setDistantLigands(List<Ligand> list) {
        this.distantLigands = list;
    }

    @Generated
    public List<ResidueChain> getPeptides() {
        return this.peptides;
    }

    @Generated
    public void setPeptides(List<ResidueChain> list) {
        this.peptides = list;
    }

    @Generated
    public Map<String, Object> getSecondaryData() {
        return this.secondaryData;
    }

    @Generated
    public void setSecondaryData(Map<String, Object> map) {
        this.secondaryData = map;
    }
}

