/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.domain;

import cz.siret.prank.domain.Ligand;
import cz.siret.prank.domain.Protein;
import cz.siret.prank.domain.loaders.LoaderParams;
import cz.siret.prank.geom.Atoms;
import cz.siret.prank.geom.Struct;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Group;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ligands
implements Parametrized,
GroovyObject {
    private List<Ligand> relevantLigands;
    private List<Ligand> smallLigands;
    private List<Ligand> ignoredLigands;
    private List<Ligand> distantLigands;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public Ligands() {
        MetaClass metaClass;
        ArrayList<Ligand> arrayList = new ArrayList<Ligand>();
        this.relevantLigands = arrayList;
        ArrayList<Ligand> arrayList2 = new ArrayList<Ligand>();
        this.smallLigands = arrayList2;
        ArrayList<Ligand> arrayList3 = new ArrayList<Ligand>();
        this.ignoredLigands = arrayList3;
        ArrayList<Ligand> arrayList4 = new ArrayList<Ligand>();
        this.distantLigands = arrayList4;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
    }

    public Ligands loadForProtein(Protein protein, LoaderParams loaderParams, String pdbFileName) {
        Reference loaderParams2 = new Reference((Object)loaderParams);
        List<Group> ligandGroups = Struct.getLigandGroups(protein.getStructure());
        if (((LoaderParams)loaderParams2.get()).getLigandsSeparatedByTER()) {
            List<Atoms> ligAtomGroups = this.getLigandAtomGroupsByTER(protein.getAllAtoms(), pdbFileName);
            List<Ligand> ligands = this.makeLigands(ligAtomGroups, protein);
            List<Ligand> list = ligands;
            this.relevantLigands = list;
        } else {
            List<Atoms> list;
            public final class _loadForProtein_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference loaderParams;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _loadForProtein_closure1(Object _outerInstance, Object _thisObject, Reference loaderParams) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.loaderParams = reference = loaderParams;
                }

                public Object doCall(Object it) {
                    return Ligands.isRelevantLigGroup((Group)ScriptBytecodeAdapter.castToType((Object)it, Group.class), (LoaderParams)ScriptBytecodeAdapter.castToType((Object)this.loaderParams.get(), LoaderParams.class));
                }

                public LoaderParams getLoaderParams() {
                    return (LoaderParams)ScriptBytecodeAdapter.castToType((Object)this.loaderParams.get(), LoaderParams.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadForProtein_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List relevantGroups = DefaultGroovyMethods.findAll(ligandGroups, (Closure)new _loadForProtein_closure1(this, this, loaderParams2));
            public final class _loadForProtein_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference loaderParams;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _loadForProtein_closure2(Object _outerInstance, Object _thisObject, Reference loaderParams) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.loaderParams = reference = loaderParams;
                }

                public Object doCall(Object it) {
                    return !Ligands.isRelevantLigGroup((Group)ScriptBytecodeAdapter.castToType((Object)it, Group.class), (LoaderParams)ScriptBytecodeAdapter.castToType((Object)this.loaderParams.get(), LoaderParams.class));
                }

                public LoaderParams getLoaderParams() {
                    return (LoaderParams)ScriptBytecodeAdapter.castToType((Object)this.loaderParams.get(), LoaderParams.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadForProtein_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List ignoredGroups = DefaultGroovyMethods.findAll(ligandGroups, (Closure)new _loadForProtein_closure2(this, this, loaderParams2));
            public final class _loadForProtein_closure3
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _loadForProtein_closure3(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return Atoms.allFromGroup((Group)ScriptBytecodeAdapter.castToType((Object)it, Group.class));
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadForProtein_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List<Atoms> relevantAtomGroups = DefaultGroovyMethods.collect((Iterable)relevantGroups, (Closure)new _loadForProtein_closure3(this, this));
            public final class _loadForProtein_closure4
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _loadForProtein_closure4(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return Atoms.allFromGroup((Group)ScriptBytecodeAdapter.castToType((Object)it, Group.class));
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadForProtein_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List ignoredAtomGroups = DefaultGroovyMethods.collect((Iterable)ignoredGroups, (Closure)new _loadForProtein_closure4(this, this));
            relevantAtomGroups = list = Struct.clusterAtomGroups(relevantAtomGroups, this.getParams().getLigand_clustering_distance());
            List<Ligand> ligands = this.makeLigands(relevantAtomGroups, protein);
            if (((LoaderParams)loaderParams2.get()).getRelevantLigandsDefined()) {
                List<Ligand> list2 = ligands;
                this.relevantLigands = list2;
            } else {
                this.categorizeLigands(ligands, (LoaderParams)loaderParams2.get());
            }
            List<Ligand> list3 = this.makeLigands(ignoredAtomGroups, protein);
            this.ignoredLigands = list3;
        }
        this.sortLigands(this.relevantLigands);
        this.sortLigands(this.ignoredLigands);
        this.sortLigands(this.smallLigands);
        this.sortLigands(this.distantLigands);
        return this;
    }

    private static boolean isRelevantLigGroup(Group group, LoaderParams loaderParams) {
        if (loaderParams.getRelevantLigandsDefined()) {
            return loaderParams.getRelevantLigandNames().contains(group.getPDBName());
        }
        return !loaderParams.getIgnoredHetGroups().contains(group.getPDBName());
    }

    private List<Ligand> makeLigands(List<Atoms> ligAtomGroups, Protein protein) {
        Object v0;
        if (log.isInfoEnabled()) {
            log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{ligAtomGroups.size()}, new String[]{"loading ", " ligands"})));
            v0 = null;
        } else {
            v0 = null;
        }
        ArrayList<Ligand> res = new ArrayList<Ligand>();
        Atoms ligAtoms = null;
        Iterator<Atoms> iterator = ligAtomGroups.iterator();
        while (iterator.hasNext()) {
            double d;
            double d2;
            ligAtoms = (Atoms)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Atoms.class);
            if (!(ligAtoms.getCount() > 0)) continue;
            Ligand lig = new Ligand(ligAtoms, protein);
            protein.getProteinAtoms().dist(lig.getAtoms().getCenterOfMass());
            lig.setCenterToProteinDist(d2);
            protein.getProteinAtoms().dist(lig.getAtoms());
            lig.setContactDistance(d);
            res.add(lig);
        }
        return res;
    }

    private void sortLigands(List<Ligand> ligands) {
        public final class _sortLigands_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _sortLigands_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)((Ligand)it).getNameCode(), (CharSequence)"_"), (CharSequence)((Ligand)it).getCode());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _sortLigands_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.sort(ligands, (Closure)new _sortLigands_closure5(this, this));
    }

    private void categorizeLigands(List<Ligand> ligands, LoaderParams loaderParams) {
        Ligand ligand = null;
        Iterator<Ligand> iterator = ligands.iterator();
        while (iterator.hasNext()) {
            ligand = (Ligand)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Ligand.class);
            this.categorizeLigand(ligand, loaderParams);
        }
    }

    private void categorizeLigand(Ligand lig, LoaderParams loaderParams) {
        if (lig.getAtoms().getCount() < loaderParams.getMinLigandAtoms()) {
            Object v0;
            if (log.isInfoEnabled()) {
                log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{lig.getName(), lig.getAtoms().getCount(), loaderParams.getMinLigandAtoms()}, new String[]{"ignoring ligand ", " with only ", " atoms (min ", ")"})));
                v0 = null;
            } else {
                v0 = null;
            }
            this.smallLigands.add(lig);
        } else if (!(lig.getContactDistance() <= this.getParams().getLigand_protein_contact_distance())) {
            Object v1;
            if (log.isInfoEnabled()) {
                log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{lig.getName(), lig.getContactDistance(), this.getParams().getLigand_protein_contact_distance()}, new String[]{"ignoring ligand ", " that is not in contact with protein surface d=", " (max=", ")"})));
                v1 = null;
            } else {
                v1 = null;
            }
            this.distantLigands.add(lig);
        } else if (!(lig.getCenterToProteinDist() <= this.getParams().getLigc_prot_dist())) {
            Object v2;
            if (log.isInfoEnabled()) {
                log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{lig.getName(), lig.getCenterToProteinDist(), this.getParams().getLigc_prot_dist()}, new String[]{"ignoring ligand ", " that has a center too far from protein surface d=", " (max=", ")"})));
                v2 = null;
            } else {
                v2 = null;
            }
            this.distantLigands.add(lig);
        } else {
            this.relevantLigands.add(lig);
        }
    }

    private List<Atoms> getLigandAtomGroupsByTER(Atoms allStructAtoms, String pdbFileName) {
        ArrayList<Atoms> res = new ArrayList<Atoms>();
        ArrayList<Atom> curLigAtoms = new ArrayList<Atom>();
        String line = null;
        Iterator iterator = ResourceGroovyMethods.readLines((File)new File(pdbFileName)).iterator();
        while (iterator.hasNext()) {
            line = ShortTypeHandling.castToString(iterator.next());
            if (line.startsWith("A")) continue;
            if (line.startsWith("HETATM")) {
                Object v0;
                String tline = line.substring(6);
                int atomId = StringGroovyMethods.toInteger((CharSequence)this.firstWord(tline));
                Atom a = allStructAtoms.getByID(atomId);
                if (a != null) {
                    curLigAtoms.add(a);
                    continue;
                }
                if (log.isWarnEnabled()) {
                    log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{atomId, pdbFileName, line}, new String[]{"can't find atom ", "! file: ", "\n", "\n"})));
                    v0 = null;
                    continue;
                }
                v0 = null;
                continue;
            }
            if (!line.startsWith("TER")) continue;
            if (curLigAtoms != null) {
                res.add(new Atoms((List<? extends Atom>)curLigAtoms));
            }
            ArrayList arrayList = new ArrayList();
            curLigAtoms = arrayList;
        }
        return res;
    }

    public String firstWord(String s) {
        String string;
        s = string = s.trim();
        int i = 0;
        while (i != s.length()) {
            if (Character.isWhitespace(s.charAt(i))) {
                return ShortTypeHandling.castToString((Object)s.subSequence(0, i));
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return s;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Ligands.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.domain.Ligands");
        Parametrized.Trait.Helper.$static$init$(Ligands.class);
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public List<Ligand> getRelevantLigands() {
        return this.relevantLigands;
    }

    @Generated
    public void setRelevantLigands(List<Ligand> list) {
        this.relevantLigands = list;
    }

    @Generated
    public List<Ligand> getSmallLigands() {
        return this.smallLigands;
    }

    @Generated
    public void setSmallLigands(List<Ligand> list) {
        this.smallLigands = list;
    }

    @Generated
    public List<Ligand> getIgnoredLigands() {
        return this.ignoredLigands;
    }

    @Generated
    public void setIgnoredLigands(List<Ligand> list) {
        this.ignoredLigands = list;
    }

    @Generated
    public List<Ligand> getDistantLigands() {
        return this.distantLigands;
    }

    @Generated
    public void setDistantLigands(List<Ligand> list) {
        this.distantLigands = list;
    }
}

