/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.domain;

import cz.siret.prank.domain.Pocket;
import cz.siret.prank.domain.Protein;
import cz.siret.prank.geom.Atoms;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import cz.siret.prank.utils.PdbUtils;
import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Group;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ligand
implements Parametrized,
GroovyObject {
    private String name;
    private String code;
    private Atoms atoms;
    private Protein protein;
    private double contactDistance;
    private double centerToProteinDist;
    private Atoms sasPoints;
    private Pocket predictedPocket;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public Ligand(Atoms ligAtoms, Protein protein) {
        Object v0;
        String string;
        String string2;
        Protein protein2;
        Atoms atoms;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
        if (!(!ligAtoms.isEmpty())) {
            ScriptBytecodeAdapter.assertFailed((Object)"ligAtoms.empty", (Object)"Trying to create ligand with no atoms!");
        }
        this.atoms = atoms = new Atoms(ligAtoms);
        this.protein = protein2 = protein;
        List<Group> groups = this.atoms.getDistinctGroupsSorted();
        Set uniqueNames = DefaultGroovyMethods.toSet((Collection)((Collection)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(Ligand.class, groups, (String)"PDBName"), Collection.class)));
        this.name = string2 = DefaultGroovyMethods.join((Iterable)uniqueNames, (String)"&");
        this.code = string = DefaultGroovyMethods.join((Iterable)((Iterable)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(Ligand.class, groups, (String)"residueNumber"), Iterable.class)), (String)"&");
        Atom a = null;
        Iterator<Atom> iterator = this.atoms.iterator();
        while (iterator.hasNext()) {
            a = (Atom)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Atom.class);
            PdbUtils.correctBioJavaElement(a);
        }
        if (log.isDebugEnabled()) {
            DefaultGroovyMethods.each(groups, (Closure)new _closure1(this, this));
        }
        if (log.isInfoEnabled()) {
            log.info(this.toString());
            v0 = null;
        } else {
            v0 = null;
        }
    }

    public Atoms getSasPoints() {
        if (this.sasPoints == null) {
            Atoms atoms;
            this.sasPoints = atoms = this.protein.getAccessibleSurface().getPoints().cutoutShell(this.atoms, this.getParams().getLigand_induced_volume_cutoff());
        }
        return this.sasPoints;
    }

    public Atom getCentroid() {
        return this.atoms.getCenterOfMass();
    }

    public String getNameCode() {
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)this.name, (CharSequence)"_"), (CharSequence)this.code);
    }

    public int getSize() {
        return this.atoms.getCount();
    }

    public String toString() {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.name, this.atoms.getCount()}, new String[]{"ligand ", " atoms:", ""}));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Ligand.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.domain.Ligand");
        Parametrized.Trait.Helper.$static$init$(Ligand.class);
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String string) {
        this.name = string;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public void setCode(String string) {
        this.code = string;
    }

    @Generated
    public Atoms getAtoms() {
        return this.atoms;
    }

    @Generated
    public void setAtoms(Atoms atoms) {
        this.atoms = atoms;
    }

    @Generated
    public Protein getProtein() {
        return this.protein;
    }

    @Generated
    public void setProtein(Protein protein) {
        this.protein = protein;
    }

    @Generated
    public double getContactDistance() {
        return this.contactDistance;
    }

    @Generated
    public void setContactDistance(double d) {
        this.contactDistance = d;
    }

    @Generated
    public double getCenterToProteinDist() {
        return this.centerToProteinDist;
    }

    @Generated
    public void setCenterToProteinDist(double d) {
        this.centerToProteinDist = d;
    }

    @Generated
    public void setSasPoints(Atoms atoms) {
        this.sasPoints = atoms;
    }

    @Generated
    public Pocket getPredictedPocket() {
        return this.predictedPocket;
    }

    @Generated
    public void setPredictedPocket(Pocket pocket) {
        this.predictedPocket = pocket;
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Group g) {
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug(StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)new GStringImpl(new Object[]{g.getPDBName(), g.getResidueNumber()}, new String[]{"\tligand group: ", " [", "] atoms:"}), (Object)Atoms.allFromGroup(g).getCount()), (CharSequence)" component: "), (Object)g.getChemComp()));
                v0 = null;
            } else {
                v0 = null;
            }
            return v0;
        }

        public Object call(Group g) {
            return this.doCall(g);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

