/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.domain;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import cz.siret.prank.domain.Prediction;
import cz.siret.prank.domain.PredictionPair;
import cz.siret.prank.domain.Protein;
import cz.siret.prank.domain.labeling.BinaryLabeling;
import cz.siret.prank.domain.labeling.ResidueLabeler;
import cz.siret.prank.domain.loaders.pockets.ConcavityLoader;
import cz.siret.prank.domain.loaders.pockets.DeepSiteLoader;
import cz.siret.prank.domain.loaders.pockets.FPocketLoader;
import cz.siret.prank.domain.loaders.pockets.LiseLoader;
import cz.siret.prank.domain.loaders.pockets.MetaPocket2Loader;
import cz.siret.prank.domain.loaders.pockets.P2RankLoader;
import cz.siret.prank.domain.loaders.pockets.PredictionLoader;
import cz.siret.prank.domain.loaders.pockets.SiteHoundLoader;
import cz.siret.prank.features.api.ProcessedItemContext;
import cz.siret.prank.program.PrankException;
import cz.siret.prank.program.ThreadPoolFactory;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import cz.siret.prank.utils.Futils;
import cz.siret.prank.utils.Sutils;
import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dataset
implements Parametrized,
GroovyObject {
    private static final Splitter SPLITTER;
    private static final String PARAM_PREDICTION_METHOD = "PREDICTION_METHOD";
    private static final String PARAM_LIGANDS_SEPARATED_BY_TER = "LIGANDS_SEPARATED_BY_TER";
    private static final String PARAM_RESIDUE_LABELING_FORMAT = "RESIDUE_LABELING_FORMAT";
    private static final String PARAM_RESIDUE_LABELING_FILE = "RESIDUE_LABELING_FILE";
    private static final String COLUMN_PROTEIN = "protein";
    private static final String COLUMN_PREDICTION = "prediction";
    private static final String COLUMN_LIGAND_CODES = "ligand_codes";
    private static final String COLUMN_CONSERVATION_FILES_PATTERN = "conservation_files_pattern";
    private static final String COLUMN_CHAINS = "chains";
    private static final List<String> DEFAULT_HEADER;
    private String name;
    private String dir;
    private Map<String, String> attributes;
    private List<String> header;
    private List<Item> items;
    private boolean cached;
    private ResidueLabeler residueLabeler;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public Dataset(String name, String dir) {
        MetaClass metaClass;
        boolean bl;
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        Object object = callSiteArray[0].callConstructor(HashMap.class);
        this.attributes = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        List<String> list = DEFAULT_HEADER;
        this.header = list;
        Object object2 = callSiteArray[1].callConstructor(ArrayList.class);
        this.items = (List)ScriptBytecodeAdapter.castToType((Object)object2, List.class);
        this.cached = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        callSiteArray[2].call(Parametrized.Trait.Helper.class, (Object)this);
        String string = name;
        this.name = ShortTypeHandling.castToString((Object)string);
        String string2 = dir;
        this.dir = ShortTypeHandling.castToString((Object)string2);
    }

    public Dataset withCache(boolean c) {
        boolean bl;
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        this.cached = bl = c;
        return this;
    }

    public String getLabel() {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[3].call(Futils.class, (Object)this.name));
    }

    public int getSize() {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        return DefaultTypeTransformation.intUnbox((Object)callSiteArray[4].call(this.items));
    }

    public void clearSecondaryCaches() {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        public final class _clearSecondaryCaches_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _clearSecondaryCaches_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _clearSecondaryCaches_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _clearSecondaryCaches_closure1.$getCallSiteArray();
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[0].callGetProperty(it), null)) {
                    callSiteArray[1].call(callSiteArray[2].callGetProperty(callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(it))));
                    return callSiteArray[5].call(callSiteArray[6].callGetProperty(callSiteArray[7].callGetProperty(it)));
                }
                return null;
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _clearSecondaryCaches_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _clearSecondaryCaches_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "cachedPair";
                stringArray[1] = "clearSecondaryData";
                stringArray[2] = Dataset.COLUMN_PROTEIN;
                stringArray[3] = Dataset.COLUMN_PREDICTION;
                stringArray[4] = "cachedPair";
                stringArray[5] = "clearSecondaryData";
                stringArray[6] = Dataset.COLUMN_PROTEIN;
                stringArray[7] = "cachedPair";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _clearSecondaryCaches_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_clearSecondaryCaches_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _clearSecondaryCaches_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[5].call(this.items, (Object)new _clearSecondaryCaches_closure1(this, this));
    }

    public void clearPrimaryCaches() {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        public final class _clearPrimaryCaches_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _clearPrimaryCaches_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _clearPrimaryCaches_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _clearPrimaryCaches_closure2.$getCallSiteArray();
                Object var3_3 = null;
                ScriptBytecodeAdapter.setProperty(var3_3, null, (Object)it, (String)"cachedPair");
                return var3_3;
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _clearPrimaryCaches_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _clearPrimaryCaches_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_clearPrimaryCaches_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _clearPrimaryCaches_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[6].call(this.items, (Object)new _clearPrimaryCaches_closure2(this, this));
    }

    public boolean checkFilesExist() {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        Reference ok = new Reference((Object)true);
        public final class _checkFilesExist_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference ok;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _checkFilesExist_closure3(Object _outerInstance, Object _thisObject, Reference ok) {
                Reference reference;
                CallSite[] callSiteArray = _checkFilesExist_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.ok = reference = ok;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _checkFilesExist_closure3.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), callSiteArray[2].callGetProperty(Dataset.class))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(Futils.class, callSiteArray[4].callGetProperty(it)))) {
                    Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call(callSiteArray[6].callGetProperty(Dataset.class))) ? callSiteArray[7].call(callSiteArray[8].callGetProperty(Dataset.class), (Object)new GStringImpl(new Object[]{callSiteArray[9].callGetProperty(it)}, new String[]{"prediction file doesn't exist: ", ""})) : null;
                    boolean bl = false;
                    this.ok.set((Object)bl);
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[10].call(callSiteArray[11].callGroovyObjectGetProperty((Object)this), callSiteArray[12].callGetProperty(Dataset.class)))) {
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call(Futils.class, callSiteArray[14].callGetProperty(it)))) {
                        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].call(callSiteArray[16].callGetProperty(Dataset.class))) ? callSiteArray[17].call(callSiteArray[18].callGetProperty(Dataset.class), (Object)new GStringImpl(new Object[]{callSiteArray[19].callGetProperty(it)}, new String[]{"protein file doesn't exist: ", ""})) : null;
                        boolean bl = false;
                        this.ok.set((Object)bl);
                        return bl;
                    }
                    return null;
                }
                return null;
            }

            public Boolean getOk() {
                CallSite[] callSiteArray = _checkFilesExist_closure3.$getCallSiteArray();
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.ok.get(), Boolean.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _checkFilesExist_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _checkFilesExist_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "contains";
                stringArray[1] = "header";
                stringArray[2] = "COLUMN_PREDICTION";
                stringArray[3] = "exists";
                stringArray[4] = "pocketPredictionFile";
                stringArray[5] = "isErrorEnabled";
                stringArray[6] = "log";
                stringArray[7] = "error";
                stringArray[8] = "log";
                stringArray[9] = "pocketPredictionFile";
                stringArray[10] = "contains";
                stringArray[11] = "header";
                stringArray[12] = "COLUMN_PROTEIN";
                stringArray[13] = "exists";
                stringArray[14] = "proteinFile";
                stringArray[15] = "isErrorEnabled";
                stringArray[16] = "log";
                stringArray[17] = "error";
                stringArray[18] = "log";
                stringArray[19] = "proteinFile";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[20];
                _checkFilesExist_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_checkFilesExist_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _checkFilesExist_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[7].call(this.items, (Object)new _checkFilesExist_closure3(this, this, ok));
        return DefaultTypeTransformation.booleanUnbox((Object)((Boolean)ok.get()));
    }

    public Result processItems(Processor processor) {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        return (Result)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].callCurrent((GroovyObject)this, callSiteArray[9].callGetProperty(callSiteArray[10].callGroovyObjectGetProperty((Object)this)), (Object)processor), Result.class);
    }

    public Result processItems(Closure processor) {
        Reference processor2 = new Reference((Object)processor);
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        return (Result)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callCurrent((GroovyObject)this, (Object)new Processor(this, processor2){
            public /* synthetic */ Reference processor;
            public /* synthetic */ Dataset this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Reference reference;
                Dataset dataset;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0 = dataset = p0;
                this.processor = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void processItem(Item item) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                callSiteArray[0].call(this.processor.get(), (Object)item);
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0.this$dist$set$1(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "call";
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), Result.class);
    }

    public Result processItems(boolean parallel, Processor processor) {
        Reference processor2 = new Reference((Object)processor);
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].call((Object)log)) ? callSiteArray[13].call((Object)log, callSiteArray[14].call((Object)"ITEMS: ", callSiteArray[15].call(Sutils.class, this.items))) : null;
        Reference result = new Reference((Object)((Result)ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].callConstructor(Result.class), Result.class)));
        if (parallel) {
            int nt = DefaultTypeTransformation.intUnbox((Object)callSiteArray[17].callGetProperty(callSiteArray[18].callGetProperty(ThreadPoolFactory.class)));
            Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[19].call((Object)log)) ? callSiteArray[20].call((Object)log, (Object)new GStringImpl(new Object[]{this.name, nt}, new String[]{"processing dataset [", "] using ", " threads"})) : null;
            ExecutorService executor = (ExecutorService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].call(Executors.class, callSiteArray[22].callGetProperty(callSiteArray[23].callGroovyObjectGetProperty((Object)this))), ExecutorService.class);
            Reference tasks = new Reference((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].callConstructor(ArrayList.class), List.class)));
            public final class _processItems_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference tasks;
                private /* synthetic */ Reference processor;
                private /* synthetic */ Reference result;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _processItems_closure4(Object _outerInstance, Object _thisObject, Reference tasks, Reference processor, Reference result) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    CallSite[] callSiteArray = _processItems_closure4.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.tasks = reference3 = tasks;
                    this.processor = reference2 = processor;
                    this.result = reference = result;
                }

                public Object doCall(Item item, int idx) {
                    Reference item2 = new Reference((Object)item);
                    CallSite[] callSiteArray = _processItems_closure4.$getCallSiteArray();
                    Reference num = new Reference((Object)0);
                    if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        Object object = callSiteArray[0].call((Object)idx, (Object)1);
                        num.set((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)object, Integer.class)));
                    } else {
                        int n = idx + 1;
                        num.set((Object)n);
                    }
                    return callSiteArray[1].call(this.tasks.get(), (Object)new Callable(this, item2, num, this.processor, this.result){
                        public /* synthetic */ Reference result;
                        public /* synthetic */ Reference processor;
                        public /* synthetic */ Reference num;
                        public /* synthetic */ Reference item;
                        public /* synthetic */ Closure this$0;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private transient /* synthetic */ MetaClass metaClass;
                        private static /* synthetic */ SoftReference $callSiteArray;
                        {
                            MetaClass metaClass;
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            Reference reference4;
                            Closure closure;
                            CallSite[] callSiteArray = 2.$getCallSiteArray();
                            this.this$0 = closure = p0;
                            this.result = reference4 = p4;
                            this.processor = reference3 = p3;
                            this.num = reference2 = p2;
                            this.item = reference = p1;
                            this.metaClass = metaClass = this.$getStaticMetaClass();
                        }

                        public Object call() throws Exception {
                            CallSite[] callSiteArray = 2.$getCallSiteArray();
                            return callSiteArray[0].callCurrent((GroovyObject)this, this.item.get(), this.num.get(), this.processor.get(), this.result.get());
                        }

                        public /* synthetic */ Object methodMissing(String name, Object args) {
                            CallSite[] callSiteArray = 2.$getCallSiteArray();
                            return ((Dataset)this.this$0.getThisObject()).this$dist$invoke$1(name, args);
                        }

                        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                            CallSite[] callSiteArray = 2.$getCallSiteArray();
                            return ScriptBytecodeAdapter.invokeMethodN(2.class, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                        }

                        public /* synthetic */ void propertyMissing(String name, Object val) {
                            CallSite[] callSiteArray = 2.$getCallSiteArray();
                            ((Dataset)this.this$0.getThisObject()).this$dist$set$1(name, val);
                        }

                        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                            CallSite[] callSiteArray = 2.$getCallSiteArray();
                            Object object = val;
                            ScriptBytecodeAdapter.setProperty((Object)object, null, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                        }

                        public /* synthetic */ Object propertyMissing(String name) {
                            CallSite[] callSiteArray = 2.$getCallSiteArray();
                            return ((Dataset)this.this$0.getThisObject()).this$dist$get$1(name);
                        }

                        public static /* synthetic */ Object $static_propertyMissing(String name) {
                            CallSite[] callSiteArray = 2.$getCallSiteArray();
                            return ScriptBytecodeAdapter.getProperty(2.class, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (this.getClass() != 2.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)this);
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        @Generated
                        @Internal
                        public /* synthetic */ MetaClass getMetaClass() {
                            MetaClass metaClass = this.metaClass;
                            if (metaClass != null) {
                                return metaClass;
                            }
                            this.metaClass = this.$getStaticMetaClass();
                            return this.metaClass;
                        }

                        @Generated
                        @Internal
                        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                            this.metaClass = metaClass;
                        }

                        @Generated
                        @Internal
                        public /* synthetic */ Object invokeMethod(String string, Object object) {
                            return this.getMetaClass().invokeMethod((Object)this, string, object);
                        }

                        @Generated
                        @Internal
                        public /* synthetic */ Object getProperty(String string) {
                            return this.getMetaClass().getProperty((Object)this, string);
                        }

                        @Generated
                        @Internal
                        public /* synthetic */ void setProperty(String string, Object object) {
                            this.getMetaClass().setProperty((Object)this, string, object);
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[1];
                            stringArray[0] = "processItem";
                            return new CallSiteArray(2.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = 2.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    });
                }

                public Object call(Item item, int idx) {
                    Reference item2 = new Reference((Object)item);
                    CallSite[] callSiteArray = _processItems_closure4.$getCallSiteArray();
                    return callSiteArray[2].callCurrent((GroovyObject)this, (Object)((Item)item2.get()), (Object)idx);
                }

                public List getTasks() {
                    CallSite[] callSiteArray = _processItems_closure4.$getCallSiteArray();
                    return (List)ScriptBytecodeAdapter.castToType((Object)this.tasks.get(), List.class);
                }

                public Processor getProcessor() {
                    CallSite[] callSiteArray = _processItems_closure4.$getCallSiteArray();
                    return (Processor)ScriptBytecodeAdapter.castToType((Object)this.processor.get(), Processor.class);
                }

                public Result getResult() {
                    CallSite[] callSiteArray = _processItems_closure4.$getCallSiteArray();
                    return (Result)ScriptBytecodeAdapter.castToType((Object)this.result.get(), Result.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _processItems_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "plus";
                    stringArray[1] = "add";
                    stringArray[2] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _processItems_closure4.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_processItems_closure4.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _processItems_closure4.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[25].call(this.items, (Object)new _processItems_closure4(this, this, tasks, processor2, result));
            callSiteArray[26].call((Object)executor, (Object)((List)tasks.get()));
            callSiteArray[27].call((Object)executor);
        } else {
            Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[28].call((Object)log)) ? callSiteArray[29].call((Object)log, (Object)new GStringImpl(new Object[]{this.name}, new String[]{"processing dataset [", "] using 1 thread"})) : null;
            Reference counter = new Reference((Object)1);
            public final class _processItems_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference counter;
                private /* synthetic */ Reference processor;
                private /* synthetic */ Reference result;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _processItems_closure5(Object _outerInstance, Object _thisObject, Reference counter, Reference processor, Reference result) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    CallSite[] callSiteArray = _processItems_closure5.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.counter = reference3 = counter;
                    this.processor = reference2 = processor;
                    this.result = reference = result;
                }

                public Object doCall(Item item) {
                    CallSite[] callSiteArray = _processItems_closure5.$getCallSiteArray();
                    CallSite callSite = callSiteArray[0];
                    Object object = this.counter.get();
                    this.counter.set((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(object), Integer.class)));
                    return callSite.callCurrent((GroovyObject)this, (Object)item, object, this.processor.get(), this.result.get());
                }

                public Object call(Item item) {
                    CallSite[] callSiteArray = _processItems_closure5.$getCallSiteArray();
                    return callSiteArray[2].callCurrent((GroovyObject)this, (Object)item);
                }

                public Integer getCounter() {
                    CallSite[] callSiteArray = _processItems_closure5.$getCallSiteArray();
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.counter.get(), Integer.class);
                }

                public Processor getProcessor() {
                    CallSite[] callSiteArray = _processItems_closure5.$getCallSiteArray();
                    return (Processor)ScriptBytecodeAdapter.castToType((Object)this.processor.get(), Processor.class);
                }

                public Result getResult() {
                    CallSite[] callSiteArray = _processItems_closure5.$getCallSiteArray();
                    return (Result)ScriptBytecodeAdapter.castToType((Object)this.result.get(), Result.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _processItems_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "processItem";
                    stringArray[1] = "next";
                    stringArray[2] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _processItems_closure5.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_processItems_closure5.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _processItems_closure5.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[30].call(this.items, (Object)new _processItems_closure5(this, this, counter, processor2, result));
        }
        return (Result)result.get();
    }

    private void processItem(Item item, int num, Processor processor, Result result) {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        String msg = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[31].callGroovyObjectGetProperty((Object)item), num, callSiteArray[32].callGroovyObjectGetProperty((Object)this)}, new String[]{"processing [", "] (", "/", ")"}));
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[33].call((Object)log)) ? callSiteArray[34].call((Object)log, callSiteArray[35].call(callSiteArray[36].call((Object)"\n------------------------------------------------------------------------------------------------------------------------", (Object)new GStringImpl(new Object[]{msg}, new String[]{"\n", ""})), (Object)"\n------------------------------------------------------------------------------------------------------------------------")) : null;
        callSiteArray[37].call(callSiteArray[38].callGetProperty(System.class), (Object)msg);
        try {
            callSiteArray[39].call((Object)processor, (Object)item);
        }
        catch (Exception e) {
            String emsg = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[40].callGroovyObjectGetProperty((Object)item)}, new String[]{"error processing dataset item [", "]"}));
            callSiteArray[41].call((Object)log, (Object)emsg, (Object)e);
            callSiteArray[42].call(callSiteArray[43].callGroovyObjectGetProperty((Object)result), (Object)item);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[44].callGetProperty(callSiteArray[45].callGroovyObjectGetProperty((Object)this)))) {
                throw (Throwable)callSiteArray[46].callConstructor(PrankException.class, (Object)emsg, (Object)e);
            }
        }
    }

    private PredictionLoader getLoader(Item item) {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        return (PredictionLoader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].callCurrent((GroovyObject)this, callSiteArray[48].call(this.attributes, (Object)PARAM_PREDICTION_METHOD), (Object)item), PredictionLoader.class);
    }

    private PredictionLoader getLoader(String method, Item item) {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        PredictionLoader res = null;
        String string = method;
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"fpocket")) {
            Object object = callSiteArray[49].callConstructor(FPocketLoader.class);
            res = (PredictionLoader)ScriptBytecodeAdapter.castToType((Object)object, PredictionLoader.class);
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"concavity")) {
            Object object = callSiteArray[50].callConstructor(ConcavityLoader.class);
            res = (PredictionLoader)ScriptBytecodeAdapter.castToType((Object)object, PredictionLoader.class);
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"sitehound")) {
            Object object = callSiteArray[51].callConstructor(SiteHoundLoader.class);
            res = (PredictionLoader)ScriptBytecodeAdapter.castToType((Object)object, PredictionLoader.class);
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"lise")) {
            Object object = callSiteArray[52].callConstructor(LiseLoader.class);
            res = (PredictionLoader)ScriptBytecodeAdapter.castToType((Object)object, PredictionLoader.class);
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"deepsite")) {
            Object object = callSiteArray[53].callConstructor(DeepSiteLoader.class);
            res = (PredictionLoader)ScriptBytecodeAdapter.castToType((Object)object, PredictionLoader.class);
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"metapocket2")) {
            Object object = callSiteArray[54].callConstructor(MetaPocket2Loader.class);
            res = (PredictionLoader)ScriptBytecodeAdapter.castToType((Object)object, PredictionLoader.class);
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"p2rank")) {
            Object object = callSiteArray[55].callConstructor(P2RankLoader.class);
            res = (PredictionLoader)ScriptBytecodeAdapter.castToType((Object)object, PredictionLoader.class);
        } else {
            Object object = callSiteArray[56].callConstructor(FPocketLoader.class);
            res = (PredictionLoader)ScriptBytecodeAdapter.castToType((Object)object, PredictionLoader.class);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)res, null)) {
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[57].call(this.attributes, (Object)PARAM_LIGANDS_SEPARATED_BY_TER), (Object)"true");
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)callSiteArray[58].callGroovyObjectGetProperty((Object)res), (String)"ligandsSeparatedByTER");
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[59].callCurrent((GroovyObject)this);
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[60].callGroovyObjectGetProperty((Object)res), (String)"relevantLigandsDefined");
            } else {
                boolean bl2 = this.hasLigandCodes();
                ScriptBytecodeAdapter.setProperty((Object)bl2, null, (Object)callSiteArray[61].callGroovyObjectGetProperty((Object)res), (String)"relevantLigandsDefined");
            }
            Object object = callSiteArray[62].call((Object)item);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[63].callGroovyObjectGetProperty((Object)res), (String)"relevantLigandNames");
            public final class _getLoader_closure6
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getLoader_closure6(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _getLoader_closure6.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object s) {
                    CallSite[] callSiteArray = _getLoader_closure6.$getCallSiteArray();
                    return callSiteArray[0].call(s, (Object)"conservation");
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getLoader_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "contains";
                    return new CallSiteArray(_getLoader_closure6.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getLoader_closure6.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            boolean bl3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[64].call(callSiteArray[65].callGetProperty(callSiteArray[66].callGroovyObjectGetProperty((Object)this)), (Object)new _getLoader_closure6(this, this))) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[67].callGetProperty(callSiteArray[68].callGroovyObjectGetProperty((Object)this)));
            ScriptBytecodeAdapter.setProperty((Object)bl3, null, (Object)callSiteArray[69].callGroovyObjectGetProperty((Object)res), (String)"load_conservation_paths");
            Object object2 = callSiteArray[70].callGetProperty(callSiteArray[71].callGroovyObjectGetProperty((Object)this));
            ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)callSiteArray[72].callGroovyObjectGetProperty((Object)res), (String)"load_conservation");
            Object object3 = callSiteArray[73].callGetProperty(callSiteArray[74].callGroovyObjectGetProperty((Object)this));
            ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)callSiteArray[75].callGroovyObjectGetProperty((Object)res), (String)"conservation_origin");
        }
        return res;
    }

    public Dataset randomSubset(int subsetSize, long seed) {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)subsetSize, (Object)callSiteArray[76].callGroovyObjectGetProperty((Object)this))) {
            return this;
        }
        List shuffledItems = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[77].callConstructor(ArrayList.class, this.items), List.class);
        callSiteArray[78].call(Collections.class, (Object)shuffledItems, callSiteArray[79].callConstructor(Random.class, (Object)seed));
        return (Dataset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[80].callCurrent((GroovyObject)this, callSiteArray[81].call((Object)shuffledItems, (Object)0, (Object)subsetSize), callSiteArray[82].call((Object)this.name, (Object)new GStringImpl(new Object[]{subsetSize}, new String[]{" (random subset of size ", ")"}))), Dataset.class);
    }

    public List<Fold> sampleFolds(int k, long seed) {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[83].callGroovyObjectGetProperty((Object)this), (Object)k)) {
            throw (Throwable)callSiteArray[84].callConstructor(PrankException.class, (Object)new GStringImpl(new Object[]{k, callSiteArray[85].callGroovyObjectGetProperty((Object)this)}, new String[]{"There is less dataset items than folds! (", " < ", ")"}));
        }
        List shuffledItems = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[86].callConstructor(ArrayList.class, this.items), List.class);
        callSiteArray[87].call(Collections.class, (Object)shuffledItems, callSiteArray[88].callConstructor(Random.class, (Object)seed));
        Object[] subsets = new List[k];
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            int i = 0;
            while (i < k) {
                Object object = callSiteArray[89].callConstructor(ArrayList.class);
                callSiteArray[90].call((Object)subsets, (Object)i, object);
                int n = i;
                i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[91].call((Object)n));
            }
        } else {
            int i = 0;
            while (i < k) {
                Object object = callSiteArray[92].callConstructor(ArrayList.class);
                BytecodeInterface8.objectArraySet((Object[])subsets, (int)i, (Object)((List)ScriptBytecodeAdapter.castToType((Object)object, List.class)));
                int n = i;
                int cfr_ignored_0 = n + 1;
            }
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            int i = 0;
            while (ScriptBytecodeAdapter.compareNotEqual((Object)i, (Object)callSiteArray[93].call(this.items))) {
                callSiteArray[94].call(callSiteArray[95].call((Object)subsets, callSiteArray[96].call((Object)i, (Object)k)), callSiteArray[97].call((Object)shuffledItems, (Object)i));
                i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[98].call((Object)i));
            }
        } else {
            int i = 0;
            while (ScriptBytecodeAdapter.compareNotEqual((Object)i, (Object)callSiteArray[99].call(this.items))) {
                callSiteArray[100].call(BytecodeInterface8.objectArrayGet((Object[])subsets, (int)(i % k)), callSiteArray[101].call((Object)shuffledItems, (Object)i));
                int cfr_ignored_1 = i + 1;
            }
        }
        List folds = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[102].callConstructor(ArrayList.class, (Object)k), List.class);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            int i = 0;
            while (i != k) {
                Dataset evalset = (Dataset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[103].callCurrent((GroovyObject)this, callSiteArray[104].call((Object)subsets, (Object)i), (Object)new GStringImpl(new Object[]{this.name, k, i}, new String[]{"", "_fold.", ".", "_eval"})), Dataset.class);
                Dataset trainset = (Dataset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[105].callCurrent((GroovyObject)this, callSiteArray[106].call((Object)shuffledItems, callSiteArray[107].call((Object)subsets, (Object)i)), (Object)new GStringImpl(new Object[]{this.name, k, i}, new String[]{"", "_fold.", ".", "_train"})), Dataset.class);
                callSiteArray[108].call((Object)folds, callSiteArray[109].callConstructor(Fold.class, callSiteArray[110].call((Object)i, (Object)1), (Object)trainset, (Object)evalset));
                i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[111].call((Object)i));
            }
        } else {
            int i = 0;
            while (i != k) {
                Dataset evalset = (Dataset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[112].callCurrent((GroovyObject)this, BytecodeInterface8.objectArrayGet((Object[])subsets, (int)i), (Object)new GStringImpl(new Object[]{this.name, k, i}, new String[]{"", "_fold.", ".", "_eval"})), Dataset.class);
                Dataset trainset = (Dataset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[113].callCurrent((GroovyObject)this, callSiteArray[114].call((Object)shuffledItems, BytecodeInterface8.objectArrayGet((Object[])subsets, (int)i)), (Object)new GStringImpl(new Object[]{this.name, k, i}, new String[]{"", "_fold.", ".", "_train"})), Dataset.class);
                callSiteArray[115].call((Object)folds, callSiteArray[116].callConstructor(Fold.class, (Object)(i + 1), (Object)trainset, (Object)evalset));
                int cfr_ignored_2 = i + 1;
            }
        }
        return folds;
    }

    private Dataset createSubset(List<Item> items, String name) {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        Dataset res = (Dataset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[117].callConstructor(Dataset.class, (Object)name, (Object)this.dir), Dataset.class);
        List<Item> list = items;
        ScriptBytecodeAdapter.setGroovyObjectProperty(list, Dataset.class, (GroovyObject)res, (String)"items");
        Map<String, String> map = this.attributes;
        ScriptBytecodeAdapter.setGroovyObjectProperty(map, Dataset.class, (GroovyObject)res, (String)"attributes");
        boolean bl = this.cached;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, Dataset.class, (GroovyObject)res, (String)"cached");
        List<String> list2 = this.header;
        ScriptBytecodeAdapter.setGroovyObjectProperty(list2, Dataset.class, (GroovyObject)res, (String)"header");
        return res;
    }

    public static Dataset createSingleFileDataset(String pdbFile, ProcessedItemContext itemContext) {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        Dataset ds = (Dataset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[118].callConstructor(Dataset.class, callSiteArray[119].call(Futils.class, (Object)pdbFile), callSiteArray[120].call(Futils.class, (Object)pdbFile)), Dataset.class);
        Map columnValues = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[121].callConstructor(HashMap.class), Map.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)itemContext, null)) {
            callSiteArray[122].call((Object)columnValues, callSiteArray[123].callGroovyObjectGetProperty((Object)itemContext));
        }
        callSiteArray[124].call(callSiteArray[125].callGroovyObjectGetProperty((Object)ds), callSiteArray[126].call((Object)ds, (Object)pdbFile, null, (Object)columnValues));
        return ds;
    }

    public static Dataset createSingleFileDataset(String pdbFile) {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        return (Dataset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[127].callStatic(Dataset.class, (Object)pdbFile, null), Dataset.class);
    }

    public boolean hasLigandCodes() {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[128].call(this.header, (Object)COLUMN_LIGAND_CODES));
    }

    public boolean hasResidueLabeling() {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[129].call(this.attributes, (Object)PARAM_RESIDUE_LABELING_FORMAT));
    }

    public boolean hasPredictedResidueLabeling() {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[130].call(this.attributes, (Object)PARAM_PREDICTION_METHOD));
    }

    @Nullable
    public ResidueLabeler getResidueLabeler() {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.residueLabeler, null) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[131].callCurrent((GroovyObject)this))) {
                String labelingFile = ShortTypeHandling.castToString((Object)callSiteArray[132].call(callSiteArray[133].call((Object)this.dir, (Object)"/"), callSiteArray[134].call(this.attributes, (Object)PARAM_RESIDUE_LABELING_FILE)));
                Object object = callSiteArray[135].call(ResidueLabeler.class, callSiteArray[136].call(this.attributes, (Object)PARAM_RESIDUE_LABELING_FORMAT), (Object)labelingFile);
                this.residueLabeler = (ResidueLabeler)ScriptBytecodeAdapter.castToType((Object)object, ResidueLabeler.class);
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)this.residueLabeler, null) && this.hasResidueLabeling()) {
            String labelingFile = ShortTypeHandling.castToString((Object)callSiteArray[137].call(callSiteArray[138].call((Object)this.dir, (Object)"/"), callSiteArray[139].call(this.attributes, (Object)PARAM_RESIDUE_LABELING_FILE)));
            Object object = callSiteArray[140].call(ResidueLabeler.class, callSiteArray[141].call(this.attributes, (Object)PARAM_RESIDUE_LABELING_FORMAT), (Object)labelingFile);
            this.residueLabeler = (ResidueLabeler)ScriptBytecodeAdapter.castToType((Object)object, ResidueLabeler.class);
        }
        return this.residueLabeler;
    }

    @Nullable
    public ResidueLabeler<Boolean> getBinaryResidueLabeler() {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        ResidueLabeler labeler = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[142].callCurrent((GroovyObject)this);
            labeler = (ResidueLabeler)ScriptBytecodeAdapter.castToType((Object)object, ResidueLabeler.class);
        } else {
            ResidueLabeler residueLabeler;
            labeler = residueLabeler = this.getResidueLabeler();
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[143].callGroovyObjectGetProperty((Object)labeler))) {
            throw (Throwable)callSiteArray[144].callConstructor(PrankException.class, (Object)"Dataset residue labeling is not binary!");
        }
        return labeler;
    }

    public static Dataset loadFromFile(String fname) {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        File file = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[145].callConstructor(File.class, (Object)fname), File.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[146].call((Object)file))) {
            throw (Throwable)callSiteArray[147].callConstructor(PrankException.class, (Object)new GStringImpl(new Object[]{callSiteArray[148].callGetProperty((Object)file)}, new String[]{"cannot find dataset file [", "]"}));
        }
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[149].call((Object)log)) ? callSiteArray[150].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[151].callGetProperty((Object)file)}, new String[]{"loading dataset [", "]"})) : null;
        Dataset dataset = (Dataset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[152].callConstructor(Dataset.class, callSiteArray[153].callGetProperty((Object)file), callSiteArray[154].callGetProperty((Object)file)), Dataset.class);
        String line = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[155].call(callSiteArray[156].call((Object)file)), Iterator.class);
        while (iterator.hasNext()) {
            line = ShortTypeHandling.castToString(iterator.next());
            Object object2 = callSiteArray[157].call((Object)line);
            line = ShortTypeHandling.castToString((Object)object2);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[158].call((Object)line, (Object)"#")) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[159].call((Object)line))) continue;
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[160].call((Object)line, (Object)"PARAM."))) {
                String paramName = ShortTypeHandling.castToString((Object)callSiteArray[161].call(callSiteArray[162].call((Object)line, callSiteArray[163].call(callSiteArray[164].call((Object)line, (Object)"."), (Object)1), callSiteArray[165].call((Object)line, (Object)"="))));
                String paramValue = ShortTypeHandling.castToString((Object)callSiteArray[166].call(callSiteArray[167].call((Object)line, callSiteArray[168].call(callSiteArray[169].call((Object)line, (Object)"="), (Object)1))));
                callSiteArray[170].call(callSiteArray[171].callGroovyObjectGetProperty((Object)dataset), (Object)paramName, (Object)paramValue);
                continue;
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[172].call((Object)line, (Object)"HEADER:"))) {
                Object object3 = callSiteArray[173].callStatic(Dataset.class, (Object)line);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object3, Dataset.class, (GroovyObject)dataset, (String)"header");
                continue;
            }
            callSiteArray[174].call(callSiteArray[175].callGroovyObjectGetProperty((Object)dataset), callSiteArray[176].call((Object)dataset, (Object)line));
        }
        Object object4 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[177].call((Object)log)) ? callSiteArray[178].call((Object)log, (Object)"dataset header: {}", callSiteArray[179].callGroovyObjectGetProperty((Object)dataset)) : null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[180].call((Object)dataset))) {
            throw (Throwable)callSiteArray[181].callConstructor(PrankException.class, (Object)"dataset contains invalid files");
        }
        return dataset;
    }

    private Item parseItem(String line) {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        Reference cols = new Reference((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[182].call((Object)SPLITTER, (Object)line), List.class)));
        Reference colValues = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[183].callConstructor(HashMap.class), Map.class)));
        public final class _parseItem_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference cols;
            private /* synthetic */ Reference colValues;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _parseItem_closure7(Object _outerInstance, Object _thisObject, Reference cols, Reference colValues) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _parseItem_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.cols = reference2 = cols;
                this.colValues = reference = colValues;
            }

            public Object doCall(String col, int i) {
                CallSite[] callSiteArray = _parseItem_closure7.$getCallSiteArray();
                if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)col, (Object)callSiteArray[0].callGetProperty(Dataset.class)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call(callSiteArray[2].call(this.cols.get(), (Object)i), (Object)"%chainID%"))) {
                        throw (Throwable)callSiteArray[3].callConstructor(PrankException.class, callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call((Object)"invalid conservation files pattern.", callSiteArray[7].call(this.cols.get(), (Object)i)), (Object)"does "), (Object)"not contain %chainID% substring."));
                    }
                } else if (ScriptBytecodeAdapter.compareEqual((Object)col, (Object)callSiteArray[8].callGetProperty(Dataset.class)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].call(callSiteArray[10].call(this.cols.get(), (Object)i), (Object)"%chainID%"))) {
                    throw (Throwable)callSiteArray[11].callConstructor(PrankException.class, callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].call((Object)"invalid conservation files pattern.", callSiteArray[15].call(this.cols.get(), (Object)i)), (Object)"does "), (Object)"not contain %chainID% substring."));
                }
                return callSiteArray[16].call(this.colValues.get(), (Object)col, callSiteArray[17].call(this.cols.get(), (Object)i));
            }

            public Object call(String col, int i) {
                CallSite[] callSiteArray = _parseItem_closure7.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[18].callCurrent((GroovyObject)this, (Object)col, (Object)i);
                }
                return this.doCall(col, i);
            }

            public List getCols() {
                CallSite[] callSiteArray = _parseItem_closure7.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.cols.get(), List.class);
            }

            public Map getColValues() {
                CallSite[] callSiteArray = _parseItem_closure7.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.colValues.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _parseItem_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "COLUMN_CONSERVATION_FILES_PATTERN";
                stringArray[1] = "contains";
                stringArray[2] = "getAt";
                stringArray[3] = "<$constructor$>";
                stringArray[4] = "plus";
                stringArray[5] = "plus";
                stringArray[6] = "plus";
                stringArray[7] = "getAt";
                stringArray[8] = "COLUMN_CONSERVATION_FILES_PATTERN";
                stringArray[9] = "contains";
                stringArray[10] = "getAt";
                stringArray[11] = "<$constructor$>";
                stringArray[12] = "plus";
                stringArray[13] = "plus";
                stringArray[14] = "plus";
                stringArray[15] = "getAt";
                stringArray[16] = "put";
                stringArray[17] = "getAt";
                stringArray[18] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[19];
                _parseItem_closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_parseItem_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _parseItem_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[184].call(this.header, (Object)new _parseItem_closure7(this, this, cols, colValues));
        return (Item)ScriptBytecodeAdapter.castToType((Object)callSiteArray[185].callCurrent((GroovyObject)this, (Object)((Map)colValues.get())), Item.class);
    }

    public static List<String> parseHeader(String line) {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[186].call(callSiteArray[187].call((Object)SPLITTER, (Object)line)), List.class);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset createJoined(List<Dataset> datasets) {
        var1_1 = Dataset.$getCallSiteArray();
        var2_2 = new ValueRecorder();
        try {
            v0 = datasets;
            var2_2.record(v0, 8);
            v1 = ScriptBytecodeAdapter.compareNotEqual(v0, null);
            var2_2.record((Object)v1, 16);
            if (!v1) ** GOTO lbl-1000
            v2 = var1_1[188];
            v3 = datasets;
            var2_2.record(v3, 27);
            v4 = v2.callGetProperty(v3);
            var2_2.record(v4, 36);
            v5 = DefaultTypeTransformation.booleanUnbox((Object)v4) == false;
            var2_2.record((Object)v5, 26);
            if (v5) {
                v6 = true;
            } else lbl-1000:
            // 2 sources

            {
                v6 = false;
            }
            var2_2.record((Object)v6, 23);
            if (v6) {
                var2_2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert datasets!=null && !datasets.empty", (ValueRecorder)var2_2), null);
            }
        }
        catch (Throwable v7) {
            var2_2.clear();
            throw v7;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)var1_1[189].call(datasets), (Object)1)) {
            return (Dataset)ScriptBytecodeAdapter.castToType((Object)var1_1[190].call(datasets, (Object)0), Dataset.class);
        }
        name = ShortTypeHandling.castToString((Object)var1_1[191].call(ScriptBytecodeAdapter.getPropertySpreadSafe(Dataset.class, datasets, (String)"name"), (Object)"+"));
        res = (Dataset)ScriptBytecodeAdapter.castToType((Object)var1_1[192].callConstructor(Dataset.class, (Object)name, (Object)"--joined--"), Dataset.class);
        var5_5 = var1_1[193].callGetProperty(var1_1[194].call(datasets, (Object)0));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var5_5, Dataset.class, (GroovyObject)res, (String)"header");
        d = null;
        var7_7 = (Iterator)ScriptBytecodeAdapter.castToType((Object)var1_1[195].call(datasets), Iterator.class);
        while (var7_7.hasNext()) {
            d = (Dataset)ScriptBytecodeAdapter.castToType(var7_7.next(), Dataset.class);
            var1_1[196].call(var1_1[197].callGroovyObjectGetProperty((Object)res), var1_1[198].callGroovyObjectGetProperty((Object)d));
        }
        return res;
    }

    public Item createNewItem(String proteinFile, String predictionFile, Map<String, String> columnValues) {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        return (Item)ScriptBytecodeAdapter.castToType((Object)callSiteArray[199].callConstructor(Item.class, ArrayUtil.createArray((Object)this, (Object)this, (Object)proteinFile, (Object)predictionFile, columnValues)), Item.class);
    }

    public Item createNewItem(Map<String, String> columnValues) {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        String proteinFile = ShortTypeHandling.castToString((Object)callSiteArray[200].call(callSiteArray[201].call((Object)this.dir, (Object)"/"), callSiteArray[202].call(columnValues, (Object)COLUMN_PROTEIN)));
        String predictionFile = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[203].call(this.header, (Object)COLUMN_PREDICTION))) {
            Object object = callSiteArray[204].call(callSiteArray[205].call((Object)this.dir, (Object)"/"), callSiteArray[206].call(columnValues, (Object)COLUMN_PREDICTION));
            predictionFile = ShortTypeHandling.castToString((Object)object);
        }
        return (Item)ScriptBytecodeAdapter.castToType((Object)callSiteArray[207].callCurrent((GroovyObject)this, (Object)proteinFile, predictionFile, columnValues), Item.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Dataset.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        return (Params)ScriptBytecodeAdapter.castToType((Object)callSiteArray[208].call(Parametrized.Trait.Helper.class, (Object)this), Params.class);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)callSiteArray[209].callStatic(InvokerHelper.class, callSiteArray[210].call((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class))), (Object)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        List list;
        Object object = Dataset.$getCallSiteArray()[211].call(Dataset.$getCallSiteArray()[212].call(Dataset.$getCallSiteArray()[213].call(Splitter.class, Dataset.$getCallSiteArray()[214].call(CharMatcher.class))));
        SPLITTER = (Splitter)ScriptBytecodeAdapter.castToType((Object)object, Splitter.class);
        DEFAULT_HEADER = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{COLUMN_PROTEIN});
        Object object2 = Dataset.$getCallSiteArray()[215].call(LoggerFactory.class, (Object)"cz.siret.prank.domain.Dataset");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object2, Logger.class);
        Parametrized.Trait.Helper.$static$init$(Dataset.class);
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(Dataset.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Dataset.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(Dataset.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    public Dataset withCache() {
        CallSite[] callSiteArray = Dataset.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.withCache(true);
        }
        return this.withCache(true);
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public static Splitter getSPLITTER() {
        return SPLITTER;
    }

    @Generated
    public static String getPARAM_PREDICTION_METHOD() {
        return PARAM_PREDICTION_METHOD;
    }

    @Generated
    public static String getPARAM_LIGANDS_SEPARATED_BY_TER() {
        return PARAM_LIGANDS_SEPARATED_BY_TER;
    }

    @Generated
    public static String getPARAM_RESIDUE_LABELING_FORMAT() {
        return PARAM_RESIDUE_LABELING_FORMAT;
    }

    @Generated
    public static String getPARAM_RESIDUE_LABELING_FILE() {
        return PARAM_RESIDUE_LABELING_FILE;
    }

    @Generated
    public static String getCOLUMN_PROTEIN() {
        return COLUMN_PROTEIN;
    }

    @Generated
    public static String getCOLUMN_PREDICTION() {
        return COLUMN_PREDICTION;
    }

    @Generated
    public static String getCOLUMN_LIGAND_CODES() {
        return COLUMN_LIGAND_CODES;
    }

    @Generated
    public static String getCOLUMN_CONSERVATION_FILES_PATTERN() {
        return COLUMN_CONSERVATION_FILES_PATTERN;
    }

    @Generated
    public static String getCOLUMN_CHAINS() {
        return COLUMN_CHAINS;
    }

    @Generated
    public static List<String> getDEFAULT_HEADER() {
        return DEFAULT_HEADER;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String string) {
        this.name = string;
    }

    @Generated
    public String getDir() {
        return this.dir;
    }

    @Generated
    public void setDir(String string) {
        this.dir = string;
    }

    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setAttributes(Map<String, String> map) {
        this.attributes = map;
    }

    @Generated
    public List<String> getHeader() {
        return this.header;
    }

    @Generated
    public void setHeader(List<String> list) {
        this.header = list;
    }

    @Generated
    public List<Item> getItems() {
        return this.items;
    }

    @Generated
    public void setItems(List<Item> list) {
        this.items = list;
    }

    @Generated
    public boolean getCached() {
        return this.cached;
    }

    @Generated
    public boolean isCached() {
        return this.cached;
    }

    @Generated
    public void setCached(boolean bl) {
        this.cached = bl;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "$init$";
        stringArray[3] = "removeExtension";
        stringArray[4] = "size";
        stringArray[5] = "each";
        stringArray[6] = "each";
        stringArray[7] = "each";
        stringArray[8] = "processItems";
        stringArray[9] = "parallel";
        stringArray[10] = "params";
        stringArray[11] = "processItems";
        stringArray[12] = "isTraceEnabled";
        stringArray[13] = "trace";
        stringArray[14] = "plus";
        stringArray[15] = "toStr";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "poolSize";
        stringArray[18] = "pool";
        stringArray[19] = "isInfoEnabled";
        stringArray[20] = "info";
        stringArray[21] = "newFixedThreadPool";
        stringArray[22] = "threads";
        stringArray[23] = "params";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "eachWithIndex";
        stringArray[26] = "invokeAll";
        stringArray[27] = "shutdownNow";
        stringArray[28] = "isInfoEnabled";
        stringArray[29] = "info";
        stringArray[30] = "each";
        stringArray[31] = "label";
        stringArray[32] = "size";
        stringArray[33] = "isInfoEnabled";
        stringArray[34] = "info";
        stringArray[35] = "plus";
        stringArray[36] = "plus";
        stringArray[37] = "println";
        stringArray[38] = "out";
        stringArray[39] = "processItem";
        stringArray[40] = "label";
        stringArray[41] = "error";
        stringArray[42] = "add";
        stringArray[43] = "errorItems";
        stringArray[44] = "fail_fast";
        stringArray[45] = "params";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "getLoader";
        stringArray[48] = "get";
        stringArray[49] = "<$constructor$>";
        stringArray[50] = "<$constructor$>";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "<$constructor$>";
        stringArray[53] = "<$constructor$>";
        stringArray[54] = "<$constructor$>";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "<$constructor$>";
        stringArray[57] = "get";
        stringArray[58] = "loaderParams";
        stringArray[59] = "hasLigandCodes";
        stringArray[60] = "loaderParams";
        stringArray[61] = "loaderParams";
        stringArray[62] = "getLigandCodes";
        stringArray[63] = "loaderParams";
        stringArray[64] = "any";
        stringArray[65] = "extra_features";
        stringArray[66] = "params";
        stringArray[67] = "load_conservation";
        stringArray[68] = "params";
        stringArray[69] = "loaderParams";
        stringArray[70] = "load_conservation";
        stringArray[71] = "params";
        stringArray[72] = "loaderParams";
        stringArray[73] = "conservation_origin";
        stringArray[74] = "params";
        stringArray[75] = "loaderParams";
        stringArray[76] = "size";
        stringArray[77] = "<$constructor$>";
        stringArray[78] = "shuffle";
        stringArray[79] = "<$constructor$>";
        stringArray[80] = "createSubset";
        stringArray[81] = "subList";
        stringArray[82] = "plus";
        stringArray[83] = "size";
        stringArray[84] = "<$constructor$>";
        stringArray[85] = "size";
        stringArray[86] = "<$constructor$>";
        stringArray[87] = "shuffle";
        stringArray[88] = "<$constructor$>";
        stringArray[89] = "<$constructor$>";
        stringArray[90] = "putAt";
        stringArray[91] = "next";
        stringArray[92] = "<$constructor$>";
        stringArray[93] = "size";
        stringArray[94] = "add";
        stringArray[95] = "getAt";
        stringArray[96] = "mod";
        stringArray[97] = "getAt";
        stringArray[98] = "next";
        stringArray[99] = "size";
        stringArray[100] = "add";
        stringArray[101] = "getAt";
        stringArray[102] = "<$constructor$>";
        stringArray[103] = "createSubset";
        stringArray[104] = "getAt";
        stringArray[105] = "createSubset";
        stringArray[106] = "minus";
        stringArray[107] = "getAt";
        stringArray[108] = "add";
        stringArray[109] = "<$constructor$>";
        stringArray[110] = "plus";
        stringArray[111] = "next";
        stringArray[112] = "createSubset";
        stringArray[113] = "createSubset";
        stringArray[114] = "minus";
        stringArray[115] = "add";
        stringArray[116] = "<$constructor$>";
        stringArray[117] = "<$constructor$>";
        stringArray[118] = "<$constructor$>";
        stringArray[119] = "shortName";
        stringArray[120] = "dir";
        stringArray[121] = "<$constructor$>";
        stringArray[122] = "putAll";
        stringArray[123] = "datsetColumnValues";
        stringArray[124] = "add";
        stringArray[125] = "items";
        stringArray[126] = "createNewItem";
        stringArray[127] = "createSingleFileDataset";
        stringArray[128] = "contains";
        stringArray[129] = "containsKey";
        stringArray[130] = "containsKey";
        stringArray[131] = "hasResidueLabeling";
        stringArray[132] = "plus";
        stringArray[133] = "plus";
        stringArray[134] = "get";
        stringArray[135] = "loadFromFile";
        stringArray[136] = "get";
        stringArray[137] = "plus";
        stringArray[138] = "plus";
        stringArray[139] = "get";
        stringArray[140] = "loadFromFile";
        stringArray[141] = "get";
        stringArray[142] = "getResidueLabeler";
        stringArray[143] = "binary";
        stringArray[144] = "<$constructor$>";
        stringArray[145] = "<$constructor$>";
        stringArray[146] = "exists";
        stringArray[147] = "<$constructor$>";
        stringArray[148] = "name";
        stringArray[149] = "isInfoEnabled";
        stringArray[150] = "info";
        stringArray[151] = "absolutePath";
        stringArray[152] = "<$constructor$>";
        stringArray[153] = "name";
        stringArray[154] = "parent";
        stringArray[155] = "iterator";
        stringArray[156] = "readLines";
        stringArray[157] = "trim";
        stringArray[158] = "startsWith";
        stringArray[159] = "isEmpty";
        stringArray[160] = "startsWith";
        stringArray[161] = "trim";
        stringArray[162] = "substring";
        stringArray[163] = "plus";
        stringArray[164] = "indexOf";
        stringArray[165] = "indexOf";
        stringArray[166] = "trim";
        stringArray[167] = "substring";
        stringArray[168] = "plus";
        stringArray[169] = "indexOf";
        stringArray[170] = "put";
        stringArray[171] = "attributes";
        stringArray[172] = "startsWith";
        stringArray[173] = "parseHeader";
        stringArray[174] = "add";
        stringArray[175] = "items";
        stringArray[176] = "parseItem";
        stringArray[177] = "isDebugEnabled";
        stringArray[178] = "debug";
        stringArray[179] = "header";
        stringArray[180] = "checkFilesExist";
        stringArray[181] = "<$constructor$>";
        stringArray[182] = "splitToList";
        stringArray[183] = "<$constructor$>";
        stringArray[184] = "eachWithIndex";
        stringArray[185] = "createNewItem";
        stringArray[186] = "tail";
        stringArray[187] = "splitToList";
        stringArray[188] = "empty";
        stringArray[189] = "size";
        stringArray[190] = "getAt";
        stringArray[191] = "join";
        stringArray[192] = "<$constructor$>";
        stringArray[193] = "header";
        stringArray[194] = "getAt";
        stringArray[195] = "iterator";
        stringArray[196] = "addAll";
        stringArray[197] = "items";
        stringArray[198] = "items";
        stringArray[199] = "<$constructor$>";
        stringArray[200] = "plus";
        stringArray[201] = "plus";
        stringArray[202] = "get";
        stringArray[203] = "contains";
        stringArray[204] = "plus";
        stringArray[205] = "plus";
        stringArray[206] = "get";
        stringArray[207] = "createNewItem";
        stringArray[208] = "getParams";
        stringArray[209] = "invokeMethod";
        stringArray[210] = "getProxyTarget";
        stringArray[211] = "omitEmptyStrings";
        stringArray[212] = "trimResults";
        stringArray[213] = "on";
        stringArray[214] = "whitespace";
        stringArray[215] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[216];
        Dataset.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Dataset.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Dataset.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public class Item
    implements GroovyObject {
        private Dataset dataset;
        private Map<String, String> columnValues;
        private String proteinFile;
        @Nullable
        private String pocketPredictionFile;
        private String label;
        private PredictionPair cachedPair;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        public /* synthetic */ Dataset this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        private Item(Dataset $p$, Dataset dataset, String proteinFile, String predictionFile, Map<String, String> columnValues) {
            MetaClass metaClass;
            Dataset dataset2;
            CallSite[] callSiteArray = Item.$getCallSiteArray();
            this.this$0 = dataset2 = $p$;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Dataset dataset3 = dataset;
            this.dataset = (Dataset)ScriptBytecodeAdapter.castToType((Object)dataset3, Dataset.class);
            Map<String, String> map = columnValues;
            this.columnValues = (Map)ScriptBytecodeAdapter.castToType(map, Map.class);
            String string = proteinFile;
            this.proteinFile = ShortTypeHandling.castToString((Object)string);
            String string2 = predictionFile;
            this.pocketPredictionFile = ShortTypeHandling.castToString((Object)string2);
            String string3 = this.pocketPredictionFile;
            Object object = callSiteArray[0].call(Futils.class, (Object)(DefaultTypeTransformation.booleanUnbox((Object)string3) ? string3 : proteinFile));
            this.label = ShortTypeHandling.castToString((Object)object);
        }

        public Prediction getPrediction() {
            CallSite[] callSiteArray = Item.$getCallSiteArray();
            String string = this.pocketPredictionFile;
            String file = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : this.proteinFile;
            return (Prediction)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(callSiteArray[2].callCurrent((GroovyObject)this, (Object)this), (Object)file), Prediction.class);
        }

        public PredictionPair getPredictionPair() {
            CallSite[] callSiteArray = Item.$getCallSiteArray();
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].callGroovyObjectGetProperty((Object)this))) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)this.cachedPair, null)) {
                        Object object = callSiteArray[4].callCurrent((GroovyObject)this);
                        this.cachedPair = (PredictionPair)ScriptBytecodeAdapter.castToType((Object)object, PredictionPair.class);
                        callSiteArray[5].call(callSiteArray[6].callGetProperty(Dataset.class), (Object)new GStringImpl(new Object[]{this.label}, new String[]{"caching structures in dataset item [", "]"}));
                    }
                    return this.cachedPair;
                }
                return (PredictionPair)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].callCurrent((GroovyObject)this), PredictionPair.class);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].callGroovyObjectGetProperty((Object)this))) {
                if (ScriptBytecodeAdapter.compareEqual((Object)this.cachedPair, null)) {
                    PredictionPair predictionPair;
                    this.cachedPair = predictionPair = this.loadPredictionPair();
                    callSiteArray[9].call(callSiteArray[10].callGetProperty(Dataset.class), (Object)new GStringImpl(new Object[]{this.label}, new String[]{"caching structures in dataset item [", "]"}));
                }
                return this.cachedPair;
            }
            return this.loadPredictionPair();
        }

        public Protein getProtein() {
            CallSite[] callSiteArray = Item.$getCallSiteArray();
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                return (Protein)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callGetProperty(callSiteArray[12].callCurrent((GroovyObject)this)), Protein.class);
            }
            return (Protein)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].callGetProperty((Object)this.getPredictionPair()), Protein.class);
        }

        public PredictionPair loadPredictionPair() {
            CallSite[] callSiteArray = Item.$getCallSiteArray();
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                return (PredictionPair)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].call(callSiteArray[15].callCurrent((GroovyObject)this, (Object)this), (Object)this.proteinFile, (Object)this.pocketPredictionFile, callSiteArray[16].callCurrent((GroovyObject)this)), PredictionPair.class);
            }
            return (PredictionPair)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].call(callSiteArray[18].callCurrent((GroovyObject)this, (Object)this), (Object)this.proteinFile, (Object)this.pocketPredictionFile, (Object)this.getContext()), PredictionPair.class);
        }

        public Set<String> getLigandCodes() {
            CallSite[] callSiteArray = Item.$getCallSiteArray();
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[19].call(this.columnValues, callSiteArray[20].callGetProperty(Dataset.class)))) {
                return (Set)ScriptBytecodeAdapter.castToType(null, Set.class);
            }
            return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].call(callSiteArray[22].call(callSiteArray[23].call(Splitter.class, (Object)","), callSiteArray[24].call(this.columnValues, callSiteArray[25].callGetProperty(Dataset.class)))), Set.class);
        }

        public List<String> getChains() {
            CallSite[] callSiteArray = Item.$getCallSiteArray();
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[26].call(this.columnValues, callSiteArray[27].callGetProperty(Dataset.class)))) {
                return (List)ScriptBytecodeAdapter.castToType(null, List.class);
            }
            return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].call(callSiteArray[29].call(callSiteArray[30].call(Splitter.class, (Object)","), callSiteArray[31].call(this.columnValues, callSiteArray[32].callGetProperty(Dataset.class)))), List.class);
        }

        @Nullable
        public BinaryLabeling getDefinedBinaryLabeling() {
            CallSite[] callSiteArray = Item.$getCallSiteArray();
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[33].call((Object)this.dataset))) {
                return (BinaryLabeling)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].call(callSiteArray[35].callGroovyObjectGetProperty((Object)this.dataset), callSiteArray[36].callGetProperty(callSiteArray[37].callGroovyObjectGetProperty((Object)this)), callSiteArray[38].callGroovyObjectGetProperty((Object)this)), BinaryLabeling.class);
            }
            return (BinaryLabeling)ScriptBytecodeAdapter.castToType(null, BinaryLabeling.class);
        }

        public ProcessedItemContext getContext() {
            CallSite[] callSiteArray = Item.$getCallSiteArray();
            return (ProcessedItemContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].callConstructor(ProcessedItemContext.class, (Object)this, this.columnValues), ProcessedItemContext.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Item.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Item.$getCallSiteArray();
            return this.this$0.this$dist$invoke$1(name, args);
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Item.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(Item.class, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = Item.$getCallSiteArray();
            this.this$0.this$dist$set$1(name, val);
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = Item.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = Item.$getCallSiteArray();
            return this.this$0.this$dist$get$1(name);
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = Item.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Item.class, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Dataset getDataset() {
            return this.dataset;
        }

        @Generated
        public void setDataset(Dataset dataset) {
            this.dataset = dataset;
        }

        @Generated
        public Map<String, String> getColumnValues() {
            return this.columnValues;
        }

        @Generated
        public void setColumnValues(Map<String, String> map) {
            this.columnValues = map;
        }

        @Generated
        public String getProteinFile() {
            return this.proteinFile;
        }

        @Generated
        public void setProteinFile(String string) {
            this.proteinFile = string;
        }

        @Generated
        public String getPocketPredictionFile() {
            return this.pocketPredictionFile;
        }

        @Generated
        public void setPocketPredictionFile(String string) {
            this.pocketPredictionFile = string;
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public void setLabel(String string) {
            this.label = string;
        }

        @Generated
        public PredictionPair getCachedPair() {
            return this.cachedPair;
        }

        @Generated
        public void setCachedPair(PredictionPair predictionPair) {
            this.cachedPair = predictionPair;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "shortName";
            stringArray[1] = "loadPredictionWithoutProtein";
            stringArray[2] = "getLoader";
            stringArray[3] = "cached";
            stringArray[4] = "loadPredictionPair";
            stringArray[5] = "info";
            stringArray[6] = "log";
            stringArray[7] = "loadPredictionPair";
            stringArray[8] = "cached";
            stringArray[9] = "info";
            stringArray[10] = "log";
            stringArray[11] = Dataset.COLUMN_PROTEIN;
            stringArray[12] = "getPredictionPair";
            stringArray[13] = Dataset.COLUMN_PROTEIN;
            stringArray[14] = "loadPredictionPair";
            stringArray[15] = "getLoader";
            stringArray[16] = "getContext";
            stringArray[17] = "loadPredictionPair";
            stringArray[18] = "getLoader";
            stringArray[19] = "containsKey";
            stringArray[20] = "COLUMN_LIGAND_CODES";
            stringArray[21] = "toSet";
            stringArray[22] = "split";
            stringArray[23] = "on";
            stringArray[24] = "getAt";
            stringArray[25] = "COLUMN_LIGAND_CODES";
            stringArray[26] = "containsKey";
            stringArray[27] = "COLUMN_CHAINS";
            stringArray[28] = "asList";
            stringArray[29] = "split";
            stringArray[30] = "on";
            stringArray[31] = "getAt";
            stringArray[32] = "COLUMN_CHAINS";
            stringArray[33] = "hasResidueLabeling";
            stringArray[34] = "getBinaryLabeling";
            stringArray[35] = "binaryResidueLabeler";
            stringArray[36] = "residues";
            stringArray[37] = Dataset.COLUMN_PROTEIN;
            stringArray[38] = Dataset.COLUMN_PROTEIN;
            stringArray[39] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[40];
            Item.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(Item.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = Item.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static final class Fold
    implements GroovyObject {
        private int num;
        private Dataset trainset;
        private Dataset evalset;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public Fold(int num, Dataset trainset, Dataset evalset) {
            MetaClass metaClass;
            CallSite[] callSiteArray = Fold.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            int n = num;
            this.num = DefaultTypeTransformation.intUnbox((Object)n);
            Dataset dataset = trainset;
            this.trainset = (Dataset)ScriptBytecodeAdapter.castToType((Object)dataset, Dataset.class);
            Dataset dataset2 = evalset;
            this.evalset = (Dataset)ScriptBytecodeAdapter.castToType((Object)dataset2, Dataset.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Fold.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Fold.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(Fold.class, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Fold.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(Fold.class, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = Fold.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = Fold.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = Fold.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Fold.class, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = Fold.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Fold.class, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public int getNum() {
            return this.num;
        }

        @Generated
        public void setNum(int n) {
            this.num = n;
        }

        @Generated
        public Dataset getTrainset() {
            return this.trainset;
        }

        @Generated
        public void setTrainset(Dataset dataset) {
            this.trainset = dataset;
        }

        @Generated
        public Dataset getEvalset() {
            return this.evalset;
        }

        @Generated
        public void setEvalset(Dataset dataset) {
            this.evalset = dataset;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(Fold.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = Fold.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    @FunctionalInterface
    public interface Processor {
        public void processItem(Item var1);
    }

    public static class Result
    implements GroovyObject {
        private List<Item> errorItems;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public Result() {
            MetaClass metaClass;
            CallSite[] callSiteArray = Result.$getCallSiteArray();
            Object object = callSiteArray[0].call(Collections.class, callSiteArray[1].callConstructor(ArrayList.class));
            this.errorItems = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public boolean hasErrors() {
            CallSite[] callSiteArray = Result.$getCallSiteArray();
            return ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[2].call(this.errorItems), (Object)0);
        }

        public int getErrorCount() {
            CallSite[] callSiteArray = Result.$getCallSiteArray();
            return DefaultTypeTransformation.intUnbox((Object)callSiteArray[3].call(this.errorItems));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Result.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Result.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(Result.class, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Result.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(Result.class, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = Result.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = Result.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = Result.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Result.class, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = Result.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Result.class, Dataset.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public List<Item> getErrorItems() {
            return this.errorItems;
        }

        @Generated
        public void setErrorItems(List<Item> list) {
            this.errorItems = list;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "synchronizedList";
            stringArray[1] = "<$constructor$>";
            stringArray[2] = "size";
            stringArray[3] = "size";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[4];
            Result.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(Result.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = Result.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

