/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.collectors;

import cz.siret.prank.collectors.VectorCollector;
import cz.siret.prank.domain.PredictionPair;
import cz.siret.prank.domain.labeling.LabeledPoint;
import cz.siret.prank.features.FeatureExtractor;
import cz.siret.prank.features.FeatureVector;
import cz.siret.prank.features.PrankFeatureExtractor;
import cz.siret.prank.features.api.ProcessedItemContext;
import cz.siret.prank.geom.Atoms;
import cz.siret.prank.program.PrankException;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PointVectorCollector
extends VectorCollector
implements Parametrized {
    private FeatureExtractor extractorFactory;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public PointVectorCollector(FeatureExtractor extractorFactory) {
        FeatureExtractor featureExtractor;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
        this.extractorFactory = featureExtractor = extractorFactory;
    }

    public abstract List<LabeledPoint> labelPoints(Atoms var1, PredictionPair var2, ProcessedItemContext var3);

    @Override
    public VectorCollector.Result collectVectors(PredictionPair pair, ProcessedItemContext context) {
        FeatureExtractor proteinExtractorPrototype = this.extractorFactory.createPrototypeForProtein(pair.getPrediction().getProtein(), context);
        FeatureExtractor proteinExtractor = ((PrankFeatureExtractor)ScriptBytecodeAdapter.asType((Object)proteinExtractorPrototype, PrankFeatureExtractor.class)).createInstanceForWholeProtein();
        Atoms points = proteinExtractor.getSampledPoints();
        List<LabeledPoint> labeledPoints = this.labelPoints(points, pair, context);
        VectorCollector.Result res = new VectorCollector.Result(labeledPoints.size());
        LabeledPoint point = null;
        Iterator<LabeledPoint> iterator = labeledPoints.iterator();
        while (iterator.hasNext()) {
            point = (LabeledPoint)ScriptBytecodeAdapter.castToType((Object)iterator.next(), LabeledPoint.class);
            try {
                Object vect = proteinExtractor.calcFeatureVector(point);
                boolean positive = point.getObserved();
                res.addBinary(((FeatureVector)vect).getArray(), positive);
            }
            catch (Exception e) {
                if (this.getParams().getFail_fast()) {
                    throw (Throwable)new PrankException("failed extraction for point", e);
                }
                log.error("skipping extraction for point", (Throwable)e);
            }
        }
        proteinExtractorPrototype.finalizeProteinPrototype();
        return res;
    }

    @Override
    public List<String> getHeader() {
        return DefaultGroovyMethods.plus(this.extractorFactory.getVectorHeader(), (Object)"class");
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PointVectorCollector.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(VectorCollector.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.collectors.PointVectorCollector");
        Parametrized.Trait.Helper.$static$init$(PointVectorCollector.class);
    }

    @Generated
    public FeatureExtractor getExtractorFactory() {
        return this.extractorFactory;
    }

    @Generated
    public void setExtractorFactory(FeatureExtractor featureExtractor) {
        this.extractorFactory = featureExtractor;
    }
}

