/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.collectors;

import cz.siret.prank.collectors.VectorCollector;
import cz.siret.prank.domain.Pocket;
import cz.siret.prank.domain.PredictionPair;
import cz.siret.prank.features.FeatureExtractor;
import cz.siret.prank.features.FeatureVector;
import cz.siret.prank.features.PrankFeatureExtractor;
import cz.siret.prank.features.api.ProcessedItemContext;
import cz.siret.prank.geom.Atoms;
import cz.siret.prank.prediction.pockets.criteria.DCA;
import cz.siret.prank.prediction.pockets.criteria.PocketCriterium;
import cz.siret.prank.program.PrankException;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import cz.siret.prank.utils.Cutils;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LigandabilityPointVectorCollector
extends VectorCollector
implements Parametrized {
    private static final PocketCriterium DEFAULT_POCKET_CRITERIUM;
    private final double POSITIVE_VC_LIGAND_DISTANCE;
    private final double NEGATIVES_DIST;
    private FeatureExtractor extractorFactory;
    private PocketCriterium criterium;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public LigandabilityPointVectorCollector(FeatureExtractor extractorFactory) {
        MetaClass metaClass;
        PocketCriterium pocketCriterium;
        CallSite[] callSiteArray = LigandabilityPointVectorCollector.$getCallSiteArray();
        Object object = callSiteArray[0].callGetProperty(callSiteArray[1].callGroovyObjectGetProperty((Object)this));
        this.POSITIVE_VC_LIGAND_DISTANCE = DefaultTypeTransformation.doubleUnbox((Object)object);
        Object object2 = callSiteArray[2].call(callSiteArray[3].callGetProperty(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), callSiteArray[5].callGetProperty(callSiteArray[6].callGroovyObjectGetProperty((Object)this)));
        this.NEGATIVES_DIST = DefaultTypeTransformation.doubleUnbox((Object)object2);
        this.criterium = pocketCriterium = DEFAULT_POCKET_CRITERIUM;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        callSiteArray[7].call(Parametrized.Trait.Helper.class, (Object)this);
        FeatureExtractor featureExtractor = extractorFactory;
        this.extractorFactory = (FeatureExtractor)ScriptBytecodeAdapter.castToType((Object)featureExtractor, FeatureExtractor.class);
    }

    public Atoms getTrainingRelevantLigandAtoms(PredictionPair pair) {
        CallSite[] callSiteArray = LigandabilityPointVectorCollector.$getCallSiteArray();
        Atoms res = (Atoms)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].callConstructor(Atoms.class), Atoms.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].call(callSiteArray[10].callGetProperty(callSiteArray[11].callGroovyObjectGetProperty((Object)this)), (Object)"relevant"))) {
            callSiteArray[12].call((Object)res, ScriptBytecodeAdapter.getPropertySpreadSafe(LigandabilityPointVectorCollector.class, (Object)callSiteArray[13].callGetProperty(callSiteArray[14].callGroovyObjectGetProperty((Object)pair)), (String)"atoms"));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].call(callSiteArray[16].callGetProperty(callSiteArray[17].callGroovyObjectGetProperty((Object)this)), (Object)"ignored"))) {
            callSiteArray[18].call((Object)res, ScriptBytecodeAdapter.getPropertySpreadSafe(LigandabilityPointVectorCollector.class, (Object)callSiteArray[19].callGetProperty(callSiteArray[20].callGroovyObjectGetProperty((Object)pair)), (String)"atoms"));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].call(callSiteArray[22].callGetProperty(callSiteArray[23].callGroovyObjectGetProperty((Object)this)), (Object)"small"))) {
            callSiteArray[24].call((Object)res, ScriptBytecodeAdapter.getPropertySpreadSafe(LigandabilityPointVectorCollector.class, (Object)callSiteArray[25].callGetProperty(callSiteArray[26].callGroovyObjectGetProperty((Object)pair)), (String)"atoms"));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].call(callSiteArray[28].callGetProperty(callSiteArray[29].callGroovyObjectGetProperty((Object)this)), (Object)"distant"))) {
            callSiteArray[30].call((Object)res, ScriptBytecodeAdapter.getPropertySpreadSafe(LigandabilityPointVectorCollector.class, (Object)callSiteArray[31].callGetProperty(callSiteArray[32].callGroovyObjectGetProperty((Object)pair)), (String)"atoms"));
        }
        return res;
    }

    @Override
    public VectorCollector.Result collectVectors(PredictionPair pair, ProcessedItemContext context) {
        CallSite[] callSiteArray = LigandabilityPointVectorCollector.$getCallSiteArray();
        VectorCollector.Result finalRes = (VectorCollector.Result)ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].callConstructor(VectorCollector.Result.class), VectorCollector.Result.class);
        FeatureExtractor proteinExtractorPrototype = (FeatureExtractor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].call((Object)this.extractorFactory, callSiteArray[35].callGetProperty(callSiteArray[36].callGroovyObjectGetProperty((Object)pair)), (Object)context), FeatureExtractor.class);
        Atoms ligandAtoms = (Atoms)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].callCurrent((GroovyObject)this, (Object)pair), Atoms.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[38].callGetProperty((Object)ligandAtoms))) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[39].call((Object)log)) ? callSiteArray[40].call((Object)log, (Object)"no ligands! [{}]", callSiteArray[41].callGetProperty(callSiteArray[42].callGroovyObjectGetProperty((Object)pair))) : null;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[43].callGetProperty(callSiteArray[44].callGroovyObjectGetProperty((Object)this)))) {
            Object object = callSiteArray[45].callCurrent((GroovyObject)this, (Object)ligandAtoms, (Object)proteinExtractorPrototype);
            finalRes = (VectorCollector.Result)ScriptBytecodeAdapter.castToType((Object)object, VectorCollector.Result.class);
        } else {
            callSiteArray[46].call((Object)proteinExtractorPrototype);
            List usePockets = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].callGetProperty(callSiteArray[48].callGroovyObjectGetProperty((Object)pair)), List.class);
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[49].callGetProperty(callSiteArray[50].callGroovyObjectGetProperty((Object)this)), (Object)0)) {
                List list;
                usePockets = list = ScriptBytecodeAdapter.createList((Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{callSiteArray[51].call((Object)pair, (Object)this.criterium), callSiteArray[52].call(Cutils.class, callSiteArray[53].callGetProperty(callSiteArray[54].callGroovyObjectGetProperty((Object)this)), callSiteArray[55].call((Object)pair, (Object)this.criterium))}, (int[])new int[]{0, 0}));
            }
            Pocket pocket = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[56].call((Object)usePockets), Iterator.class);
            while (iterator.hasNext()) {
                pocket = (Pocket)ScriptBytecodeAdapter.castToType(iterator.next(), Pocket.class);
                try {
                    FeatureExtractor pocketExtractor = (FeatureExtractor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[57].call((Object)proteinExtractorPrototype, (Object)pocket), FeatureExtractor.class);
                    VectorCollector.Result pocketRes = (VectorCollector.Result)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].callCurrent((GroovyObject)this, (Object)pocket, (Object)pair, (Object)ligandAtoms, (Object)pocketExtractor), VectorCollector.Result.class);
                    callSiteArray[59].call((Object)finalRes, (Object)pocketRes);
                }
                catch (Exception e) {
                    Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].call((Object)log)) ? callSiteArray[61].call((Object)log, callSiteArray[62].call((Object)new GStringImpl(new Object[]{callSiteArray[63].callGroovyObjectGetProperty((Object)pocket)}, new String[]{"skipping extraction from pocket:", " reason: "}), callSiteArray[64].call((Object)e)), (Object)e) : null;
                }
            }
        }
        callSiteArray[65].call((Object)proteinExtractorPrototype);
        return finalRes;
    }

    public VectorCollector.Result collectWholeSurface(Atoms ligandAtoms, FeatureExtractor proteinExtractorPrototype) {
        FeatureExtractor proteinExtractor = ((PrankFeatureExtractor)ScriptBytecodeAdapter.asType((Object)proteinExtractorPrototype, PrankFeatureExtractor.class)).createInstanceForWholeProtein();
        VectorCollector.Result res = new VectorCollector.Result();
        Atoms points = proteinExtractor.getSampledPoints();
        if (!(this.getParams().getTrain_lig_cutoff() <= 0.0)) {
            Atoms atoms;
            points = atoms = points.cutoutShell(ligandAtoms, this.getParams().getTrain_lig_cutoff());
        }
        Atom point = null;
        Iterator<Atom> iterator = points.iterator();
        while (iterator.hasNext()) {
            point = (Atom)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Atom.class);
            try {
                double closestLigandDistance = ligandAtoms.dist(point);
                boolean ligPoint = closestLigandDistance <= this.POSITIVE_VC_LIGAND_DISTANCE;
                boolean negPoint = !(closestLigandDistance < this.NEGATIVES_DIST);
                if (!(ligPoint || negPoint)) continue;
                double clazz = ligPoint ? 1.0 : 0.0;
                Object vect = proteinExtractor.calcFeatureVector(point);
                res.add(((FeatureVector)vect).getArray(), clazz);
                if (ligPoint) {
                    int n = res.getPositives();
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)(n + 1), LigandabilityPointVectorCollector.class, (GroovyObject)res, (String)"positives");
                    continue;
                }
                int n = res.getNegatives();
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)(n + 1), LigandabilityPointVectorCollector.class, (GroovyObject)res, (String)"negatives");
            }
            catch (Exception e) {
                if (this.getParams().getFail_fast()) {
                    throw (Throwable)new PrankException("failed extraction for point", e);
                }
                log.error("skipping extraction for point", (Throwable)e);
            }
        }
        return res;
    }

    private VectorCollector.Result collectForPocket(Pocket pocket, PredictionPair pair, Atoms ligandAtoms, FeatureExtractor pocketExtractor) {
        boolean ligPocket = pair.isCorrectlyPredictedPocket(pocket, this.criterium);
        VectorCollector.Result res = new VectorCollector.Result();
        Atom point = null;
        Iterator<Atom> iterator = pocketExtractor.getSampledPoints().iterator();
        while (iterator.hasNext()) {
            point = (Atom)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Atom.class);
            double closestLigandDistance = ligandAtoms.dist(point);
            if (!(closestLigandDistance <= (double)100)) {
                int n = 100;
                closestLigandDistance = n;
            }
            boolean ligPoint = closestLigandDistance <= this.POSITIVE_VC_LIGAND_DISTANCE;
            boolean includePoint = false;
            double clazz = ligPoint ? 1.0 : 0.0;
            if (ligPoint) {
                boolean bl;
                int n = res.getPositives();
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)(n + 1), LigandabilityPointVectorCollector.class, (GroovyObject)res, (String)"positives");
                includePoint = bl = true;
            } else if (!ligPocket && !ligPoint && !(closestLigandDistance <= this.NEGATIVES_DIST)) {
                boolean bl;
                int n = res.getNegatives();
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)(n + 1), LigandabilityPointVectorCollector.class, (GroovyObject)res, (String)"negatives");
                includePoint = bl = true;
            }
            if (!includePoint) continue;
            Object vect = pocketExtractor.calcFeatureVector(point);
            res.add(((FeatureVector)vect).getArray(), clazz);
        }
        return res;
    }

    @Override
    public List<String> getHeader() {
        CallSite[] callSiteArray = LigandabilityPointVectorCollector.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[66].call(callSiteArray[67].callGroovyObjectGetProperty((Object)this.extractorFactory), (Object)"is_liganated_point"), List.class);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != LigandabilityPointVectorCollector.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        CallSite[] callSiteArray = LigandabilityPointVectorCollector.$getCallSiteArray();
        return (Params)ScriptBytecodeAdapter.castToType((Object)callSiteArray[68].call(Parametrized.Trait.Helper.class, (Object)this), Params.class);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        CallSite[] callSiteArray = LigandabilityPointVectorCollector.$getCallSiteArray();
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].callStatic(InvokerHelper.class, callSiteArray[70].call((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class))), (Object)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(VectorCollector.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        Object object = LigandabilityPointVectorCollector.$getCallSiteArray()[71].callConstructor(DCA.class, (Object)5);
        DEFAULT_POCKET_CRITERIUM = (PocketCriterium)ScriptBytecodeAdapter.castToType((Object)object, PocketCriterium.class);
        Object object2 = LigandabilityPointVectorCollector.$getCallSiteArray()[72].call(LoggerFactory.class, (Object)"cz.siret.prank.collectors.LigandabilityPointVectorCollector");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object2, Logger.class);
        Parametrized.Trait.Helper.$static$init$(LigandabilityPointVectorCollector.class);
    }

    @Generated
    public static PocketCriterium getDEFAULT_POCKET_CRITERIUM() {
        return DEFAULT_POCKET_CRITERIUM;
    }

    @Generated
    public final double getPOSITIVE_VC_LIGAND_DISTANCE() {
        return this.POSITIVE_VC_LIGAND_DISTANCE;
    }

    @Generated
    public final double getNEGATIVES_DIST() {
        return this.NEGATIVES_DIST;
    }

    @Generated
    public FeatureExtractor getExtractorFactory() {
        return this.extractorFactory;
    }

    @Generated
    public void setExtractorFactory(FeatureExtractor featureExtractor) {
        this.extractorFactory = featureExtractor;
    }

    @Generated
    public PocketCriterium getCriterium() {
        return this.criterium;
    }

    @Generated
    public void setCriterium(PocketCriterium pocketCriterium) {
        this.criterium = pocketCriterium;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "positive_point_ligand_distance";
        stringArray[1] = "params";
        stringArray[2] = "plus";
        stringArray[3] = "positive_point_ligand_distance";
        stringArray[4] = "params";
        stringArray[5] = "neutral_points_margin";
        stringArray[6] = "params";
        stringArray[7] = "$init$";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "contains";
        stringArray[10] = "positive_def_ligtypes";
        stringArray[11] = "params";
        stringArray[12] = "addAll";
        stringArray[13] = "ligands";
        stringArray[14] = "protein";
        stringArray[15] = "contains";
        stringArray[16] = "positive_def_ligtypes";
        stringArray[17] = "params";
        stringArray[18] = "addAll";
        stringArray[19] = "ignoredLigands";
        stringArray[20] = "protein";
        stringArray[21] = "contains";
        stringArray[22] = "positive_def_ligtypes";
        stringArray[23] = "params";
        stringArray[24] = "addAll";
        stringArray[25] = "smallLigands";
        stringArray[26] = "protein";
        stringArray[27] = "contains";
        stringArray[28] = "positive_def_ligtypes";
        stringArray[29] = "params";
        stringArray[30] = "addAll";
        stringArray[31] = "distantLigands";
        stringArray[32] = "protein";
        stringArray[33] = "<$constructor$>";
        stringArray[34] = "createPrototypeForProtein";
        stringArray[35] = "protein";
        stringArray[36] = "prediction";
        stringArray[37] = "getTrainingRelevantLigandAtoms";
        stringArray[38] = "empty";
        stringArray[39] = "isErrorEnabled";
        stringArray[40] = "error";
        stringArray[41] = "name";
        stringArray[42] = "protein";
        stringArray[43] = "sample_negatives_from_decoys";
        stringArray[44] = "params";
        stringArray[45] = "collectWholeSurface";
        stringArray[46] = "prepareProteinPrototypeForPockets";
        stringArray[47] = "pockets";
        stringArray[48] = "prediction";
        stringArray[49] = "train_pockets";
        stringArray[50] = "params";
        stringArray[51] = "getCorrectlyPredictedPockets";
        stringArray[52] = "head";
        stringArray[53] = "train_pockets";
        stringArray[54] = "params";
        stringArray[55] = "getFalsePositivePockets";
        stringArray[56] = "iterator";
        stringArray[57] = "createInstanceForPocket";
        stringArray[58] = "collectForPocket";
        stringArray[59] = "addAll";
        stringArray[60] = "isErrorEnabled";
        stringArray[61] = "error";
        stringArray[62] = "plus";
        stringArray[63] = "name";
        stringArray[64] = "getMessage";
        stringArray[65] = "finalizeProteinPrototype";
        stringArray[66] = "plus";
        stringArray[67] = "vectorHeader";
        stringArray[68] = "getParams";
        stringArray[69] = "invokeMethod";
        stringArray[70] = "getProxyTarget";
        stringArray[71] = "<$constructor$>";
        stringArray[72] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[73];
        LigandabilityPointVectorCollector.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(LigandabilityPointVectorCollector.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = LigandabilityPointVectorCollector.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

