/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.collectors;

import cz.siret.prank.features.implementation.ProtrusionFeature;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import cz.siret.prank.utils.Formatter;
import cz.siret.prank.utils.PerfUtils;
import cz.siret.prank.utils.WekaUtils;
import cz.siret.prank.utils.Writable;
import groovy.lang.GString;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class DataPreprocessor
implements Parametrized,
Writable,
GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DataPreprocessor() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Writable.Trait.Helper.$init$(this);
        Parametrized.Trait.Helper.$init$(this);
    }

    public Instances preProcessTrainData(Instances data) {
        double removePercentage = 0.0;
        int reduceToSubsetSize = this.getParams().getMax_train_instances();
        if (reduceToSubsetSize > 0 && data.size() > reduceToSubsetSize) {
            double d;
            Object v0;
            if (log.isInfoEnabled()) {
                log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{reduceToSubsetSize}, new String[]{"reducing vectors to subset of size ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            removePercentage = d = (double)100 * (1.0 - (double)reduceToSubsetSize / (double)data.size());
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)removePercentage, (Object)$const$0)) {
            Object v2;
            Instances instances;
            Object v1;
            if (log.isInfoEnabled()) {
                log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{removePercentage}, new String[]{"removing percentage ", ""})));
                v1 = null;
            } else {
                v1 = null;
            }
            data = instances = WekaUtils.randomSubsample(1.0 - removePercentage, this.getParams().getSeed(), data);
            if (log.isInfoEnabled()) {
                log.info(StringGroovyMethods.plus((CharSequence)"instances left: ", (Object)data.size()));
                v2 = null;
            } else {
                v2 = null;
            }
        }
        if (this.getParams().isSupersample() || this.getParams().isSubsample()) {
            Instances instances;
            data = instances = this.handleClassImbalances(data);
        }
        if (this.getParams().isBalance_class_weights()) {
            Instances instances;
            data = instances = this.balanceClassWeights(data);
        }
        return data;
    }

    private Instances handleClassImbalances(Instances data) {
        Instances instances;
        Instances instances2;
        List<Instances> split = WekaUtils.splitPositivesNegatives(data);
        Instances positives = (Instances)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(split, (int)0), Instances.class);
        Instances negatives = (Instances)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(split, (int)1), Instances.class);
        int pc = positives.size();
        int nc = negatives.size();
        double ratio = (double)pc / (double)nc;
        double targetRatio = this.getParams().getTarget_class_ratio();
        int seed = new Random(this.getParams().getSeed()).nextInt();
        DataPreprocessor.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DataPreprocessor.fmt(ratio), DataPreprocessor.fmt(targetRatio)}, new String[]{"positives/negatives  ratio: ", "  targetRatio: ", ""})));
        if (Math.abs(ratio - targetRatio) * (double)data.size() < 1.0) {
            DataPreprocessor.write("diference between ratio and target ratio is negligible");
            return data;
        }
        if (this.getParams().isSupersample() || this.getParams().isSubsample()) {
            DataPreprocessor.write(StringGroovyMethods.plus((String)"instances: ", (CharSequence)DataPreprocessor.descState(positives, negatives)));
            if (this.getParams().isSupersample()) {
                if (ratio < targetRatio) {
                    Instances instances3;
                    double multiplier = targetRatio / ratio;
                    DataPreprocessor.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DataPreprocessor.fmt(multiplier)}, new String[]{"supersampling positives (multiplier: ", ")"})));
                    positives = instances3 = WekaUtils.randomSample(multiplier, seed, positives);
                } else {
                    Instances instances4;
                    double multiplier = ratio / targetRatio;
                    DataPreprocessor.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DataPreprocessor.fmt(multiplier)}, new String[]{"supersampling negatives (multiplier: ", ")"})));
                    negatives = instances4 = WekaUtils.randomSample(multiplier, seed, negatives);
                }
            } else if (ratio < targetRatio) {
                double multiplier = ratio / targetRatio;
                DataPreprocessor.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DataPreprocessor.fmt(multiplier)}, new String[]{"subsampling negatives (multiplier: ", ")"})));
                if (this.getParams().isSubsampl_high_protrusion_negatives()) {
                    Instances instances5;
                    Attribute attr = negatives.attribute(ProtrusionFeature.getNAME());
                    if (attr != null) {
                        negatives.sort(attr);
                    }
                    negatives = instances5 = WekaUtils.removeRatio(negatives, 1.0 - multiplier);
                } else {
                    Instances instances6;
                    negatives = instances6 = WekaUtils.randomSample(multiplier, seed, negatives);
                }
            } else {
                Instances instances7;
                double multiplier = targetRatio / ratio;
                DataPreprocessor.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{multiplier}, new String[]{"subsampling positives (multiplier: ", ")"})));
                positives = instances7 = WekaUtils.randomSample(multiplier, seed, positives);
            }
            DataPreprocessor.write(StringGroovyMethods.plus((String)"instances: ", (CharSequence)DataPreprocessor.descState(positives, negatives)));
        }
        data = instances2 = WekaUtils.joinInstances(ScriptBytecodeAdapter.createList((Object[])new Object[]{positives, negatives}));
        data = instances = WekaUtils.randomize(data, seed);
        return data;
    }

    private static String descState(Instances positives, Instances negatives) {
        int pos = positives.size();
        int neg = negatives.size();
        double ratio = PerfUtils.round((double)pos / (double)neg, 6);
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pos, neg, DataPreprocessor.fmt(ratio)}, new String[]{"positives: ", ", negatives: ", ", ratio: ", ""}));
    }

    private static String fmt(double d) {
        return Formatter.format(d, 3);
    }

    private Instances balanceClassWeights(Instances data) {
        List<Instances> split = WekaUtils.splitPositivesNegatives(data);
        Instances positives = (Instances)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(split, (int)0), Instances.class);
        Instances negatives = (Instances)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(split, (int)1), Instances.class);
        int pc = positives.size();
        int nc = negatives.size();
        double ratio = (double)pc / (double)nc;
        double targetWeightRatio = this.getParams().getTarget_class_weight_ratio();
        double posWeight = targetWeightRatio / ratio;
        DataPreprocessor.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DataPreprocessor.fmt(ratio)}, new String[]{"balancing class weights ... ratio: ", ""}).plus((GString)new GStringImpl(new Object[]{DataPreprocessor.fmt(targetWeightRatio), DataPreprocessor.fmt(posWeight)}, new String[]{"  target ratio: ", "  pos. weight: ", ""}))));
        Instance inst = null;
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            inst = (Instance)ScriptBytecodeAdapter.castToType(iterator.next(), Instance.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)WekaUtils.isPositiveInstance(inst))) continue;
            inst.setWeight(posWeight);
        }
        DataPreprocessor.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DataPreprocessor.fmt(DataPreprocessor.weightedRatio(data))}, new String[]{"weighted ratio: ", ""})));
        return data;
    }

    private static double weightedRatio(Instances data) {
        double wp = 0.0;
        double wn = 0.0;
        Instance inst = null;
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            inst = (Instance)ScriptBytecodeAdapter.castToType(iterator.next(), Instance.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)WekaUtils.isPositiveInstance(inst))) {
                double cfr_ignored_0 = wp + inst.weight();
                continue;
            }
            double cfr_ignored_1 = wn + inst.weight();
        }
        return wp / wn;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DataPreprocessor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;Lorg/slf4j/Logger;)V")
    public static void write(String arg1, Logger arg2) {
        ScriptBytecodeAdapter.invokeMethodN(DataPreprocessor.class, Writable.Trait.Helper.class, (String)"write", (Object[])new Object[]{DataPreprocessor.class, arg1, arg2});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;Ljava/lang/Throwable;)V")
    public static void writeError(String arg1, Throwable arg2) {
        ScriptBytecodeAdapter.invokeMethodN(DataPreprocessor.class, Writable.Trait.Helper.class, (String)"writeError", (Object[])new Object[]{DataPreprocessor.class, arg1, arg2});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;)V")
    public static void write(String arg1) {
        ScriptBytecodeAdapter.invokeMethodN(DataPreprocessor.class, Writable.Trait.Helper.class, (String)"write", (Object[])new Object[]{DataPreprocessor.class, arg1});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;)V")
    public static void writeError(String arg1) {
        ScriptBytecodeAdapter.invokeMethodN(DataPreprocessor.class, Writable.Trait.Helper.class, (String)"writeError", (Object[])new Object[]{DataPreprocessor.class, arg1});
    }

    static {
        Logger logger;
        DataPreprocessor.__$swapInit();
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.collectors.DataPreprocessor");
        Writable.Trait.Helper.$static$init$(DataPreprocessor.class);
        Parametrized.Trait.Helper.$static$init$(DataPreprocessor.class);
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        $const$0 = bigDecimal = new BigDecimal("0.0");
    }
}

