# Contributing
## Contributing guidelines
We’d love you to help us improve this project. To help us keep this collection high quality, we
request that contributions adhere to the following guidelines.

- **Provide links to documentation** supporting the change you’re making.
  If documentation isn’t available to support your change, do the best you can to explain what
  you're aiming for.

- **Explain why you’re making a change**. Even if it seems self-evident, please take a sentence or
  two to tell us why your change or addition should happen. It’s especially helpful to articulate
  why this change applies to *everyone* who works with the applicable technology, rather than just
  you or your team.

- **One change/feature per pull request**. This helps keep pull requests and feedback focused on a
  specific topic or improvement.

In general, the more you can do to help us understand the change you’re making, the more likely
we’ll be to accept your contribution quickly.

## Contributing workflow
Here’s how we suggest you go about proposing a change to this project:

1. [Fork this project][fork] to your account.
2. [Create a branch][branch] for the change you intend to make.
3. Make your changes to your fork.
4. [Send a pull request][pr] from your fork’s branch to our `master` branch.

Using the web-based interface to make changes is fine too, and will help you by automatically
forking the project and prompting to send a pull request too.

[fork]: https://github.com/jbrazio/Ardupower#fork-destination-box
[branch]: https://github.com/jbrazio/Ardupower/branches
[pr]: https://github.com/jbrazio/Ardupower/pulls
