If you find a bug, please create an issue on GitHub. Be sure to include details on how to reproduce the bug and any relevant screenshots or logs.

### Suggesting Features

We are always looking for new ideas! If you have a suggestion, please open an issue and tag it with the `enhancement` label.

### Code Contributions

1. **Fork the Repository:**
   Fork the repository on GitHub to your own account.

2. **Clone Your Fork:**
   ```bash
   git clone https://github.com/jbpassot/flutter_voice_friend.git
   ```

3. **Create a New Branch:**
   ```bash
   git checkout -b feature/your-feature-name
   ```

4. **Make Your Changes:**
   Implement your changes, making sure to follow our coding style.

5. **Run Tests:**
   Make sure all tests pass before submitting your code.

6. **Commit Your Changes:**
   ```bash
   git commit -m "Description of changes"
   ```

7. **Push Your Branch:**
   ```bash
   git push origin feature/your-feature-name
   ```

8. **Submit a Pull Request:**
   Go to the original repository on GitHub and submit a pull request. Please provide a detailed description of your changes.

### Code Style

Please follow these guidelines:

- Use descriptive names for variables and functions.
- Write comments for complex logic.
- Ensure code is formatted with Dart's `flutter format` command.

### License

By contributing, you agree that your contributions will be licensed under the same license as this project.

Thank you for contributing to FlutterVoiceFriend - Whisper!