<?php

declare(strict_types=1);

/**
 * MapFile Generator - MapServer .MAP Generator (Read, Write & Preview).
 *
 * @author Jonathan Beliën
 * @license GNU General Public License, version 2
 */

namespace MapFile\Parser;

use MapFile\Exception\UnsupportedException;
use MapFile\Model\Feature as FeatureObject;

class Feature extends Parser
{
    public function parse(string $filename, int $lineNumber = 0): FeatureObject
    {
        parent::parse($filename, $lineNumber);

        $feature = new FeatureObject();

        while ($this->eof === false) {
            $line = $this->getCurrentLine();
            if (strlen($line) === 0) {
                continue;
            }

            if (preg_match('/^FEATURE$/i', $line) === 1) {
                $this->lineStart = $this->currentLineIndex;
                $this->parsing = 'FEATURE';
            } elseif ($this->parsing === 'FEATURE' && preg_match('/^POINTS$/i', $line) === 1) {
                $pointsParser = new Points();

                $feature->points = $pointsParser->parse($this->file, $this->currentLineIndex - 1);

                $this->currentLineIndex = $pointsParser->lineEnd;
            } elseif ($this->parsing === 'FEATURE' && preg_match('/^ITEMS ["\'](.+)["\']$/i', $line, $matches) === 1) {
                $feature->items = $matches[1];
            } elseif ($this->parsing === 'FEATURE' && preg_match('/^TEXT ["\'](.+)["\']$/i', $line, $matches) === 1) {
                $feature->text = $matches[1];
            } elseif ($this->parsing === 'FEATURE' && preg_match('/^WKT ["\'](.+)["\']$/i', $line, $matches) === 1) {
                $feature->wkt = $matches[1];
            } elseif ($this->parsing === 'FEATURE' && preg_match('/^END( # FEATURE)?$/i', $line) === 1) {
                $this->lineEnd = $this->currentLineIndex;
                $this->parsing = null;

                break;
            } else {
                throw new UnsupportedException(
                    sprintf('Unsupported (or deprecated) parameter "%s" at line %d.', $line, $this->currentLineIndex)
                );
            }
        }

        return $feature;
    }
}
