DROP ALL OBJECTS;

CREATE TABLE ADDRESS (
    address_id                  smallint        not null IDENTITY,
    street_name                 varchar(255)    ,
    city                        varchar(255)    not null,
    version                     smallint        default 0,
    primary key (address_id)
);
-- _________________________________________________________________
--
--                       ACCOUNT
-- _________________________________________________________________


CREATE TABLE ACCOUNT (
    account_id              char(32) not null,
    address_id              smallint,    
    login                   varchar(255) not null,
    password                varchar(255) not null,
    email                   varchar(255) not null,
    is_enabled              bool,
    birth_date              timestamp,
    civility                char(2),
    first_name              varchar(255),
    last_name               varchar(255),
    version                 smallint default 0,

    constraint account_unique_1 unique (login),
    constraint account_unique_2 unique (email),
    constraint account_unique_3 unique (address_id),
    constraint account_fk_1 foreign key (address_id) references ADDRESS,    
    primary key (account_id)
);


CREATE TABLE ROLE (
    role_id         smallint        generated by default as identity,
    name_locale     varchar(255)    not null,

    constraint role_unique_1 unique (name_locale),
    primary key (role_id)
);

CREATE TABLE ACCOUNT_ROLE (
    account_id  char(32) not null,
    role_id     smallint not null,

    constraint account_role_fk_1 foreign key (account_id) references ACCOUNT,
    constraint account_role_fk_2 foreign key (role_id) references ROLE,
    primary key (account_id, role_id)
);

CREATE TABLE DOCUMENT (
    document_id                 char(32)        not null,
    account_id                  char(32)        not null,
    document_content_type       varchar(255)    not null,
    document_size               integer         not null,
    document_file_name          varchar(255)    not null,
    document_binary             bytea,
    version                     smallint        default 0,

    constraint document_fk_1 foreign key (account_id) references ACCOUNT,
    primary key (document_id)
);

CREATE TABLE BOOK (
    book_id                     smallint        not null IDENTITY,
    account_id                  char(32)        not null,
    title                       varchar(255)    not null,
    number_of_pages             integer         not null,
    version                     smallint        default 0,

    constraint book_fk_1 foreign key (account_id) references ACCOUNT,
    primary key (book_id)
);

CREATE TABLE LEGACY (
    name varchar(16) not null,
    code varchar(8) not null,
    dept smallint not null,
    extra_info varchar(255) not null,
    primary key (name, code, dept)
);

-- _________________________________________________________________
--
--                       ACCOUNT
-- _________________________________________________________________
INSERT INTO ACCOUNT (account_id, login, password, email, is_enabled) VALUES ('0000000000000000000000000000001', 'user',  'user',  'user@example.com', true);
INSERT INTO ACCOUNT (account_id, login, password, email, is_enabled) VALUES ('0000000000000000000000000000002', 'demo',  'demo',  'demo@example.com', true);
INSERT INTO ACCOUNT (account_id, login, password, email, is_enabled) VALUES ('0000000000000000000000000000003', 'admin', 'admin', 'admin@example.com', true);

-- _________________________________________________________________
--
--                       ROLE
-- _________________________________________________________________
-- We rely on sequence seq_role to prevent collision.
-- pk=1 ==> ROLE_ADMIN, 
-- pk=2 ==> ROLE_USER, 
-- pk=3 ==> ROLE_ANONYMOUS

INSERT INTO ROLE (name_locale) VALUES ('ROLE_ADMIN');
INSERT INTO ROLE (name_locale) VALUES ('ROLE_USER');
INSERT INTO ROLE (name_locale) VALUES ('ROLE_ANONYMOUS');

-- _________________________________________________________________
--
--                       ACCOUNT_ROLE
-- _________________________________________________________________
INSERT INTO ACCOUNT_ROLE (account_id, role_id) VALUES ('0000000000000000000000000000001', 2);
INSERT INTO ACCOUNT_ROLE (account_id, role_id) VALUES ('0000000000000000000000000000001', 3);
INSERT INTO ACCOUNT_ROLE (account_id, role_id) VALUES ('0000000000000000000000000000002', 2);
INSERT INTO ACCOUNT_ROLE (account_id, role_id) VALUES ('0000000000000000000000000000002', 3);
INSERT INTO ACCOUNT_ROLE (account_id, role_id) VALUES ('0000000000000000000000000000003', 1);
INSERT INTO ACCOUNT_ROLE (account_id, role_id) VALUES ('0000000000000000000000000000003', 2);
INSERT INTO ACCOUNT_ROLE (account_id, role_id) VALUES ('0000000000000000000000000000003', 3);

INSERT INTO LEGACY (name, code, dept, extra_info) VALUES ('name1', 'code1', 1, 'extra1');
INSERT INTO LEGACY (name, code, dept, extra_info) VALUES ('name2', 'code2', 2, 'extra2');
INSERT INTO LEGACY (name, code, dept, extra_info) VALUES ('name3', 'code3', 3, 'extra3');
INSERT INTO LEGACY (name, code, dept, extra_info) VALUES ('name4', 'code4', 4, 'extra4');


