
--  _______________________
--  NOTE ABOUT Primary Keys
--
--  1/ For each numerical pk, Celerio expects by convention a sequence.
--     sequence name = seq_<tablename>
--     For example, if the Table is 'BANK_ACCOUNT', the sequence name should be 'seq_bank_account'
--
--  2/ By convention, for all pk that are char(32), Celerio will configure hibernate to use
--     an UUIDHexGenerator. Therefore no sequence is needed for these pk.
--
--  3/ For pk that are char(x) where x is different from 32, Celerio configure hibernate
--     with the "assigned" generator, which means that you must provide manually the pk value.
--

CREATE TABLE ADDRESS (
    address_id                  smallint        not null IDENTITY,
    street_name                 varchar(255)    ,
    city                        varchar(255)    not null,
    version                     smallint        default 0,
    primary key (address_id)
);
-- _________________________________________________________________
--
--                       ACCOUNT
-- _________________________________________________________________


CREATE TABLE ACCOUNT (
    account_id              char(32) not null,
    address_id              smallint,    
    login                   varchar(255) not null,
    password                varchar(255) not null,
    email                   varchar(255) not null,
    is_enabled              bool,
    last_access_date        timestamp,
    first_name              varchar(255),
    last_name               varchar(255),
    version                 smallint default 0,

    constraint account_unique_1 unique (login),
    constraint account_unique_2 unique (email),
    constraint account_unique_3 unique (address_id),
    constraint account_fk_1 foreign key (address_id) references ADDRESS,    
    primary key (account_id)
);


CREATE TABLE ROLE (
    role_id         smallint        generated by default as identity,
    name_locale     varchar(255)    not null,

    constraint role_unique_1 unique (name_locale),
    primary key (role_id)
);

CREATE TABLE ACCOUNT_ROLE (
    account_id  char(32) not null,
    role_id     smallint not null,

    constraint account_role_fk_1 foreign key (account_id) references ACCOUNT,
    constraint account_role_fk_2 foreign key (role_id) references ROLE,
    primary key (account_id, role_id)
);

CREATE TABLE DOCUMENT (
    document_id                 char(32)        not null,
    account_id                  char(32)        not null,
    document_content_type       varchar(255)    not null,
    document_size               integer         not null,
    document_file_name          varchar(255)    not null,
    document_binary             bytea,
    version                     smallint        default 0,

    constraint document_fk_1 foreign key (account_id) references ACCOUNT,
    primary key (document_id)
);

CREATE TABLE LEGACY (
    name varchar(16) not null,
    code varchar(8) not null,
    dept smallint not null,
    extra_info varchar(255) not null,
    primary key (name, code, dept)
);

