/*
 * Copyright 2015 JAXIO http://www.jaxio.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.jaxio.celerio.configuration.entity;

import lombok.Setter;

@Setter
public class Label {

    private String lang;
    private String value;

    /*
     * The label's language, for example 'fr'. Leave it null for the base.
     */
    public String getLang() {
        return lang;
    }

    /*
     * The label. It is copied in properties file located in the folder 'src/main/resources/localization/domain'.
     */
    public String getValue() {
        return value;
    }
}