/*
 * Copyright 2015 JAXIO http://www.jaxio.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.jaxio.celerio.configuration;

import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * Meta attributes are free form key value pairs
 */
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class MetaAttribute {
    private String name;
    private String value;

    /*
     * name of you meta attribute
     */
    public String getName() {
        return name;
    }

    /*
     * value for this attribute
     */
    public String getValue() {
        return value;
    }
}
