/*
 * Copyright 2015 JAXIO http://www.jaxio.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.jaxio.celerio.configuration;

import java.util.Calendar;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;
import static com.jaxio.celerio.configuration.Util.firstNonNull;
import static com.jaxio.celerio.configuration.Util.nonNull;
import static java.util.Calendar.YEAR;

/*
 * Specify your own file header comments
 */
public class HeaderComment {
    private static final int currentYear = Calendar.getInstance().get(YEAR);
    private static List<String> defaultHeaderComment = newArrayList(
            "Source code generated by Celerio, a Jaxio product.", //
            "Documentation: http://www.jaxio.com/documentation/celerio/",
            "Follow us on twitter: @jaxiosoft", //
            "Need commercial support ? Contact us: info@jaxio.com"
    );

    protected Boolean include = true;
    protected Boolean showTemplateName = true;
    protected List<String> lines = newArrayList();

    /*
     * Set each line to be added to the header files.
     */
    public List<String> getLines() {
        return lines;
    }

    public void setLines(List<String> lines) {
        this.lines = nonNull(lines);
    }

    /*
     * Should the header be present in the generated files ?
     */
    public Boolean getInclude() {
        return include;
    }

    public void setInclude(Boolean include) {
        this.include = firstNonNull(include, this.include);
    }

    /*
     * Should the template name be present in the header. This is useful when dealing with large amount of templates and packs for debugging purposes or support
     * information.
     */
    public Boolean getShowTemplateName() {
        return showTemplateName;
    }

    public void setShowTemplateName(Boolean showTemplateName) {
        this.showTemplateName = firstNonNull(showTemplateName, this.showTemplateName);
    }

    public List<String> getComments() {
        return lines.isEmpty() ? defaultHeaderComment : lines;
    }
}