# Parameters:
# OPTION_VAR_NAME is variable name which will be passed to OPTION call
# OPTION_DESCRIPTION is text description which will be passed to OPTION call
# PACKAGE_FOUND_VAR is boolean variable indicated is requiring package found or not
MACRO (OPTION_DEPENDENT_ON_PACKAGE OPTION_VAR_NAME OPTION_DESCRIPTION PACKAGE_FOUND_VAR)
	IF (NOT DEFINED ${OPTION_VAR_NAME})
		OPTION (${OPTION_VAR_NAME} "${OPTION_DESCRIPTION}" ${${PACKAGE_FOUND_VAR}})
	ELSE (NOT DEFINED ${OPTION_VAR_NAME})
		IF (${OPTION_VAR_NAME} AND NOT ${PACKAGE_FOUND_VAR})
			MESSAGE (FATAL_ERROR "You have set using of ${OPTION_VAR_NAME} whereas ${PACKAGE_FOUND_VAR} is NO")
		ENDIF (${OPTION_VAR_NAME} AND NOT ${PACKAGE_FOUND_VAR})
	ENDIF (NOT DEFINED ${OPTION_VAR_NAME})
ENDMACRO (OPTION_DEPENDENT_ON_PACKAGE)

# Parameters:
# OPTION_VAR_NAME is variable name which will be passed to OPTION call
# OPTION_DESCRIPTION is text description which will be passed to OPTION call
# PACKAGE_FOUND_VAR and after parameters are boolean variables indicated is requiring package found or not
MACRO (OPTION_DEPENDENT_ON_ALL_PACKAGES OPTION_VAR_NAME OPTION_DESCRIPTION PACKAGE_FOUND_VAR)
	SET (ALL_PACKAGES_FOUND TRUE)
	FOREACH (cur_package ${PACKAGE_FOUND_VAR} ${ARGN})
		IF (NOT ${cur_package})
			SET (ALL_PACKAGES_FOUND FALSE)
			SET (NOTFOUND_PACKAGES ${NOTFOUND_PACKAGES} ${cur_package})
		ENDIF (NOT ${cur_package})
	ENDFOREACH (cur_package)
	IF (NOT DEFINED ${OPTION_VAR_NAME})
		OPTION (${OPTION_VAR_NAME} "${OPTION_DESCRIPTION}" ${ALL_PACKAGES_FOUND})
	ELSE (NOT DEFINED ${OPTION_VAR_NAME})
		IF (${OPTION_VAR_NAME} AND NOT ALL_PACKAGES_FOUND)
			MESSAGE (FATAL_ERROR "You have set using of ${OPTION_VAR_NAME} whereas ${NOTFOUND_PACKAGES} is NO")
		ENDIF (${OPTION_VAR_NAME} AND NOT ALL_PACKAGES_FOUND)
	ENDIF (NOT DEFINED ${OPTION_VAR_NAME})
ENDMACRO (OPTION_DEPENDENT_ON_ALL_PACKAGES)
