# The Complete JavaScript Course 🔥

The modern JavaScript course to help you go from **Zero to HERO** in 2024! Master JavaScript with projects, challenges and theory; the only course you'll ever need!

## What You'll Learn

✅ Become an advanced, confident, and modern JavaScript developer from scratch.  
✅ Build 5 beautiful real-world projects for your portfolio (not boring toy apps).  
✅ Become job-ready by understanding how JavaScript really works behind the scenes.  
✅ How to think and work like a developer: problem-solving, researching, workflows.  
✅ JavaScript fundamentals: variables, if/else, operators, boolean logic, functions,. arrays, objects, loops, strings, etc.  
✅ Modern ES6+ from the beginning: arrow functions, destructuring, spread operator, optional chaining (ES2020), etc.  
✅ Modern OOP: Classes, constructors, prototypal inheritance, etc.  
✅ Complex concepts like the 'this' keyword, higher-order functions, closures, etc.  
✅ Asynchronous JavaScript: Event loop, promises, async/await and APIs.  
✅ How to architect your code using flowcharts and common patterns.  
✅ Modern tools for 2024 and beyond: NPM & ES6 modules.  
✅ Practice your skills with 50+ challenges and assignments (solutions included).  
✅ Get fast and friendly support in the Q&A discord.  

## The Course Includes

🔥 9+ hours on-demand video.  
⭐️ 58 coding exercises.  
⚡️ [Companion JavaScript Notes](https://smoljames.com/notes/javascript).  
🧪 Access on mobile and TV.  
🏆 5 amazing JavaScript projects.  
🪄 Access to a [Discord](https://discord.gg/BYr6gujs4k) support community.  
🎉 Certificate of completion.  


## Who This Course Is For

- Take this course if you want to gain a true and deep understanding of JavaScript.
- Take this course if you have been trying to learn JavaScript but: 1) still don't really understand JavaScript, or 2) still don't feel confident to code real apps.
- Take this course if you're interested in using a library/framework like React, Angular, Vue or Node in the future.
- Take this course if you already know JavaScript and are looking for an advanced course. This course includes expert topics!
- Take this course if you want to get started with programming: JavaScript is a great first language!

## Requirements

- No coding experience is necessary to take this course! I take you from absolute zero to pro!
- Any computer and OS will work — Windows, macOS or Linux. We will set up your text editor the course.
- A basic understanding of HTML and CSS is a plus, but not a must! There is an HTML & CSS crash course linked within the course resources.

## Description

### Why is this the right JavaScript course for you?

This course will teach you everything you need to know to dive into JavaScript development today 🔥 But even more than that, it teaches it via a curriculum that won't take you hundreds of hours to complete. It's an all-in-one package that will take you from the very fundamentals of JavaScript, all the way to building modern and complex applications.

You will learn modern JavaScript from the very beginning, step-by-step. I will guide you through practical and fun code examples, important theory about how JavaScript works behind the scenes, and beautiful and complete projects.

You will become ready to continue learning advanced front-end frameworks like React, Vue, Angular, or SvelteKit.

You will also learn how to think like a developer, how to plan application features, how to architect your code, how to debug code, and a lot of other real-world skills that you will need in your developer job.

And unlike other courses, this one actually contains beginner, intermediate, advanced, and even expert topics, so you don't have to buy any other course in order to master JavaScript from the ground up!

By the end of the course, you will have the knowledge and confidence that you need in order to ace your job interviews, build insane applications with JavaScript, and become a professional developer.

### Why am I the right JavaScript teacher for you?

My name is James, and I've helped over 500,000 individuals just like you learn to code. I self-taught programming and understand how challenging it can be to learn to code; but I don't want it to be hard for you. This course is the course I wish I had back when I was learning to become a JavaScript pro in a comfortable amount of time. 

I am also an experienced web developer and designer, and have experience teaching programming, sciences and mathematics for over 10 years. I know how students learn JavaScript and what they need in order to master it. And with that knowledge, I designed the ideal course curriculum. It's a unique blend of real-world projects, deep explanations, theory lectures, and challenges, that will take you from zero to absolute hero and you will be a confident JavaScript developer no time at all.

### So what exactly is covered in the course?

- Build 5 beautiful real-world projects for your portfolio! In these projects, you will learn how to plan and architect your applications using flowcharts and common JavaScript patterns
- Master the JavaScript fundamentals: variables, if/else, operators, boolean logic, functions, arrays, objects, loops, strings, and more
- Learn modern JavaScript (ES6+) from the beginning: arrow functions, destructuring, spread operator, default arguments, optional chaining, and more
- Deep dive into functions: arrow functions, first-class and higher-order functions, bind, and closures.
- Deep dive into asynchronous JavaScript: the event loop, promises, async/await, and error handling. You will use these to access data from third-party APIs with AJAX calls. [This is like a small standalone course]
- Learn modern tools that are used by professional web developers: NPM, Parcel, Babel, and ES6 modules

Check out the [course curriculum](#course-curriculum) for an even more detailed overview of the content :P

### This is what's also included in the package:

- Up-to-date HD-quality videos, that are easy to search and reference.
- Downloadable starter code and final code for each section.
- Course companion guides & summary notes.
- Professional English captions (coming soon).
- 58+ coding challenges / questions to practice your new skills

Does any of these look like you? If so, then start this adventure today, and join me and numerous other developers in the only JavaScript course that you will ever need!

## Instructor

James graduated with an Honors degree in Civil Engineering, and after working a few years as a consultant, decided self-taught coding &  pursue a career as a Software Developer. James runs a [YouTube](https://www.youtube.com/smoljames) channel where he has helped thousands of individuals learn to code and land their very own developer jobs. 

He has over 10 years of private tutoring experience in maths, programming and sciences, having taught students of all ages and capabilities. He believes that education should be about fun and curiousity and helps student learn the art of self-teaching so they can continue to extend their ability beyond his lessons. James is available for contact in his [Discord](https://discord.gg/BYr6gujs4k) channel, or over on [LinkedIn](https://www.linkedin.com/in/jamezmcarthur/).

* https://www.smoljames.com


## Course Curriculum

### 1.0 Introduction

- Course structure & outline.
- About the tutor.
- Setting up our code editor.
- How to think like a developer.

### 2.0 Learn basic javascript syntax and concepts

- Introduction to JavaScript & how it works.
- Fundamental JavaScript syntax, including variables, data types, and operators.
- Control flow through conditional statements and loops.
- Basic functions and their use in structuring code.

### 3.0 Develop Intermediate Programming Skills with JavaScript

- Working with arrays, objects, and manipulating data.
- Scope, closures, and how to write modular and reusable code.
- Error handling techniques and debugging tools for effective troubleshooting.

### 4.0 Understand DOM Manipulation and Event Handling in JavaScript
- Master the Document Object Model (DOM) and its manipulation using JavaScript.
- Handling user events and updating the DOM dynamically.
- Understand event delegation and bubbling for efficient event management.
- Dynamic page styling with DOM manipulation.

### 5.0 Modern OOP with Classes, constructors & prototypal inheritance.

- Learn to define and instantiate classes, and initialize properties with constructors.
- Understand the prototype chain and how objects inherit properties and methods.
- The This keyword.

### 6.0 Gain Competency with Asynchronous Programming in JavaScript

- Asynchronous JavaScript with promises and async/await.
- Make HTTP requests and work with APIs for data retrieval and integration.

### 7.0 Learn the Modern ES6+ JavaScript Syntax

- Advanced JavaScript features introduced in ES6+.
- JavaScript Modules and Import/Export.

### 8.0 Coding Best Practices and Algorithmic Programming with JavaScript

- Optimize JavaScript code for better performance and efficiency.
- Apply coding best practices, and write clean and maintainable code.
- Big 0 notation
- Solving algorithmic programming questions with JavaScript.

### 9.0 Develop Numerous Portfolio Projects with JavaScript

- Build a Compound Interest calculator.
- Code an AI chatbot.
- Program a functional TODO app w. HTML & CSS.
- Write a custom JSON database.
- Develop a stock data web server with Node.JS + Express.JS.

### 10.0 Future Learning and Extra for Experts

- Front-end and backend JavaScript frameworks.
- Deploying your code to a production environment.
- Cloud functions and cloud computing.
- Continuing your JavaScript journey.


<!-- turn it into a link to the course -->
[![img-thumbnail](/assets/thumbnail.jpg)](https://www.udemy.com/course/the-complete-javascript-course-zero-to-hero/?referralCode=F6229ABBDBD16EB43FA4)