import 'package:flutter/material.dart';

class MakeItem extends StatelessWidget {
  final String image;
  final String title;
  final String route;

  MakeItem({
    this.image,
    this.title,
    this.route,
  });

  void traverse(BuildContext ctx, String route) {
    Navigator.of(ctx).pushNamed(route);
  }

  @override
  Widget build(BuildContext context) {
    return AspectRatio(
      aspectRatio: 1 / 1,
      child: Container(
        margin: EdgeInsets.only(right: 15),
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(20),
          image: DecorationImage(
            image: AssetImage(image),
            fit: BoxFit.cover,
          ),
        ),
        child: InkWell(
          onTap: () => traverse(context, route),
          splashColor: Theme.of(context).accentColor,
          borderRadius: BorderRadius.circular(20),
          child: Container(
            padding: EdgeInsets.all(20),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(20),
              gradient: LinearGradient(
                begin: Alignment.bottomRight,
                colors: [
                  Theme.of(context).primaryColor.withOpacity(.8),
                  Theme.of(context).primaryColor.withOpacity(.2),
                ],
              ),
            ),
            child: Align(
              alignment: Alignment.bottomLeft,
              child: Text(
                title,
                style: TextStyle(
                  color: Colors.white,
                  fontSize: 20,
                  fontFamily: 'Lato',
                ),
              ),
            ),
          ),
        ),
      ),
    );
  }
}
