# KitBook 

Documentation, Prototyping, Inspection & Testing Workbench Tool for Svelte built with SvelteKit that lets you rapidly build, document, and test components. Inspired by [Svench](https://svench-docs.vercel.app/) and [[why|others]].

## Best Features
- File-based sidebar tree structure, with optional prefixed numbers to adjust ordering of your docs
- Iframe isolation for easy media query testing
- [[3-component-variants|Variants]] and [[4-component-compositions|Compositions]] are [[Rendering-Platform|SSR rendered and then hydrated client-side]] just like the rest of your SvelteKit app
- Quickly create and compare [[3-component-variants|Variants]] of a component via **typesafe** exported prop objects in a colocated `.variants.ts` file that can also be used for testing, especially visual regression tests of your components.
- Use [[5-write-documentation|markdown]] to enable easy documenation as you build
- All SvelteKit-only imports are automatically available because it runs inside your regular SvelteKit app. No need for any special mocks or compatibility hacks. 
- Build components using the same context as your main app, like i18n.
- [Foam](https://foambubble.github.io/foam/) based automatic updating [[6-easy-wikilinks|wiki-links]] for easy linking between pages within your Kitbook that will never get out of date.
- Conveniently view and edit component state from your app and quickly create component variants the [[2-viewer]] tool.
- Great [[8-i18n]] support
- Unlimited [[7-visual-regression-testing]] with Playwright

## Start Building!

Learn how to [[1-get-started]], view some [[9-examples]], *hint: you're looking at one*, or open the starter template in Stackblitz:

[![Open in StackBlitz](https://developer.stackblitz.com/img/open_in_stackblitz.svg)](https://stackblitz.com/fork/github/jacob-8/kitbook/tree/main/packages/template)


[//begin]: # "Autogenerated link references for markdown compatibility"
[why|others]: docs/why.md "Why not use an already existing alternative?"
[3-component-variants|Variants]: docs/3-component-variants.md "Component Variants"
[4-component-compositions|Compositions]: docs/4-component-compositions.md "Component Compositions"
[Rendering-Platform|SSR rendered and then hydrated client-side]: docs/1-variants/Rendering-Platform.md "Rendering Platform"
[5-write-documentation|markdown]: docs/5-write-documentation.md "Write Documentation"
[6-easy-wikilinks|wiki-links]: docs/6-easy-wikilinks.md "Easy Wikilinks"
[2-viewer]: docs/2-viewer.md "Viewer"
[8-i18n]: docs/8-i18n.md "i18n"
[7-visual-regression-testing]: docs/7-visual-regression-testing.md "Visual Regression Testing"
[1-get-started]: docs/1-get-started.md "Get Started"
[9-examples]: docs/9-examples.md "Examples"
[//end]: # "Autogenerated link references"