# Addtional Component Tests

Variants have an optional `tests` property which allows you to write a normal Playwright test against the current variant state in each of that variant's viewports (and languages if applicable).

The test name will be the name used for the variant plus the key you specify in your tests Object, `bar-works` in the following example. The value should be an async function and you can write a Playwright test just like normal. We do some interaction and then take a screenshot in the following example but there's no need to screenshot if you'd rather do a different type of expect.

```ts title="Foo.variants.ts" {9-15}
import type { Variant, Viewport } from 'kitbook'
import type Component from './Foo.svelte'

export const variants: Variant<Component>[] = [
  {
    props: {
      baz: true,
    },
    tests: {
      additional: {
        'bar-works': async ({ page, expect, name }) => {
          await page.getByRole('button', { name: 'bar' }).click()
          await expect(page.getByText('I can be seen after clicking on bar')).toBeVisible()
          await expect(page).toHaveScreenshot([`${name}.png`])
        },
      }
    }
  },
]
```

Speaking of languages, if you have a multilingual site, you should check out the section on [[8-i18n]].

[//begin]: # "Autogenerated link references for markdown compatibility"
[8-i18n]: 8-i18n.md "i18n"
[//end]: # "Autogenerated link references"