# Easy Wikilinks

Kitbook supports using [Foam](https://foambubble.github.io/foam/) to easily add [wikilinks](https://foambubble.github.io/foam/user/features/wikilinks) between your various documentation pages in a manner that ensures they always stay up-to-date. *These links will also work in Github and VS Code!*

## Setup Foam

- Add the [Foam extension](https://marketplace.visualstudio.com/items?itemName=foam.foam-vscode)
- Add these VSCode settings:
  ```json title=".vscode/settings.json"
  {
    "foam.completion.label": "title",
    "foam.edit.linkReferenceDefinitions": "withExtensions",
    "foam.files.ignore": [
      // any folders containing unrelated markdown files not part of your Kitbook can be added here to avoid autocompletion noise
      "**/node_modules/**/*",
      "**/.svelte-kit/**/*",
      "**/dist/**/*" // if using svelte-package
    ],
    "foam.files.notesExtensions": "composition" // allows direct linking to compositions from within your markdown files
  }
  ```

- Add a placeholder `.vscode/foam.json` file to tell the Foam extension to activate in your repo:
  ```json title=".vscode/foam.json"
  {
    "purpose": "this file exists to tell the foam-vscode plugin that it's currently in a foam workspace",
    "future": "we may use this for custom configuration"
  }
  ```

- The [Markdown All in One extension](https://marketplace.visualstudio.com/items?itemName=yzhang.markdown-all-in-one) is highly recommended but not required for [Foam](https://foambubble.github.io/foam/) to work. It's best feature is the ability to paste a URL on top of highlighted text to automatically create a markdown link.

## Usage

You should read the [Foam](https://foambubble.github.io/foam/) docs, but to get you started, you can create a link to any markdown or composition file in your repo by typing `[[` and then letting Foam's autocomplete help you as you type either the filename or the main heading. For example, to link to this page which has a name of `6-easy-wikilinks` and a main heading of `Easy Wikilinks`, just start typing heading `[[Easy Wi` and select the autocomplete option to place`[[6-easy-wikilinks]]` in your code which will render like this: [[6-easy-wikilinks]]. Now you can now click the link in your editor to jump to that file. *Note that you usually need to save the file for Foam to create the [wikilink](https://foambubble.github.io/foam/user/features/wikilinks) reference at the bottom of your file. Foam handles the linking in your editor and Kitbook uses these wikilink references to give you  appropriate links in the browser.*

The Foam extension does a good job of automatically updating links as you change filenames but if names get out of sync somehow, you can always run [`Foam: Run Janitor`](https://foambubble.github.io/foam/user/tools/workspace-janitor) from VS Code's command palette to ensure the links across your entire repo are up to date. Also note that sometimes with a 1 line markdown file, Foam doesn't respond. Try adding a few more lines and saving again to get the wikilinks to generate.

### Using Aliases
Sometimes when you link to a page in mid sentence like [[1-get-started|this project's amazing guide to getting started]] you want to use a custom alias for your wikilink. You can do that by adding a `|` character followed by your alias. That link you just saw looks like `[[1-get-started|this project's amazing guide to getting started]]` in the source code.

### Linking to a sub-heading

[Foam](https://foambubble.github.io/foam/) supports [linking to specific sections](https://foambubble.github.io/foam/user/features/wikilinks#support-for-sections) of a page, which you can also take advantage of in Kitbook. So `[[6-easy-wikilinks#Setup Foam]]` would result in a direct link to the section above and looks like: [[6-easy-wikilinks#Setup Foam]]. If you change your section titles, Foam will not automatically update the link to that section though it will give you an editor warning on the wikilink that no section with such title exists.

### Include a composition inline in your markdown

By default any compositions for your markdown files will show after the markdown. If you want to include a composition inline in your markdown, you can do so by adding a `[[filename.composition]]` tag. For example, `[[6-easy-wikilinks.composition]]` will include the composition for this markdown file below this paragraph.

[[6-easy-wikilinks.composition]]

Assuming you added the `"foam.files.notesExtensions": "composition"` setting to your `.vscode/settings.json` file, and have restarted VS Code, you should get autocompletion for your compositions as well.

If you've made it this far, you must be a power user. Read on to add [[7-visual-regression-testing]].

[//begin]: # "Autogenerated link references for markdown compatibility"
[6-easy-wikilinks]: 6-easy-wikilinks.md "Easy Wikilinks"
[1-get-started|this project's amazing guide to getting started]: 1-get-started.md "Get Started"
[6-easy-wikilinks#Setup Foam]: 6-easy-wikilinks.md "Easy Wikilinks"
[6-easy-wikilinks.composition]: 6-easy-wikilinks.composition "6-easy-wikilinks"
[7-visual-regression-testing]: 7-visual-regression-testing.md "Visual Regression Testing"
[//end]: # "Autogenerated link references"