# Write Documentation

You can document your application and components by writing markdown ending in `.md`. For general documentation (like this page you're reading now), you can create a folder with any name under your `/src` folder and begin writing documentation in markdown. This Kitbook has a `docs` folder, which is where this file exists as can be seen in the sidebar navigation.

## Component Documentation

To document a component titled `Button.svelte`, navigate to the component's page in Kitbook and click `Add Docs` which will add a sibling file titled `Button.md`. Begin writing and your documentation will automatically be included in the same page as any variants and compositions you've written for that component.

## Index Page

By default Kitbook will display your project's README.md file as its home page. *You can override this by adding a `src/index.md` file.* 

If you would like to include a link to your Kitbook from your README but feel silly when the Kitbook then links to itself, you can surround the link with skip comments which Kitbook will use to strip it out:

```markdown
<!-- Kitbook Skip -->

[Read the docs](https://your-site.app/kitbook)

<!-- Kitbook Skip End -->
```

## Naming Conventions

Name files and folders according to how you want them shown in the sidebar. Alphabetically `Get Started` comes after `Button` but you can use an initial number followed by a hyphen to update the sort order as seen here:
- `1-get-started.md`, displayed first as `Get Started`
- `2-button.svelte`, displayed second as `Button`
  
Folder naming follows the same conventions. `0-components/` will show up as `Components` and be placed before `1-about/` (displayed as `About`).

## Convenient links

You know enough to get started with documentation, but if you want to supercharge your writing abilities, you'll definitely want to learn how to add [[6-easy-wikilinks]].


[//begin]: # "Autogenerated link references for markdown compatibility"
[6-easy-wikilinks]: 6-easy-wikilinks.md "Easy Wikilinks"
[//end]: # "Autogenerated link references"