/*
SQLyog Ultimate v10.00 Beta1
MySQL - 5.6.37 : Database - pengzucms
*********************************************************************
*/


/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`pengzucms` /*!40100 DEFAULT CHARACTER SET utf8 */;

USE `pengzucms`;

/*Table structure for table `article` */

DROP TABLE IF EXISTS `article`;

CREATE TABLE `article` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '文件ID',
  `folder_id` bigint(20) DEFAULT NULL COMMENT '目录Id',
  `father_folder_id` bigint(20) DEFAULT NULL COMMENT '父级目录Id',
  `user_id` varchar(64) DEFAULT NULL COMMENT '管理员ID',
  `picture` varchar(255) DEFAULT NULL COMMENT '图片',
  `title` varchar(200) DEFAULT '' COMMENT '文章名称',
  `summary` varchar(2000) DEFAULT NULL COMMENT '摘要',
  `content` mediumtext COMMENT '文章内容',
  `view_count` bigint(11) DEFAULT '0' COMMENT '浏览数',
  `comment_count` bigint(11) DEFAULT '0' COMMENT '评论数',
  `status` int(2) DEFAULT '1' COMMENT '状态：0 显示 1 隐藏',
  `check` int(2) DEFAULT '1' COMMENT '审核 0 通过审核 1 未审核 2 审核中 3 未通过审核',
  `keywords` varchar(100) DEFAULT NULL COMMENT '关键字',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `is_delete` int(2) DEFAULT '0' COMMENT '是否删除 0:未删除 1:已删除',
  `gmt_article` datetime DEFAULT NULL COMMENT '文章时间',
  `gmt_publish` datetime DEFAULT NULL COMMENT '发布时间',
  `is_publish` int(2) DEFAULT '0' COMMENT '是否发布 0未发布 1 已发布',
  PRIMARY KEY (`id`),
  KEY `idx_folder` (`status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='文章';


/*Table structure for table `blogroll` */

DROP TABLE IF EXISTS `blogroll`;

CREATE TABLE `blogroll` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '友情链接ID',
  `blogroll_name` varchar(200) DEFAULT NULL COMMENT '友情链接名称',
  `blogroll_url` varchar(200) DEFAULT NULL COMMENT '友情链接地址',
  `description` varchar(500) DEFAULT NULL COMMENT '友情链接描述',
  `blogroll_image_url` varchar(500) DEFAULT NULL COMMENT '友情链接图片',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `modify_date` datetime DEFAULT NULL COMMENT '修改时间',
  `user_id` bigint(20) DEFAULT NULL COMMENT '管理员ID',
  `status` int(4) DEFAULT '0' COMMENT '该条友情链接状态0为新建1为删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='友情链接';


/*Table structure for table `comment` */

DROP TABLE IF EXISTS `comment`;

CREATE TABLE `comment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '评论ID',
  `user_id` bigint(20) DEFAULT NULL COMMENT '用户ID',
  `father_id` bigint(20) DEFAULT NULL COMMENT '父评论ID',
  `kind_id` bigint(20) DEFAULT NULL,
  `kind` varchar(45) DEFAULT NULL COMMENT '文件ID',
  `name` varchar(45) DEFAULT NULL COMMENT '评论者',
  `email` varchar(45) DEFAULT NULL COMMENT '评论者邮件地址',
  `url` varchar(200) DEFAULT NULL COMMENT '评论者网址',
  `phone` varchar(20) DEFAULT NULL,
  `content` text COMMENT '内容',
  `ip` varchar(45) DEFAULT NULL COMMENT 'Ip',
  `status` varchar(20) DEFAULT '0' COMMENT '状态 0 显示 1 隐藏',
  `gmt_create` datetime DEFAULT NULL COMMENT '创建时间',
  `gmt_modify` datetime DEFAULT NULL COMMENT '修改时间',
  `is_delete` int(2) NOT NULL DEFAULT '0' COMMENT '是否删除 0 未删除 1 已删除',
  PRIMARY KEY (`id`),
  KEY `idx_status` (`status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='评论';

/*Data for the table `comment` */

/*Table structure for table `download_file` */

DROP TABLE IF EXISTS `download_file`;

CREATE TABLE `download_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '文件ID',
  `file_name` varchar(255) NOT NULL COMMENT '文件名称',
  `url` varchar(255) NOT NULL COMMENT '文件链接地址',
  `gmt_create` datetime NOT NULL COMMENT '创建时间',
  `gmt_modify` datetime NOT NULL COMMENT '修改时间',
  `is_delete` int(1) NOT NULL COMMENT '是否删除  0表示未删除 1表示已删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='文件下载';

/*Data for the table `download_file` */

/*Table structure for table `folder` */

DROP TABLE IF EXISTS `folder`;

CREATE TABLE `folder` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '目录ID',
  `father_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '父亲Id，用于构建目录树',
  `ename` varchar(45) NOT NULL COMMENT '英文名',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '中文名',
  `level` int(4) DEFAULT '1' COMMENT '层级',
  `sort` int(4) DEFAULT '0' COMMENT '排序',
  `count` int(11) DEFAULT '0' COMMENT '文件数',
  `status` int(2) DEFAULT '1' COMMENT '状态：0 隐藏 1 显示',
  `check` int(2) DEFAULT '1' COMMENT '审核 0 通过审核 1 未审核 2 审核中 3 未通过审核',
  `gmt_create` datetime DEFAULT NULL COMMENT '创建时间',
  `gmt_modify` datetime DEFAULT NULL COMMENT '修改时间',
  `title` varchar(100) DEFAULT NULL COMMENT '目录标题',
  `keywords` varchar(100) DEFAULT NULL COMMENT '目录关键字',
  `description` varchar(500) DEFAULT NULL COMMENT '目录描述',
  `is_delete` int(2) DEFAULT '0' COMMENT '是否删除 0 未删除 1 已删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='目录';

/*Data for the table `folder` */

insert  into `folder`(`id`,`father_id`,`ename`,`name`,`level`,`sort`,`count`,`status`,`check`,`gmt_create`,`gmt_modify`,`title`,`keywords`,`description`,`is_delete`) values (1,0,'sy','首页',1,-1,0,0,1,'2018-04-06 20:29:11','2018-09-12 17:04:22','欢迎访问xxxx官方网站','欢迎访问xxxx官方网站','xxxxx是以撒的as 啊',0);

/*Table structure for table `guestbook` */

DROP TABLE IF EXISTS `guestbook`;

CREATE TABLE `guestbook` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL COMMENT '留言者姓名',
  `email` varchar(100) DEFAULT NULL COMMENT '留言者邮箱',
  `phone` varchar(20) DEFAULT NULL COMMENT '留言着者联系方式',
  `title` varchar(200) DEFAULT NULL COMMENT '留言标题',
  `content` varchar(2000) DEFAULT NULL COMMENT '留言内容',
  `reply` varchar(2000) DEFAULT NULL COMMENT '回复内容',
  `status` int(2) DEFAULT '0' COMMENT '阅读状态 0 未读 1 已读',
  `gmt_craete` datetime DEFAULT NULL COMMENT '创建时间',
  `gmt_modify` datetime DEFAULT NULL COMMENT '修改时间',
  `gmt_reply` datetime DEFAULT NULL COMMENT '回复时间',
  `is_delete` int(2) DEFAULT '0' COMMENT '是否删除 0 未删除 1 已删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

/*Data for the table `guestbook` */

/*Table structure for table `headline` */

DROP TABLE IF EXISTS `headline`;

CREATE TABLE `headline` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `picture` varchar(100) DEFAULT NULL,
  `url` varchar(200) DEFAULT NULL,
  `sort` int(4) DEFAULT '0',
  `gmt_create` datetime DEFAULT NULL,
  `gmt_publish` datetime DEFAULT NULL COMMENT '发布时间',
  `gmt_modify` datetime DEFAULT NULL COMMENT '最后修改时间',
  `status` int(4) DEFAULT '0' COMMENT '发布状态 0 未发布 1 已发布',
  `alt` varchar(255) DEFAULT NULL COMMENT 'ALT标题',
  `is_delete` int(2) DEFAULT '0' COMMENT '是否删除 0 未删除 1 已删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='首页头图';


/*Table structure for table `pengzu_config` */

DROP TABLE IF EXISTS `pengzu_config`;

CREATE TABLE `pengzu_config` (
  `key` varchar(45) NOT NULL COMMENT 'Key',
  `value` varchar(255) DEFAULT NULL COMMENT '值',
  `description` varchar(512) DEFAULT NULL COMMENT '描述',
  `config_type` int(2) DEFAULT '0' COMMENT '配置类型 0：前台配置 1：后台配置',
  `gmt_create` datetime DEFAULT NULL COMMENT '创建时间',
  `gmt_modify` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='网站配置';

/*Data for the table `pengzu_config` */

insert  into `pengzu_config`(`key`,`value`,`description`,`config_type`,`gmt_create`,`gmt_modify`) values ('aboutUs','关于我们关于我们关于我们关于我们','关于我们',0,'2018-05-28 21:27:32','2018-09-12 21:14:30'),('address','四川省xxx市xx县','联系地址',0,'2018-06-10 21:37:30','2018-09-12 21:14:30'),('copyRight','Copyright © 2018 xxxx 版权所有','版权信息',0,'2018-05-28 20:50:41','2018-09-12 21:14:30'),('copyRightBack','Copyright © 2018 xxxx 版权所有',NULL,1,'2018-06-05 21:21:32','2018-09-12 21:14:30'),('favicon','/download/2018/09/12/73favicon.ico','浏览器图标',0,'2018-06-05 21:21:32','2018-09-12 21:14:30'),('faviconBack','/download/2018/09/12/6favicon.ico','浏览器图标后台',1,'2018-06-05 21:21:32','2018-09-12 21:14:30'),('logo','/download/2018/09/12/72logo (2).jpg','系统logo哟',0,'2018-05-22 22:40:27','2018-09-12 21:14:30'),('logoBack','/download/2018/09/12/73logo (2).jpg',NULL,1,'2018-06-05 21:21:32','2018-09-12 21:14:30'),('qq','xxxxxxxx','qq',0,'2018-06-05 21:21:32','2018-09-12 21:14:30'),('qqgroup','/download/2018/09/12/81528644273884.png','QQ群',0,'2018-06-10 21:23:13','2018-09-12 21:14:30'),('QRCode','/download/2018/09/12/91xiaochaon_06.png','微信公众号二维码',0,'2018-05-28 20:53:40','2018-09-12 21:14:30'),('recordNumber','<a href=\"http://www.miibeian.gov.cn/\" target=\"_blank\">蜀ICP备xxxxxx号</a>','备案号',0,'2018-05-28 20:49:50','2018-09-12 21:14:30'),('siteName','xxx','网站名称',0,'2018-05-22 22:57:10','2018-09-12 21:14:30'),('siteNameBack','xxx','网站名称后台',1,'2018-06-05 21:21:32','2018-09-12 21:14:30'),('telephone','1xxxxxxxxxx','联系方式',0,'2018-05-28 21:49:49','2018-09-12 21:14:30'),('wechat','1xxxxxxxxxx',NULL,0,NULL,'2018-09-12 21:14:30'),('wechatQRCode','/download/2018/09/12/171083662330.jpg','微信二维码',0,'2018-06-10 21:55:00','2018-09-12 21:14:30'),('weibo','http://weibo.com/u/xxxxxxxx','新浪微博',1,NULL,'2018-09-12 21:14:30');

/*Table structure for table `pengzu_region` */

DROP TABLE IF EXISTS `pengzu_region`;

CREATE TABLE `pengzu_region` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `code` varchar(255) NOT NULL COMMENT '按照国家规定的统一编码来',
  `parent_code` varchar(255) NOT NULL COMMENT '上一级地区的编码',
  `region_name` varchar(255) NOT NULL COMMENT '地区名字',
  `abb_name` varchar(200) DEFAULT NULL COMMENT '别名',
  `region_type` varchar(40) NOT NULL COMMENT '1：国家,2：省份/直辖市,3:市，4：县/区，5：环线',
  `zip` varchar(40) DEFAULT NULL COMMENT '邮编',
  `creater_id` varchar(40) DEFAULT NULL COMMENT '创建者Id',
  `creater` varchar(100) DEFAULT NULL COMMENT '创建者',
  `gmt_create` datetime DEFAULT NULL COMMENT '创建时间',
  `modifier_id` varchar(40) DEFAULT NULL COMMENT '修改者ID',
  `modifier` varchar(100) DEFAULT NULL COMMENT '修改者',
  `gmt_modifier` datetime DEFAULT NULL COMMENT '修改时间',
  `is_deleted` int(1) DEFAULT '0' COMMENT '是否删除 0：未删除, 1：已删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3751 DEFAULT CHARSET=utf8 COMMENT='区域表';

/*Data for the table `pengzu_region` */

insert  into `pengzu_region`(`id`,`code`,`parent_code`,`region_name`,`abb_name`,`region_type`,`zip`,`creater_id`,`creater`,`gmt_create`,`modifier_id`,`modifier`,`gmt_modifier`,`is_deleted`) values (1,'100000','0','中国','zhongguo','1','',NULL,NULL,'2017-02-14 17:04:43',NULL,NULL,NULL,0),(2,'110000','100000','北京','beijing','2','',NULL,NULL,'2017-02-14 17:04:43',NULL,NULL,NULL,0),(3,'110100','110000','北京市','beijingshi','3','100000',NULL,NULL,'2017-02-14 17:04:43',NULL,NULL,NULL,0),(4,'110101','110100','东城区','dongcheng','4','100010',NULL,NULL,'2017-02-14 17:04:43',NULL,NULL,NULL,0),(5,'110102','110100','西城区','xicheng','4','100032',NULL,NULL,'2017-02-14 17:04:43',NULL,NULL,NULL,0),(6,'110105','110100','朝阳区','chaoyang','4','100020',NULL,NULL,'2017-02-14 17:04:43',NULL,NULL,NULL,0),(7,'110106','110100','丰台区','fengtai','4','100071',NULL,NULL,'2017-02-14 17:04:43',NULL,NULL,NULL,0),(8,'110107','110100','石景山区','shijingshan','4','100043',NULL,NULL,'2017-02-14 17:04:43',NULL,NULL,NULL,0),(9,'110108','110100','海淀区','haidian','4','100089',NULL,NULL,'2017-02-14 17:04:43',NULL,NULL,NULL,0),(10,'110109','110100','门头沟区','mentougou','4','102300',NULL,NULL,'2017-02-14 17:04:43',NULL,NULL,NULL,0),(11,'110111','110100','房山区','fangshan','4','102488',NULL,NULL,'2017-02-14 17:04:43',NULL,NULL,NULL,0),(12,'110112','110100','通州区','tongzhou','4','101149',NULL,NULL,'2017-02-14 17:04:43',NULL,NULL,NULL,0),(13,'110113','110100','顺义区','shunyi','4','101300',NULL,NULL,'2017-02-14 17:04:43',NULL,NULL,NULL,0),(14,'110114','110100','昌平区','changping','4','102200',NULL,NULL,'2017-02-14 17:04:43',NULL,NULL,NULL,0),(15,'110115','110100','大兴区','daxing','4','102600',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(16,'110116','110100','怀柔区','huairou','4','101400',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(17,'110117','110100','平谷区','pinggu','4','101200',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(18,'110228','110100','密云县','miyunxian','4','101500',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(19,'110229','110100','延庆县','yanqingxian','4','102100',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(20,'120000','100000','天津','tianjin','2','',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(21,'120100','120000','天津市','tianjinshi','3','300000',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(22,'120101','120100','和平区','heping','4','300041',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(23,'120102','120100','河东区','hedong','4','300171',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(24,'120103','120100','河西区','hexi','4','300202',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(25,'120104','120100','南开区','nankai','4','300110',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(26,'120105','120100','河北区','hebei','4','300143',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(27,'120106','120100','红桥区','hongqiao','4','300131',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(28,'120110','120100','东丽区','dongli','4','300300',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(29,'120111','120100','西青区','xiqing','4','300380',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(30,'120112','120100','津南区','jinnan','4','300350',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(31,'120113','120100','北辰区','beichen','4','300400',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(32,'120114','120100','武清区','wuqing','4','301700',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(33,'120115','120100','宝坻区','baochi','4','301800',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(34,'120116','120100','滨海新区','binhaixin','4','300451',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(35,'120221','120100','宁河县','ninghexian','4','301500',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(36,'120223','120100','静海县','jinghaixian','4','301600',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(37,'120225','120100','蓟县','jixian','4','301900',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(38,'130000','100000','河北省','hebeisheng','2','',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(39,'130100','130000','石家庄市','shijiazhuangshi','3','050011',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(40,'130102','130100','长安区','zhangan','4','050011',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(41,'130104','130100','桥西区','qiaoxi','4','050091',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(42,'130105','130100','新华区','xinhua','4','050051',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(43,'130107','130100','井陉矿区','jingxingkuang','4','050100',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(44,'130108','130100','裕华区','yuhua','4','050031',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(45,'130109','130100','藁城区','gaocheng','4','052160',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(46,'130110','130100','鹿泉区','luquan','4','050200',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(47,'130111','130100','栾城区','luancheng','4','051430',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(48,'130121','130100','井陉县','jingxingxian','4','050300',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(49,'130123','130100','正定县','zhengdingxian','4','050800',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(50,'130125','130100','行唐县','xingtangxian','4','050600',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(51,'130126','130100','灵寿县','lingshouxian','4','050500',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(52,'130127','130100','高邑县','gaoyixian','4','051330',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(53,'130128','130100','深泽县','shenzexian','4','052560',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(54,'130129','130100','赞皇县','zanhuangxian','4','051230',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(55,'130130','130100','无极县','wujixian','4','052460',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(56,'130131','130100','平山县','pingshanxian','4','050400',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(57,'130132','130100','元氏县','yuanshixian','4','051130',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(58,'130133','130100','赵县','zhaoxian','4','051530',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(59,'130181','130100','辛集市','xinjishi','4','052360',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(60,'130183','130100','晋州市','jinzhoushi','4','052260',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(61,'130184','130100','新乐市','xinleshi','4','050700',NULL,NULL,'2017-02-14 17:04:44',NULL,NULL,NULL,0),(62,'130200','130000','唐山市','tangshanshi','3','063000',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(63,'130202','130200','路南区','lunan','4','063000',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(64,'130203','130200','路北区','lubei','4','063000',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(65,'130204','130200','古冶区','guye','4','063100',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(66,'130205','130200','开平区','kaiping','4','063021',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(67,'130207','130200','丰南区','fengnan','4','063300',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(68,'130208','130200','丰润区','fengrun','4','064000',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(69,'130209','130200','曹妃甸区','caofeidian','4','063200',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(70,'130223','130200','滦县','luanxian','4','063700',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(71,'130224','130200','滦南县','luannanxian','4','063500',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(72,'130225','130200','乐亭县','letingxian','4','063600',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(73,'130227','130200','迁西县','qianxixian','4','064300',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(74,'130229','130200','玉田县','yutianxian','4','064100',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(75,'130281','130200','遵化市','zunhuashi','4','064200',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(76,'130283','130200','迁安市','qiananshi','4','064400',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(77,'130300','130000','秦皇岛市','qinhuangdaoshi','3','066000',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(78,'130302','130300','海港区','haigang','4','066000',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(79,'130303','130300','山海关区','shanhaiguan','4','066200',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(80,'130304','130300','北戴河区','beidaihe','4','066100',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(81,'130321','130300','青龙满族自治县','qinglongmanzuzizhixian','4','066500',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(82,'130322','130300','昌黎县','changlixian','4','066600',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(83,'130323','130300','抚宁县','funingxian','4','066300',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(84,'130324','130300','卢龙县','lulongxian','4','066400',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(85,'130400','130000','邯郸市','handanshi','3','056002',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(86,'130402','130400','邯山区','hanshan','4','056001',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(87,'130403','130400','丛台区','congtai','4','056002',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(88,'130404','130400','复兴区','fuxing','4','056003',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(89,'130406','130400','峰峰矿区','fengfengkuang','4','056200',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(90,'130421','130400','邯郸县','handanxian','4','056101',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(91,'130423','130400','临漳县','linzhangxian','4','056600',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(92,'130424','130400','成安县','chenganxian','4','056700',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(93,'130425','130400','大名县','damingxian','4','056900',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(94,'130426','130400','涉县','shexian','4','056400',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(95,'130427','130400','磁县','cixian','4','056500',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(96,'130428','130400','肥乡县','feixiangxian','4','057550',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(97,'130429','130400','永年县','yongnianxian','4','057150',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(98,'130430','130400','邱县','qiuxian','4','057450',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(99,'130431','130400','鸡泽县','jizexian','4','057350',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(100,'130432','130400','广平县','guangpingxian','4','057650',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(101,'130433','130400','馆陶县','guantaoxian','4','057750',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(102,'130434','130400','魏县','weixian','4','056800',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(103,'130435','130400','曲周县','quzhouxian','4','057250',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(104,'130481','130400','武安市','wuanshi','4','056300',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(105,'130500','130000','邢台市','xingtaishi','3','054001',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(106,'130502','130500','桥东区','qiaodong','4','054001',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(107,'130503','130500','桥西区','qiaoxi','4','054000',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(108,'130521','130500','邢台县','xingtaixian','4','054001',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(109,'130522','130500','临城县','linchengxian','4','054300',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(110,'130523','130500','内丘县','neiqiuxian','4','054200',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(111,'130524','130500','柏乡县','boxiangxian','4','055450',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(112,'130525','130500','隆尧县','longyaoxian','4','055350',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(113,'130526','130500','任县','renxian','4','055150',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(114,'130527','130500','南和县','nanhexian','4','054400',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(115,'130528','130500','宁晋县','ningjinxian','4','055550',NULL,NULL,'2017-02-14 17:04:45',NULL,NULL,NULL,0),(116,'130529','130500','巨鹿县','juluxian','4','055250',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(117,'130530','130500','新河县','xinhexian','4','055650',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(118,'130531','130500','广宗县','guangzongxian','4','054600',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(119,'130532','130500','平乡县','pingxiangxian','4','054500',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(120,'130533','130500','威县','weixian','4','054700',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(121,'130534','130500','清河县','qinghexian','4','054800',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(122,'130535','130500','临西县','linxixian','4','054900',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(123,'130581','130500','南宫市','nangongshi','4','055750',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(124,'130582','130500','沙河市','shaheshi','4','054100',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(125,'130600','130000','保定市','baodingshi','3','071052',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(126,'130602','130600','新市区','xinshi','4','071051',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(127,'130603','130600','北市区','beishi','4','071000',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(128,'130604','130600','南市区','nanshi','4','071001',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(129,'130621','130600','满城县','manchengxian','4','072150',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(130,'130622','130600','清苑县','qingyuanxian','4','071100',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(131,'130623','130600','涞水县','laishuixian','4','074100',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(132,'130624','130600','阜平县','fupingxian','4','073200',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(133,'130625','130600','徐水县','xushuixian','4','072550',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(134,'130626','130600','定兴县','dingxingxian','4','072650',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(135,'130627','130600','唐县','tangxian','4','072350',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(136,'130628','130600','高阳县','gaoyangxian','4','071500',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(137,'130629','130600','容城县','rongchengxian','4','071700',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(138,'130630','130600','涞源县','laiyuanxian','4','074300',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(139,'130631','130600','望都县','wangdouxian','4','072450',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(140,'130632','130600','安新县','anxinxian','4','071600',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(141,'130633','130600','易县','yixian','4','074200',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(142,'130634','130600','曲阳县','quyangxian','4','073100',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(143,'130635','130600','蠡县','lixian','4','071400',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(144,'130636','130600','顺平县','shunpingxian','4','072250',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(145,'130637','130600','博野县','boyexian','4','071300',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(146,'130638','130600','雄县','xiongxian','4','071800',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(147,'130681','130600','涿州市','zhuozhoushi','4','072750',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(148,'130682','130600','定州市','dingzhoushi','4','073000',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(149,'130683','130600','安国市','anguoshi','4','071200',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(150,'130684','130600','高碑店市','gaobeidianshi','4','074000',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(151,'130700','130000','张家口市','zhangjiakoushi','3','075000',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(152,'130702','130700','桥东区','qiaodong','4','075000',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(153,'130703','130700','桥西区','qiaoxi','4','075061',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(154,'130705','130700','宣化区','xuanhua','4','075100',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(155,'130706','130700','下花园区','xiahuayuan','4','075300',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(156,'130721','130700','宣化县','xuanhuaxian','4','075100',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(157,'130722','130700','张北县','zhangbeixian','4','076450',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(158,'130723','130700','康保县','kangbaoxian','4','076650',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(159,'130724','130700','沽源县','guyuanxian','4','076550',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(160,'130725','130700','尚义县','shangyixian','4','076750',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(161,'130726','130700','蔚县','yuxian','4','075700',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(162,'130727','130700','阳原县','yangyuanxian','4','075800',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(163,'130728','130700','怀安县','huaianxian','4','076150',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(164,'130729','130700','万全县','wanquanxian','4','076250',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(165,'130730','130700','怀来县','huailaixian','4','075400',NULL,NULL,'2017-02-14 17:04:46',NULL,NULL,NULL,0),(166,'130731','130700','涿鹿县','zhuoluxian','4','075600',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(167,'130732','130700','赤城县','chichengxian','4','075500',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(168,'130733','130700','崇礼县','chonglixian','4','076350',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(169,'130800','130000','承德市','chengdeshi','3','067000',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(170,'130802','130800','双桥区','shuangqiao','4','067000',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(171,'130803','130800','双滦区','shuangluan','4','067001',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(172,'130804','130800','鹰手营子矿区','yingshouyingzikuang','4','067200',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(173,'130821','130800','承德县','chengdexian','4','067400',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(174,'130822','130800','兴隆县','xinglongxian','4','067300',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(175,'130823','130800','平泉县','pingquanxian','4','067500',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(176,'130824','130800','滦平县','luanpingxian','4','068250',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(177,'130825','130800','隆化县','longhuaxian','4','068150',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(178,'130826','130800','丰宁满族自治县','fengningmanzuzizhixian','4','068350',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(179,'130827','130800','宽城满族自治县','kuanchengmanzuzizhixian','4','067600',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(180,'130828','130800','围场满族蒙古族自治县','weichangmanzumengguzuzizhixian','4','068450',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(181,'130900','130000','沧州市','cangzhoushi','3','061001',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(182,'130902','130900','新华区','xinhua','4','061000',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(183,'130903','130900','运河区','yunhe','4','061001',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(184,'130921','130900','沧县','cangxian','4','061000',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(185,'130922','130900','青县','qingxian','4','062650',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(186,'130923','130900','东光县','dongguangxian','4','061600',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(187,'130924','130900','海兴县','haixingxian','4','061200',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(188,'130925','130900','盐山县','yanshanxian','4','061300',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(189,'130926','130900','肃宁县','suningxian','4','062350',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(190,'130927','130900','南皮县','nanpixian','4','061500',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(191,'130928','130900','吴桥县','wuqiaoxian','4','061800',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(192,'130929','130900','献县','xianxian','4','062250',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(193,'130930','130900','孟村回族自治县','mengcunhuizuzizhixian','4','061400',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(194,'130981','130900','泊头市','botoushi','4','062150',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(195,'130982','130900','任丘市','renqiushi','4','062550',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(196,'130983','130900','黄骅市','huanghuashi','4','061100',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(197,'130984','130900','河间市','hejianshi','4','062450',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(198,'131000','130000','廊坊市','langfangshi','3','065000',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(199,'131002','131000','安次区','anci','4','065000',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(200,'131003','131000','广阳区','guangyang','4','065000',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(201,'131022','131000','固安县','guanxian','4','065500',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(202,'131023','131000','永清县','yongqingxian','4','065600',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(203,'131024','131000','香河县','xianghexian','4','065400',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(204,'131025','131000','大城县','dachengxian','4','065900',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(205,'131026','131000','文安县','wenanxian','4','065800',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(206,'131028','131000','大厂回族自治县','dachanghuizuzizhixian','4','065300',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(207,'131081','131000','霸州市','bazhoushi','4','065700',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(208,'131082','131000','三河市','sanheshi','4','065200',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(209,'131100','130000','衡水市','hengshuishi','3','053000',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(210,'131102','131100','桃城区','taocheng','4','053000',NULL,NULL,'2017-02-14 17:04:47',NULL,NULL,NULL,0),(211,'131121','131100','枣强县','zaoqiangxian','4','053100',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(212,'131122','131100','武邑县','wuyixian','4','053400',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(213,'131123','131100','武强县','wuqiangxian','4','053300',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(214,'131124','131100','饶阳县','raoyangxian','4','053900',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(215,'131125','131100','安平县','anpingxian','4','053600',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(216,'131126','131100','故城县','guchengxian','4','053800',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(217,'131127','131100','景县','jingxian','4','053500',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(218,'131128','131100','阜城县','fuchengxian','4','053700',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(219,'131181','131100','冀州市','jizhoushi','4','053200',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(220,'131182','131100','深州市','shenzhoushi','4','053800',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(221,'140000','100000','山西省','shanxisheng','2','',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(222,'140100','140000','太原市','taiyuanshi','3','030082',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(223,'140105','140100','小店区','xiaodian','4','030032',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(224,'140106','140100','迎泽区','yingze','4','030002',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(225,'140107','140100','杏花岭区','xinghualing','4','030009',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(226,'140108','140100','尖草坪区','jiancaoping','4','030023',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(227,'140109','140100','万柏林区','wanbolin','4','030024',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(228,'140110','140100','晋源区','jinyuan','4','030025',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(229,'140121','140100','清徐县','qingxuxian','4','030400',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(230,'140122','140100','阳曲县','yangquxian','4','030100',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(231,'140123','140100','娄烦县','loufanxian','4','030300',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(232,'140181','140100','古交市','gujiaoshi','4','030200',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(233,'140200','140000','大同市','datongshi','3','037008',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(234,'140202','140200','城区','cheng','4','037008',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(235,'140203','140200','矿区','kuang','4','037003',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(236,'140211','140200','南郊区','nanjiao','4','037001',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(237,'140212','140200','新荣区','xinrong','4','037002',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(238,'140221','140200','阳高县','yanggaoxian','4','038100',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(239,'140222','140200','天镇县','tianzhenxian','4','038200',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(240,'140223','140200','广灵县','guanglingxian','4','037500',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(241,'140224','140200','灵丘县','lingqiuxian','4','034400',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(242,'140225','140200','浑源县','hunyuanxian','4','037400',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(243,'140226','140200','左云县','zuoyunxian','4','037100',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(244,'140227','140200','大同县','datongxian','4','037300',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(245,'140300','140000','阳泉市','yangquanshi','3','045000',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(246,'140302','140300','城区','cheng','4','045000',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(247,'140303','140300','矿区','kuang','4','045000',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(248,'140311','140300','郊区','jiao','4','045011',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(249,'140321','140300','平定县','pingdingxian','4','045200',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(250,'140322','140300','盂县','yuxian','4','045100',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(251,'140400','140000','长治市','zhangzhishi','3','046000',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(252,'140402','140400','城区','cheng','4','046011',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(253,'140411','140400','郊区','jiao','4','046011',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(254,'140421','140400','长治县','zhangzhixian','4','047100',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(255,'140423','140400','襄垣县','xiangyuanxian','4','046200',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(256,'140424','140400','屯留县','tunliuxian','4','046100',NULL,NULL,'2017-02-14 17:04:48',NULL,NULL,NULL,0),(257,'140425','140400','平顺县','pingshunxian','4','047400',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(258,'140426','140400','黎城县','lichengxian','4','047600',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(259,'140427','140400','壶关县','huguanxian','4','047300',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(260,'140428','140400','长子县','zhangzixian','4','046600',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(261,'140429','140400','武乡县','wuxiangxian','4','046300',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(262,'140430','140400','沁县','qinxian','4','046400',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(263,'140431','140400','沁源县','qinyuanxian','4','046500',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(264,'140481','140400','潞城市','luchengshi','4','047500',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(265,'140500','140000','晋城市','jinchengshi','3','048000',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(266,'140502','140500','城区','cheng','4','048000',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(267,'140521','140500','沁水县','qinshuixian','4','048200',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(268,'140522','140500','阳城县','yangchengxian','4','048100',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(269,'140524','140500','陵川县','lingchuanxian','4','048300',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(270,'140525','140500','泽州县','zezhouxian','4','048012',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(271,'140581','140500','高平市','gaopingshi','4','048400',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(272,'140600','140000','朔州市','shuozhoushi','3','038500',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(273,'140602','140600','朔城区','shuocheng','4','036000',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(274,'140603','140600','平鲁区','pinglu','4','038600',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(275,'140621','140600','山阴县','shanyinxian','4','036900',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(276,'140622','140600','应县','yingxian','4','037600',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(277,'140623','140600','右玉县','youyuxian','4','037200',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(278,'140624','140600','怀仁县','huairenxian','4','038300',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(279,'140700','140000','晋中市','jinzhongshi','3','030600',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(280,'140702','140700','榆次区','yuci','4','030600',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(281,'140721','140700','榆社县','yushexian','4','031800',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(282,'140722','140700','左权县','zuoquanxian','4','032600',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(283,'140723','140700','和顺县','heshunxian','4','032700',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(284,'140724','140700','昔阳县','xiyangxian','4','045300',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(285,'140725','140700','寿阳县','shouyangxian','4','045400',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(286,'140726','140700','太谷县','taiguxian','4','030800',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(287,'140727','140700','祁县','qixian','4','030900',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(288,'140728','140700','平遥县','pingyaoxian','4','031100',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(289,'140729','140700','灵石县','lingshixian','4','031300',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(290,'140781','140700','介休市','jiexiushi','4','032000',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(291,'140800','140000','运城市','yunchengshi','3','044000',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(292,'140802','140800','盐湖区','yanhu','4','044000',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(293,'140821','140800','临猗县','linyixian','4','044100',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(294,'140822','140800','万荣县','wanrongxian','4','044200',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(295,'140823','140800','闻喜县','wenxixian','4','043800',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(296,'140824','140800','稷山县','jishanxian','4','043200',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(297,'140825','140800','新绛县','xinjiangxian','4','043100',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(298,'140826','140800','绛县','jiangxian','4','043600',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(299,'140827','140800','垣曲县','yuanquxian','4','043700',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(300,'140828','140800','夏县','xiaxian','4','044400',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(301,'140829','140800','平陆县','pingluxian','4','044300',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(302,'140830','140800','芮城县','ruichengxian','4','044600',NULL,NULL,'2017-02-14 17:04:49',NULL,NULL,NULL,0),(303,'140881','140800','永济市','yongjishi','4','044500',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(304,'140882','140800','河津市','hejinshi','4','043300',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(305,'140900','140000','忻州市','xinzhoushi','3','034000',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(306,'140902','140900','忻府区','xinfu','4','034000',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(307,'140921','140900','定襄县','dingxiangxian','4','035400',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(308,'140922','140900','五台县','wutaixian','4','035500',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(309,'140923','140900','代县','daixian','4','034200',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(310,'140924','140900','繁峙县','fanzhixian','4','034300',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(311,'140925','140900','宁武县','ningwuxian','4','036700',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(312,'140926','140900','静乐县','jinglexian','4','035100',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(313,'140927','140900','神池县','shenchixian','4','036100',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(314,'140928','140900','五寨县','wuzhaixian','4','036200',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(315,'140929','140900','岢岚县','kelanxian','4','036300',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(316,'140930','140900','河曲县','hequxian','4','036500',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(317,'140931','140900','保德县','baodexian','4','036600',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(318,'140932','140900','偏关县','pianguanxian','4','036400',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(319,'140981','140900','原平市','yuanpingshi','4','034100',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(320,'141000','140000','临汾市','linfenshi','3','041000',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(321,'141002','141000','尧都区','yaodou','4','041000',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(322,'141021','141000','曲沃县','quwoxian','4','043400',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(323,'141022','141000','翼城县','yichengxian','4','043500',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(324,'141023','141000','襄汾县','xiangfenxian','4','041500',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(325,'141024','141000','洪洞县','hongdongxian','4','041600',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(326,'141025','141000','古县','guxian','4','042400',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(327,'141026','141000','安泽县','anzexian','4','042500',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(328,'141027','141000','浮山县','fushanxian','4','042600',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(329,'141028','141000','吉县','jixian','4','042200',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(330,'141029','141000','乡宁县','xiangningxian','4','042100',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(331,'141030','141000','大宁县','daningxian','4','042300',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(332,'141031','141000','隰县','xixian','4','041300',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(333,'141032','141000','永和县','yonghexian','4','041400',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(334,'141033','141000','蒲县','puxian','4','041200',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(335,'141034','141000','汾西县','fenxixian','4','031500',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(336,'141081','141000','侯马市','houmashi','4','043000',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(337,'141082','141000','霍州市','huozhoushi','4','031400',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(338,'141100','140000','吕梁市','lvliangshi','3','033000',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(339,'141102','141100','离石区','lishi','4','033000',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(340,'141121','141100','文水县','wenshuixian','4','032100',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(341,'141122','141100','交城县','jiaochengxian','4','030500',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(342,'141123','141100','兴县','xingxian','4','033600',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(343,'141124','141100','临县','linxian','4','033200',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(344,'141125','141100','柳林县','liulinxian','4','033300',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(345,'141126','141100','石楼县','shilouxian','4','032500',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(346,'141127','141100','岚县','lanxian','4','033500',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(347,'141128','141100','方山县','fangshanxian','4','033100',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(348,'141129','141100','中阳县','zhongyangxian','4','033400',NULL,NULL,'2017-02-14 17:04:50',NULL,NULL,NULL,0),(349,'141130','141100','交口县','jiaokouxian','4','032400',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(350,'141181','141100','孝义市','xiaoyishi','4','032300',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(351,'141182','141100','汾阳市','fenyangshi','4','032200',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(352,'150000','100000','内蒙古自治区','neimengguzizhi','2','',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(353,'150100','150000','呼和浩特市','huhehaoteshi','3','010000',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(354,'150102','150100','新城区','xincheng','4','010050',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(355,'150103','150100','回民区','huimin','4','010030',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(356,'150104','150100','玉泉区','yuquan','4','010020',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(357,'150105','150100','赛罕区','saihan','4','010020',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(358,'150121','150100','土默特左旗','tumotezuoqi','4','010100',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(359,'150122','150100','托克托县','tuoketuoxian','4','010200',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(360,'150123','150100','和林格尔县','helingeerxian','4','011500',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(361,'150124','150100','清水河县','qingshuihexian','4','011600',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(362,'150125','150100','武川县','wuchuanxian','4','011700',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(363,'150200','150000','包头市','baotoushi','3','014025',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(364,'150202','150200','东河区','donghe','4','014040',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(365,'150203','150200','昆都仑区','kundoulun','4','014010',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(366,'150204','150200','青山区','qingshan','4','014030',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(367,'150205','150200','石拐区','shiguai','4','014070',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(368,'150206','150200','白云鄂博矿区','baiyunebokuang','4','014080',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(369,'150207','150200','九原区','jiuyuan','4','014060',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(370,'150221','150200','土默特右旗','tumoteyouqi','4','014100',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(371,'150222','150200','固阳县','guyangxian','4','014200',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(372,'150223','150200','达尔罕茂明安联合旗','daerhanmaominganlianheqi','4','014500',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(373,'150300','150000','乌海市','wuhaishi','3','016000',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(374,'150302','150300','海勃湾区','haibowan','4','016000',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(375,'150303','150300','海南区','hainan','4','016030',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(376,'150304','150300','乌达区','wuda','4','016040',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(377,'150400','150000','赤峰市','chifengshi','3','024000',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(378,'150402','150400','红山区','hongshan','4','024020',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(379,'150403','150400','元宝山区','yuanbaoshan','4','024076',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(380,'150404','150400','松山区','songshan','4','024005',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(381,'150421','150400','阿鲁科尔沁旗','alukeerqinqi','4','025550',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(382,'150422','150400','巴林左旗','balinzuoqi','4','025450',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(383,'150423','150400','巴林右旗','balinyouqi','4','025150',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(384,'150424','150400','林西县','linxixian','4','025250',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(385,'150425','150400','克什克腾旗','keshenketengqi','4','025350',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(386,'150426','150400','翁牛特旗','wengniuteqi','4','024500',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(387,'150428','150400','喀喇沁旗','kalaqinqi','4','024400',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(388,'150429','150400','宁城县','ningchengxian','4','024200',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(389,'150430','150400','敖汉旗','aohanqi','4','024300',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(390,'150500','150000','通辽市','tongliaoshi','3','028000',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(391,'150502','150500','科尔沁区','keerqin','4','028000',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(392,'150521','150500','科尔沁左翼中旗','keerqinzuoyizhongqi','4','029300',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(393,'150522','150500','科尔沁左翼后旗','keerqinzuoyihouqi','4','028100',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(394,'150523','150500','开鲁县','kailuxian','4','028400',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(395,'150524','150500','库伦旗','kulunqi','4','028200',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(396,'150525','150500','奈曼旗','naimanqi','4','028300',NULL,NULL,'2017-02-14 17:04:51',NULL,NULL,NULL,0),(397,'150526','150500','扎鲁特旗','zhaluteqi','4','029100',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(398,'150581','150500','霍林郭勒市','huolinguoleshi','4','029200',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(399,'150600','150000','鄂尔多斯市','eerduosishi','3','017004',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(400,'150602','150600','东胜区','dongsheng','4','017000',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(401,'150621','150600','达拉特旗','dalateqi','4','014300',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(402,'150622','150600','准格尔旗','zhungeerqi','4','017100',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(403,'150623','150600','鄂托克前旗','etuokeqianqi','4','016200',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(404,'150624','150600','鄂托克旗','etuokeqi','4','016100',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(405,'150625','150600','杭锦旗','hangjinqi','4','017400',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(406,'150626','150600','乌审旗','wushenqi','4','017300',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(407,'150627','150600','伊金霍洛旗','yijinhuoluoqi','4','017200',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(408,'150700','150000','呼伦贝尔市','hulunbeiershi','3','021008',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(409,'150702','150700','海拉尔区','hailaer','4','021000',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(410,'150703','150700','扎赉诺尔区','zhalainuoer','4','021410',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(411,'150721','150700','阿荣旗','arongqi','4','162750',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(412,'150722','150700','莫力达瓦达斡尔族自治旗','molidawadawoerzuzizhiqi','4','162850',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(413,'150723','150700','鄂伦春自治旗','elunchunzizhiqi','4','165450',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(414,'150724','150700','鄂温克族自治旗','ewenkezuzizhiqi','4','021100',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(415,'150725','150700','陈巴尔虎旗','chenbaerhuqi','4','021500',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(416,'150726','150700','新巴尔虎左旗','xinbaerhuzuoqi','4','021200',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(417,'150727','150700','新巴尔虎右旗','xinbaerhuyouqi','4','021300',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(418,'150781','150700','满洲里市','manzhoulishi','4','021400',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(419,'150782','150700','牙克石市','yakeshishi','4','022150',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(420,'150783','150700','扎兰屯市','zhalantunshi','4','162650',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(421,'150784','150700','额尔古纳市','eergunashi','4','022250',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(422,'150785','150700','根河市','genheshi','4','022350',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(423,'150800','150000','巴彦淖尔市','bayannaoershi','3','015001',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(424,'150802','150800','临河区','linhe','4','015001',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(425,'150821','150800','五原县','wuyuanxian','4','015100',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(426,'150822','150800','磴口县','dengkouxian','4','015200',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(427,'150823','150800','乌拉特前旗','wulateqianqi','4','014400',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(428,'150824','150800','乌拉特中旗','wulatezhongqi','4','015300',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(429,'150825','150800','乌拉特后旗','wulatehouqi','4','015500',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(430,'150826','150800','杭锦后旗','hangjinhouqi','4','015400',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(431,'150900','150000','乌兰察布市','wulanchabushi','3','012000',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(432,'150902','150900','集宁区','jining','4','012000',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(433,'150921','150900','卓资县','zhuozixian','4','012300',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(434,'150922','150900','化德县','huadexian','4','013350',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(435,'150923','150900','商都县','shangdouxian','4','013450',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(436,'150924','150900','兴和县','xinghexian','4','013650',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(437,'150925','150900','凉城县','liangchengxian','4','013750',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(438,'150926','150900','察哈尔右翼前旗','chahaeryouyiqianqi','4','012200',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(439,'150927','150900','察哈尔右翼中旗','chahaeryouyizhongqi','4','013550',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(440,'150928','150900','察哈尔右翼后旗','chahaeryouyihouqi','4','012400',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(441,'150929','150900','四子王旗','siziwangqi','4','011800',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(442,'150981','150900','丰镇市','fengzhenshi','4','012100',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(443,'152200','150000','兴安盟','xinganmeng','3','137401',NULL,NULL,'2017-02-14 17:04:52',NULL,NULL,NULL,0),(444,'152201','152200','乌兰浩特市','wulanhaoteshi','4','137401',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(445,'152202','152200','阿尔山市','aershanshi','4','137800',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(446,'152221','152200','科尔沁右翼前旗','keerqinyouyiqianqi','4','137423',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(447,'152222','152200','科尔沁右翼中旗','keerqinyouyizhongqi','4','029400',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(448,'152223','152200','扎赉特旗','zhalaiteqi','4','137600',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(449,'152224','152200','突泉县','tuquanxian','4','137500',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(450,'152500','150000','锡林郭勒盟','xilinguolemeng','3','026000',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(451,'152501','152500','二连浩特市','erlianhaoteshi','4','011100',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(452,'152502','152500','锡林浩特市','xilinhaoteshi','4','026021',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(453,'152522','152500','阿巴嘎旗','abagaqi','4','011400',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(454,'152523','152500','苏尼特左旗','sunitezuoqi','4','011300',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(455,'152524','152500','苏尼特右旗','suniteyouqi','4','011200',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(456,'152525','152500','东乌珠穆沁旗','dongwuzhumuqinqi','4','026300',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(457,'152526','152500','西乌珠穆沁旗','xiwuzhumuqinqi','4','026200',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(458,'152527','152500','太仆寺旗','taipusiqi','4','027000',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(459,'152528','152500','镶黄旗','xianghuangqi','4','013250',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(460,'152529','152500','正镶白旗','zhengxiangbaiqi','4','013800',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(461,'152530','152500','正蓝旗','zhenglanqi','4','027200',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(462,'152531','152500','多伦县','duolunxian','4','027300',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(463,'152900','150000','阿拉善盟','alashanmeng','3','750306',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(464,'152921','152900','阿拉善左旗','alashanzuoqi','4','750306',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(465,'152922','152900','阿拉善右旗','alashanyouqi','4','737300',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(466,'152923','152900','额济纳旗','ejinaqi','4','735400',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(467,'210000','100000','辽宁省','liaoningsheng','2','',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(468,'210100','210000','沈阳市','shenyangshi','3','110013',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(469,'210102','210100','和平区','heping','4','110001',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(470,'210103','210100','沈河区','shenhe','4','110011',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(471,'210104','210100','大东区','dadong','4','110041',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(472,'210105','210100','皇姑区','huanggu','4','110031',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(473,'210106','210100','铁西区','tiexi','4','110021',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(474,'210111','210100','苏家屯区','sujiatun','4','110101',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(475,'210112','210100','浑南区','hunnan','4','110015',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(476,'210113','210100','沈北新区','shenbeixin','4','110121',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(477,'210114','210100','于洪区','yuhong','4','110141',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(478,'210122','210100','辽中县','liaozhongxian','4','110200',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(479,'210123','210100','康平县','kangpingxian','4','110500',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(480,'210124','210100','法库县','fakuxian','4','110400',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(481,'210181','210100','新民市','xinminshi','4','110300',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(482,'210200','210000','大连市','dalianshi','3','116011',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(483,'210202','210200','中山区','zhongshan','4','116001',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(484,'210203','210200','西岗区','xigang','4','116011',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(485,'210204','210200','沙河口区','shahekou','4','116021',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(486,'210211','210200','甘井子区','ganjingzi','4','116033',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(487,'210212','210200','旅顺口区','lvshunkou','4','116041',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(488,'210213','210200','金州区','jinzhou','4','116100',NULL,NULL,'2017-02-14 17:04:53',NULL,NULL,NULL,0),(489,'210224','210200','长海县','zhanghaixian','4','116500',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(490,'210281','210200','瓦房店市','wafangdianshi','4','116300',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(491,'210282','210200','普兰店市','pulandianshi','4','116200',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(492,'210283','210200','庄河市','zhuangheshi','4','116400',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(493,'210300','210000','鞍山市','anshanshi','3','114001',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(494,'210302','210300','铁东区','tiedong','4','114001',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(495,'210303','210300','铁西区','tiexi','4','114013',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(496,'210304','210300','立山区','lishan','4','114031',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(497,'210311','210300','千山区','qianshan','4','114041',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(498,'210321','210300','台安县','taianxian','4','114100',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(499,'210323','210300','岫岩满族自治县','xiuyanmanzuzizhixian','4','114300',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(500,'210381','210300','海城市','haichengshi','4','114200',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(501,'210400','210000','抚顺市','fushunshi','3','113008',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(502,'210402','210400','新抚区','xinfu','4','113008',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(503,'210403','210400','东洲区','dongzhou','4','113003',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(504,'210404','210400','望花区','wanghua','4','113001',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(505,'210411','210400','顺城区','shuncheng','4','113006',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(506,'210421','210400','抚顺县','fushunxian','4','113006',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(507,'210422','210400','新宾满族自治县','xinbinmanzuzizhixian','4','113200',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(508,'210423','210400','清原满族自治县','qingyuanmanzuzizhixian','4','113300',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(509,'210500','210000','本溪市','benxishi','3','117000',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(510,'210502','210500','平山区','pingshan','4','117000',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(511,'210503','210500','溪湖区','xihu','4','117002',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(512,'210504','210500','明山区','mingshan','4','117021',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(513,'210505','210500','南芬区','nanfen','4','117014',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(514,'210521','210500','本溪满族自治县','benximanzuzizhixian','4','117100',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(515,'210522','210500','桓仁满族自治县','huanrenmanzuzizhixian','4','117200',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(516,'210600','210000','丹东市','dandongshi','3','118000',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(517,'210602','210600','元宝区','yuanbao','4','118000',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(518,'210603','210600','振兴区','zhenxing','4','118002',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(519,'210604','210600','振安区','zhenan','4','118001',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(520,'210624','210600','宽甸满族自治县','kuandianmanzuzizhixian','4','118200',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(521,'210681','210600','东港市','donggangshi','4','118300',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(522,'210682','210600','凤城市','fengchengshi','4','118100',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(523,'210700','210000','锦州市','jinzhoushi','3','121000',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(524,'210702','210700','古塔区','guta','4','121001',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(525,'210703','210700','凌河区','linghe','4','121000',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(526,'210711','210700','太和区','taihe','4','121011',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(527,'210726','210700','黑山县','heishanxian','4','121400',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(528,'210727','210700','义县','yixian','4','121100',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(529,'210781','210700','凌海市','linghaishi','4','121200',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(530,'210782','210700','北镇市','beizhenshi','4','121300',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(531,'210800','210000','营口市','yingkoushi','3','115003',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(532,'210802','210800','站前区','zhanqian','4','115002',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(533,'210803','210800','西市区','xishi','4','115004',NULL,NULL,'2017-02-14 17:04:54',NULL,NULL,NULL,0),(534,'210804','210800','鲅鱼圈区','bayuquan','4','115007',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(535,'210811','210800','老边区','laobian','4','115005',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(536,'210881','210800','盖州市','gaizhoushi','4','115200',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(537,'210882','210800','大石桥市','dashiqiaoshi','4','115100',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(538,'210900','210000','阜新市','fuxinshi','3','123000',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(539,'210902','210900','海州区','haizhou','4','123000',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(540,'210903','210900','新邱区','xinqiu','4','123005',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(541,'210904','210900','太平区','taiping','4','123003',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(542,'210905','210900','清河门区','qinghemen','4','123006',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(543,'210911','210900','细河区','xihe','4','123000',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(544,'210921','210900','阜新蒙古族自治县','fuxinmengguzuzizhixian','4','123100',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(545,'210922','210900','彰武县','zhangwuxian','4','123200',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(546,'211000','210000','辽阳市','liaoyangshi','3','111000',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(547,'211002','211000','白塔区','baita','4','111000',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(548,'211003','211000','文圣区','wensheng','4','111000',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(549,'211004','211000','宏伟区','hongwei','4','111003',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(550,'211005','211000','弓长岭区','gongzhangling','4','111008',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(551,'211011','211000','太子河区','taizihe','4','111000',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(552,'211021','211000','辽阳县','liaoyangxian','4','111200',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(553,'211081','211000','灯塔市','dengtashi','4','111300',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(554,'211100','210000','盘锦市','panjinshi','3','124010',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(555,'211102','211100','双台子区','shuangtaizi','4','124000',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(556,'211103','211100','兴隆台区','xinglongtai','4','124010',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(557,'211121','211100','大洼县','dawaxian','4','124200',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(558,'211122','211100','盘山县','panshanxian','4','124000',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(559,'211200','210000','铁岭市','tielingshi','3','112000',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(560,'211202','211200','银州区','yinzhou','4','112000',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(561,'211204','211200','清河区','qinghe','4','112003',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(562,'211221','211200','铁岭县','tielingxian','4','112000',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(563,'211223','211200','西丰县','xifengxian','4','112400',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(564,'211224','211200','昌图县','changtuxian','4','112500',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(565,'211281','211200','调兵山市','diaobingshanshi','4','112700',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(566,'211282','211200','开原市','kaiyuanshi','4','112300',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(567,'211300','210000','朝阳市','chaoyangshi','3','122000',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(568,'211302','211300','双塔区','shuangta','4','122000',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(569,'211303','211300','龙城区','longcheng','4','122000',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(570,'211321','211300','朝阳县','chaoyangxian','4','122000',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(571,'211322','211300','建平县','jianpingxian','4','122400',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(572,'211324','211300','喀喇沁左翼蒙古族自治县','kalaqinzuoyimengguzuzizhixian','4','122300',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(573,'211381','211300','北票市','beipiaoshi','4','122100',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(574,'211382','211300','凌源市','lingyuanshi','4','122500',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(575,'211400','210000','葫芦岛市','huludaoshi','3','125000',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(576,'211402','211400','连山区','lianshan','4','125001',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(577,'211403','211400','龙港区','longgang','4','125003',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(578,'211404','211400','南票区','nanpiao','4','125027',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(579,'211421','211400','绥中县','suizhongxian','4','125200',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(580,'211422','211400','建昌县','jianchangxian','4','125300',NULL,NULL,'2017-02-14 17:04:55',NULL,NULL,NULL,0),(581,'211481','211400','兴城市','xingchengshi','4','125100',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(582,'211500','210000','金普新区','jinpuxin','3','116100',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(583,'211501','211500','金州新区','jinzhouxin','4','116100',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(584,'211502','211500','普湾新区','puwanxin','4','116200',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(585,'211503','211500','保税区','baoshui','4','116100',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(586,'220000','100000','吉林省','jilinsheng','2','',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(587,'220100','220000','长春市','zhangchunshi','3','130022',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(588,'220102','220100','南关区','nanguan','4','130022',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(589,'220103','220100','宽城区','kuancheng','4','130051',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(590,'220104','220100','朝阳区','chaoyang','4','130012',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(591,'220105','220100','二道区','erdao','4','130031',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(592,'220106','220100','绿园区','lvyuan','4','130062',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(593,'220112','220100','双阳区','shuangyang','4','130600',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(594,'220113','220100','九台区','jiutai','4','130500',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(595,'220122','220100','农安县','nonganxian','4','130200',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(596,'220182','220100','榆树市','yushushi','4','130400',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(597,'220183','220100','德惠市','dehuishi','4','130300',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(598,'220200','220000','吉林市','jilinshi','3','132011',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(599,'220202','220200','昌邑区','changyi','4','132002',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(600,'220203','220200','龙潭区','longtan','4','132021',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(601,'220204','220200','船营区','chuanying','4','132011',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(602,'220211','220200','丰满区','fengman','4','132013',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(603,'220221','220200','永吉县','yongjixian','4','132200',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(604,'220281','220200','蛟河市','jiaoheshi','4','132500',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(605,'220282','220200','桦甸市','huadianshi','4','132400',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(606,'220283','220200','舒兰市','shulanshi','4','132600',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(607,'220284','220200','磐石市','panshishi','4','132300',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(608,'220300','220000','四平市','sipingshi','3','136000',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(609,'220302','220300','铁西区','tiexi','4','136000',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(610,'220303','220300','铁东区','tiedong','4','136001',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(611,'220322','220300','梨树县','lishuxian','4','136500',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(612,'220323','220300','伊通满族自治县','yitongmanzuzizhixian','4','130700',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(613,'220381','220300','公主岭市','gongzhulingshi','4','136100',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(614,'220382','220300','双辽市','shuangliaoshi','4','136400',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(615,'220400','220000','辽源市','liaoyuanshi','3','136200',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(616,'220402','220400','龙山区','longshan','4','136200',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(617,'220403','220400','西安区','xian','4','136201',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(618,'220421','220400','东丰县','dongfengxian','4','136300',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(619,'220422','220400','东辽县','dongliaoxian','4','136600',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(620,'220500','220000','通化市','tonghuashi','3','134001',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(621,'220502','220500','东昌区','dongchang','4','134001',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(622,'220503','220500','二道江区','erdaojiang','4','134003',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(623,'220521','220500','通化县','tonghuaxian','4','134100',NULL,NULL,'2017-02-14 17:04:56',NULL,NULL,NULL,0),(624,'220523','220500','辉南县','huinanxian','4','135100',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(625,'220524','220500','柳河县','liuhexian','4','135300',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(626,'220581','220500','梅河口市','meihekoushi','4','135000',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(627,'220582','220500','集安市','jianshi','4','134200',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(628,'220600','220000','白山市','baishanshi','3','134300',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(629,'220602','220600','浑江区','hunjiang','4','134300',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(630,'220605','220600','江源区','jiangyuan','4','134700',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(631,'220621','220600','抚松县','fusongxian','4','134500',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(632,'220622','220600','靖宇县','jingyuxian','4','135200',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(633,'220623','220600','长白朝鲜族自治县','zhangbaichaoxianzuzizhixian','4','134400',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(634,'220681','220600','临江市','linjiangshi','4','134600',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(635,'220700','220000','松原市','songyuanshi','3','138000',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(636,'220702','220700','宁江区','ningjiang','4','138000',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(637,'220721','220700','前郭尔罗斯蒙古族自治县','qianguoerluosimengguzuzizhixian','4','138000',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(638,'220722','220700','长岭县','zhanglingxian','4','131500',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(639,'220723','220700','乾安县','qiananxian','4','131400',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(640,'220781','220700','扶余市','fuyushi','4','131200',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(641,'220800','220000','白城市','baichengshi','3','137000',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(642,'220802','220800','洮北区','taobei','4','137000',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(643,'220821','220800','镇赉县','zhenlaixian','4','137300',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(644,'220822','220800','通榆县','tongyuxian','4','137200',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(645,'220881','220800','洮南市','taonanshi','4','137100',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(646,'220882','220800','大安市','daanshi','4','131300',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(647,'222400','220000','延边朝鲜族自治州','yanbianchaoxianzuzizhizhou','3','133000',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(648,'222401','222400','延吉市','yanjishi','4','133000',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(649,'222402','222400','图们市','tumenshi','4','133100',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(650,'222403','222400','敦化市','dunhuashi','4','133700',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(651,'222404','222400','珲春市','hunchunshi','4','133300',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(652,'222405','222400','龙井市','longjingshi','4','133400',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(653,'222406','222400','和龙市','helongshi','4','133500',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(654,'222424','222400','汪清县','wangqingxian','4','133200',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(655,'222426','222400','安图县','antuxian','4','133600',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(656,'230000','100000','黑龙江省','heilongjiangsheng','2','',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(657,'230100','230000','哈尔滨市','haerbinshi','3','150010',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(658,'230102','230100','道里区','daoli','4','150010',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(659,'230103','230100','南岗区','nangang','4','150006',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(660,'230104','230100','道外区','daowai','4','150020',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(661,'230108','230100','平房区','pingfang','4','150060',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(662,'230109','230100','松北区','songbei','4','150028',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(663,'230110','230100','香坊区','xiangfang','4','150036',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(664,'230111','230100','呼兰区','hulan','4','150500',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(665,'230112','230100','阿城区','acheng','4','150300',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(666,'230113','230100','双城区','shuangcheng','4','150100',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(667,'230123','230100','依兰县','yilanxian','4','154800',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(668,'230124','230100','方正县','fangzhengxian','4','150800',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(669,'230125','230100','宾县','binxian','4','150400',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(670,'230126','230100','巴彦县','bayanxian','4','151800',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(671,'230127','230100','木兰县','mulanxian','4','151900',NULL,NULL,'2017-02-14 17:04:57',NULL,NULL,NULL,0),(672,'230128','230100','通河县','tonghexian','4','150900',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(673,'230129','230100','延寿县','yanshouxian','4','150700',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(674,'230183','230100','尚志市','shangzhishi','4','150600',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(675,'230184','230100','五常市','wuchangshi','4','150200',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(676,'230200','230000','齐齐哈尔市','qiqihaershi','3','161005',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(677,'230202','230200','龙沙区','longsha','4','161000',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(678,'230203','230200','建华区','jianhua','4','161006',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(679,'230204','230200','铁锋区','tiefeng','4','161000',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(680,'230205','230200','昂昂溪区','angangxi','4','161031',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(681,'230206','230200','富拉尔基区','fulaerji','4','161041',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(682,'230207','230200','碾子山区','nianzishan','4','161046',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(683,'230208','230200','梅里斯达斡尔族区','meilisidawoerzu','4','161021',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(684,'230221','230200','龙江县','longjiangxian','4','161100',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(685,'230223','230200','依安县','yianxian','4','161500',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(686,'230224','230200','泰来县','tailaixian','4','162400',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(687,'230225','230200','甘南县','gannanxian','4','162100',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(688,'230227','230200','富裕县','fuyuxian','4','161200',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(689,'230229','230200','克山县','keshanxian','4','161600',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(690,'230230','230200','克东县','kedongxian','4','164800',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(691,'230231','230200','拜泉县','baiquanxian','4','164700',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(692,'230281','230200','讷河市','neheshi','4','161300',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(693,'230300','230000','鸡西市','jixishi','3','158100',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(694,'230302','230300','鸡冠区','jiguan','4','158100',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(695,'230303','230300','恒山区','hengshan','4','158130',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(696,'230304','230300','滴道区','didao','4','158150',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(697,'230305','230300','梨树区','lishu','4','158160',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(698,'230306','230300','城子河区','chengzihe','4','158170',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(699,'230307','230300','麻山区','mashan','4','158180',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(700,'230321','230300','鸡东县','jidongxian','4','158200',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(701,'230381','230300','虎林市','hulinshi','4','158400',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(702,'230382','230300','密山市','mishanshi','4','158300',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(703,'230400','230000','鹤岗市','hegangshi','3','154100',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(704,'230402','230400','向阳区','xiangyang','4','154100',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(705,'230403','230400','工农区','gongnong','4','154101',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(706,'230404','230400','南山区','nanshan','4','154104',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(707,'230405','230400','兴安区','xingan','4','154102',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(708,'230406','230400','东山区','dongshan','4','154106',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(709,'230407','230400','兴山区','xingshan','4','154105',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(710,'230421','230400','萝北县','luobeixian','4','154200',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(711,'230422','230400','绥滨县','suibinxian','4','156200',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(712,'230500','230000','双鸭山市','shuangyashanshi','3','155100',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(713,'230502','230500','尖山区','jianshan','4','155100',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(714,'230503','230500','岭东区','lingdong','4','155120',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(715,'230505','230500','四方台区','sifangtai','4','155130',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(716,'230506','230500','宝山区','baoshan','4','155131',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(717,'230521','230500','集贤县','jixianxian','4','155900',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(718,'230522','230500','友谊县','youyixian','4','155800',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(719,'230523','230500','宝清县','baoqingxian','4','155600',NULL,NULL,'2017-02-14 17:04:58',NULL,NULL,NULL,0),(720,'230524','230500','饶河县','raohexian','4','155700',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(721,'230600','230000','大庆市','daqingshi','3','163000',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(722,'230602','230600','萨尔图区','saertu','4','163001',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(723,'230603','230600','龙凤区','longfeng','4','163711',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(724,'230604','230600','让胡路区','ranghulu','4','163712',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(725,'230605','230600','红岗区','honggang','4','163511',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(726,'230606','230600','大同区','datong','4','163515',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(727,'230621','230600','肇州县','zhaozhouxian','4','166400',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(728,'230622','230600','肇源县','zhaoyuanxian','4','166500',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(729,'230623','230600','林甸县','lindianxian','4','166300',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(730,'230624','230600','杜尔伯特蒙古族自治县','duerbotemengguzuzizhixian','4','166200',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(731,'230700','230000','伊春市','yichunshi','3','153000',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(732,'230702','230700','伊春区','yichun','4','153000',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(733,'230703','230700','南岔区','nancha','4','153100',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(734,'230704','230700','友好区','youhao','4','153031',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(735,'230705','230700','西林区','xilin','4','153025',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(736,'230706','230700','翠峦区','cuiluan','4','153013',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(737,'230707','230700','新青区','xinqing','4','153036',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(738,'230708','230700','美溪区','meixi','4','153021',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(739,'230709','230700','金山屯区','jinshantun','4','153026',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(740,'230710','230700','五营区','wuying','4','153033',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(741,'230711','230700','乌马河区','wumahe','4','153011',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(742,'230712','230700','汤旺河区','tangwanghe','4','153037',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(743,'230713','230700','带岭区','dailing','4','153106',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(744,'230714','230700','乌伊岭区','wuyiling','4','153038',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(745,'230715','230700','红星区','hongxing','4','153035',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(746,'230716','230700','上甘岭区','shangganling','4','153032',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(747,'230722','230700','嘉荫县','jiayinxian','4','153200',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(748,'230781','230700','铁力市','tielishi','4','152500',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(749,'230800','230000','佳木斯市','jiamusishi','3','154002',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(750,'230803','230800','向阳区','xiangyang','4','154002',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(751,'230804','230800','前进区','qianjin','4','154002',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(752,'230805','230800','东风区','dongfeng','4','154005',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(753,'230811','230800','郊区','jiao','4','154004',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(754,'230822','230800','桦南县','huananxian','4','154400',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(755,'230826','230800','桦川县','huachuanxian','4','154300',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(756,'230828','230800','汤原县','tangyuanxian','4','154700',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(757,'230833','230800','抚远县','fuyuanxian','4','156500',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(758,'230881','230800','同江市','tongjiangshi','4','156400',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(759,'230882','230800','富锦市','fujinshi','4','156100',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(760,'230900','230000','七台河市','qitaiheshi','3','154600',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(761,'230902','230900','新兴区','xinxing','4','154604',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(762,'230903','230900','桃山区','taoshan','4','154600',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(763,'230904','230900','茄子河区','qiezihe','4','154622',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(764,'230921','230900','勃利县','bolixian','4','154500',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(765,'231000','230000','牡丹江市','mudanjiangshi','3','157000',NULL,NULL,'2017-02-14 17:04:59',NULL,NULL,NULL,0),(766,'231002','231000','东安区','dongan','4','157000',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(767,'231003','231000','阳明区','yangming','4','157013',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(768,'231004','231000','爱民区','aimin','4','157009',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(769,'231005','231000','西安区','xian','4','157000',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(770,'231024','231000','东宁县','dongningxian','4','157200',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(771,'231025','231000','林口县','linkouxian','4','157600',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(772,'231081','231000','绥芬河市','suifenheshi','4','157300',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(773,'231083','231000','海林市','hailinshi','4','157100',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(774,'231084','231000','宁安市','ninganshi','4','157400',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(775,'231085','231000','穆棱市','mulengshi','4','157500',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(776,'231100','230000','黑河市','heiheshi','3','164300',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(777,'231102','231100','爱辉区','aihui','4','164300',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(778,'231121','231100','嫩江县','nenjiangxian','4','161400',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(779,'231123','231100','逊克县','xunkexian','4','164400',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(780,'231124','231100','孙吴县','sunwuxian','4','164200',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(781,'231181','231100','北安市','beianshi','4','164000',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(782,'231182','231100','五大连池市','wudalianchishi','4','164100',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(783,'231200','230000','绥化市','suihuashi','3','152000',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(784,'231202','231200','北林区','beilin','4','152000',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(785,'231221','231200','望奎县','wangkuixian','4','152100',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(786,'231222','231200','兰西县','lanxixian','4','151500',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(787,'231223','231200','青冈县','qinggangxian','4','151600',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(788,'231224','231200','庆安县','qinganxian','4','152400',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(789,'231225','231200','明水县','mingshuixian','4','151700',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(790,'231226','231200','绥棱县','suilengxian','4','152200',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(791,'231281','231200','安达市','andashi','4','151400',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(792,'231282','231200','肇东市','zhaodongshi','4','151100',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(793,'231283','231200','海伦市','hailunshi','4','152300',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(794,'232700','230000','大兴安岭地区','daxinganlingdi','3','165000',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(795,'232701','232700','加格达奇区','jiagedaqi','4','165000',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(796,'232702','232700','新林区','xinlin','4','165000',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(797,'232703','232700','松岭区','songling','4','165000',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(798,'232704','232700','呼中区','huzhong','4','165000',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(799,'232721','232700','呼玛县','humaxian','4','165100',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(800,'232722','232700','塔河县','tahexian','4','165200',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(801,'232723','232700','漠河县','mohexian','4','165300',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(802,'310000','100000','上海','shanghai','2','',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(803,'310100','310000','上海市','shanghaishi','3','200000',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(804,'310101','310100','黄浦区','huangpu','4','200001',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(805,'310104','310100','徐汇区','xuhui','4','200030',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(806,'310105','310100','长宁区','zhangning','4','200050',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(807,'310106','310100','静安区','jingan','4','200040',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(808,'310107','310100','普陀区','putuo','4','200333',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(809,'310108','310100','闸北区','zhabei','4','200070',NULL,NULL,'2017-02-14 17:05:00',NULL,NULL,NULL,0),(810,'310109','310100','虹口区','hongkou','4','200086',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(811,'310110','310100','杨浦区','yangpu','4','200082',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(812,'310112','310100','闵行区','minxing','4','201100',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(813,'310113','310100','宝山区','baoshan','4','201900',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(814,'310114','310100','嘉定区','jiading','4','201800',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(815,'310115','310100','浦东新区','pudongxin','4','200135',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(816,'310116','310100','金山区','jinshan','4','200540',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(817,'310117','310100','松江区','songjiang','4','201600',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(818,'310118','310100','青浦区','qingpu','4','201700',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(819,'310120','310100','奉贤区','fengxian','4','201400',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(820,'310230','310100','崇明县','chongmingxian','4','202150',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(821,'320000','100000','江苏省','jiangsusheng','2','',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(822,'320100','320000','南京市','nanjingshi','3','210008',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(823,'320102','320100','玄武区','xuanwu','4','210018',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(824,'320104','320100','秦淮区','qinhuai','4','210001',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(825,'320105','320100','建邺区','jianye','4','210004',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(826,'320106','320100','鼓楼区','gulou','4','210009',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(827,'320111','320100','浦口区','pukou','4','211800',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(828,'320113','320100','栖霞区','qixia','4','210046',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(829,'320114','320100','雨花台区','yuhuatai','4','210012',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(830,'320115','320100','江宁区','jiangning','4','211100',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(831,'320116','320100','六合区','liuhe','4','211500',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(832,'320117','320100','溧水区','lishui','4','211200',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(833,'320118','320100','高淳区','gaochun','4','211300',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(834,'320200','320000','无锡市','wuxishi','3','214000',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(835,'320202','320200','崇安区','chongan','4','214001',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(836,'320203','320200','南长区','nanzhang','4','214021',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(837,'320204','320200','北塘区','beitang','4','214044',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(838,'320205','320200','锡山区','xishan','4','214101',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(839,'320206','320200','惠山区','huishan','4','214174',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(840,'320211','320200','滨湖区','binhu','4','214123',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(841,'320281','320200','江阴市','jiangyinshi','4','214431',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(842,'320282','320200','宜兴市','yixingshi','4','214200',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(843,'320300','320000','徐州市','xuzhoushi','3','221003',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(844,'320302','320300','鼓楼区','gulou','4','221005',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(845,'320303','320300','云龙区','yunlong','4','221007',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(846,'320305','320300','贾汪区','jiawang','4','221003',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(847,'320311','320300','泉山区','quanshan','4','221006',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(848,'320312','320300','铜山区','tongshan','4','221106',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(849,'320321','320300','丰县','fengxian','4','221700',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(850,'320322','320300','沛县','peixian','4','221600',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(851,'320324','320300','睢宁县','suiningxian','4','221200',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(852,'320381','320300','新沂市','xinyishi','4','221400',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(853,'320382','320300','邳州市','pizhoushi','4','221300',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(854,'320400','320000','常州市','changzhoushi','3','213000',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(855,'320402','320400','天宁区','tianning','4','213000',NULL,NULL,'2017-02-14 17:05:01',NULL,NULL,NULL,0),(856,'320404','320400','钟楼区','zhonglou','4','213023',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(857,'320405','320400','戚墅堰区','qishuyan','4','213025',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(858,'320411','320400','新北区','xinbei','4','213022',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(859,'320412','320400','武进区','wujin','4','213100',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(860,'320481','320400','溧阳市','liyangshi','4','213300',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(861,'320482','320400','金坛市','jintanshi','4','213200',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(862,'320500','320000','苏州市','suzhoushi','3','215002',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(863,'320505','320500','虎丘区','huqiu','4','215004',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(864,'320506','320500','吴中区','wuzhong','4','215128',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(865,'320507','320500','相城区','xiangcheng','4','215131',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(866,'320508','320500','姑苏区','gusu','4','215031',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(867,'320509','320500','吴江区','wujiang','4','215200',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(868,'320581','320500','常熟市','changshushi','4','215500',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(869,'320582','320500','张家港市','zhangjiagangshi','4','215600',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(870,'320583','320500','昆山市','kunshanshi','4','215300',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(871,'320585','320500','太仓市','taicangshi','4','215400',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(872,'320600','320000','南通市','nantongshi','3','226001',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(873,'320602','320600','崇川区','chongchuan','4','226001',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(874,'320611','320600','港闸区','gangzha','4','226001',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(875,'320612','320600','通州区','tongzhou','4','226300',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(876,'320621','320600','海安县','haianxian','4','226600',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(877,'320623','320600','如东县','rudongxian','4','226400',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(878,'320681','320600','启东市','qidongshi','4','226200',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(879,'320682','320600','如皋市','rugaoshi','4','226500',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(880,'320684','320600','海门市','haimenshi','4','226100',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(881,'320700','320000','连云港市','lianyungangshi','3','222002',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(882,'320703','320700','连云区','lianyun','4','222042',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(883,'320706','320700','海州区','haizhou','4','222003',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(884,'320707','320700','赣榆区','ganyu','4','222100',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(885,'320722','320700','东海县','donghaixian','4','222300',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(886,'320723','320700','灌云县','guanyunxian','4','222200',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(887,'320724','320700','灌南县','guannanxian','4','222500',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(888,'320800','320000','淮安市','huaianshi','3','223001',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(889,'320802','320800','清河区','qinghe','4','223001',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(890,'320803','320800','淮安区','huaian','4','223200',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(891,'320804','320800','淮阴区','huaiyin','4','223300',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(892,'320811','320800','清浦区','qingpu','4','223002',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(893,'320826','320800','涟水县','lianshuixian','4','223400',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(894,'320829','320800','洪泽县','hongzexian','4','223100',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(895,'320830','320800','盱眙县','xuyixian','4','211700',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(896,'320831','320800','金湖县','jinhuxian','4','211600',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(897,'320900','320000','盐城市','yanchengshi','3','224005',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(898,'320902','320900','亭湖区','tinghu','4','224005',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(899,'320903','320900','盐都区','yandou','4','224055',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(900,'320921','320900','响水县','xiangshuixian','4','224600',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(901,'320922','320900','滨海县','binhaixian','4','224500',NULL,NULL,'2017-02-14 17:05:02',NULL,NULL,NULL,0),(902,'320923','320900','阜宁县','funingxian','4','224400',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(903,'320924','320900','射阳县','sheyangxian','4','224300',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(904,'320925','320900','建湖县','jianhuxian','4','224700',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(905,'320981','320900','东台市','dongtaishi','4','224200',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(906,'320982','320900','大丰市','dafengshi','4','224100',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(907,'321000','320000','扬州市','yangzhoushi','3','225002',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(908,'321002','321000','广陵区','guangling','4','225002',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(909,'321003','321000','邗江区','hanjiang','4','225002',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(910,'321012','321000','江都区','jiangdou','4','225200',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(911,'321023','321000','宝应县','baoyingxian','4','225800',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(912,'321081','321000','仪征市','yizhengshi','4','211400',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(913,'321084','321000','高邮市','gaoyoushi','4','225600',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(914,'321100','320000','镇江市','zhenjiangshi','3','212004',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(915,'321102','321100','京口区','jingkou','4','212003',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(916,'321111','321100','润州区','runzhou','4','212005',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(917,'321112','321100','丹徒区','dantu','4','212028',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(918,'321181','321100','丹阳市','danyangshi','4','212300',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(919,'321182','321100','扬中市','yangzhongshi','4','212200',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(920,'321183','321100','句容市','jurongshi','4','212400',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(921,'321200','320000','泰州市','taizhoushi','3','225300',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(922,'321202','321200','海陵区','hailing','4','225300',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(923,'321203','321200','高港区','gaogang','4','225321',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(924,'321204','321200','姜堰区','jiangyan','4','225500',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(925,'321281','321200','兴化市','xinghuashi','4','225700',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(926,'321282','321200','靖江市','jingjiangshi','4','214500',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(927,'321283','321200','泰兴市','taixingshi','4','225400',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(928,'321300','320000','宿迁市','suqianshi','3','223800',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(929,'321302','321300','宿城区','sucheng','4','223800',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(930,'321311','321300','宿豫区','suyu','4','223800',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(931,'321322','321300','沭阳县','shuyangxian','4','223600',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(932,'321323','321300','泗阳县','siyangxian','4','223700',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(933,'321324','321300','泗洪县','sihongxian','4','223900',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(934,'330000','100000','浙江省','zhejiangsheng','2','',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(935,'330100','330000','杭州市','hangzhoushi','3','310026',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(936,'330102','330100','上城区','shangcheng','4','310002',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(937,'330103','330100','下城区','xiacheng','4','310006',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(938,'330104','330100','江干区','jianggan','4','310016',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(939,'330105','330100','拱墅区','gongshu','4','310011',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(940,'330106','330100','西湖区','xihu','4','310013',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(941,'330108','330100','滨江区','binjiang','4','310051',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(942,'330109','330100','萧山区','xiaoshan','4','311200',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(943,'330110','330100','余杭区','yuhang','4','311100',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(944,'330122','330100','桐庐县','tongluxian','4','311500',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(945,'330127','330100','淳安县','chunanxian','4','311700',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(946,'330182','330100','建德市','jiandeshi','4','311600',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(947,'330183','330100','富阳区','fuyang','4','311400',NULL,NULL,'2017-02-14 17:05:03',NULL,NULL,NULL,0),(948,'330185','330100','临安市','linanshi','4','311300',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(949,'330200','330000','宁波市','ningboshi','3','315000',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(950,'330203','330200','海曙区','haishu','4','315000',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(951,'330204','330200','江东区','jiangdong','4','315040',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(952,'330205','330200','江北区','jiangbei','4','315020',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(953,'330206','330200','北仑区','beilun','4','315800',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(954,'330211','330200','镇海区','zhenhai','4','315200',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(955,'330212','330200','鄞州区','yinzhou','4','315100',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(956,'330225','330200','象山县','xiangshanxian','4','315700',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(957,'330226','330200','宁海县','ninghaixian','4','315600',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(958,'330281','330200','余姚市','yuyaoshi','4','315400',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(959,'330282','330200','慈溪市','cixishi','4','315300',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(960,'330283','330200','奉化市','fenghuashi','4','315500',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(961,'330300','330000','温州市','wenzhoushi','3','325000',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(962,'330302','330300','鹿城区','lucheng','4','325000',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(963,'330303','330300','龙湾区','longwan','4','325013',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(964,'330304','330300','瓯海区','ouhai','4','325005',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(965,'330322','330300','洞头县','dongtouxian','4','325700',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(966,'330324','330300','永嘉县','yongjiaxian','4','325100',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(967,'330326','330300','平阳县','pingyangxian','4','325400',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(968,'330327','330300','苍南县','cangnanxian','4','325800',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(969,'330328','330300','文成县','wenchengxian','4','325300',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(970,'330329','330300','泰顺县','taishunxian','4','325500',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(971,'330381','330300','瑞安市','ruianshi','4','325200',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(972,'330382','330300','乐清市','leqingshi','4','325600',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(973,'330400','330000','嘉兴市','jiaxingshi','3','314000',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(974,'330402','330400','南湖区','nanhu','4','314051',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(975,'330411','330400','秀洲区','xiuzhou','4','314031',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(976,'330421','330400','嘉善县','jiashanxian','4','314100',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(977,'330424','330400','海盐县','haiyanxian','4','314300',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(978,'330481','330400','海宁市','hainingshi','4','314400',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(979,'330482','330400','平湖市','pinghushi','4','314200',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(980,'330483','330400','桐乡市','tongxiangshi','4','314500',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(981,'330500','330000','湖州市','huzhoushi','3','313000',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(982,'330502','330500','吴兴区','wuxing','4','313000',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(983,'330503','330500','南浔区','nanxun','4','313009',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(984,'330521','330500','德清县','deqingxian','4','313200',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(985,'330522','330500','长兴县','zhangxingxian','4','313100',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(986,'330523','330500','安吉县','anjixian','4','313300',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(987,'330600','330000','绍兴市','shaoxingshi','3','312000',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(988,'330602','330600','越城区','yuecheng','4','312000',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(989,'330603','330600','柯桥区','keqiao','4','312030',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(990,'330604','330600','上虞区','shangyu','4','312300',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(991,'330624','330600','新昌县','xinchangxian','4','312500',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(992,'330681','330600','诸暨市','zhujishi','4','311800',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(993,'330683','330600','嵊州市','shengzhoushi','4','312400',NULL,NULL,'2017-02-14 17:05:04',NULL,NULL,NULL,0),(994,'330700','330000','金华市','jinhuashi','3','321000',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(995,'330702','330700','婺城区','wucheng','4','321000',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(996,'330703','330700','金东区','jindong','4','321000',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(997,'330723','330700','武义县','wuyixian','4','321200',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(998,'330726','330700','浦江县','pujiangxian','4','322200',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(999,'330727','330700','磐安县','pananxian','4','322300',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1000,'330781','330700','兰溪市','lanxishi','4','321100',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1001,'330782','330700','义乌市','yiwushi','4','322000',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1002,'330783','330700','东阳市','dongyangshi','4','322100',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1003,'330784','330700','永康市','yongkangshi','4','321300',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1004,'330800','330000','衢州市','quzhoushi','3','324002',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1005,'330802','330800','柯城区','kecheng','4','324100',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1006,'330803','330800','衢江区','qujiang','4','324022',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1007,'330822','330800','常山县','changshanxian','4','324200',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1008,'330824','330800','开化县','kaihuaxian','4','324300',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1009,'330825','330800','龙游县','longyouxian','4','324400',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1010,'330881','330800','江山市','jiangshanshi','4','324100',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1011,'330900','330000','舟山市','zhoushanshi','3','316000',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1012,'330902','330900','定海区','dinghai','4','316000',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1013,'330903','330900','普陀区','putuo','4','316100',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1014,'330921','330900','岱山县','daishanxian','4','316200',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1015,'330922','330900','嵊泗县','shengsixian','4','202450',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1016,'331000','330000','台州市','taizhoushi','3','318000',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1017,'331002','331000','椒江区','jiaojiang','4','318000',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1018,'331003','331000','黄岩区','huangyan','4','318020',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1019,'331004','331000','路桥区','luqiao','4','318050',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1020,'331021','331000','玉环县','yuhuanxian','4','317600',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1021,'331022','331000','三门县','sanmenxian','4','317100',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1022,'331023','331000','天台县','tiantaixian','4','317200',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1023,'331024','331000','仙居县','xianjuxian','4','317300',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1024,'331081','331000','温岭市','wenlingshi','4','317500',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1025,'331082','331000','临海市','linhaishi','4','317000',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1026,'331100','330000','丽水市','lishuishi','3','323000',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1027,'331102','331100','莲都区','liandou','4','323000',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1028,'331121','331100','青田县','qingtianxian','4','323900',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1029,'331122','331100','缙云县','jinyunxian','4','321400',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1030,'331123','331100','遂昌县','suichangxian','4','323300',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1031,'331124','331100','松阳县','songyangxian','4','323400',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1032,'331125','331100','云和县','yunhexian','4','323600',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1033,'331126','331100','庆元县','qingyuanxian','4','323800',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1034,'331127','331100','景宁畲族自治县','jingningshezuzizhixian','4','323500',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1035,'331181','331100','龙泉市','longquanshi','4','323700',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1036,'331200','330000','舟山群岛新区','zhoushanqundaoxin','3','316000',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1037,'331201','331200','金塘岛','jintangdao','4','316000',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1038,'331202','331200','六横岛','liuhengdao','4','316000',NULL,NULL,'2017-02-14 17:05:05',NULL,NULL,NULL,0),(1039,'331203','331200','衢山岛','qushandao','4','316000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1040,'331204','331200','舟山本岛西北部','zhoushanbendaoxibeibu','4','316000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1041,'331205','331200','岱山岛西南部','daishandaoxinanbu','4','316000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1042,'331206','331200','泗礁岛','sijiaodao','4','316000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1043,'331207','331200','朱家尖岛','zhujiajiandao','4','316000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1044,'331208','331200','洋山岛','yangshandao','4','316000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1045,'331209','331200','长涂岛','zhangtudao','4','316000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1046,'331210','331200','虾峙岛','xiazhidao','4','316000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1047,'340000','100000','安徽省','anhuisheng','2','',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1048,'340100','340000','合肥市','hefeishi','3','230001',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1049,'340102','340100','瑶海区','yaohai','4','230011',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1050,'340103','340100','庐阳区','luyang','4','230001',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1051,'340104','340100','蜀山区','shushan','4','230031',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1052,'340111','340100','包河区','baohe','4','230041',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1053,'340121','340100','长丰县','zhangfengxian','4','231100',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1054,'340122','340100','肥东县','feidongxian','4','231600',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1055,'340123','340100','肥西县','feixixian','4','231200',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1056,'340124','340100','庐江县','lujiangxian','4','231500',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1057,'340181','340100','巢湖市','chaohushi','4','238000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1058,'340200','340000','芜湖市','wuhushi','3','241000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1059,'340202','340200','镜湖区','jinghu','4','241000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1060,'340203','340200','弋江区','yijiang','4','241000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1061,'340207','340200','鸠江区','jiujiang','4','241000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1062,'340208','340200','三山区','sanshan','4','241000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1063,'340221','340200','芜湖县','wuhuxian','4','241100',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1064,'340222','340200','繁昌县','fanchangxian','4','241200',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1065,'340223','340200','南陵县','nanlingxian','4','242400',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1066,'340225','340200','无为县','wuweixian','4','238300',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1067,'340300','340000','蚌埠市','bangbushi','3','233000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1068,'340302','340300','龙子湖区','longzihu','4','233000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1069,'340303','340300','蚌山区','bangshan','4','233000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1070,'340304','340300','禹会区','yuhui','4','233010',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1071,'340311','340300','淮上区','huaishang','4','233002',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1072,'340321','340300','怀远县','huaiyuanxian','4','233400',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1073,'340322','340300','五河县','wuhexian','4','233300',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1074,'340323','340300','固镇县','guzhenxian','4','233700',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1075,'340400','340000','淮南市','huainanshi','3','232001',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1076,'340402','340400','大通区','datong','4','232033',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1077,'340403','340400','田家庵区','tianjiaan','4','232000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1078,'340404','340400','谢家集区','xiejiaji','4','232052',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1079,'340405','340400','八公山区','bagongshan','4','232072',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1080,'340406','340400','潘集区','panji','4','232082',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1081,'340421','340400','凤台县','fengtaixian','4','232100',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1082,'340500','340000','马鞍山市','maanshanshi','3','243001',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1083,'340503','340500','花山区','huashan','4','243000',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1084,'340504','340500','雨山区','yushan','4','243071',NULL,NULL,'2017-02-14 17:05:06',NULL,NULL,NULL,0),(1085,'340506','340500','博望区','bowang','4','243131',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1086,'340521','340500','当涂县','dangtuxian','4','243100',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1087,'340522','340500','含山县','hanshanxian','4','238100',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1088,'340523','340500','和县','hexian','4','238200',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1089,'340600','340000','淮北市','huaibeishi','3','235000',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1090,'340602','340600','杜集区','duji','4','235000',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1091,'340603','340600','相山区','xiangshan','4','235000',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1092,'340604','340600','烈山区','lieshan','4','235000',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1093,'340621','340600','濉溪县','suixixian','4','235100',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1094,'340700','340000','铜陵市','tonglingshi','3','244000',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1095,'340702','340700','铜官山区','tongguanshan','4','244000',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1096,'340703','340700','狮子山区','shizishan','4','244000',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1097,'340711','340700','郊区','jiao','4','244000',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1098,'340721','340700','铜陵县','tonglingxian','4','244100',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1099,'340800','340000','安庆市','anqingshi','3','246001',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1100,'340802','340800','迎江区','yingjiang','4','246001',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1101,'340803','340800','大观区','daguan','4','246002',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1102,'340811','340800','宜秀区','yixiu','4','246003',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1103,'340822','340800','怀宁县','huainingxian','4','246100',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1104,'340823','340800','枞阳县','zongyangxian','4','246700',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1105,'340824','340800','潜山县','qianshanxian','4','246300',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1106,'340825','340800','太湖县','taihuxian','4','246400',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1107,'340826','340800','宿松县','susongxian','4','246500',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1108,'340827','340800','望江县','wangjiangxian','4','246200',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1109,'340828','340800','岳西县','yuexixian','4','246600',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1110,'340881','340800','桐城市','tongchengshi','4','231400',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1111,'341000','340000','黄山市','huangshanshi','3','245000',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1112,'341002','341000','屯溪区','tunxi','4','245000',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1113,'341003','341000','黄山区','huangshan','4','242700',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1114,'341004','341000','徽州区','huizhou','4','245061',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1115,'341021','341000','歙县','shexian','4','245200',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1116,'341022','341000','休宁县','xiuningxian','4','245400',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1117,'341023','341000','黟县','yixian','4','245500',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1118,'341024','341000','祁门县','qimenxian','4','245600',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1119,'341100','340000','滁州市','chuzhoushi','3','239000',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1120,'341102','341100','琅琊区','langya','4','239000',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1121,'341103','341100','南谯区','nanqiao','4','239000',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1122,'341122','341100','来安县','laianxian','4','239200',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1123,'341124','341100','全椒县','quanjiaoxian','4','239500',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1124,'341125','341100','定远县','dingyuanxian','4','233200',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1125,'341126','341100','凤阳县','fengyangxian','4','233100',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1126,'341181','341100','天长市','tianzhangshi','4','239300',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1127,'341182','341100','明光市','mingguangshi','4','239400',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1128,'341200','340000','阜阳市','fuyangshi','3','236033',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1129,'341202','341200','颍州区','yingzhou','4','236001',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1130,'341203','341200','颍东区','yingdong','4','236058',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1131,'341204','341200','颍泉区','yingquan','4','236045',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1132,'341221','341200','临泉县','linquanxian','4','236400',NULL,NULL,'2017-02-14 17:05:07',NULL,NULL,NULL,0),(1133,'341222','341200','太和县','taihexian','4','236600',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1134,'341225','341200','阜南县','funanxian','4','236300',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1135,'341226','341200','颍上县','yingshangxian','4','236200',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1136,'341282','341200','界首市','jieshoushi','4','236500',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1137,'341300','340000','宿州市','suzhoushi','3','234000',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1138,'341302','341300','埇桥区','yongqiao','4','234000',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1139,'341321','341300','砀山县','dangshanxian','4','235300',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1140,'341322','341300','萧县','xiaoxian','4','235200',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1141,'341323','341300','灵璧县','lingbixian','4','234200',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1142,'341324','341300','泗县','sixian','4','234300',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1143,'341500','340000','六安市','liuanshi','3','237000',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1144,'341502','341500','金安区','jinan','4','237005',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1145,'341503','341500','裕安区','yuan','4','237010',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1146,'341521','341500','寿县','shouxian','4','232200',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1147,'341522','341500','霍邱县','huoqiuxian','4','237400',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1148,'341523','341500','舒城县','shuchengxian','4','231300',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1149,'341524','341500','金寨县','jinzhaixian','4','237300',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1150,'341525','341500','霍山县','huoshanxian','4','237200',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1151,'341600','340000','亳州市','bozhoushi','3','236802',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1152,'341602','341600','谯城区','qiaocheng','4','236800',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1153,'341621','341600','涡阳县','woyangxian','4','233600',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1154,'341622','341600','蒙城县','mengchengxian','4','233500',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1155,'341623','341600','利辛县','lixinxian','4','236700',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1156,'341700','340000','池州市','chizhoushi','3','247100',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1157,'341702','341700','贵池区','guichi','4','247100',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1158,'341721','341700','东至县','dongzhixian','4','247200',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1159,'341722','341700','石台县','shitaixian','4','245100',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1160,'341723','341700','青阳县','qingyangxian','4','242800',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1161,'341800','340000','宣城市','xuanchengshi','3','242000',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1162,'341802','341800','宣州区','xuanzhou','4','242000',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1163,'341821','341800','郎溪县','langxixian','4','242100',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1164,'341822','341800','广德县','guangdexian','4','242200',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1165,'341823','341800','泾县','jingxian','4','242500',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1166,'341824','341800','绩溪县','jixixian','4','245300',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1167,'341825','341800','旌德县','jingdexian','4','242600',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1168,'341881','341800','宁国市','ningguoshi','4','242300',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1169,'350000','100000','福建省','fujiansheng','2','',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1170,'350100','350000','福州市','fuzhoushi','3','350001',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1171,'350102','350100','鼓楼区','gulou','4','350001',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1172,'350103','350100','台江区','taijiang','4','350004',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1173,'350104','350100','仓山区','cangshan','4','350007',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1174,'350105','350100','马尾区','mawei','4','350015',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1175,'350111','350100','晋安区','jinan','4','350011',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1176,'350121','350100','闽侯县','minhouxian','4','350100',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1177,'350122','350100','连江县','lianjiangxian','4','350500',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1178,'350123','350100','罗源县','luoyuanxian','4','350600',NULL,NULL,'2017-02-14 17:05:08',NULL,NULL,NULL,0),(1179,'350124','350100','闽清县','minqingxian','4','350800',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1180,'350125','350100','永泰县','yongtaixian','4','350700',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1181,'350128','350100','平潭县','pingtanxian','4','350400',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1182,'350181','350100','福清市','fuqingshi','4','350300',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1183,'350182','350100','长乐市','zhangleshi','4','350200',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1184,'350200','350000','厦门市','shamenshi','3','361003',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1185,'350203','350200','思明区','siming','4','361001',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1186,'350205','350200','海沧区','haicang','4','361026',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1187,'350206','350200','湖里区','huli','4','361006',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1188,'350211','350200','集美区','jimei','4','361021',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1189,'350212','350200','同安区','tongan','4','361100',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1190,'350213','350200','翔安区','xiangan','4','361101',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1191,'350300','350000','莆田市','putianshi','3','351100',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1192,'350302','350300','城厢区','chengxiang','4','351100',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1193,'350303','350300','涵江区','hanjiang','4','351111',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1194,'350304','350300','荔城区','licheng','4','351100',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1195,'350305','350300','秀屿区','xiuyu','4','351152',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1196,'350322','350300','仙游县','xianyouxian','4','351200',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1197,'350400','350000','三明市','sanmingshi','3','365000',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1198,'350402','350400','梅列区','meilie','4','365000',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1199,'350403','350400','三元区','sanyuan','4','365001',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1200,'350421','350400','明溪县','mingxixian','4','365200',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1201,'350423','350400','清流县','qingliuxian','4','365300',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1202,'350424','350400','宁化县','ninghuaxian','4','365400',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1203,'350425','350400','大田县','datianxian','4','366100',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1204,'350426','350400','尤溪县','youxixian','4','365100',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1205,'350427','350400','沙县','shaxian','4','365500',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1206,'350428','350400','将乐县','jianglexian','4','353300',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1207,'350429','350400','泰宁县','tainingxian','4','354400',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1208,'350430','350400','建宁县','jianningxian','4','354500',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1209,'350481','350400','永安市','yonganshi','4','366000',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1210,'350500','350000','泉州市','quanzhoushi','3','362000',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1211,'350502','350500','鲤城区','licheng','4','362000',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1212,'350503','350500','丰泽区','fengze','4','362000',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1213,'350504','350500','洛江区','luojiang','4','362011',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1214,'350505','350500','泉港区','quangang','4','362114',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1215,'350521','350500','惠安县','huianxian','4','362100',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1216,'350524','350500','安溪县','anxixian','4','362400',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1217,'350525','350500','永春县','yongchunxian','4','362600',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1218,'350526','350500','德化县','dehuaxian','4','362500',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1219,'350527','350500','金门县','jinmenxian','4','',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1220,'350581','350500','石狮市','shishishi','4','362700',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1221,'350582','350500','晋江市','jinjiangshi','4','362200',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1222,'350583','350500','南安市','nananshi','4','362300',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1223,'350600','350000','漳州市','zhangzhoushi','3','363005',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1224,'350602','350600','芗城区','xiangcheng','4','363000',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1225,'350603','350600','龙文区','longwen','4','363005',NULL,NULL,'2017-02-14 17:05:09',NULL,NULL,NULL,0),(1226,'350622','350600','云霄县','yunxiaoxian','4','363300',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1227,'350623','350600','漳浦县','zhangpuxian','4','363200',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1228,'350624','350600','诏安县','zhaoanxian','4','363500',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1229,'350625','350600','长泰县','zhangtaixian','4','363900',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1230,'350626','350600','东山县','dongshanxian','4','363400',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1231,'350627','350600','南靖县','nanjingxian','4','363600',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1232,'350628','350600','平和县','pinghexian','4','363700',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1233,'350629','350600','华安县','huaanxian','4','363800',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1234,'350681','350600','龙海市','longhaishi','4','363100',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1235,'350700','350000','南平市','nanpingshi','3','353000',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1236,'350702','350700','延平区','yanping','4','353000',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1237,'350703','350700','建阳区','jianyang','4','354200',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1238,'350721','350700','顺昌县','shunchangxian','4','353200',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1239,'350722','350700','浦城县','puchengxian','4','353400',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1240,'350723','350700','光泽县','guangzexian','4','354100',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1241,'350724','350700','松溪县','songxixian','4','353500',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1242,'350725','350700','政和县','zhenghexian','4','353600',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1243,'350781','350700','邵武市','shaowushi','4','354000',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1244,'350782','350700','武夷山市','wuyishanshi','4','354300',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1245,'350783','350700','建瓯市','jianoushi','4','353100',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1246,'350800','350000','龙岩市','longyanshi','3','364000',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1247,'350802','350800','新罗区','xinluo','4','364000',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1248,'350821','350800','长汀县','zhangtingxian','4','366300',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1249,'350822','350800','永定区','yongding','4','364100',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1250,'350823','350800','上杭县','shanghangxian','4','364200',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1251,'350824','350800','武平县','wupingxian','4','364300',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1252,'350825','350800','连城县','lianchengxian','4','366200',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1253,'350881','350800','漳平市','zhangpingshi','4','364400',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1254,'350900','350000','宁德市','ningdeshi','3','352100',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1255,'350902','350900','蕉城区','jiaocheng','4','352100',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1256,'350921','350900','霞浦县','xiapuxian','4','355100',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1257,'350922','350900','古田县','gutianxian','4','352200',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1258,'350923','350900','屏南县','pingnanxian','4','352300',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1259,'350924','350900','寿宁县','shouningxian','4','355500',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1260,'350925','350900','周宁县','zhouningxian','4','355400',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1261,'350926','350900','柘荣县','zherongxian','4','355300',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1262,'350981','350900','福安市','fuanshi','4','355000',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1263,'350982','350900','福鼎市','fudingshi','4','355200',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1264,'360000','100000','江西省','jiangxisheng','2','',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1265,'360100','360000','南昌市','nanchangshi','3','330008',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1266,'360102','360100','东湖区','donghu','4','330006',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1267,'360103','360100','西湖区','xihu','4','330009',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1268,'360104','360100','青云谱区','qingyunpu','4','330001',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1269,'360105','360100','湾里区','wanli','4','330004',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1270,'360111','360100','青山湖区','qingshanhu','4','330029',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1271,'360121','360100','南昌县','nanchangxian','4','330200',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1272,'360122','360100','新建县','xinjianxian','4','330100',NULL,NULL,'2017-02-14 17:05:10',NULL,NULL,NULL,0),(1273,'360123','360100','安义县','anyixian','4','330500',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1274,'360124','360100','进贤县','jinxianxian','4','331700',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1275,'360200','360000','景德镇市','jingdezhenshi','3','333000',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1276,'360202','360200','昌江区','changjiang','4','333000',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1277,'360203','360200','珠山区','zhushan','4','333000',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1278,'360222','360200','浮梁县','fuliangxian','4','333400',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1279,'360281','360200','乐平市','lepingshi','4','333300',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1280,'360300','360000','萍乡市','pingxiangshi','3','337000',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1281,'360302','360300','安源区','anyuan','4','337000',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1282,'360313','360300','湘东区','xiangdong','4','337016',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1283,'360321','360300','莲花县','lianhuaxian','4','337100',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1284,'360322','360300','上栗县','shanglixian','4','337009',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1285,'360323','360300','芦溪县','luxixian','4','337053',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1286,'360400','360000','九江市','jiujiangshi','3','332000',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1287,'360402','360400','庐山区','lushan','4','332005',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1288,'360403','360400','浔阳区','xunyang','4','332000',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1289,'360421','360400','九江县','jiujiangxian','4','332100',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1290,'360423','360400','武宁县','wuningxian','4','332300',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1291,'360424','360400','修水县','xiushuixian','4','332400',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1292,'360425','360400','永修县','yongxiuxian','4','330300',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1293,'360426','360400','德安县','deanxian','4','330400',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1294,'360427','360400','星子县','xingzixian','4','332800',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1295,'360428','360400','都昌县','douchangxian','4','332600',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1296,'360429','360400','湖口县','hukouxian','4','332500',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1297,'360430','360400','彭泽县','pengzexian','4','332700',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1298,'360481','360400','瑞昌市','ruichangshi','4','332200',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1299,'360482','360400','共青城市','gongqingchengshi','4','332020',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1300,'360500','360000','新余市','xinyushi','3','338025',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1301,'360502','360500','渝水区','yushui','4','338025',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1302,'360521','360500','分宜县','fenyixian','4','336600',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1303,'360600','360000','鹰潭市','yingtanshi','3','335000',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1304,'360602','360600','月湖区','yuehu','4','335000',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1305,'360622','360600','余江县','yujiangxian','4','335200',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1306,'360681','360600','贵溪市','guixishi','4','335400',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1307,'360700','360000','赣州市','ganzhoushi','3','341000',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1308,'360702','360700','章贡区','zhanggong','4','341000',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1309,'360703','360700','南康区','nankang','4','341400',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1310,'360721','360700','赣县','ganxian','4','341100',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1311,'360722','360700','信丰县','xinfengxian','4','341600',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1312,'360723','360700','大余县','dayuxian','4','341500',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1313,'360724','360700','上犹县','shangyouxian','4','341200',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1314,'360725','360700','崇义县','chongyixian','4','341300',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1315,'360726','360700','安远县','anyuanxian','4','342100',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1316,'360727','360700','龙南县','longnanxian','4','341700',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1317,'360728','360700','定南县','dingnanxian','4','341900',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1318,'360729','360700','全南县','quannanxian','4','341800',NULL,NULL,'2017-02-14 17:05:11',NULL,NULL,NULL,0),(1319,'360730','360700','宁都县','ningdouxian','4','342800',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1320,'360731','360700','于都县','yudouxian','4','342300',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1321,'360732','360700','兴国县','xingguoxian','4','342400',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1322,'360733','360700','会昌县','huichangxian','4','342600',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1323,'360734','360700','寻乌县','xunwuxian','4','342200',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1324,'360735','360700','石城县','shichengxian','4','342700',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1325,'360781','360700','瑞金市','ruijinshi','4','342500',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1326,'360800','360000','吉安市','jianshi','3','343000',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1327,'360802','360800','吉州区','jizhou','4','343000',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1328,'360803','360800','青原区','qingyuan','4','343009',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1329,'360821','360800','吉安县','jianxian','4','343100',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1330,'360822','360800','吉水县','jishuixian','4','331600',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1331,'360823','360800','峡江县','xiajiangxian','4','331409',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1332,'360824','360800','新干县','xinganxian','4','331300',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1333,'360825','360800','永丰县','yongfengxian','4','331500',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1334,'360826','360800','泰和县','taihexian','4','343700',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1335,'360827','360800','遂川县','suichuanxian','4','343900',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1336,'360828','360800','万安县','wananxian','4','343800',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1337,'360829','360800','安福县','anfuxian','4','343200',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1338,'360830','360800','永新县','yongxinxian','4','343400',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1339,'360881','360800','井冈山市','jinggangshanshi','4','343600',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1340,'360900','360000','宜春市','yichunshi','3','336000',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1341,'360902','360900','袁州区','yuanzhou','4','336000',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1342,'360921','360900','奉新县','fengxinxian','4','330700',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1343,'360922','360900','万载县','wanzaixian','4','336100',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1344,'360923','360900','上高县','shanggaoxian','4','336400',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1345,'360924','360900','宜丰县','yifengxian','4','336300',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1346,'360925','360900','靖安县','jinganxian','4','330600',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1347,'360926','360900','铜鼓县','tongguxian','4','336200',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1348,'360981','360900','丰城市','fengchengshi','4','331100',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1349,'360982','360900','樟树市','zhangshushi','4','331200',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1350,'360983','360900','高安市','gaoanshi','4','330800',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1351,'361000','360000','抚州市','fuzhoushi','3','344000',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1352,'361002','361000','临川区','linchuan','4','344000',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1353,'361021','361000','南城县','nanchengxian','4','344700',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1354,'361022','361000','黎川县','lichuanxian','4','344600',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1355,'361023','361000','南丰县','nanfengxian','4','344500',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1356,'361024','361000','崇仁县','chongrenxian','4','344200',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1357,'361025','361000','乐安县','leanxian','4','344300',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1358,'361026','361000','宜黄县','yihuangxian','4','344400',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1359,'361027','361000','金溪县','jinxixian','4','344800',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1360,'361028','361000','资溪县','zixixian','4','335300',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1361,'361029','361000','东乡县','dongxiangxian','4','331800',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1362,'361030','361000','广昌县','guangchangxian','4','344900',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1363,'361100','360000','上饶市','shangraoshi','3','334000',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1364,'361102','361100','信州区','xinzhou','4','334000',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1365,'361121','361100','上饶县','shangraoxian','4','334100',NULL,NULL,'2017-02-14 17:05:12',NULL,NULL,NULL,0),(1366,'361122','361100','广丰县','guangfengxian','4','334600',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1367,'361123','361100','玉山县','yushanxian','4','334700',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1368,'361124','361100','铅山县','qianshanxian','4','334500',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1369,'361125','361100','横峰县','hengfengxian','4','334300',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1370,'361126','361100','弋阳县','yiyangxian','4','334400',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1371,'361127','361100','余干县','yuganxian','4','335100',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1372,'361128','361100','鄱阳县','poyangxian','4','333100',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1373,'361129','361100','万年县','wannianxian','4','335500',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1374,'361130','361100','婺源县','wuyuanxian','4','333200',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1375,'361181','361100','德兴市','dexingshi','4','334200',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1376,'370000','100000','山东省','shandongsheng','2','',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1377,'370100','370000','济南市','jinanshi','3','250001',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1378,'370102','370100','历下区','lixia','4','250014',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1379,'370103','370100','市中区','shizhong','4','250001',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1380,'370104','370100','槐荫区','huaiyin','4','250117',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1381,'370105','370100','天桥区','tianqiao','4','250031',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1382,'370112','370100','历城区','licheng','4','250100',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1383,'370113','370100','长清区','zhangqing','4','250300',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1384,'370124','370100','平阴县','pingyinxian','4','250400',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1385,'370125','370100','济阳县','jiyangxian','4','251400',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1386,'370126','370100','商河县','shanghexian','4','251600',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1387,'370181','370100','章丘市','zhangqiushi','4','250200',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1388,'370200','370000','青岛市','qingdaoshi','3','266001',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1389,'370202','370200','市南区','shinan','4','266001',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1390,'370203','370200','市北区','shibei','4','266011',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1391,'370211','370200','黄岛区','huangdao','4','266500',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1392,'370212','370200','崂山区','laoshan','4','266100',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1393,'370213','370200','李沧区','licang','4','266021',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1394,'370214','370200','城阳区','chengyang','4','266041',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1395,'370281','370200','胶州市','jiaozhoushi','4','266300',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1396,'370282','370200','即墨市','jimoshi','4','266200',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1397,'370283','370200','平度市','pingdushi','4','266700',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1398,'370285','370200','莱西市','laixishi','4','266600',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1399,'370286','370200','西海岸新区','xihaianxin','4','266500',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1400,'370300','370000','淄博市','ziboshi','3','255039',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1401,'370302','370300','淄川区','zichuan','4','255100',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1402,'370303','370300','张店区','zhangdian','4','255022',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1403,'370304','370300','博山区','boshan','4','255200',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1404,'370305','370300','临淄区','linzi','4','255400',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1405,'370306','370300','周村区','zhoucun','4','255300',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1406,'370321','370300','桓台县','huantaixian','4','256400',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1407,'370322','370300','高青县','gaoqingxian','4','256300',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1408,'370323','370300','沂源县','yiyuanxian','4','256100',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1409,'370400','370000','枣庄市','zaozhuangshi','3','277101',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1410,'370402','370400','市中区','shizhong','4','277101',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1411,'370403','370400','薛城区','xuecheng','4','277000',NULL,NULL,'2017-02-14 17:05:13',NULL,NULL,NULL,0),(1412,'370404','370400','峄城区','yicheng','4','277300',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1413,'370405','370400','台儿庄区','taierzhuang','4','277400',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1414,'370406','370400','山亭区','shanting','4','277200',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1415,'370481','370400','滕州市','tengzhoushi','4','277500',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1416,'370500','370000','东营市','dongyingshi','3','257093',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1417,'370502','370500','东营区','dongying','4','257029',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1418,'370503','370500','河口区','hekou','4','257200',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1419,'370521','370500','垦利县','kenlixian','4','257500',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1420,'370522','370500','利津县','lijinxian','4','257400',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1421,'370523','370500','广饶县','guangraoxian','4','257300',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1422,'370600','370000','烟台市','yantaishi','3','264010',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1423,'370602','370600','芝罘区','zhifu','4','264001',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1424,'370611','370600','福山区','fushan','4','265500',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1425,'370612','370600','牟平区','mouping','4','264100',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1426,'370613','370600','莱山区','laishan','4','264600',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1427,'370634','370600','长岛县','zhangdaoxian','4','265800',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1428,'370681','370600','龙口市','longkoushi','4','265700',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1429,'370682','370600','莱阳市','laiyangshi','4','265200',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1430,'370683','370600','莱州市','laizhoushi','4','261400',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1431,'370684','370600','蓬莱市','penglaishi','4','265600',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1432,'370685','370600','招远市','zhaoyuanshi','4','265400',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1433,'370686','370600','栖霞市','qixiashi','4','265300',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1434,'370687','370600','海阳市','haiyangshi','4','265100',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1435,'370700','370000','潍坊市','weifangshi','3','261041',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1436,'370702','370700','潍城区','weicheng','4','261021',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1437,'370703','370700','寒亭区','hanting','4','261100',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1438,'370704','370700','坊子区','fangzi','4','261200',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1439,'370705','370700','奎文区','kuiwen','4','261031',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1440,'370724','370700','临朐县','linquxian','4','262600',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1441,'370725','370700','昌乐县','changlexian','4','262400',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1442,'370781','370700','青州市','qingzhoushi','4','262500',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1443,'370782','370700','诸城市','zhuchengshi','4','262200',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1444,'370783','370700','寿光市','shouguangshi','4','262700',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1445,'370784','370700','安丘市','anqiushi','4','262100',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1446,'370785','370700','高密市','gaomishi','4','261500',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1447,'370786','370700','昌邑市','changyishi','4','261300',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1448,'370800','370000','济宁市','jiningshi','3','272119',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1449,'370811','370800','任城区','rencheng','4','272113',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1450,'370812','370800','兖州区','yanzhou','4','272000',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1451,'370826','370800','微山县','weishanxian','4','277600',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1452,'370827','370800','鱼台县','yutaixian','4','272300',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1453,'370828','370800','金乡县','jinxiangxian','4','272200',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1454,'370829','370800','嘉祥县','jiaxiangxian','4','272400',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1455,'370830','370800','汶上县','wenshangxian','4','272501',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1456,'370831','370800','泗水县','sishuixian','4','273200',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1457,'370832','370800','梁山县','liangshanxian','4','272600',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1458,'370881','370800','曲阜市','qufushi','4','273100',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1459,'370883','370800','邹城市','zouchengshi','4','273500',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1460,'370900','370000','泰安市','taianshi','3','271000',NULL,NULL,'2017-02-14 17:05:14',NULL,NULL,NULL,0),(1461,'370902','370900','泰山区','taishan','4','271000',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1462,'370911','370900','岱岳区','daiyue','4','271000',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1463,'370921','370900','宁阳县','ningyangxian','4','271400',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1464,'370923','370900','东平县','dongpingxian','4','271500',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1465,'370982','370900','新泰市','xintaishi','4','271200',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1466,'370983','370900','肥城市','feichengshi','4','271600',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1467,'371000','370000','威海市','weihaishi','3','264200',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1468,'371002','371000','环翠区','huancui','4','264200',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1469,'371003','371000','文登区','wendeng','4','266440',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1470,'371082','371000','荣成市','rongchengshi','4','264300',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1471,'371083','371000','乳山市','rushanshi','4','264500',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1472,'371100','370000','日照市','rizhaoshi','3','276800',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1473,'371102','371100','东港区','donggang','4','276800',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1474,'371103','371100','岚山区','lanshan','4','276808',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1475,'371121','371100','五莲县','wulianxian','4','262300',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1476,'371122','371100','莒县','juxian','4','276500',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1477,'371200','370000','莱芜市','laiwushi','3','271100',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1478,'371202','371200','莱城区','laicheng','4','271199',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1479,'371203','371200','钢城区','gangcheng','4','271100',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1480,'371300','370000','临沂市','linyishi','3','253000',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1481,'371302','371300','兰山区','lanshan','4','276002',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1482,'371311','371300','罗庄区','luozhuang','4','276022',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1483,'371312','371300','河东区','hedong','4','276034',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1484,'371321','371300','沂南县','yinanxian','4','276300',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1485,'371322','371300','郯城县','tanchengxian','4','276100',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1486,'371323','371300','沂水县','yishuixian','4','276400',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1487,'371324','371300','兰陵县','lanlingxian','4','277700',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1488,'371325','371300','费县','feixian','4','273400',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1489,'371326','371300','平邑县','pingyixian','4','273300',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1490,'371327','371300','莒南县','junanxian','4','276600',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1491,'371328','371300','蒙阴县','mengyinxian','4','276200',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1492,'371329','371300','临沭县','linshuxian','4','276700',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1493,'371400','370000','德州市','dezhoushi','3','253000',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1494,'371402','371400','德城区','decheng','4','253012',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1495,'371403','371400','陵城区','lingcheng','4','253500',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1496,'371422','371400','宁津县','ningjinxian','4','253400',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1497,'371423','371400','庆云县','qingyunxian','4','253700',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1498,'371424','371400','临邑县','linyixian','4','251500',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1499,'371425','371400','齐河县','qihexian','4','251100',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1500,'371426','371400','平原县','pingyuanxian','4','253100',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1501,'371427','371400','夏津县','xiajinxian','4','253200',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1502,'371428','371400','武城县','wuchengxian','4','253300',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1503,'371481','371400','乐陵市','lelingshi','4','253600',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1504,'371482','371400','禹城市','yuchengshi','4','251200',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1505,'371500','370000','聊城市','liaochengshi','3','252052',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1506,'371502','371500','东昌府区','dongchangfu','4','252000',NULL,NULL,'2017-02-14 17:05:15',NULL,NULL,NULL,0),(1507,'371521','371500','阳谷县','yangguxian','4','252300',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1508,'371522','371500','莘县','xinxian','4','252400',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1509,'371523','371500','茌平县','chipingxian','4','252100',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1510,'371524','371500','东阿县','dongaxian','4','252200',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1511,'371525','371500','冠县','guanxian','4','252500',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1512,'371526','371500','高唐县','gaotangxian','4','252800',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1513,'371581','371500','临清市','linqingshi','4','252600',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1514,'371600','370000','滨州市','binzhoushi','3','256619',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1515,'371602','371600','滨城区','bincheng','4','256613',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1516,'371603','371600','沾化区','zhanhua','4','256800',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1517,'371621','371600','惠民县','huiminxian','4','251700',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1518,'371622','371600','阳信县','yangxinxian','4','251800',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1519,'371623','371600','无棣县','wudixian','4','251900',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1520,'371625','371600','博兴县','boxingxian','4','256500',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1521,'371626','371600','邹平县','zoupingxian','4','256200',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1522,'371627','371600','北海新区','beihaixin','4','256200',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1523,'371700','370000','菏泽市','hezeshi','3','274020',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1524,'371702','371700','牡丹区','mudan','4','274009',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1525,'371721','371700','曹县','caoxian','4','274400',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1526,'371722','371700','单县','danxian','4','273700',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1527,'371723','371700','成武县','chengwuxian','4','274200',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1528,'371724','371700','巨野县','juyexian','4','274900',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1529,'371725','371700','郓城县','yunchengxian','4','274700',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1530,'371726','371700','鄄城县','juanchengxian','4','274600',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1531,'371727','371700','定陶县','dingtaoxian','4','274100',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1532,'371728','371700','东明县','dongmingxian','4','274500',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1533,'410000','100000','河南省','henansheng','2','',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1534,'410100','410000','郑州市','zhengzhoushi','3','450000',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1535,'410102','410100','中原区','zhongyuan','4','450007',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1536,'410103','410100','二七区','erqi','4','450052',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1537,'410104','410100','管城回族区','guanchenghuizu','4','450000',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1538,'410105','410100','金水区','jinshui','4','450003',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1539,'410106','410100','上街区','shangjie','4','450041',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1540,'410108','410100','惠济区','huiji','4','450053',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1541,'410122','410100','中牟县','zhongmouxian','4','451450',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1542,'410181','410100','巩义市','gongyishi','4','451200',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1543,'410182','410100','荥阳市','yingyangshi','4','450100',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1544,'410183','410100','新密市','xinmishi','4','452300',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1545,'410184','410100','新郑市','xinzhengshi','4','451100',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1546,'410185','410100','登封市','dengfengshi','4','452470',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1547,'410200','410000','开封市','kaifengshi','3','475001',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1548,'410202','410200','龙亭区','longting','4','475100',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1549,'410203','410200','顺河回族区','shunhehuizu','4','475000',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1550,'410204','410200','鼓楼区','gulou','4','475000',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1551,'410205','410200','禹王台区','yuwangtai','4','475003',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1552,'410212','410200','祥符区','xiangfu','4','475100',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1553,'410221','410200','杞县','qixian','4','475200',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1554,'410222','410200','通许县','tongxuxian','4','475400',NULL,NULL,'2017-02-14 17:05:16',NULL,NULL,NULL,0),(1555,'410223','410200','尉氏县','weishixian','4','475500',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1556,'410225','410200','兰考县','lankaoxian','4','475300',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1557,'410300','410000','洛阳市','luoyangshi','3','471000',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1558,'410302','410300','老城区','laocheng','4','471002',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1559,'410303','410300','西工区','xigong','4','471000',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1560,'410304','410300','瀍河回族区','chanhehuizu','4','471002',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1561,'410305','410300','涧西区','jianxi','4','471003',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1562,'410306','410300','吉利区','jili','4','471012',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1563,'410311','410300','洛龙区','luolong','4','471000',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1564,'410322','410300','孟津县','mengjinxian','4','471100',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1565,'410323','410300','新安县','xinanxian','4','471800',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1566,'410324','410300','栾川县','luanchuanxian','4','471500',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1567,'410325','410300','嵩县','songxian','4','471400',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1568,'410326','410300','汝阳县','ruyangxian','4','471200',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1569,'410327','410300','宜阳县','yiyangxian','4','471600',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1570,'410328','410300','洛宁县','luoningxian','4','471700',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1571,'410329','410300','伊川县','yichuanxian','4','471300',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1572,'410381','410300','偃师市','yanshishi','4','471900',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1573,'410400','410000','平顶山市','pingdingshanshi','3','467000',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1574,'410402','410400','新华区','xinhua','4','467002',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1575,'410403','410400','卫东区','weidong','4','467021',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1576,'410404','410400','石龙区','shilong','4','467045',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1577,'410411','410400','湛河区','zhanhe','4','467000',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1578,'410421','410400','宝丰县','baofengxian','4','467400',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1579,'410422','410400','叶县','yexian','4','467200',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1580,'410423','410400','鲁山县','lushanxian','4','467300',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1581,'410425','410400','郏县','jiaxian','4','467100',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1582,'410481','410400','舞钢市','wugangshi','4','462500',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1583,'410482','410400','汝州市','ruzhoushi','4','467500',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1584,'410500','410000','安阳市','anyangshi','3','455000',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1585,'410502','410500','文峰区','wenfeng','4','455000',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1586,'410503','410500','北关区','beiguan','4','455001',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1587,'410505','410500','殷都区','yindou','4','455004',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1588,'410506','410500','龙安区','longan','4','455001',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1589,'410522','410500','安阳县','anyangxian','4','455000',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1590,'410523','410500','汤阴县','tangyinxian','4','456150',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1591,'410526','410500','滑县','huaxian','4','456400',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1592,'410527','410500','内黄县','neihuangxian','4','456350',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1593,'410581','410500','林州市','linzhoushi','4','456550',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1594,'410600','410000','鹤壁市','hebishi','3','458030',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1595,'410602','410600','鹤山区','heshan','4','458010',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1596,'410603','410600','山城区','shancheng','4','458000',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1597,'410611','410600','淇滨区','qibin','4','458000',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1598,'410621','410600','浚县','junxian','4','456250',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1599,'410622','410600','淇县','qixian','4','456750',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1600,'410700','410000','新乡市','xinxiangshi','3','453000',NULL,NULL,'2017-02-14 17:05:17',NULL,NULL,NULL,0),(1601,'410702','410700','红旗区','hongqi','4','453000',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1602,'410703','410700','卫滨区','weibin','4','453000',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1603,'410704','410700','凤泉区','fengquan','4','453011',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1604,'410711','410700','牧野区','muye','4','453002',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1605,'410721','410700','新乡县','xinxiangxian','4','453700',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1606,'410724','410700','获嘉县','huojiaxian','4','453800',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1607,'410725','410700','原阳县','yuanyangxian','4','453500',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1608,'410726','410700','延津县','yanjinxian','4','453200',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1609,'410727','410700','封丘县','fengqiuxian','4','453300',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1610,'410728','410700','长垣县','zhangyuanxian','4','453400',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1611,'410781','410700','卫辉市','weihuishi','4','453100',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1612,'410782','410700','辉县市','huixianshi','4','453600',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1613,'410800','410000','焦作市','jiaozuoshi','3','454002',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1614,'410802','410800','解放区','jiefang','4','454000',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1615,'410803','410800','中站区','zhongzhan','4','454191',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1616,'410804','410800','马村区','macun','4','454171',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1617,'410811','410800','山阳区','shanyang','4','454002',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1618,'410821','410800','修武县','xiuwuxian','4','454350',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1619,'410822','410800','博爱县','boaixian','4','454450',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1620,'410823','410800','武陟县','wuzhixian','4','454950',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1621,'410825','410800','温县','wenxian','4','454850',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1622,'410882','410800','沁阳市','qinyangshi','4','454550',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1623,'410883','410800','孟州市','mengzhoushi','4','454750',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1624,'410900','410000','濮阳市','puyangshi','3','457000',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1625,'410902','410900','华龙区','hualong','4','457001',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1626,'410922','410900','清丰县','qingfengxian','4','457300',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1627,'410923','410900','南乐县','nanlexian','4','457400',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1628,'410926','410900','范县','fanxian','4','457500',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1629,'410927','410900','台前县','taiqianxian','4','457600',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1630,'410928','410900','濮阳县','puyangxian','4','457100',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1631,'411000','410000','许昌市','xuchangshi','3','461000',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1632,'411002','411000','魏都区','weidou','4','461000',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1633,'411023','411000','许昌县','xuchangxian','4','461100',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1634,'411024','411000','鄢陵县','yanlingxian','4','461200',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1635,'411025','411000','襄城县','xiangchengxian','4','461700',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1636,'411081','411000','禹州市','yuzhoushi','4','461670',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1637,'411082','411000','长葛市','zhanggeshi','4','461500',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1638,'411100','410000','漯河市','luoheshi','3','462000',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1639,'411102','411100','源汇区','yuanhui','4','462000',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1640,'411103','411100','郾城区','yancheng','4','462300',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1641,'411104','411100','召陵区','zhaoling','4','462300',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1642,'411121','411100','舞阳县','wuyangxian','4','462400',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1643,'411122','411100','临颍县','linyingxian','4','462600',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1644,'411200','410000','三门峡市','sanmenxiashi','3','472000',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1645,'411202','411200','湖滨区','hubin','4','472000',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1646,'411221','411200','渑池县','mianchixian','4','472400',NULL,NULL,'2017-02-14 17:05:18',NULL,NULL,NULL,0),(1647,'411222','411200','陕县','shanxian','4','472100',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1648,'411224','411200','卢氏县','lushixian','4','472200',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1649,'411281','411200','义马市','yimashi','4','472300',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1650,'411282','411200','灵宝市','lingbaoshi','4','472500',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1651,'411300','410000','南阳市','nanyangshi','3','473002',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1652,'411302','411300','宛城区','wancheng','4','473001',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1653,'411303','411300','卧龙区','wolong','4','473003',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1654,'411321','411300','南召县','nanzhaoxian','4','474650',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1655,'411322','411300','方城县','fangchengxian','4','473200',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1656,'411323','411300','西峡县','xixiaxian','4','474550',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1657,'411324','411300','镇平县','zhenpingxian','4','474250',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1658,'411325','411300','内乡县','neixiangxian','4','474350',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1659,'411326','411300','淅川县','xichuanxian','4','474450',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1660,'411327','411300','社旗县','sheqixian','4','473300',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1661,'411328','411300','唐河县','tanghexian','4','473400',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1662,'411329','411300','新野县','xinyexian','4','473500',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1663,'411330','411300','桐柏县','tongboxian','4','474750',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1664,'411381','411300','邓州市','dengzhoushi','4','474150',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1665,'411400','410000','商丘市','shangqiushi','3','476000',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1666,'411402','411400','梁园区','liangyuan','4','476000',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1667,'411403','411400','睢阳区','suiyang','4','476100',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1668,'411421','411400','民权县','minquanxian','4','476800',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1669,'411422','411400','睢县','suixian','4','476900',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1670,'411423','411400','宁陵县','ninglingxian','4','476700',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1671,'411424','411400','柘城县','zhechengxian','4','476200',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1672,'411425','411400','虞城县','yuchengxian','4','476300',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1673,'411426','411400','夏邑县','xiayixian','4','476400',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1674,'411481','411400','永城市','yongchengshi','4','476600',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1675,'411500','410000','信阳市','xinyangshi','3','464000',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1676,'411502','411500','浉河区','shihe','4','464000',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1677,'411503','411500','平桥区','pingqiao','4','464100',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1678,'411521','411500','罗山县','luoshanxian','4','464200',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1679,'411522','411500','光山县','guangshanxian','4','465450',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1680,'411523','411500','新县','xinxian','4','465550',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1681,'411524','411500','商城县','shangchengxian','4','465350',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1682,'411525','411500','固始县','gushixian','4','465250',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1683,'411526','411500','潢川县','huangchuanxian','4','465150',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1684,'411527','411500','淮滨县','huaibinxian','4','464400',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1685,'411528','411500','息县','xixian','4','464300',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1686,'411600','410000','周口市','zhoukoushi','3','466000',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1687,'411602','411600','川汇区','chuanhui','4','466000',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1688,'411621','411600','扶沟县','fugouxian','4','461300',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1689,'411622','411600','西华县','xihuaxian','4','466600',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1690,'411623','411600','商水县','shangshuixian','4','466100',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1691,'411624','411600','沈丘县','shenqiuxian','4','466300',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1692,'411625','411600','郸城县','danchengxian','4','477150',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1693,'411626','411600','淮阳县','huaiyangxian','4','466700',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1694,'411627','411600','太康县','taikangxian','4','461400',NULL,NULL,'2017-02-14 17:05:19',NULL,NULL,NULL,0),(1695,'411628','411600','鹿邑县','luyixian','4','477200',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1696,'411681','411600','项城市','xiangchengshi','4','466200',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1697,'411700','410000','驻马店市','zhumadianshi','3','463000',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1698,'411702','411700','驿城区','yicheng','4','463000',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1699,'411721','411700','西平县','xipingxian','4','463900',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1700,'411722','411700','上蔡县','shangcaixian','4','463800',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1701,'411723','411700','平舆县','pingyuxian','4','463400',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1702,'411724','411700','正阳县','zhengyangxian','4','463600',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1703,'411725','411700','确山县','queshanxian','4','463200',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1704,'411726','411700','泌阳县','miyangxian','4','463700',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1705,'411727','411700','汝南县','runanxian','4','463300',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1706,'411728','411700','遂平县','suipingxian','4','463100',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1707,'411729','411700','新蔡县','xincaixian','4','463500',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1708,'419000','410000','直辖县级','zhixiaxianji','-1','113.665412',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1709,'419001','419000','济源市','jiyuanshi','4','454650',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1710,'420000','100000','湖北省','hubeisheng','2','',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1711,'420100','420000','武汉市','wuhanshi','3','430014',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1712,'420102','420100','江岸区','jiangan','4','430014',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1713,'420103','420100','江汉区','jianghan','4','430021',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1714,'420104','420100','硚口区','qiaokou','4','430033',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1715,'420105','420100','汉阳区','hanyang','4','430050',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1716,'420106','420100','武昌区','wuchang','4','430061',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1717,'420107','420100','青山区','qingshan','4','430080',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1718,'420111','420100','洪山区','hongshan','4','430070',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1719,'420112','420100','东西湖区','dongxihu','4','430040',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1720,'420113','420100','汉南区','hannan','4','430090',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1721,'420114','420100','蔡甸区','caidian','4','430100',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1722,'420115','420100','江夏区','jiangxia','4','430200',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1723,'420116','420100','黄陂区','huangpo','4','432200',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1724,'420117','420100','新洲区','xinzhou','4','431400',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1725,'420200','420000','黄石市','huangshishi','3','435003',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1726,'420202','420200','黄石港区','huangshigang','4','435000',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1727,'420203','420200','西塞山区','xisaishan','4','435001',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1728,'420204','420200','下陆区','xialu','4','435005',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1729,'420205','420200','铁山区','tieshan','4','435006',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1730,'420222','420200','阳新县','yangxinxian','4','435200',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1731,'420281','420200','大冶市','dayeshi','4','435100',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1732,'420300','420000','十堰市','shiyanshi','3','442000',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1733,'420302','420300','茅箭区','maojian','4','442012',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1734,'420303','420300','张湾区','zhangwan','4','442001',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1735,'420304','420300','郧阳区','yunyang','4','442500',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1736,'420322','420300','郧西县','yunxixian','4','442600',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1737,'420323','420300','竹山县','zhushanxian','4','442200',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1738,'420324','420300','竹溪县','zhuxixian','4','442300',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1739,'420325','420300','房县','fangxian','4','442100',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1740,'420381','420300','丹江口市','danjiangkoushi','4','442700',NULL,NULL,'2017-02-14 17:05:20',NULL,NULL,NULL,0),(1741,'420500','420000','宜昌市','yichangshi','3','443000',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1742,'420502','420500','西陵区','xiling','4','443000',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1743,'420503','420500','伍家岗区','wujiagang','4','443001',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1744,'420504','420500','点军区','dianjun','4','443006',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1745,'420505','420500','猇亭区','yaoting','4','443007',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1746,'420506','420500','夷陵区','yiling','4','443100',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1747,'420525','420500','远安县','yuananxian','4','444200',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1748,'420526','420500','兴山县','xingshanxian','4','443711',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1749,'420527','420500','秭归县','ziguixian','4','443600',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1750,'420528','420500','长阳土家族自治县','zhangyangtujiazuzizhixian','4','443500',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1751,'420529','420500','五峰土家族自治县','wufengtujiazuzizhixian','4','443413',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1752,'420581','420500','宜都市','yidoushi','4','443300',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1753,'420582','420500','当阳市','dangyangshi','4','444100',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1754,'420583','420500','枝江市','zhijiangshi','4','443200',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1755,'420600','420000','襄阳市','xiangyangshi','3','441021',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1756,'420602','420600','襄城区','xiangcheng','4','441021',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1757,'420606','420600','樊城区','fancheng','4','441001',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1758,'420607','420600','襄州区','xiangzhou','4','441100',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1759,'420624','420600','南漳县','nanzhangxian','4','441500',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1760,'420625','420600','谷城县','guchengxian','4','441700',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1761,'420626','420600','保康县','baokangxian','4','441600',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1762,'420682','420600','老河口市','laohekoushi','4','441800',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1763,'420683','420600','枣阳市','zaoyangshi','4','441200',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1764,'420684','420600','宜城市','yichengshi','4','441400',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1765,'420700','420000','鄂州市','ezhoushi','3','436000',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1766,'420702','420700','梁子湖区','liangzihu','4','436064',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1767,'420703','420700','华容区','huarong','4','436030',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1768,'420704','420700','鄂城区','echeng','4','436000',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1769,'420800','420000','荆门市','jingmenshi','3','448000',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1770,'420802','420800','东宝区','dongbao','4','448004',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1771,'420804','420800','掇刀区','duodao','4','448124',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1772,'420821','420800','京山县','jingshanxian','4','431800',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1773,'420822','420800','沙洋县','shayangxian','4','448200',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1774,'420881','420800','钟祥市','zhongxiangshi','4','431900',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1775,'420900','420000','孝感市','xiaoganshi','3','432100',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1776,'420902','420900','孝南区','xiaonan','4','432100',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1777,'420921','420900','孝昌县','xiaochangxian','4','432900',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1778,'420922','420900','大悟县','dawuxian','4','432800',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1779,'420923','420900','云梦县','yunmengxian','4','432500',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1780,'420981','420900','应城市','yingchengshi','4','432400',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1781,'420982','420900','安陆市','anlushi','4','432600',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1782,'420984','420900','汉川市','hanchuanshi','4','432300',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1783,'421000','420000','荆州市','jingzhoushi','3','434000',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1784,'421002','421000','沙市区','shashi','4','434000',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1785,'421003','421000','荆州区','jingzhou','4','434020',NULL,NULL,'2017-02-14 17:05:21',NULL,NULL,NULL,0),(1786,'421022','421000','公安县','gonganxian','4','434300',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1787,'421023','421000','监利县','jianlixian','4','433300',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1788,'421024','421000','江陵县','jianglingxian','4','434101',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1789,'421081','421000','石首市','shishoushi','4','434400',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1790,'421083','421000','洪湖市','honghushi','4','433200',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1791,'421087','421000','松滋市','songzishi','4','434200',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1792,'421100','420000','黄冈市','huanggangshi','3','438000',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1793,'421102','421100','黄州区','huangzhou','4','438000',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1794,'421121','421100','团风县','tuanfengxian','4','438800',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1795,'421122','421100','红安县','honganxian','4','438401',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1796,'421123','421100','罗田县','luotianxian','4','438600',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1797,'421124','421100','英山县','yingshanxian','4','438700',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1798,'421125','421100','浠水县','xishuixian','4','438200',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1799,'421126','421100','蕲春县','qichunxian','4','435300',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1800,'421127','421100','黄梅县','huangmeixian','4','435500',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1801,'421181','421100','麻城市','machengshi','4','438300',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1802,'421182','421100','武穴市','wuxueshi','4','435400',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1803,'421200','420000','咸宁市','xianningshi','3','437000',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1804,'421202','421200','咸安区','xianan','4','437000',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1805,'421221','421200','嘉鱼县','jiayuxian','4','437200',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1806,'421222','421200','通城县','tongchengxian','4','437400',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1807,'421223','421200','崇阳县','chongyangxian','4','437500',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1808,'421224','421200','通山县','tongshanxian','4','437600',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1809,'421281','421200','赤壁市','chibishi','4','437300',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1810,'421300','420000','随州市','suizhoushi','3','441300',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1811,'421303','421300','曾都区','cengdou','4','441300',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1812,'421321','421300','随县','suixian','4','441309',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1813,'421381','421300','广水市','guangshuishi','4','432700',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1814,'422800','420000','恩施土家族苗族自治州','enshitujiazumiaozuzizhizhou','3','445000',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1815,'422801','422800','恩施市','enshishi','4','445000',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1816,'422802','422800','利川市','lichuanshi','4','445400',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1817,'422822','422800','建始县','jianshixian','4','445300',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1818,'422823','422800','巴东县','badongxian','4','444300',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1819,'422825','422800','宣恩县','xuanenxian','4','445500',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1820,'422826','422800','咸丰县','xianfengxian','4','445600',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1821,'422827','422800','来凤县','laifengxian','4','445700',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1822,'422828','422800','鹤峰县','hefengxian','4','445800',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1823,'429000','420000','直辖县级','zhixiaxianji','-1','114.298572',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1824,'429004','429000','仙桃市','xiantaoshi','4','433000',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1825,'429005','429000','潜江市','qianjiangshi','4','433100',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1826,'429006','429000','天门市','tianmenshi','4','431700',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1827,'429021','429000','神农架林区','shennongjialin','4','442400',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1828,'430000','100000','湖南省','hunansheng','2','',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1829,'430100','430000','长沙市','zhangshashi','3','410005',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1830,'430102','430100','芙蓉区','furong','4','410011',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1831,'430103','430100','天心区','tianxin','4','410004',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1832,'430104','430100','岳麓区','yuelu','4','410013',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1833,'430105','430100','开福区','kaifu','4','410008',NULL,NULL,'2017-02-14 17:05:22',NULL,NULL,NULL,0),(1834,'430111','430100','雨花区','yuhua','4','410011',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1835,'430112','430100','望城区','wangcheng','4','410200',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1836,'430121','430100','长沙县','zhangshaxian','4','410100',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1837,'430124','430100','宁乡县','ningxiangxian','4','410600',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1838,'430181','430100','浏阳市','liuyangshi','4','410300',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1839,'430200','430000','株洲市','zhuzhoushi','3','412000',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1840,'430202','430200','荷塘区','hetang','4','412000',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1841,'430203','430200','芦淞区','lusong','4','412000',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1842,'430204','430200','石峰区','shifeng','4','412005',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1843,'430211','430200','天元区','tianyuan','4','412007',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1844,'430221','430200','株洲县','zhuzhouxian','4','412100',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1845,'430223','430200','攸县','youxian','4','412300',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1846,'430224','430200','茶陵县','chalingxian','4','412400',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1847,'430225','430200','炎陵县','yanlingxian','4','412500',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1848,'430281','430200','醴陵市','lilingshi','4','412200',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1849,'430300','430000','湘潭市','xiangtanshi','3','411100',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1850,'430302','430300','雨湖区','yuhu','4','411100',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1851,'430304','430300','岳塘区','yuetang','4','411101',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1852,'430321','430300','湘潭县','xiangtanxian','4','411228',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1853,'430381','430300','湘乡市','xiangxiangshi','4','411400',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1854,'430382','430300','韶山市','shaoshanshi','4','411300',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1855,'430400','430000','衡阳市','hengyangshi','3','421001',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1856,'430405','430400','珠晖区','zhuhui','4','421002',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1857,'430406','430400','雁峰区','yanfeng','4','421001',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1858,'430407','430400','石鼓区','shigu','4','421005',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1859,'430408','430400','蒸湘区','zhengxiang','4','421001',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1860,'430412','430400','南岳区','nanyue','4','421900',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1861,'430421','430400','衡阳县','hengyangxian','4','421200',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1862,'430422','430400','衡南县','hengnanxian','4','421131',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1863,'430423','430400','衡山县','hengshanxian','4','421300',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1864,'430424','430400','衡东县','hengdongxian','4','421400',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1865,'430426','430400','祁东县','qidongxian','4','421600',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1866,'430481','430400','耒阳市','leiyangshi','4','421800',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1867,'430482','430400','常宁市','changningshi','4','421500',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1868,'430500','430000','邵阳市','shaoyangshi','3','422000',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1869,'430502','430500','双清区','shuangqing','4','422001',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1870,'430503','430500','大祥区','daxiang','4','422000',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1871,'430511','430500','北塔区','beita','4','422007',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1872,'430521','430500','邵东县','shaodongxian','4','422800',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1873,'430522','430500','新邵县','xinshaoxian','4','422900',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1874,'430523','430500','邵阳县','shaoyangxian','4','422100',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1875,'430524','430500','隆回县','longhuixian','4','422200',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1876,'430525','430500','洞口县','dongkouxian','4','422300',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1877,'430527','430500','绥宁县','suiningxian','4','422600',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1878,'430528','430500','新宁县','xinningxian','4','422700',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1879,'430529','430500','城步苗族自治县','chengbumiaozuzizhixian','4','422500',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1880,'430581','430500','武冈市','wugangshi','4','422400',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1881,'430600','430000','岳阳市','yueyangshi','3','414000',NULL,NULL,'2017-02-14 17:05:23',NULL,NULL,NULL,0),(1882,'430602','430600','岳阳楼区','yueyanglou','4','414000',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1883,'430603','430600','云溪区','yunxi','4','414009',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1884,'430611','430600','君山区','junshan','4','414005',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1885,'430621','430600','岳阳县','yueyangxian','4','414100',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1886,'430623','430600','华容县','huarongxian','4','414200',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1887,'430624','430600','湘阴县','xiangyinxian','4','414600',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1888,'430626','430600','平江县','pingjiangxian','4','414500',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1889,'430681','430600','汨罗市','miluoshi','4','414400',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1890,'430682','430600','临湘市','linxiangshi','4','414300',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1891,'430700','430000','常德市','changdeshi','3','415000',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1892,'430702','430700','武陵区','wuling','4','415000',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1893,'430703','430700','鼎城区','dingcheng','4','415101',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1894,'430721','430700','安乡县','anxiangxian','4','415600',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1895,'430722','430700','汉寿县','hanshouxian','4','415900',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1896,'430723','430700','澧县','lixian','4','415500',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1897,'430724','430700','临澧县','linlixian','4','415200',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1898,'430725','430700','桃源县','taoyuanxian','4','415700',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1899,'430726','430700','石门县','shimenxian','4','415300',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1900,'430781','430700','津市市','jinshishi','4','415400',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1901,'430800','430000','张家界市','zhangjiajieshi','3','427000',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1902,'430802','430800','永定区','yongding','4','427000',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1903,'430811','430800','武陵源区','wulingyuan','4','427400',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1904,'430821','430800','慈利县','cilixian','4','427200',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1905,'430822','430800','桑植县','sangzhixian','4','427100',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1906,'430900','430000','益阳市','yiyangshi','3','413000',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1907,'430902','430900','资阳区','ziyang','4','413001',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1908,'430903','430900','赫山区','heshan','4','413002',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1909,'430921','430900','南县','nanxian','4','413200',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1910,'430922','430900','桃江县','taojiangxian','4','413400',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1911,'430923','430900','安化县','anhuaxian','4','413500',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1912,'430981','430900','沅江市','yuanjiangshi','4','413100',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1913,'431000','430000','郴州市','chenzhoushi','3','423000',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1914,'431002','431000','北湖区','beihu','4','423000',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1915,'431003','431000','苏仙区','suxian','4','423000',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1916,'431021','431000','桂阳县','guiyangxian','4','424400',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1917,'431022','431000','宜章县','yizhangxian','4','424200',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1918,'431023','431000','永兴县','yongxingxian','4','423300',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1919,'431024','431000','嘉禾县','jiahexian','4','424500',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1920,'431025','431000','临武县','linwuxian','4','424300',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1921,'431026','431000','汝城县','ruchengxian','4','424100',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1922,'431027','431000','桂东县','guidongxian','4','423500',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1923,'431028','431000','安仁县','anrenxian','4','423600',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1924,'431081','431000','资兴市','zixingshi','4','423400',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1925,'431100','430000','永州市','yongzhoushi','3','425000',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1926,'431102','431100','零陵区','lingling','4','425100',NULL,NULL,'2017-02-14 17:05:24',NULL,NULL,NULL,0),(1927,'431103','431100','冷水滩区','lengshuitan','4','425100',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1928,'431121','431100','祁阳县','qiyangxian','4','426100',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1929,'431122','431100','东安县','donganxian','4','425900',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1930,'431123','431100','双牌县','shuangpaixian','4','425200',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1931,'431124','431100','道县','daoxian','4','425300',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1932,'431125','431100','江永县','jiangyongxian','4','425400',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1933,'431126','431100','宁远县','ningyuanxian','4','425600',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1934,'431127','431100','蓝山县','lanshanxian','4','425800',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1935,'431128','431100','新田县','xintianxian','4','425700',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1936,'431129','431100','江华瑶族自治县','jianghuayaozuzizhixian','4','425500',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1937,'431200','430000','怀化市','huaihuashi','3','418000',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1938,'431202','431200','鹤城区','hecheng','4','418000',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1939,'431221','431200','中方县','zhongfangxian','4','418005',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1940,'431222','431200','沅陵县','yuanlingxian','4','419600',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1941,'431223','431200','辰溪县','chenxixian','4','419500',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1942,'431224','431200','溆浦县','xupuxian','4','419300',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1943,'431225','431200','会同县','huitongxian','4','418300',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1944,'431226','431200','麻阳苗族自治县','mayangmiaozuzizhixian','4','419400',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1945,'431227','431200','新晃侗族自治县','xinhuangdongzuzizhixian','4','419200',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1946,'431228','431200','芷江侗族自治县','zhijiangdongzuzizhixian','4','419100',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1947,'431229','431200','靖州苗族侗族自治县','jingzhoumiaozudongzuzizhixian','4','418400',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1948,'431230','431200','通道侗族自治县','tongdaodongzuzizhixian','4','418500',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1949,'431281','431200','洪江市','hongjiangshi','4','418100',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1950,'431300','430000','娄底市','loudishi','3','417000',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1951,'431302','431300','娄星区','louxing','4','417000',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1952,'431321','431300','双峰县','shuangfengxian','4','417700',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1953,'431322','431300','新化县','xinhuaxian','4','417600',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1954,'431381','431300','冷水江市','lengshuijiangshi','4','417500',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1955,'431382','431300','涟源市','lianyuanshi','4','417100',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1956,'433100','430000','湘西土家族苗族自治州','xiangxitujiazumiaozuzizhizhou','3','416000',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1957,'433101','433100','吉首市','jishoushi','4','416000',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1958,'433122','433100','泸溪县','luxixian','4','416100',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1959,'433123','433100','凤凰县','fenghuangxian','4','416200',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1960,'433124','433100','花垣县','huayuanxian','4','416400',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1961,'433125','433100','保靖县','baojingxian','4','416500',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1962,'433126','433100','古丈县','guzhangxian','4','416300',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1963,'433127','433100','永顺县','yongshunxian','4','416700',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1964,'433130','433100','龙山县','longshanxian','4','416800',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1965,'440000','100000','广东省','guangdongsheng','2','',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1966,'440100','440000','广州市','guangzhoushi','3','510032',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1967,'440103','440100','荔湾区','liwan','4','510170',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1968,'440104','440100','越秀区','yuexiu','4','510030',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1969,'440105','440100','海珠区','haizhu','4','510300',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1970,'440106','440100','天河区','tianhe','4','510665',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1971,'440111','440100','白云区','baiyun','4','510405',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1972,'440112','440100','黄埔区','huangpu','4','510700',NULL,NULL,'2017-02-14 17:05:25',NULL,NULL,NULL,0),(1973,'440113','440100','番禺区','fanyu','4','511400',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1974,'440114','440100','花都区','huadou','4','510800',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1975,'440115','440100','南沙区','nansha','4','511458',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1976,'440117','440100','从化区','conghua','4','510900',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1977,'440118','440100','增城区','zengcheng','4','511300',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1978,'440200','440000','韶关市','shaoguanshi','3','512002',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1979,'440203','440200','武江区','wujiang','4','512026',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1980,'440204','440200','浈江区','zhenjiang','4','512023',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1981,'440205','440200','曲江区','qujiang','4','512101',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1982,'440222','440200','始兴县','shixingxian','4','512500',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1983,'440224','440200','仁化县','renhuaxian','4','512300',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1984,'440229','440200','翁源县','wengyuanxian','4','512600',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1985,'440232','440200','乳源瑶族自治县','ruyuanyaozuzizhixian','4','512700',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1986,'440233','440200','新丰县','xinfengxian','4','511100',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1987,'440281','440200','乐昌市','lechangshi','4','512200',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1988,'440282','440200','南雄市','nanxiongshi','4','512400',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1989,'440300','440000','深圳市','shenzhenshi','3','518035',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1990,'440303','440300','罗湖区','luohu','4','518021',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1991,'440304','440300','福田区','futian','4','518048',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1992,'440305','440300','南山区','nanshan','4','518051',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1993,'440306','440300','宝安区','baoan','4','518101',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1994,'440307','440300','龙岗区','longgang','4','518172',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1995,'440308','440300','盐田区','yantian','4','518081',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1996,'440309','440300','光明新区','guangmingxin','4','518100',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1997,'440310','440300','坪山新区','pingshanxin','4','518000',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1998,'440311','440300','大鹏新区','dapengxin','4','518000',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(1999,'440312','440300','龙华新区','longhuaxin','4','518100',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2000,'440400','440000','珠海市','zhuhaishi','3','519000',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2001,'440402','440400','香洲区','xiangzhou','4','519000',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2002,'440403','440400','斗门区','doumen','4','519110',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2003,'440404','440400','金湾区','jinwan','4','519040',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2004,'440500','440000','汕头市','shantoushi','3','515041',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2005,'440507','440500','龙湖区','longhu','4','515041',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2006,'440511','440500','金平区','jinping','4','515041',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2007,'440512','440500','濠江区','haojiang','4','515071',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2008,'440513','440500','潮阳区','chaoyang','4','515100',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2009,'440514','440500','潮南区','chaonan','4','515144',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2010,'440515','440500','澄海区','chenghai','4','515800',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2011,'440523','440500','南澳县','nanaoxian','4','515900',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2012,'440600','440000','佛山市','foshanshi','3','528000',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2013,'440604','440600','禅城区','shancheng','4','528000',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2014,'440605','440600','南海区','nanhai','4','528251',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2015,'440606','440600','顺德区','shunde','4','528300',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2016,'440607','440600','三水区','sanshui','4','528133',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2017,'440608','440600','高明区','gaoming','4','528500',NULL,NULL,'2017-02-14 17:05:26',NULL,NULL,NULL,0),(2018,'440700','440000','江门市','jiangmenshi','3','529000',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2019,'440703','440700','蓬江区','pengjiang','4','529000',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2020,'440704','440700','江海区','jianghai','4','529040',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2021,'440705','440700','新会区','xinhui','4','529100',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2022,'440781','440700','台山市','taishanshi','4','529200',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2023,'440783','440700','开平市','kaipingshi','4','529337',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2024,'440784','440700','鹤山市','heshanshi','4','529700',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2025,'440785','440700','恩平市','enpingshi','4','529400',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2026,'440800','440000','湛江市','zhanjiangshi','3','524047',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2027,'440802','440800','赤坎区','chikan','4','524033',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2028,'440803','440800','霞山区','xiashan','4','524011',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2029,'440804','440800','坡头区','potou','4','524057',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2030,'440811','440800','麻章区','mazhang','4','524094',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2031,'440823','440800','遂溪县','suixixian','4','524300',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2032,'440825','440800','徐闻县','xuwenxian','4','524100',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2033,'440881','440800','廉江市','lianjiangshi','4','524400',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2034,'440882','440800','雷州市','leizhoushi','4','524200',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2035,'440883','440800','吴川市','wuchuanshi','4','524500',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2036,'440900','440000','茂名市','maomingshi','3','525000',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2037,'440902','440900','茂南区','maonan','4','525000',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2038,'440904','440900','电白区','dianbai','4','525400',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2039,'440981','440900','高州市','gaozhoushi','4','525200',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2040,'440982','440900','化州市','huazhoushi','4','525100',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2041,'440983','440900','信宜市','xinyishi','4','525300',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2042,'441200','440000','肇庆市','zhaoqingshi','3','526040',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2043,'441202','441200','端州区','duanzhou','4','526060',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2044,'441203','441200','鼎湖区','dinghu','4','526070',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2045,'441223','441200','广宁县','guangningxian','4','526300',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2046,'441224','441200','怀集县','huaijixian','4','526400',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2047,'441225','441200','封开县','fengkaixian','4','526500',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2048,'441226','441200','德庆县','deqingxian','4','526600',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2049,'441283','441200','高要市','gaoyaoshi','4','526100',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2050,'441284','441200','四会市','sihuishi','4','526200',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2051,'441300','440000','惠州市','huizhoushi','3','516000',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2052,'441302','441300','惠城区','huicheng','4','516008',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2053,'441303','441300','惠阳区','huiyang','4','516211',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2054,'441322','441300','博罗县','boluoxian','4','516100',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2055,'441323','441300','惠东县','huidongxian','4','516300',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2056,'441324','441300','龙门县','longmenxian','4','516800',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2057,'441400','440000','梅州市','meizhoushi','3','514021',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2058,'441402','441400','梅江区','meijiang','4','514000',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2059,'441403','441400','梅县区','meixian','4','514787',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2060,'441422','441400','大埔县','dapuxian','4','514200',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2061,'441423','441400','丰顺县','fengshunxian','4','514300',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2062,'441424','441400','五华县','wuhuaxian','4','514400',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2063,'441426','441400','平远县','pingyuanxian','4','514600',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2064,'441427','441400','蕉岭县','jiaolingxian','4','514100',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2065,'441481','441400','兴宁市','xingningshi','4','514500',NULL,NULL,'2017-02-14 17:05:27',NULL,NULL,NULL,0),(2066,'441500','440000','汕尾市','shanweishi','3','516600',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2067,'441502','441500','城区','cheng','4','516600',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2068,'441521','441500','海丰县','haifengxian','4','516400',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2069,'441523','441500','陆河县','luhexian','4','516700',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2070,'441581','441500','陆丰市','lufengshi','4','516500',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2071,'441600','440000','河源市','heyuanshi','3','517000',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2072,'441602','441600','源城区','yuancheng','4','517000',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2073,'441621','441600','紫金县','zijinxian','4','517400',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2074,'441622','441600','龙川县','longchuanxian','4','517300',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2075,'441623','441600','连平县','lianpingxian','4','517100',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2076,'441624','441600','和平县','hepingxian','4','517200',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2077,'441625','441600','东源县','dongyuanxian','4','517583',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2078,'441700','440000','阳江市','yangjiangshi','3','529500',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2079,'441702','441700','江城区','jiangcheng','4','529500',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2080,'441704','441700','阳东区','yangdong','4','529900',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2081,'441721','441700','阳西县','yangxixian','4','529800',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2082,'441781','441700','阳春市','yangchunshi','4','529600',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2083,'441800','440000','清远市','qingyuanshi','3','511500',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2084,'441802','441800','清城区','qingcheng','4','511515',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2085,'441803','441800','清新区','qingxin','4','511810',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2086,'441821','441800','佛冈县','fogangxian','4','511600',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2087,'441823','441800','阳山县','yangshanxian','4','513100',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2088,'441825','441800','连山壮族瑶族自治县','lianshanzhuangzuyaozuzizhixian','4','513200',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2089,'441826','441800','连南瑶族自治县','liannanyaozuzizhixian','4','513300',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2090,'441881','441800','英德市','yingdeshi','4','513000',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2091,'441882','441800','连州市','lianzhoushi','4','513400',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2092,'441900','440000','东莞市','dongguanshi','3','523888',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2093,'441901','441900','莞城区','guancheng','4','523128',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2094,'441902','441900','南城区','nancheng','4','523617',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2095,'441904','441900','万江区','wanjiang','4','523039',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2096,'441905','441900','石碣镇','shijiezhen','4','523290',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2097,'441906','441900','石龙镇','shilongzhen','4','523326',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2098,'441907','441900','茶山镇','chashanzhen','4','523380',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2099,'441908','441900','石排镇','shipaizhen','4','523346',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2100,'441909','441900','企石镇','qishizhen','4','523507',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2101,'441910','441900','横沥镇','henglizhen','4','523471',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2102,'441911','441900','桥头镇','qiaotouzhen','4','523520',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2103,'441912','441900','谢岗镇','xiegangzhen','4','523592',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2104,'441913','441900','东坑镇','dongkengzhen','4','523451',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2105,'441914','441900','常平镇','changpingzhen','4','523560',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2106,'441915','441900','寮步镇','liaobuzhen','4','523411',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2107,'441916','441900','大朗镇','dalangzhen','4','523770',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2108,'441917','441900','麻涌镇','mayongzhen','4','523143',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2109,'441918','441900','中堂镇','zhongtangzhen','4','523233',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2110,'441919','441900','高埗镇','gaobuzhen','4','523282',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2111,'441920','441900','樟木头镇','zhangmutouzhen','4','523619',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2112,'441921','441900','大岭山镇','dalingshanzhen','4','523835',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2113,'441922','441900','望牛墩镇','wangniudunzhen','4','523203',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2114,'441923','441900','黄江镇','huangjiangzhen','4','523755',NULL,NULL,'2017-02-14 17:05:28',NULL,NULL,NULL,0),(2115,'441924','441900','洪梅镇','hongmeizhen','4','523163',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2116,'441925','441900','清溪镇','qingxizhen','4','523660',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2117,'441926','441900','沙田镇','shatianzhen','4','523988',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2118,'441927','441900','道滘镇','daojiaozhen','4','523171',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2119,'441928','441900','塘厦镇','tangshazhen','4','523713',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2120,'441929','441900','虎门镇','humenzhen','4','523932',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2121,'441930','441900','厚街镇','houjiezhen','4','523960',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2122,'441931','441900','凤岗镇','fenggangzhen','4','523690',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2123,'441932','441900','长安镇','zhanganzhen','4','523850',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2124,'442000','440000','中山市','zhongshanshi','3','528403',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2125,'442001','442000','石岐区','shiqi','4','528400',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2126,'442004','442000','南区','nan','4','528400',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2127,'442005','442000','五桂山区','wuguishan','4','528458',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2128,'442006','442000','火炬开发区','huojukaifa','4','528437',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2129,'442007','442000','黄圃镇','huangpuzhen','4','528429',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2130,'442008','442000','南头镇','nantouzhen','4','528421',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2131,'442009','442000','东凤镇','dongfengzhen','4','528425',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2132,'442010','442000','阜沙镇','fushazhen','4','528434',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2133,'442011','442000','小榄镇','xiaolanzhen','4','528415',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2134,'442012','442000','东升镇','dongshengzhen','4','528400',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2135,'442013','442000','古镇镇','guzhenzhen','4','528422',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2136,'442014','442000','横栏镇','henglanzhen','4','528478',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2137,'442015','442000','三角镇','sanjiaozhen','4','528422',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2138,'442016','442000','民众镇','minzhongzhen','4','528441',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2139,'442017','442000','南朗镇','nanlangzhen','4','528454',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2140,'442018','442000','港口镇','gangkouzhen','4','528447',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2141,'442019','442000','大涌镇','dayongzhen','4','528476',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2142,'442020','442000','沙溪镇','shaxizhen','4','528471',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2143,'442021','442000','三乡镇','sanxiangzhen','4','528463',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2144,'442022','442000','板芙镇','banfuzhen','4','528459',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2145,'442023','442000','神湾镇','shenwanzhen','4','528462',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2146,'442024','442000','坦洲镇','tanzhouzhen','4','528467',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2147,'445100','440000','潮州市','chaozhoushi','3','521000',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2148,'445102','445100','湘桥区','xiangqiao','4','521000',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2149,'445103','445100','潮安区','chaoan','4','515638',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2150,'445122','445100','饶平县','raopingxian','4','515700',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2151,'445200','440000','揭阳市','jieyangshi','3','522000',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2152,'445202','445200','榕城区','rongcheng','4','522000',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2153,'445203','445200','揭东区','jiedong','4','515500',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2154,'445222','445200','揭西县','jiexixian','4','515400',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2155,'445224','445200','惠来县','huilaixian','4','515200',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2156,'445281','445200','普宁市','puningshi','4','515300',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2157,'445300','440000','云浮市','yunfushi','3','527300',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2158,'445302','445300','云城区','yuncheng','4','527300',NULL,NULL,'2017-02-14 17:05:29',NULL,NULL,NULL,0),(2159,'445303','445300','云安区','yunan','4','527500',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2160,'445321','445300','新兴县','xinxingxian','4','527400',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2161,'445322','445300','郁南县','yunanxian','4','527100',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2162,'445381','445300','罗定市','luodingshi','4','527200',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2163,'450000','100000','广西壮族自治区','guangxizhuangzuzizhi','2','',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2164,'450100','450000','南宁市','nanningshi','3','530028',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2165,'450102','450100','兴宁区','xingning','4','530023',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2166,'450103','450100','青秀区','qingxiu','4','530213',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2167,'450105','450100','江南区','jiangnan','4','530031',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2168,'450107','450100','西乡塘区','xixiangtang','4','530001',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2169,'450108','450100','良庆区','liangqing','4','530219',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2170,'450109','450100','邕宁区','yongning','4','530200',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2171,'450122','450100','武鸣县','wumingxian','4','530100',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2172,'450123','450100','隆安县','longanxian','4','532700',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2173,'450124','450100','马山县','mashanxian','4','530600',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2174,'450125','450100','上林县','shanglinxian','4','530500',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2175,'450126','450100','宾阳县','binyangxian','4','530400',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2176,'450127','450100','横县','hengxian','4','530300',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2177,'450128','450100','埌东新区','langdongxin','4','530000',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2178,'450200','450000','柳州市','liuzhoushi','3','545001',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2179,'450202','450200','城中区','chengzhong','4','545001',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2180,'450203','450200','鱼峰区','yufeng','4','545005',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2181,'450204','450200','柳南区','liunan','4','545007',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2182,'450205','450200','柳北区','liubei','4','545002',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2183,'450221','450200','柳江县','liujiangxian','4','545100',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2184,'450222','450200','柳城县','liuchengxian','4','545200',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2185,'450223','450200','鹿寨县','luzhaixian','4','545600',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2186,'450224','450200','融安县','ronganxian','4','545400',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2187,'450225','450200','融水苗族自治县','rongshuimiaozuzizhixian','4','545300',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2188,'450226','450200','三江侗族自治县','sanjiangdongzuzizhixian','4','545500',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2189,'450227','450200','柳东新区','liudongxin','4','545000',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2190,'450300','450000','桂林市','guilinshi','3','541100',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2191,'450302','450300','秀峰区','xiufeng','4','541001',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2192,'450303','450300','叠彩区','diecai','4','541001',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2193,'450304','450300','象山区','xiangshan','4','541002',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2194,'450305','450300','七星区','qixing','4','541004',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2195,'450311','450300','雁山区','yanshan','4','541006',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2196,'450312','450300','临桂区','lingui','4','541100',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2197,'450321','450300','阳朔县','yangshuoxian','4','541900',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2198,'450323','450300','灵川县','lingchuanxian','4','541200',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2199,'450324','450300','全州县','quanzhouxian','4','541503',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2200,'450325','450300','兴安县','xinganxian','4','541300',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2201,'450326','450300','永福县','yongfuxian','4','541800',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2202,'450327','450300','灌阳县','guanyangxian','4','541600',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2203,'450328','450300','龙胜各族自治县','longshenggezuzizhixian','4','541700',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2204,'450329','450300','资源县','ziyuanxian','4','541400',NULL,NULL,'2017-02-14 17:05:30',NULL,NULL,NULL,0),(2205,'450330','450300','平乐县','pinglexian','4','542400',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2206,'450331','450300','荔浦县','lipuxian','4','546600',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2207,'450332','450300','恭城瑶族自治县','gongchengyaozuzizhixian','4','542500',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2208,'450400','450000','梧州市','wuzhoushi','3','543002',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2209,'450403','450400','万秀区','wanxiu','4','543000',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2210,'450405','450400','长洲区','zhangzhou','4','543003',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2211,'450406','450400','龙圩区','longwei','4','543002',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2212,'450421','450400','苍梧县','cangwuxian','4','543100',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2213,'450422','450400','藤县','tengxian','4','543300',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2214,'450423','450400','蒙山县','mengshanxian','4','546700',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2215,'450481','450400','岑溪市','cenxishi','4','543200',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2216,'450500','450000','北海市','beihaishi','3','536000',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2217,'450502','450500','海城区','haicheng','4','536000',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2218,'450503','450500','银海区','yinhai','4','536000',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2219,'450512','450500','铁山港区','tieshangang','4','536017',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2220,'450521','450500','合浦县','hepuxian','4','536100',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2221,'450600','450000','防城港市','fangchenggangshi','3','538001',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2222,'450602','450600','港口区','gangkou','4','538001',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2223,'450603','450600','防城区','fangcheng','4','538021',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2224,'450621','450600','上思县','shangsixian','4','535500',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2225,'450681','450600','东兴市','dongxingshi','4','538100',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2226,'450700','450000','钦州市','qinzhoushi','3','535099',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2227,'450702','450700','钦南区','qinnan','4','535099',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2228,'450703','450700','钦北区','qinbei','4','535099',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2229,'450721','450700','灵山县','lingshanxian','4','535099',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2230,'450722','450700','浦北县','pubeixian','4','535099',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2231,'450800','450000','贵港市','guigangshi','3','537100',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2232,'450802','450800','港北区','gangbei','4','537100',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2233,'450803','450800','港南区','gangnan','4','537100',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2234,'450804','450800','覃塘区','tantang','4','537121',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2235,'450821','450800','平南县','pingnanxian','4','537300',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2236,'450881','450800','桂平市','guipingshi','4','537200',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2237,'450900','450000','玉林市','yulinshi','3','537000',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2238,'450902','450900','玉州区','yuzhou','4','537000',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2239,'450903','450900','福绵区','fumian','4','537023',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2240,'450904','450900','玉东新区','yudongxin','4','537000',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2241,'450921','450900','容县','rongxian','4','537500',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2242,'450922','450900','陆川县','luchuanxian','4','537700',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2243,'450923','450900','博白县','bobaixian','4','537600',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2244,'450924','450900','兴业县','xingyexian','4','537800',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2245,'450981','450900','北流市','beiliushi','4','537400',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2246,'451000','450000','百色市','baiseshi','3','533000',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2247,'451002','451000','右江区','youjiang','4','533000',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2248,'451021','451000','田阳县','tianyangxian','4','533600',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2249,'451022','451000','田东县','tiandongxian','4','531500',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2250,'451023','451000','平果县','pingguoxian','4','531400',NULL,NULL,'2017-02-14 17:05:31',NULL,NULL,NULL,0),(2251,'451024','451000','德保县','debaoxian','4','533700',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2252,'451025','451000','靖西县','jingxixian','4','533800',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2253,'451026','451000','那坡县','neipoxian','4','533900',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2254,'451027','451000','凌云县','lingyunxian','4','533100',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2255,'451028','451000','乐业县','leyexian','4','533200',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2256,'451029','451000','田林县','tianlinxian','4','533300',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2257,'451030','451000','西林县','xilinxian','4','533500',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2258,'451031','451000','隆林各族自治县','longlingezuzizhixian','4','533400',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2259,'451100','450000','贺州市','hezhoushi','3','542800',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2260,'451102','451100','八步区','babu','4','542800',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2261,'451121','451100','昭平县','zhaopingxian','4','546800',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2262,'451122','451100','钟山县','zhongshanxian','4','542600',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2263,'451123','451100','富川瑶族自治县','fuchuanyaozuzizhixian','4','542700',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2264,'451124','451100','平桂管理区','pingguiguanli','4','542800',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2265,'451200','450000','河池市','hechishi','3','547000',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2266,'451202','451200','金城江区','jinchengjiang','4','547000',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2267,'451221','451200','南丹县','nandanxian','4','547200',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2268,'451222','451200','天峨县','tianexian','4','547300',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2269,'451223','451200','凤山县','fengshanxian','4','547600',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2270,'451224','451200','东兰县','donglanxian','4','547400',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2271,'451225','451200','罗城仫佬族自治县','luochengmulaozuzizhixian','4','546400',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2272,'451226','451200','环江毛南族自治县','huanjiangmaonanzuzizhixian','4','547100',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2273,'451227','451200','巴马瑶族自治县','bamayaozuzizhixian','4','547500',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2274,'451228','451200','都安瑶族自治县','douanyaozuzizhixian','4','530700',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2275,'451229','451200','大化瑶族自治县','dahuayaozuzizhixian','4','530800',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2276,'451281','451200','宜州市','yizhoushi','4','546300',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2277,'451300','450000','来宾市','laibinshi','3','546100',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2278,'451302','451300','兴宾区','xingbin','4','546100',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2279,'451321','451300','忻城县','xinchengxian','4','546200',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2280,'451322','451300','象州县','xiangzhouxian','4','545800',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2281,'451323','451300','武宣县','wuxuanxian','4','545900',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2282,'451324','451300','金秀瑶族自治县','jinxiuyaozuzizhixian','4','545799',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2283,'451381','451300','合山市','heshanshi','4','546500',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2284,'451400','450000','崇左市','chongzuoshi','3','532299',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2285,'451402','451400','江州区','jiangzhou','4','532299',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2286,'451421','451400','扶绥县','fusuixian','4','532199',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2287,'451422','451400','宁明县','ningmingxian','4','532599',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2288,'451423','451400','龙州县','longzhouxian','4','532499',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2289,'451424','451400','大新县','daxinxian','4','532399',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2290,'451425','451400','天等县','tiandengxian','4','532899',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2291,'451481','451400','凭祥市','pingxiangshi','4','532699',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2292,'460000','100000','海南省','hainansheng','2','',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2293,'460100','460000','海口市','haikoushi','3','570000',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2294,'460105','460100','秀英区','xiuying','4','570311',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2295,'460106','460100','龙华区','longhua','4','570145',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2296,'460107','460100','琼山区','qiongshan','4','571100',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2297,'460108','460100','美兰区','meilan','4','570203',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2298,'460200','460000','三亚市','sanyashi','3','572000',NULL,NULL,'2017-02-14 17:05:32',NULL,NULL,NULL,0),(2299,'460202','460200','海棠区','haitang','4','572000',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2300,'460203','460200','吉阳区','jiyang','4','572000',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2301,'460204','460200','天涯区','tianya','4','572000',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2302,'460205','460200','崖州区','yazhou','4','572000',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2303,'460300','460000','三沙市','sanshashi','3','573199',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2304,'460321','460300','西沙群岛','xishaqundao','4','572000',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2305,'460322','460300','南沙群岛','nanshaqundao','4','573100',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2306,'460323','460300','中沙群岛','zhongshaqundao','4','573100',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2307,'469000','460000','直辖县级','zhixiaxianji','-1','109.503479',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2308,'469001','469000','五指山市','wuzhishanshi','4','572200',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2309,'469002','469000','琼海市','qionghaishi','4','571400',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2310,'469003','469000','儋州市','danzhoushi','4','571700',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2311,'469005','469000','文昌市','wenchangshi','4','571339',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2312,'469006','469000','万宁市','wanningshi','4','571500',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2313,'469007','469000','东方市','dongfangshi','4','572600',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2314,'469021','469000','定安县','dinganxian','4','571200',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2315,'469022','469000','屯昌县','tunchangxian','4','571600',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2316,'469023','469000','澄迈县','chengmaixian','4','571900',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2317,'469024','469000','临高县','lingaoxian','4','571800',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2318,'469025','469000','白沙黎族自治县','baishalizuzizhixian','4','572800',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2319,'469026','469000','昌江黎族自治县','changjianglizuzizhixian','4','572700',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2320,'469027','469000','乐东黎族自治县','ledonglizuzizhixian','4','572500',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2321,'469028','469000','陵水黎族自治县','lingshuilizuzizhixian','4','572400',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2322,'469029','469000','保亭黎族苗族自治县','baotinglizumiaozuzizhixian','4','572300',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2323,'469030','469000','琼中黎族苗族自治县','qiongzhonglizumiaozuzizhixian','4','572900',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2324,'500000','100000','重庆','zhongqing','2','',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2325,'500100','500000','重庆市','zhongqingshi','3','400000',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2326,'500101','500100','万州区','wanzhou','4','404000',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2327,'500102','500100','涪陵区','fuling','4','408000',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2328,'500103','500100','渝中区','yuzhong','4','400010',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2329,'500104','500100','大渡口区','dadukou','4','400080',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2330,'500105','500100','江北区','jiangbei','4','400020',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2331,'500106','500100','沙坪坝区','shapingba','4','400030',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2332,'500107','500100','九龙坡区','jiulongpo','4','400050',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2333,'500108','500100','南岸区','nanan','4','400064',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2334,'500109','500100','北碚区','beibei','4','400700',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2335,'500110','500100','綦江区','qijiang','4','400800',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2336,'500111','500100','大足区','dazu','4','400900',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2337,'500112','500100','渝北区','yubei','4','401120',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2338,'500113','500100','巴南区','banan','4','401320',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2339,'500114','500100','黔江区','qianjiang','4','409700',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2340,'500115','500100','长寿区','zhangshou','4','401220',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2341,'500116','500100','江津区','jiangjin','4','402260',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2342,'500117','500100','合川区','hechuan','4','401520',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2343,'500118','500100','永川区','yongchuan','4','402160',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2344,'500119','500100','南川区','nanchuan','4','408400',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2345,'500120','500100','璧山区','bishan','4','402760',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2346,'500151','500100','铜梁区','tongliang','4','402560',NULL,NULL,'2017-02-14 17:05:33',NULL,NULL,NULL,0),(2347,'500223','500100','潼南县','tongnanxian','4','402660',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2348,'500226','500100','荣昌县','rongchangxian','4','402460',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2349,'500228','500100','梁平县','liangpingxian','4','405200',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2350,'500229','500100','城口县','chengkouxian','4','405900',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2351,'500230','500100','丰都县','fengdouxian','4','408200',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2352,'500231','500100','垫江县','dianjiangxian','4','408300',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2353,'500232','500100','武隆县','wulongxian','4','408500',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2354,'500233','500100','忠县','zhongxian','4','404300',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2355,'500234','500100','开县','kaixian','4','405400',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2356,'500235','500100','云阳县','yunyangxian','4','404500',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2357,'500236','500100','奉节县','fengjiexian','4','404600',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2358,'500237','500100','巫山县','wushanxian','4','404700',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2359,'500238','500100','巫溪县','wuxixian','4','405800',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2360,'500240','500100','石柱土家族自治县','shizhutujiazuzizhixian','4','409100',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2361,'500241','500100','秀山土家族苗族自治县','xiushantujiazumiaozuzizhixian','4','409900',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2362,'500242','500100','酉阳土家族苗族自治县','youyangtujiazumiaozuzizhixian','4','409800',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2363,'500243','500100','彭水苗族土家族自治县','pengshuimiaozutujiazuzizhixian','4','409600',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2364,'500300','500000','两江新区','liangjiangxin','3','400000',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2365,'500301','500300','北部新区','beibuxin','4','400000',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2366,'500302','500300','保税港区','baoshuigang','4','400000',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2367,'500303','500300','工业园区','gongyeyuan','4','400000',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2368,'510000','100000','四川省','sichuansheng','2','',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2369,'510100','510000','成都市','chengdoushi','3','610015',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2370,'510104','510100','锦江区','jinjiang','4','610021',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2371,'510105','510100','青羊区','qingyang','4','610031',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2372,'510106','510100','金牛区','jinniu','4','610036',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2373,'510107','510100','武侯区','wuhou','4','610041',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2374,'510108','510100','成华区','chenghua','4','610066',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2375,'510112','510100','龙泉驿区','longquanyi','4','610100',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2376,'510113','510100','青白江区','qingbaijiang','4','610300',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2377,'510114','510100','新都区','xindou','4','610500',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2378,'510115','510100','温江区','wenjiang','4','611130',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2379,'510121','510100','金堂县','jintangxian','4','610400',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2380,'510122','510100','双流县','shuangliuxian','4','610200',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2381,'510124','510100','郫县','pixian','4','611730',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2382,'510129','510100','大邑县','dayixian','4','611330',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2383,'510131','510100','蒲江县','pujiangxian','4','611630',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2384,'510132','510100','新津县','xinjinxian','4','611430',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2385,'510181','510100','都江堰市','doujiangyanshi','4','611830',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2386,'510182','510100','彭州市','pengzhoushi','4','611930',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2387,'510183','510100','邛崃市','qionglaishi','4','611530',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2388,'510184','510100','崇州市','chongzhoushi','4','611230',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2389,'510300','510000','自贡市','zigongshi','3','643000',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2390,'510302','510300','自流井区','ziliujing','4','643000',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2391,'510303','510300','贡井区','gongjing','4','643020',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2392,'510304','510300','大安区','daan','4','643010',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2393,'510311','510300','沿滩区','yantan','4','643030',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2394,'510321','510300','荣县','rongxian','4','643100',NULL,NULL,'2017-02-14 17:05:34',NULL,NULL,NULL,0),(2395,'510322','510300','富顺县','fushunxian','4','643200',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2396,'510400','510000','攀枝花市','panzhihuashi','3','617000',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2397,'510402','510400','东区','dong','4','617067',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2398,'510403','510400','西区','xi','4','617068',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2399,'510411','510400','仁和区','renhe','4','617061',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2400,'510421','510400','米易县','miyixian','4','617200',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2401,'510422','510400','盐边县','yanbianxian','4','617100',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2402,'510500','510000','泸州市','luzhoushi','3','646000',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2403,'510502','510500','江阳区','jiangyang','4','646000',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2404,'510503','510500','纳溪区','naxi','4','646300',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2405,'510504','510500','龙马潭区','longmatan','4','646000',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2406,'510521','510500','泸县','luxian','4','646106',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2407,'510522','510500','合江县','hejiangxian','4','646200',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2408,'510524','510500','叙永县','xuyongxian','4','646400',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2409,'510525','510500','古蔺县','gulinxian','4','646500',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2410,'510600','510000','德阳市','deyangshi','3','618000',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2411,'510603','510600','旌阳区','jingyang','4','618000',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2412,'510623','510600','中江县','zhongjiangxian','4','618100',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2413,'510626','510600','罗江县','luojiangxian','4','618500',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2414,'510681','510600','广汉市','guanghanshi','4','618300',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2415,'510682','510600','什邡市','shenfangshi','4','618400',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2416,'510683','510600','绵竹市','mianzhushi','4','618200',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2417,'510700','510000','绵阳市','mianyangshi','3','621000',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2418,'510703','510700','涪城区','fucheng','4','621000',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2419,'510704','510700','游仙区','youxian','4','621022',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2420,'510722','510700','三台县','santaixian','4','621100',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2421,'510723','510700','盐亭县','yantingxian','4','621600',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2422,'510724','510700','安县','anxian','4','622650',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2423,'510725','510700','梓潼县','zitongxian','4','622150',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2424,'510726','510700','北川羌族自治县','beichuanqiangzuzizhixian','4','622750',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2425,'510727','510700','平武县','pingwuxian','4','622550',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2426,'510781','510700','江油市','jiangyoushi','4','621700',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2427,'510800','510000','广元市','guangyuanshi','3','628000',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2428,'510802','510800','利州区','lizhou','4','628017',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2429,'510811','510800','昭化区','zhaohua','4','628017',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2430,'510812','510800','朝天区','chaotian','4','628017',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2431,'510821','510800','旺苍县','wangcangxian','4','628200',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2432,'510822','510800','青川县','qingchuanxian','4','628100',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2433,'510823','510800','剑阁县','jiangexian','4','628300',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2434,'510824','510800','苍溪县','cangxixian','4','628400',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2435,'510900','510000','遂宁市','suiningshi','3','629000',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2436,'510903','510900','船山区','chuanshan','4','629000',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2437,'510904','510900','安居区','anju','4','629000',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2438,'510921','510900','蓬溪县','pengxixian','4','629100',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2439,'510922','510900','射洪县','shehongxian','4','629200',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2440,'510923','510900','大英县','dayingxian','4','629300',NULL,NULL,'2017-02-14 17:05:35',NULL,NULL,NULL,0),(2441,'511000','510000','内江市','neijiangshi','3','641000',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2442,'511002','511000','市中区','shizhong','4','641000',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2443,'511011','511000','东兴区','dongxing','4','641100',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2444,'511024','511000','威远县','weiyuanxian','4','642450',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2445,'511025','511000','资中县','zizhongxian','4','641200',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2446,'511028','511000','隆昌县','longchangxian','4','642150',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2447,'511100','510000','乐山市','leshanshi','3','614000',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2448,'511102','511100','市中区','shizhong','4','614000',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2449,'511111','511100','沙湾区','shawan','4','614900',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2450,'511112','511100','五通桥区','wutongqiao','4','614800',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2451,'511113','511100','金口河区','jinkouhe','4','614700',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2452,'511123','511100','犍为县','jianweixian','4','614400',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2453,'511124','511100','井研县','jingyanxian','4','613100',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2454,'511126','511100','夹江县','jiajiangxian','4','614100',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2455,'511129','511100','沐川县','muchuanxian','4','614500',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2456,'511132','511100','峨边彝族自治县','ebianyizuzizhixian','4','614300',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2457,'511133','511100','马边彝族自治县','mabianyizuzizhixian','4','614600',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2458,'511181','511100','峨眉山市','emeishanshi','4','614200',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2459,'511300','510000','南充市','nanchongshi','3','637000',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2460,'511302','511300','顺庆区','shunqing','4','637000',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2461,'511303','511300','高坪区','gaoping','4','637100',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2462,'511304','511300','嘉陵区','jialing','4','637100',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2463,'511321','511300','南部县','nanbuxian','4','637300',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2464,'511322','511300','营山县','yingshanxian','4','637700',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2465,'511323','511300','蓬安县','penganxian','4','637800',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2466,'511324','511300','仪陇县','yilongxian','4','637600',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2467,'511325','511300','西充县','xichongxian','4','637200',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2468,'511381','511300','阆中市','langzhongshi','4','637400',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2469,'511400','510000','眉山市','meishanshi','3','620020',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2470,'511402','511400','东坡区','dongpo','4','620010',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2471,'511403','511400','彭山区','pengshan','4','620860',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2472,'511421','511400','仁寿县','renshouxian','4','620500',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2473,'511423','511400','洪雅县','hongyaxian','4','620360',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2474,'511424','511400','丹棱县','danlengxian','4','620200',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2475,'511425','511400','青神县','qingshenxian','4','620460',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2476,'511500','510000','宜宾市','yibinshi','3','644000',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2477,'511502','511500','翠屏区','cuiping','4','644000',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2478,'511503','511500','南溪区','nanxi','4','644100',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2479,'511521','511500','宜宾县','yibinxian','4','644600',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2480,'511523','511500','江安县','jianganxian','4','644200',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2481,'511524','511500','长宁县','zhangningxian','4','644300',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2482,'511525','511500','高县','gaoxian','4','645150',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2483,'511526','511500','珙县','gongxian','4','644500',NULL,NULL,'2017-02-14 17:05:36',NULL,NULL,NULL,0),(2484,'511527','511500','筠连县','yunlianxian','4','645250',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2485,'511528','511500','兴文县','xingwenxian','4','644400',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2486,'511529','511500','屏山县','pingshanxian','4','645350',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2487,'511600','510000','广安市','guanganshi','3','638000',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2488,'511602','511600','广安区','guangan','4','638000',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2489,'511603','511600','前锋区','qianfeng','4','638019',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2490,'511621','511600','岳池县','yuechixian','4','638300',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2491,'511622','511600','武胜县','wushengxian','4','638400',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2492,'511623','511600','邻水县','linshuixian','4','638500',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2493,'511681','511600','华蓥市','huayingshi','4','638600',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2494,'511700','510000','达州市','dazhoushi','3','635000',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2495,'511702','511700','通川区','tongchuan','4','635000',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2496,'511703','511700','达川区','dachuan','4','635000',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2497,'511722','511700','宣汉县','xuanhanxian','4','636150',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2498,'511723','511700','开江县','kaijiangxian','4','636250',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2499,'511724','511700','大竹县','dazhuxian','4','635100',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2500,'511725','511700','渠县','quxian','4','635200',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2501,'511781','511700','万源市','wanyuanshi','4','636350',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2502,'511800','510000','雅安市','yaanshi','3','625000',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2503,'511802','511800','雨城区','yucheng','4','625000',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2504,'511803','511800','名山区','mingshan','4','625100',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2505,'511822','511800','荥经县','yingjingxian','4','625200',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2506,'511823','511800','汉源县','hanyuanxian','4','625300',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2507,'511824','511800','石棉县','shimianxian','4','625400',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2508,'511825','511800','天全县','tianquanxian','4','625500',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2509,'511826','511800','芦山县','lushanxian','4','625600',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2510,'511827','511800','宝兴县','baoxingxian','4','625700',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2511,'511900','510000','巴中市','bazhongshi','3','636000',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2512,'511902','511900','巴州区','bazhou','4','636001',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2513,'511903','511900','恩阳区','enyang','4','636064',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2514,'511921','511900','通江县','tongjiangxian','4','636700',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2515,'511922','511900','南江县','nanjiangxian','4','636600',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2516,'511923','511900','平昌县','pingchangxian','4','636400',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2517,'512000','510000','资阳市','ziyangshi','3','641300',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2518,'512002','512000','雁江区','yanjiang','4','641300',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2519,'512021','512000','安岳县','anyuexian','4','642350',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2520,'512022','512000','乐至县','lezhixian','4','641500',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2521,'512081','512000','简阳市','jianyangshi','4','641400',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2522,'513200','510000','阿坝藏族羌族自治州','abazangzuqiangzuzizhizhou','3','624000',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2523,'513221','513200','汶川县','wenchuanxian','4','623000',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2524,'513222','513200','理县','lixian','4','623100',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2525,'513223','513200','茂县','maoxian','4','623200',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2526,'513224','513200','松潘县','songpanxian','4','623300',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2527,'513225','513200','九寨沟县','jiuzhaigouxian','4','623400',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2528,'513226','513200','金川县','jinchuanxian','4','624100',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2529,'513227','513200','小金县','xiaojinxian','4','624200',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2530,'513228','513200','黑水县','heishuixian','4','623500',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2531,'513229','513200','马尔康县','maerkangxian','4','624000',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2532,'513230','513200','壤塘县','rangtangxian','4','624300',NULL,NULL,'2017-02-14 17:05:37',NULL,NULL,NULL,0),(2533,'513231','513200','阿坝县','abaxian','4','624600',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2534,'513232','513200','若尔盖县','ruoergaixian','4','624500',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2535,'513233','513200','红原县','hongyuanxian','4','624400',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2536,'513300','510000','甘孜藏族自治州','ganzizangzuzizhizhou','3','626000',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2537,'513321','513300','康定县','kangdingxian','4','626000',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2538,'513322','513300','泸定县','ludingxian','4','626100',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2539,'513323','513300','丹巴县','danbaxian','4','626300',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2540,'513324','513300','九龙县','jiulongxian','4','626200',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2541,'513325','513300','雅江县','yajiangxian','4','627450',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2542,'513326','513300','道孚县','daofuxian','4','626400',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2543,'513327','513300','炉霍县','luhuoxian','4','626500',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2544,'513328','513300','甘孜县','ganzixian','4','626700',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2545,'513329','513300','新龙县','xinlongxian','4','626800',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2546,'513330','513300','德格县','degexian','4','627250',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2547,'513331','513300','白玉县','baiyuxian','4','627150',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2548,'513332','513300','石渠县','shiquxian','4','627350',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2549,'513333','513300','色达县','sedaxian','4','626600',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2550,'513334','513300','理塘县','litangxian','4','627550',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2551,'513335','513300','巴塘县','batangxian','4','627650',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2552,'513336','513300','乡城县','xiangchengxian','4','627850',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2553,'513337','513300','稻城县','daochengxian','4','627750',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2554,'513338','513300','得荣县','derongxian','4','627950',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2555,'513400','510000','凉山彝族自治州','liangshanyizuzizhizhou','3','615000',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2556,'513401','513400','西昌市','xichangshi','4','615000',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2557,'513422','513400','木里藏族自治县','mulizangzuzizhixian','4','615800',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2558,'513423','513400','盐源县','yanyuanxian','4','615700',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2559,'513424','513400','德昌县','dechangxian','4','615500',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2560,'513425','513400','会理县','huilixian','4','615100',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2561,'513426','513400','会东县','huidongxian','4','615200',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2562,'513427','513400','宁南县','ningnanxian','4','615400',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2563,'513428','513400','普格县','pugexian','4','615300',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2564,'513429','513400','布拖县','butuoxian','4','616350',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2565,'513430','513400','金阳县','jinyangxian','4','616250',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2566,'513431','513400','昭觉县','zhaojuexian','4','616150',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2567,'513432','513400','喜德县','xidexian','4','616750',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2568,'513433','513400','冕宁县','mianningxian','4','615600',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2569,'513434','513400','越西县','yuexixian','4','616650',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2570,'513435','513400','甘洛县','ganluoxian','4','616850',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2571,'513436','513400','美姑县','meiguxian','4','616450',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2572,'513437','513400','雷波县','leiboxian','4','616550',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2573,'520000','100000','贵州省','guizhousheng','2','',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2574,'520100','520000','贵阳市','guiyangshi','3','550001',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2575,'520102','520100','南明区','nanming','4','550001',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2576,'520103','520100','云岩区','yunyan','4','550001',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2577,'520111','520100','花溪区','huaxi','4','550025',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2578,'520112','520100','乌当区','wudang','4','550018',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2579,'520113','520100','白云区','baiyun','4','550014',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2580,'520115','520100','观山湖区','guanshanhu','4','550009',NULL,NULL,'2017-02-14 17:05:38',NULL,NULL,NULL,0),(2581,'520121','520100','开阳县','kaiyangxian','4','550300',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2582,'520122','520100','息烽县','xifengxian','4','551100',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2583,'520123','520100','修文县','xiuwenxian','4','550200',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2584,'520181','520100','清镇市','qingzhenshi','4','551400',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2585,'520200','520000','六盘水市','liupanshuishi','3','553400',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2586,'520201','520200','钟山区','zhongshan','4','553000',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2587,'520203','520200','六枝特区','liuzhite','4','553400',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2588,'520221','520200','水城县','shuichengxian','4','553000',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2589,'520222','520200','盘县','panxian','4','561601',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2590,'520300','520000','遵义市','zunyishi','3','563000',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2591,'520302','520300','红花岗区','honghuagang','4','563000',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2592,'520303','520300','汇川区','huichuan','4','563000',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2593,'520321','520300','遵义县','zunyixian','4','563100',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2594,'520322','520300','桐梓县','tongzixian','4','563200',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2595,'520323','520300','绥阳县','suiyangxian','4','563300',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2596,'520324','520300','正安县','zhenganxian','4','563400',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2597,'520325','520300','道真仡佬族苗族自治县','daozhengelaozumiaozuzizhixian','4','563500',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2598,'520326','520300','务川仡佬族苗族自治县','wuchuangelaozumiaozuzizhixian','4','564300',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2599,'520327','520300','凤冈县','fenggangxian','4','564200',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2600,'520328','520300','湄潭县','meitanxian','4','564100',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2601,'520329','520300','余庆县','yuqingxian','4','564400',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2602,'520330','520300','习水县','xishuixian','4','564600',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2603,'520381','520300','赤水市','chishuishi','4','564700',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2604,'520382','520300','仁怀市','renhuaishi','4','564500',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2605,'520400','520000','安顺市','anshunshi','3','561000',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2606,'520402','520400','西秀区','xixiu','4','561000',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2607,'520421','520400','平坝区','pingba','4','561100',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2608,'520422','520400','普定县','pudingxian','4','562100',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2609,'520423','520400','镇宁布依族苗族自治县','zhenningbuyizumiaozuzizhixian','4','561200',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2610,'520424','520400','关岭布依族苗族自治县','guanlingbuyizumiaozuzizhixian','4','561300',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2611,'520425','520400','紫云苗族布依族自治县','ziyunmiaozubuyizuzizhixian','4','550800',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2612,'520500','520000','毕节市','bijieshi','3','551700',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2613,'520502','520500','七星关区','qixingguan','4','551700',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2614,'520521','520500','大方县','dafangxian','4','551600',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2615,'520522','520500','黔西县','qianxixian','4','551500',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2616,'520523','520500','金沙县','jinshaxian','4','551800',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2617,'520524','520500','织金县','zhijinxian','4','552100',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2618,'520525','520500','纳雍县','nayongxian','4','553300',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2619,'520526','520500','威宁彝族回族苗族自治县','weiningyizuhuizumiaozuzizhixian','4','553100',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2620,'520527','520500','赫章县','hezhangxian','4','553200',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2621,'520600','520000','铜仁市','tongrenshi','3','554300',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2622,'520602','520600','碧江区','bijiang','4','554300',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2623,'520603','520600','万山区','wanshan','4','554200',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2624,'520621','520600','江口县','jiangkouxian','4','554400',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2625,'520622','520600','玉屏侗族自治县','yupingdongzuzizhixian','4','554004',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2626,'520623','520600','石阡县','shiqianxian','4','555100',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2627,'520624','520600','思南县','sinanxian','4','565100',NULL,NULL,'2017-02-14 17:05:39',NULL,NULL,NULL,0),(2628,'520625','520600','印江土家族苗族自治县','yinjiangtujiazumiaozuzizhixian','4','555200',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2629,'520626','520600','德江县','dejiangxian','4','565200',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2630,'520627','520600','沿河土家族自治县','yanhetujiazuzizhixian','4','565300',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2631,'520628','520600','松桃苗族自治县','songtaomiaozuzizhixian','4','554100',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2632,'522300','520000','黔西南布依族苗族自治州','qianxinanbuyizumiaozuzizhizhou','3','562400',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2633,'522301','兴义','522300','522300','860','104.89548',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2634,'522322','522300','兴仁县','xingrenxian','4','562300',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2635,'522323','522300','普安县','puanxian','4','561500',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2636,'522324','522300','晴隆县','qinglongxian','4','561400',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2637,'522325','522300','贞丰县','zhenfengxian','4','562200',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2638,'522326','522300','望谟县','wangmoxian','4','552300',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2639,'522327','522300','册亨县','cehengxian','4','552200',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2640,'522328','522300','安龙县','anlongxian','4','552400',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2641,'522600','520000','黔东南苗族侗族自治州','qiandongnanmiaozudongzuzizhizhou','3','556000',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2642,'522601','522600','凯里市','kailishi','4','556000',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2643,'522622','522600','黄平县','huangpingxian','4','556100',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2644,'522623','522600','施秉县','shibingxian','4','556200',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2645,'522624','522600','三穗县','sansuixian','4','556500',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2646,'522625','522600','镇远县','zhenyuanxian','4','557700',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2647,'522626','522600','岑巩县','cengongxian','4','557800',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2648,'522627','522600','天柱县','tianzhuxian','4','556600',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2649,'522628','522600','锦屏县','jinpingxian','4','556700',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2650,'522629','522600','剑河县','jianhexian','4','556400',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2651,'522630','522600','台江县','taijiangxian','4','556300',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2652,'522631','522600','黎平县','lipingxian','4','557300',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2653,'522632','522600','榕江县','rongjiangxian','4','557200',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2654,'522633','522600','从江县','congjiangxian','4','557400',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2655,'522634','522600','雷山县','leishanxian','4','557100',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2656,'522635','522600','麻江县','majiangxian','4','557600',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2657,'522636','522600','丹寨县','danzhaixian','4','557500',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2658,'522700','520000','黔南布依族苗族自治州','qiannanbuyizumiaozuzizhizhou','3','558000',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2659,'522701','522700','都匀市','douyunshi','4','558000',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2660,'522702','522700','福泉市','fuquanshi','4','550500',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2661,'522722','522700','荔波县','liboxian','4','558400',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2662,'522723','522700','贵定县','guidingxian','4','551300',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2663,'522725','522700','瓮安县','wenganxian','4','550400',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2664,'522726','522700','独山县','dushanxian','4','558200',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2665,'522727','522700','平塘县','pingtangxian','4','558300',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2666,'522728','522700','罗甸县','luodianxian','4','550100',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2667,'522729','522700','长顺县','zhangshunxian','4','550700',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2668,'522730','522700','龙里县','longlixian','4','551200',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2669,'522731','522700','惠水县','huishuixian','4','550600',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2670,'522732','522700','三都水族自治县','sandoushuizuzizhixian','4','558100',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2671,'530000','100000','云南省','yunnansheng','2','',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2672,'530100','530000','昆明市','kunmingshi','3','650500',NULL,NULL,'2017-02-14 17:05:40',NULL,NULL,NULL,0),(2673,'530102','530100','五华区','wuhua','4','650021',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2674,'530103','530100','盘龙区','panlong','4','650051',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2675,'530111','530100','官渡区','guandu','4','650200',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2676,'530112','530100','西山区','xishan','4','650118',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2677,'530113','530100','东川区','dongchuan','4','654100',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2678,'530114','530100','呈贡区','chenggong','4','650500',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2679,'530122','530100','晋宁县','jinningxian','4','650600',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2680,'530124','530100','富民县','fuminxian','4','650400',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2681,'530125','530100','宜良县','yiliangxian','4','652100',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2682,'530126','530100','石林彝族自治县','shilinyizuzizhixian','4','652200',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2683,'530127','530100','嵩明县','songmingxian','4','651700',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2684,'530128','530100','禄劝彝族苗族自治县','luquanyizumiaozuzizhixian','4','651500',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2685,'530129','寻甸','530100','530100','872','103.2557',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2686,'530181','530100','安宁市','anningshi','4','650300',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2687,'530300','530000','曲靖市','qujingshi','3','655000',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2688,'530302','530300','麒麟区','qilin','4','655000',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2689,'530321','530300','马龙县','malongxian','4','655100',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2690,'530322','530300','陆良县','luliangxian','4','655600',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2691,'530323','530300','师宗县','shizongxian','4','655700',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2692,'530324','530300','罗平县','luopingxian','4','655800',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2693,'530325','530300','富源县','fuyuanxian','4','655500',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2694,'530326','530300','会泽县','huizexian','4','654200',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2695,'530328','530300','沾益县','zhanyixian','4','655331',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2696,'530381','530300','宣威市','xuanweishi','4','655400',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2697,'530400','530000','玉溪市','yuxishi','3','653100',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2698,'530402','530400','红塔区','hongta','4','653100',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2699,'530421','530400','江川县','jiangchuanxian','4','652600',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2700,'530422','530400','澄江县','chengjiangxian','4','652500',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2701,'530423','530400','通海县','tonghaixian','4','652700',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2702,'530424','530400','华宁县','huaningxian','4','652800',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2703,'530425','530400','易门县','yimenxian','4','651100',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2704,'530426','530400','峨山彝族自治县','eshanyizuzizhixian','4','653200',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2705,'530427','530400','新平彝族傣族自治县','xinpingyizudaizuzizhixian','4','653400',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2706,'530428','530400','元江哈尼族彝族傣族自治县','yuanjianghanizuyizudaizuzizhixian','4','653300',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2707,'530500','530000','保山市','baoshanshi','3','678000',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2708,'530502','530500','隆阳区','longyang','4','678000',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2709,'530521','530500','施甸县','shidianxian','4','678200',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2710,'530522','530500','腾冲县','tengchongxian','4','679100',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2711,'530523','530500','龙陵县','longlingxian','4','678300',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2712,'530524','530500','昌宁县','changningxian','4','678100',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2713,'530600','530000','昭通市','zhaotongshi','3','657000',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2714,'530602','530600','昭阳区','zhaoyang','4','657000',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2715,'530621','530600','鲁甸县','ludianxian','4','657100',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2716,'530622','530600','巧家县','qiaojiaxian','4','654600',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2717,'530623','530600','盐津县','yanjinxian','4','657500',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2718,'530624','530600','大关县','daguanxian','4','657400',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2719,'530625','530600','永善县','yongshanxian','4','657300',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2720,'530626','530600','绥江县','suijiangxian','4','657700',NULL,NULL,'2017-02-14 17:05:41',NULL,NULL,NULL,0),(2721,'530627','530600','镇雄县','zhenxiongxian','4','657200',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2722,'530628','530600','彝良县','yiliangxian','4','657600',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2723,'530629','530600','威信县','weixinxian','4','657900',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2724,'530630','530600','水富县','shuifuxian','4','657800',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2725,'530700','530000','丽江市','lijiangshi','3','674100',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2726,'530702','530700','古城区','gucheng','4','674100',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2727,'530721','530700','玉龙纳西族自治县','yulongnaxizuzizhixian','4','674100',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2728,'530722','530700','永胜县','yongshengxian','4','674200',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2729,'530723','530700','华坪县','huapingxian','4','674800',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2730,'530724','530700','宁蒗彝族自治县','ninglangyizuzizhixian','4','674300',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2731,'530800','530000','普洱市','puershi','3','665000',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2732,'530802','530800','思茅区','simao','4','665000',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2733,'530821','530800','宁洱哈尼族彝族自治县','ningerhanizuyizuzizhixian','4','665100',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2734,'530822','530800','墨江哈尼族自治县','mojianghanizuzizhixian','4','654800',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2735,'530823','530800','景东彝族自治县','jingdongyizuzizhixian','4','676200',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2736,'530824','530800','景谷傣族彝族自治县','jinggudaizuyizuzizhixian','4','666400',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2737,'530825','530800','镇沅彝族哈尼族拉祜族自治县','zhenyuanyizuhanizulahuzuzizhixian','4','666500',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2738,'530826','530800','江城哈尼族彝族自治县','jiangchenghanizuyizuzizhixian','4','665900',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2739,'530827','530800','孟连傣族拉祜族佤族自治县','mengliandaizulahuzuwazuzizhixian','4','665800',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2740,'530828','530800','澜沧拉祜族自治县','lancanglahuzuzizhixian','4','665600',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2741,'530829','530800','西盟佤族自治县','ximengwazuzizhixian','4','665700',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2742,'530900','530000','临沧市','lincangshi','3','677000',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2743,'530902','530900','临翔区','linxiang','4','677000',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2744,'530921','530900','凤庆县','fengqingxian','4','675900',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2745,'530922','530900','云县','yunxian','4','675800',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2746,'530923','530900','永德县','yongdexian','4','677600',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2747,'530924','530900','镇康县','zhenkangxian','4','677704',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2748,'530925','530900','双江拉祜族佤族布朗族傣族自治县','shuangjianglahuzuwazubulangzudaizuzizhixian','4','677300',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2749,'530926','530900','耿马傣族佤族自治县','gengmadaizuwazuzizhixian','4','677500',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2750,'530927','530900','沧源佤族自治县','cangyuanwazuzizhixian','4','677400',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2751,'532300','530000','楚雄彝族自治州','chuxiongyizuzizhizhou','3','675000',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2752,'532301','532300','楚雄市','chuxiongshi','4','675000',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2753,'532322','532300','双柏县','shuangboxian','4','675100',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2754,'532323','532300','牟定县','moudingxian','4','675500',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2755,'532324','532300','南华县','nanhuaxian','4','675200',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2756,'532325','532300','姚安县','yaoanxian','4','675300',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2757,'532326','532300','大姚县','dayaoxian','4','675400',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2758,'532327','532300','永仁县','yongrenxian','4','651400',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2759,'532328','532300','元谋县','yuanmouxian','4','651300',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2760,'532329','532300','武定县','wudingxian','4','651600',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2761,'532331','532300','禄丰县','lufengxian','4','651200',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2762,'532500','530000','红河哈尼族彝族自治州','honghehanizuyizuzizhizhou','3','661400',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2763,'532501','532500','个旧市','gejiushi','4','661000',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2764,'532502','532500','开远市','kaiyuanshi','4','661600',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2765,'532503','532500','蒙自市','mengzishi','4','661101',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2766,'532504','532500','弥勒市','mileshi','4','652300',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2767,'532523','532500','屏边苗族自治县','pingbianmiaozuzizhixian','4','661200',NULL,NULL,'2017-02-14 17:05:42',NULL,NULL,NULL,0),(2768,'532524','532500','建水县','jianshuixian','4','654300',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2769,'532525','532500','石屏县','shipingxian','4','662200',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2770,'532527','532500','泸西县','luxixian','4','652400',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2771,'532528','532500','元阳县','yuanyangxian','4','662400',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2772,'532529','532500','红河县','honghexian','4','654400',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2773,'532530','532500','金平苗族瑶族傣族自治县','jinpingmiaozuyaozudaizuzizhixian','4','661500',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2774,'532531','532500','绿春县','lvchunxian','4','662500',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2775,'532532','532500','河口瑶族自治县','hekouyaozuzizhixian','4','661300',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2776,'532600','530000','文山壮族苗族自治州','wenshanzhuangzumiaozuzizhizhou','3','663000',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2777,'532601','532600','文山市','wenshanshi','4','663000',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2778,'532622','532600','砚山县','yanshanxian','4','663100',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2779,'532623','532600','西畴县','xichouxian','4','663500',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2780,'532624','532600','麻栗坡县','malipoxian','4','663600',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2781,'532625','532600','马关县','maguanxian','4','663700',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2782,'532626','532600','丘北县','qiubeixian','4','663200',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2783,'532627','532600','广南县','guangnanxian','4','663300',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2784,'532628','532600','富宁县','funingxian','4','663400',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2785,'532800','530000','西双版纳傣族自治州','xishuangbannadaizuzizhizhou','3','666100',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2786,'532801','532800','景洪市','jinghongshi','4','666100',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2787,'532822','532800','勐海县','menghaixian','4','666200',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2788,'532823','532800','勐腊县','menglaxian','4','666300',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2789,'532900','530000','大理白族自治州','dalibaizuzizhizhou','3','671000',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2790,'532901','532900','大理市','dalishi','4','671000',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2791,'532922','532900','漾濞彝族自治县','yangbiyizuzizhixian','4','672500',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2792,'532923','532900','祥云县','xiangyunxian','4','672100',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2793,'532924','532900','宾川县','binchuanxian','4','671600',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2794,'532925','532900','弥渡县','miduxian','4','675600',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2795,'532926','532900','南涧彝族自治县','nanjianyizuzizhixian','4','675700',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2796,'532927','532900','巍山彝族回族自治县','weishanyizuhuizuzizhixian','4','672400',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2797,'532928','532900','永平县','yongpingxian','4','672600',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2798,'532929','532900','云龙县','yunlongxian','4','672700',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2799,'532930','532900','洱源县','eryuanxian','4','671200',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2800,'532931','532900','剑川县','jianchuanxian','4','671300',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2801,'532932','532900','鹤庆县','heqingxian','4','671500',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2802,'533100','530000','德宏傣族景颇族自治州','dehongdaizujingpozuzizhizhou','3','678400',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2803,'533102','533100','瑞丽市','ruilishi','4','678600',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2804,'533103','533100','芒市','mangshi','4','678400',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2805,'533122','533100','梁河县','lianghexian','4','679200',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2806,'533123','533100','盈江县','yingjiangxian','4','679300',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2807,'533124','533100','陇川县','longchuanxian','4','678700',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2808,'533300','530000','怒江傈僳族自治州','nujianglisuzuzizhizhou','3','673100',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2809,'533321','533300','泸水县','lushuixian','4','673100',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2810,'533323','533300','福贡县','fugongxian','4','673400',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2811,'533324','533300','贡山独龙族怒族自治县','gongshandulongzunuzuzizhixian','4','673500',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2812,'533325','533300','兰坪白族普米族自治县','lanpingbaizupumizuzizhixian','4','671400',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2813,'533400','530000','迪庆藏族自治州','diqingzangzuzizhizhou','3','674400',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2814,'533421','533400','香格里拉市','xianggelilashi','4','674400',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2815,'533422','533400','德钦县','deqinxian','4','674500',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2816,'533423','533400','维西傈僳族自治县','weixilisuzuzizhixian','4','674600',NULL,NULL,'2017-02-14 17:05:43',NULL,NULL,NULL,0),(2817,'540000','100000','西藏自治区','xizangzizhi','2','',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2818,'540100','540000','拉萨市','lasashi','3','850000',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2819,'540102','540100','城关区','chengguan','4','850000',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2820,'540121','540100','林周县','linzhouxian','4','851600',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2821,'540122','540100','当雄县','dangxiongxian','4','851500',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2822,'540123','540100','尼木县','nimuxian','4','851300',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2823,'540124','540100','曲水县','qushuixian','4','850600',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2824,'540125','540100','堆龙德庆县','duilongdeqingxian','4','851400',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2825,'540126','540100','达孜县','dazixian','4','850100',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2826,'540127','540100','墨竹工卡县','mozhugongkaxian','4','850200',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2827,'540200','540000','日喀则市','rikazeshi','3','857000',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2828,'540202','540200','桑珠孜区','sangzhuzi','4','857000',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2829,'540221','540200','南木林县','nanmulinxian','4','857100',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2830,'540222','540200','江孜县','jiangzixian','4','857400',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2831,'540223','540200','定日县','dingrixian','4','858200',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2832,'540224','540200','萨迦县','sajiaxian','4','857800',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2833,'540225','540200','拉孜县','lazixian','4','858100',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2834,'540226','540200','昂仁县','angrenxian','4','858500',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2835,'540227','540200','谢通门县','xietongmenxian','4','858900',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2836,'540228','540200','白朗县','bailangxian','4','857300',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2837,'540229','540200','仁布县','renbuxian','4','857200',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2838,'540230','540200','康马县','kangmaxian','4','857500',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2839,'540231','540200','定结县','dingjiexian','4','857900',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2840,'540232','540200','仲巴县','zhongbaxian','4','858800',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2841,'540233','540200','亚东县','yadongxian','4','857600',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2842,'540234','540200','吉隆县','jilongxian','4','858700',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2843,'540235','540200','聂拉木县','nielamuxian','4','858300',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2844,'540236','540200','萨嘎县','sagaxian','4','857800',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2845,'540237','540200','岗巴县','gangbaxian','4','857700',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2846,'540300','540000','昌都市','changdoushi','3','854000',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2847,'540302','540300','卡若区','karuo','4','854000',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2848,'540321','540300','江达县','jiangdaxian','4','854100',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2849,'540322','540300','贡觉县','gongjuexian','4','854200',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2850,'540323','540300','类乌齐县','leiwuqixian','4','855600',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2851,'540324','540300','丁青县','dingqingxian','4','855700',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2852,'540325','540300','察雅县','chayaxian','4','854300',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2853,'540326','540300','八宿县','basuxian','4','854600',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2854,'540327','540300','左贡县','zuogongxian','4','854400',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2855,'540328','540300','芒康县','mangkangxian','4','854500',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2856,'540329','540300','洛隆县','luolongxian','4','855400',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2857,'540330','540300','边坝县','bianbaxian','4','855500',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2858,'542200','540000','山南地区','shannandi','3','856000',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2859,'542221','542200','乃东县','naidongxian','4','856100',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2860,'542222','542200','扎囊县','zhanangxian','4','850800',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2861,'542223','542200','贡嘎县','gonggaxian','4','850700',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2862,'542224','542200','桑日县','sangrixian','4','856200',NULL,NULL,'2017-02-14 17:05:44',NULL,NULL,NULL,0),(2863,'542225','542200','琼结县','qiongjiexian','4','856800',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2864,'542226','542200','曲松县','qusongxian','4','856300',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2865,'542227','542200','措美县','cuomeixian','4','856900',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2866,'542228','542200','洛扎县','luozhaxian','4','856600',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2867,'542229','542200','加查县','jiachaxian','4','856400',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2868,'542231','542200','隆子县','longzixian','4','856600',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2869,'542232','542200','错那县','cuoneixian','4','856700',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2870,'542233','542200','浪卡子县','langkazixian','4','851100',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2871,'542400','540000','那曲地区','neiqudi','3','852000',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2872,'542421','542400','那曲县','neiquxian','4','852000',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2873,'542422','542400','嘉黎县','jialixian','4','852400',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2874,'542423','542400','比如县','biruxian','4','852300',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2875,'542424','542400','聂荣县','nierongxian','4','853500',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2876,'542425','542400','安多县','anduoxian','4','853400',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2877,'542426','542400','申扎县','shenzhaxian','4','853100',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2878,'542427','542400','索县','suoxian','4','852200',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2879,'542428','542400','班戈县','bangexian','4','852500',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2880,'542429','542400','巴青县','baqingxian','4','852100',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2881,'542430','542400','尼玛县','nimaxian','4','852600',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2882,'542431','542400','双湖县','shuanghuxian','4','852600',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2883,'542500','540000','阿里地区','alidi','3','859000',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2884,'542521','542500','普兰县','pulanxian','4','859500',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2885,'542522','542500','札达县','zhadaxian','4','859600',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2886,'542523','542500','噶尔县','gaerxian','4','859400',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2887,'542524','542500','日土县','rituxian','4','859700',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2888,'542525','542500','革吉县','gejixian','4','859100',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2889,'542526','542500','改则县','gaizexian','4','859200',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2890,'542527','542500','措勤县','cuoqinxian','4','859300',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2891,'542600','540000','林芝地区','linzhidi','3','850400',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2892,'542621','542600','林芝县','linzhixian','4','850400',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2893,'542622','542600','工布江达县','gongbujiangdaxian','4','850300',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2894,'542623','542600','米林县','milinxian','4','850500',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2895,'542624','542600','墨脱县','motuoxian','4','855300',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2896,'542625','542600','波密县','bomixian','4','855200',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2897,'542626','542600','察隅县','chayuxian','4','855100',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2898,'542627','542600','朗县','langxian','4','856500',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2899,'610000','100000','陕西省','shanxisheng','2','',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2900,'610100','610000','西安市','xianshi','3','710003',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2901,'610102','610100','新城区','xincheng','4','710004',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2902,'610103','610100','碑林区','beilin','4','710001',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2903,'610104','610100','莲湖区','lianhu','4','710003',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2904,'610111','610100','灞桥区','baqiao','4','710038',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2905,'610112','610100','未央区','weiyang','4','710014',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2906,'610113','610100','雁塔区','yanta','4','710061',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2907,'610114','610100','阎良区','yanliang','4','710087',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2908,'610115','610100','临潼区','lintong','4','710600',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2909,'610116','610100','长安区','zhangan','4','710100',NULL,NULL,'2017-02-14 17:05:45',NULL,NULL,NULL,0),(2910,'610122','610100','蓝田县','lantianxian','4','710500',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2911,'610124','610100','周至县','zhouzhixian','4','710400',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2912,'610125','610100','户县','huxian','4','710300',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2913,'610126','610100','高陵区','gaoling','4','710200',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2914,'610200','610000','铜川市','tongchuanshi','3','727100',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2915,'610202','610200','王益区','wangyi','4','727000',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2916,'610203','610200','印台区','yintai','4','727007',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2917,'610204','610200','耀州区','yaozhou','4','727100',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2918,'610222','610200','宜君县','yijunxian','4','727200',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2919,'610300','610000','宝鸡市','baojishi','3','721000',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2920,'610302','610300','渭滨区','weibin','4','721000',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2921,'610303','610300','金台区','jintai','4','721000',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2922,'610304','610300','陈仓区','chencang','4','721300',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2923,'610322','610300','凤翔县','fengxiangxian','4','721400',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2924,'610323','610300','岐山县','qishanxian','4','722400',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2925,'610324','610300','扶风县','fufengxian','4','722200',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2926,'610326','610300','眉县','meixian','4','722300',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2927,'610327','610300','陇县','longxian','4','721200',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2928,'610328','610300','千阳县','qianyangxian','4','721100',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2929,'610329','610300','麟游县','linyouxian','4','721500',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2930,'610330','610300','凤县','fengxian','4','721700',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2931,'610331','610300','太白县','taibaixian','4','721600',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2932,'610400','610000','咸阳市','xianyangshi','3','712000',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2933,'610402','610400','秦都区','qindou','4','712000',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2934,'610403','610400','杨陵区','yangling','4','712100',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2935,'610404','610400','渭城区','weicheng','4','712000',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2936,'610422','610400','三原县','sanyuanxian','4','713800',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2937,'610423','610400','泾阳县','jingyangxian','4','713700',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2938,'610424','610400','乾县','qianxian','4','713300',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2939,'610425','610400','礼泉县','liquanxian','4','713200',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2940,'610426','610400','永寿县','yongshouxian','4','713400',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2941,'610427','610400','彬县','binxian','4','713500',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2942,'610428','610400','长武县','zhangwuxian','4','713600',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2943,'610429','610400','旬邑县','xunyixian','4','711300',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2944,'610430','610400','淳化县','chunhuaxian','4','711200',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2945,'610431','610400','武功县','wugongxian','4','712200',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2946,'610481','610400','兴平市','xingpingshi','4','713100',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2947,'610500','610000','渭南市','weinanshi','3','714000',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2948,'610502','610500','临渭区','linwei','4','714000',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2949,'610521','610500','华县','huaxian','4','714100',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2950,'610522','610500','潼关县','tongguanxian','4','714300',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2951,'610523','610500','大荔县','dalixian','4','715100',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2952,'610524','610500','合阳县','heyangxian','4','715300',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2953,'610525','610500','澄城县','chengchengxian','4','715200',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2954,'610526','610500','蒲城县','puchengxian','4','715500',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2955,'610527','610500','白水县','baishuixian','4','715600',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2956,'610528','610500','富平县','fupingxian','4','711700',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2957,'610581','610500','韩城市','hanchengshi','4','715400',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2958,'610582','610500','华阴市','huayinshi','4','714200',NULL,NULL,'2017-02-14 17:05:46',NULL,NULL,NULL,0),(2959,'610600','610000','延安市','yananshi','3','716000',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2960,'610602','610600','宝塔区','baota','4','716000',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2961,'610621','610600','延长县','yanzhangxian','4','717100',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2962,'610622','610600','延川县','yanchuanxian','4','717200',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2963,'610623','610600','子长县','zizhangxian','4','717300',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2964,'610624','610600','安塞县','ansaixian','4','717400',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2965,'610625','610600','志丹县','zhidanxian','4','717500',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2966,'610626','610600','吴起县','wuqixian','4','717600',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2967,'610627','610600','甘泉县','ganquanxian','4','716100',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2968,'610628','610600','富县','fuxian','4','727500',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2969,'610629','610600','洛川县','luochuanxian','4','727400',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2970,'610630','610600','宜川县','yichuanxian','4','716200',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2971,'610631','610600','黄龙县','huanglongxian','4','715700',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2972,'610632','610600','黄陵县','huanglingxian','4','727300',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2973,'610700','610000','汉中市','hanzhongshi','3','723000',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2974,'610702','610700','汉台区','hantai','4','723000',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2975,'610721','610700','南郑县','nanzhengxian','4','723100',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2976,'610722','610700','城固县','chengguxian','4','723200',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2977,'610723','610700','洋县','yangxian','4','723300',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2978,'610724','610700','西乡县','xixiangxian','4','723500',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2979,'610725','610700','勉县','mianxian','4','724200',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2980,'610726','610700','宁强县','ningqiangxian','4','724400',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2981,'610727','610700','略阳县','lveyangxian','4','724300',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2982,'610728','610700','镇巴县','zhenbaxian','4','723600',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2983,'610729','610700','留坝县','liubaxian','4','724100',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2984,'610730','610700','佛坪县','fopingxian','4','723400',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2985,'610800','610000','榆林市','yulinshi','3','719000',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2986,'610802','610800','榆阳区','yuyang','4','719000',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2987,'610821','610800','神木县','shenmuxian','4','719300',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2988,'610822','610800','府谷县','fuguxian','4','719400',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2989,'610823','610800','横山县','hengshanxian','4','719100',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2990,'610824','610800','靖边县','jingbianxian','4','718500',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2991,'610825','610800','定边县','dingbianxian','4','718600',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2992,'610826','610800','绥德县','suidexian','4','718000',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2993,'610827','610800','米脂县','mizhixian','4','718100',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2994,'610828','610800','佳县','jiaxian','4','719200',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2995,'610829','610800','吴堡县','wubaoxian','4','718200',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2996,'610830','610800','清涧县','qingjianxian','4','718300',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2997,'610831','610800','子洲县','zizhouxian','4','718400',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2998,'610900','610000','安康市','ankangshi','3','725000',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(2999,'610902','610900','汉滨区','hanbin','4','725000',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(3000,'610921','610900','汉阴县','hanyinxian','4','725100',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(3001,'610922','610900','石泉县','shiquanxian','4','725200',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(3002,'610923','610900','宁陕县','ningshanxian','4','711600',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(3003,'610924','610900','紫阳县','ziyangxian','4','725300',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(3004,'610925','610900','岚皋县','langaoxian','4','725400',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(3005,'610926','610900','平利县','pinglixian','4','725500',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(3006,'610927','610900','镇坪县','zhenpingxian','4','725600',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(3007,'610928','610900','旬阳县','xunyangxian','4','725700',NULL,NULL,'2017-02-14 17:05:47',NULL,NULL,NULL,0),(3008,'610929','610900','白河县','baihexian','4','725800',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3009,'611000','610000','商洛市','shangluoshi','3','726000',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3010,'611002','611000','商州区','shangzhou','4','726000',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3011,'611021','611000','洛南县','luonanxian','4','726100',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3012,'611022','611000','丹凤县','danfengxian','4','726200',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3013,'611023','611000','商南县','shangnanxian','4','726300',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3014,'611024','611000','山阳县','shanyangxian','4','726400',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3015,'611025','611000','镇安县','zhenanxian','4','711500',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3016,'611026','611000','柞水县','zuoshuixian','4','711400',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3017,'611100','610000','西咸新区','xixianxin','3','712000',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3018,'611101','611100','空港新城','konggangxincheng','4','461000',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3019,'611102','611100','沣东新城','fengdongxincheng','4','710000',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3020,'611103','611100','秦汉新城','qinhanxincheng','4','712000',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3021,'611104','611100','沣西新城','fengxixincheng','4','710000',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3022,'611105','611100','泾河新城','jinghexincheng','4','713700',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3023,'620000','100000','甘肃省','gansusheng','2','',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3024,'620100','620000','兰州市','lanzhoushi','3','730030',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3025,'620102','620100','城关区','chengguan','4','730030',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3026,'620103','620100','七里河区','qilihe','4','730050',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3027,'620104','620100','西固区','xigu','4','730060',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3028,'620105','620100','安宁区','anning','4','730070',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3029,'620111','620100','红古区','honggu','4','730084',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3030,'620121','620100','永登县','yongdengxian','4','730300',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3031,'620122','620100','皋兰县','gaolanxian','4','730200',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3032,'620123','620100','榆中县','yuzhongxian','4','730100',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3033,'620200','620000','嘉峪关市','jiayuguanshi','3','735100',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3034,'620201','620200','雄关区','xiongguan','4','735100',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3035,'620202','620200','长城区','zhangcheng','4','735106',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3036,'620203','620200','镜铁区','jingtie','4','735100',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3037,'620300','620000','金昌市','jinchangshi','3','737100',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3038,'620302','620300','金川区','jinchuan','4','737100',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3039,'620321','620300','永昌县','yongchangxian','4','737200',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3040,'620400','620000','白银市','baiyinshi','3','730900',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3041,'620402','620400','白银区','baiyin','4','730900',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3042,'620403','620400','平川区','pingchuan','4','730913',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3043,'620421','620400','靖远县','jingyuanxian','4','730600',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3044,'620422','620400','会宁县','huiningxian','4','730700',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3045,'620423','620400','景泰县','jingtaixian','4','730400',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3046,'620500','620000','天水市','tianshuishi','3','741000',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3047,'620502','620500','秦州区','qinzhou','4','741000',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3048,'620503','620500','麦积区','maiji','4','741020',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3049,'620521','620500','清水县','qingshuixian','4','741400',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3050,'620522','620500','秦安县','qinanxian','4','741600',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3051,'620523','620500','甘谷县','ganguxian','4','741200',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3052,'620524','620500','武山县','wushanxian','4','741300',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3053,'620525','620500','张家川回族自治县','zhangjiachuanhuizuzizhixian','4','741500',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3054,'620600','620000','武威市','wuweishi','3','733000',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3055,'620602','620600','凉州区','liangzhou','4','733000',NULL,NULL,'2017-02-14 17:05:48',NULL,NULL,NULL,0),(3056,'620621','620600','民勤县','minqinxian','4','733300',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3057,'620622','620600','古浪县','gulangxian','4','733100',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3058,'620623','620600','天祝藏族自治县','tianzhuzangzuzizhixian','4','733200',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3059,'620700','620000','张掖市','zhangyeshi','3','734000',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3060,'620702','620700','甘州区','ganzhou','4','734000',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3061,'620721','620700','肃南裕固族自治县','sunanyuguzuzizhixian','4','734400',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3062,'620722','620700','民乐县','minlexian','4','734500',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3063,'620723','620700','临泽县','linzexian','4','734200',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3064,'620724','620700','高台县','gaotaixian','4','734300',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3065,'620725','620700','山丹县','shandanxian','4','734100',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3066,'620800','620000','平凉市','pingliangshi','3','744000',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3067,'620802','620800','崆峒区','kongtong','4','744000',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3068,'620821','620800','泾川县','jingchuanxian','4','744300',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3069,'620822','620800','灵台县','lingtaixian','4','744400',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3070,'620823','620800','崇信县','chongxinxian','4','744200',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3071,'620824','620800','华亭县','huatingxian','4','744100',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3072,'620825','620800','庄浪县','zhuanglangxian','4','744600',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3073,'620826','620800','静宁县','jingningxian','4','743400',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3074,'620900','620000','酒泉市','jiuquanshi','3','735000',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3075,'620902','620900','肃州区','suzhou','4','735000',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3076,'620921','620900','金塔县','jintaxian','4','735300',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3077,'620922','620900','瓜州县','guazhouxian','4','736100',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3078,'620923','620900','肃北蒙古族自治县','subeimengguzuzizhixian','4','736300',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3079,'620924','620900','阿克塞哈萨克族自治县','akesaihasakezuzizhixian','4','736400',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3080,'620981','620900','玉门市','yumenshi','4','735200',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3081,'620982','620900','敦煌市','dunhuangshi','4','736200',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3082,'621000','620000','庆阳市','qingyangshi','3','745000',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3083,'621002','621000','西峰区','xifeng','4','745000',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3084,'621021','621000','庆城县','qingchengxian','4','745100',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3085,'621022','621000','环县','huanxian','4','745700',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3086,'621023','621000','华池县','huachixian','4','745600',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3087,'621024','621000','合水县','heshuixian','4','745400',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3088,'621025','621000','正宁县','zhengningxian','4','745300',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3089,'621026','621000','宁县','ningxian','4','745200',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3090,'621027','621000','镇原县','zhenyuanxian','4','744500',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3091,'621100','620000','定西市','dingxishi','3','743000',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3092,'621102','621100','安定区','anding','4','743000',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3093,'621121','621100','通渭县','tongweixian','4','743300',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3094,'621122','621100','陇西县','longxixian','4','748100',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3095,'621123','621100','渭源县','weiyuanxian','4','748200',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3096,'621124','621100','临洮县','lintaoxian','4','730500',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3097,'621125','621100','漳县','zhangxian','4','748300',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3098,'621126','621100','岷县','minxian','4','748400',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3099,'621200','620000','陇南市','longnanshi','3','746000',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3100,'621202','621200','武都区','wudou','4','746000',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3101,'621221','621200','成县','chengxian','4','742500',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3102,'621222','621200','文县','wenxian','4','746400',NULL,NULL,'2017-02-14 17:05:49',NULL,NULL,NULL,0),(3103,'621223','621200','宕昌县','dangchangxian','4','748500',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3104,'621224','621200','康县','kangxian','4','746500',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3105,'621225','621200','西和县','xihexian','4','742100',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3106,'621226','621200','礼县','lixian','4','742200',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3107,'621227','621200','徽县','huixian','4','742300',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3108,'621228','621200','两当县','liangdangxian','4','742400',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3109,'622900','620000','临夏回族自治州','linxiahuizuzizhizhou','3','731100',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3110,'622901','622900','临夏市','linxiashi','4','731100',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3111,'622921','622900','临夏县','linxiaxian','4','731800',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3112,'622922','622900','康乐县','kanglexian','4','731500',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3113,'622923','622900','永靖县','yongjingxian','4','731600',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3114,'622924','622900','广河县','guanghexian','4','731300',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3115,'622925','622900','和政县','hezhengxian','4','731200',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3116,'622926','622900','东乡族自治县','dongxiangzuzizhixian','4','731400',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3117,'622927','622900','积石山保安族东乡族撒拉族自治县','jishishanbaoanzudongxiangzusalazuzizhixian','4','731700',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3118,'623000','620000','甘南藏族自治州','gannanzangzuzizhizhou','3','747000',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3119,'623001','623000','合作市','hezuoshi','4','747000',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3120,'623021','623000','临潭县','lintanxian','4','747500',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3121,'623022','623000','卓尼县','zhuonixian','4','747600',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3122,'623023','623000','舟曲县','zhouquxian','4','746300',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3123,'623024','623000','迭部县','diebuxian','4','747400',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3124,'623025','623000','玛曲县','maquxian','4','747300',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3125,'623026','623000','碌曲县','liuquxian','4','747200',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3126,'623027','623000','夏河县','xiahexian','4','747100',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3127,'630000','100000','青海省','qinghaisheng','2','',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3128,'630100','630000','西宁市','xiningshi','3','810000',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3129,'630102','630100','城东区','chengdong','4','810007',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3130,'630103','630100','城中区','chengzhong','4','810000',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3131,'630104','630100','城西区','chengxi','4','810001',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3132,'630105','630100','城北区','chengbei','4','810003',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3133,'630121','630100','大通回族土族自治县','datonghuizutuzuzizhixian','4','810100',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3134,'630122','630100','湟中县','huangzhongxian','4','811600',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3135,'630123','630100','湟源县','huangyuanxian','4','812100',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3136,'630200','630000','海东市','haidongshi','3','810700',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3137,'630202','630200','乐都区','ledou','4','810700',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3138,'630221','630200','平安县','pinganxian','4','810600',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3139,'630222','630200','民和回族土族自治县','minhehuizutuzuzizhixian','4','810800',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3140,'630223','630200','互助土族自治县','huzhutuzuzizhixian','4','810500',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3141,'630224','630200','化隆回族自治县','hualonghuizuzizhixian','4','810900',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3142,'630225','630200','循化撒拉族自治县','xunhuasalazuzizhixian','4','811100',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3143,'632200','630000','海北藏族自治州','haibeizangzuzizhizhou','3','812200',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3144,'632221','632200','门源回族自治县','menyuanhuizuzizhixian','4','810300',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3145,'632222','632200','祁连县','qilianxian','4','810400',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3146,'632223','632200','海晏县','haiyanxian','4','812200',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3147,'632224','632200','刚察县','gangchaxian','4','812300',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3148,'632300','630000','黄南藏族自治州','huangnanzangzuzizhizhou','3','811300',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3149,'632321','632300','同仁县','tongrenxian','4','811300',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3150,'632322','632300','尖扎县','jianzhaxian','4','811200',NULL,NULL,'2017-02-14 17:05:50',NULL,NULL,NULL,0),(3151,'632323','632300','泽库县','zekuxian','4','811400',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3152,'632324','632300','河南蒙古族自治县','henanmengguzuzizhixian','4','811500',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3153,'632500','630000','海南藏族自治州','hainanzangzuzizhizhou','3','813000',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3154,'632521','632500','共和县','gonghexian','4','813000',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3155,'632522','632500','同德县','tongdexian','4','813200',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3156,'632523','632500','贵德县','guidexian','4','811700',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3157,'632524','632500','兴海县','xinghaixian','4','813300',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3158,'632525','632500','贵南县','guinanxian','4','813100',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3159,'632600','630000','果洛藏族自治州','guoluozangzuzizhizhou','3','814000',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3160,'632621','632600','玛沁县','maqinxian','4','814000',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3161,'632622','632600','班玛县','banmaxian','4','814300',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3162,'632623','632600','甘德县','gandexian','4','814100',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3163,'632624','632600','达日县','darixian','4','814200',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3164,'632625','632600','久治县','jiuzhixian','4','624700',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3165,'632626','632600','玛多县','maduoxian','4','813500',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3166,'632700','630000','玉树藏族自治州','yushuzangzuzizhizhou','3','815000',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3167,'632701','632700','玉树市','yushushi','4','815000',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3168,'632722','632700','杂多县','zaduoxian','4','815300',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3169,'632723','632700','称多县','chengduoxian','4','815100',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3170,'632724','632700','治多县','zhiduoxian','4','815400',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3171,'632725','632700','囊谦县','nangqianxian','4','815200',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3172,'632726','632700','曲麻莱县','qumalaixian','4','815500',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3173,'632800','630000','海西蒙古族藏族自治州','haiximengguzuzangzuzizhizhou','3','817000',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3174,'632801','632800','格尔木市','geermushi','4','816000',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3175,'632802','632800','德令哈市','delinghashi','4','817000',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3176,'632821','632800','乌兰县','wulanxian','4','817100',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3177,'632822','632800','都兰县','doulanxian','4','816100',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3178,'632823','632800','天峻县','tianjunxian','4','817200',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3179,'640000','100000','宁夏回族自治区','ningxiahuizuzizhi','2','',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3180,'640100','640000','银川市','yinchuanshi','3','750004',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3181,'640104','640100','兴庆区','xingqing','4','750001',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3182,'640105','640100','西夏区','xixia','4','750021',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3183,'640106','640100','金凤区','jinfeng','4','750011',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3184,'640121','640100','永宁县','yongningxian','4','750100',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3185,'640122','640100','贺兰县','helanxian','4','750200',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3186,'640181','640100','灵武市','lingwushi','4','750004',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3187,'640200','640000','石嘴山市','shizuishanshi','3','753000',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3188,'640202','640200','大武口区','dawukou','4','753000',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3189,'640205','640200','惠农区','huinong','4','753600',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3190,'640221','640200','平罗县','pingluoxian','4','753400',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3191,'640300','640000','吴忠市','wuzhongshi','3','751100',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3192,'640302','640300','利通区','litong','4','751100',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3193,'640303','640300','红寺堡区','hongsibao','4','751900',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3194,'640323','640300','盐池县','yanchixian','4','751500',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3195,'640324','640300','同心县','tongxinxian','4','751300',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3196,'640381','640300','青铜峡市','qingtongxiashi','4','751600',NULL,NULL,'2017-02-14 17:05:51',NULL,NULL,NULL,0),(3197,'640400','640000','固原市','guyuanshi','3','756000',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3198,'640402','640400','原州区','yuanzhou','4','756000',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3199,'640422','640400','西吉县','xijixian','4','756200',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3200,'640423','640400','隆德县','longdexian','4','756300',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3201,'640424','640400','泾源县','jingyuanxian','4','756400',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3202,'640425','640400','彭阳县','pengyangxian','4','756500',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3203,'640500','640000','中卫市','zhongweishi','3','751700',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3204,'640502','640500','沙坡头区','shapotou','4','755000',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3205,'640521','640500','中宁县','zhongningxian','4','751200',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3206,'640522','640500','海原县','haiyuanxian','4','751800',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3207,'650000','100000','新疆维吾尔自治区','xinjiangweiwuerzizhi','2','',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3208,'650100','650000','乌鲁木齐市','wulumuqishi','3','830002',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3209,'650102','650100','天山区','tianshan','4','830002',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3210,'650103','650100','沙依巴克区','shayibake','4','830000',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3211,'650104','650100','新市区','xinshi','4','830011',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3212,'650105','650100','水磨沟区','shuimogou','4','830017',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3213,'650106','650100','头屯河区','toutunhe','4','830022',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3214,'650107','650100','达坂城区','dabancheng','4','830039',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3215,'650109','650100','米东区','midong','4','830019',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3216,'650121','650100','乌鲁木齐县','wulumuqixian','4','830063',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3217,'650200','650000','克拉玛依市','kelamayishi','3','834000',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3218,'650202','650200','独山子区','dushanzi','4','834021',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3219,'650203','650200','克拉玛依区','kelamayi','4','834000',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3220,'650204','650200','白碱滩区','baijiantan','4','834008',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3221,'650205','650200','乌尔禾区','wuerhe','4','834012',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3222,'652100','650000','吐鲁番地区','tulufandi','3','838000',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3223,'652101','652100','吐鲁番市','tulufanshi','4','838000',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3224,'652122','652100','鄯善县','shanshanxian','4','838200',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3225,'652123','652100','托克逊县','tuokexunxian','4','838100',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3226,'652200','650000','哈密地区','hamidi','3','839000',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3227,'652201','652200','哈密市','hamishi','4','839000',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3228,'652222','652200','巴里坤哈萨克自治县','balikunhasakezizhixian','4','839200',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3229,'652223','652200','伊吾县','yiwuxian','4','839300',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3230,'652300','650000','昌吉回族自治州','changjihuizuzizhizhou','3','831100',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3231,'652301','652300','昌吉市','changjishi','4','831100',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3232,'652302','652300','阜康市','fukangshi','4','831500',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3233,'652323','652300','呼图壁县','hutubixian','4','831200',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3234,'652324','652300','玛纳斯县','manasixian','4','832200',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3235,'652325','652300','奇台县','qitaixian','4','831800',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3236,'652327','652300','吉木萨尔县','jimusaerxian','4','831700',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3237,'652328','652300','木垒哈萨克自治县','muleihasakezizhixian','4','831900',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3238,'652700','650000','博尔塔拉蒙古自治州','boertalamengguzizhizhou','3','833400',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3239,'652701','652700','博乐市','boleshi','4','833400',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3240,'652702','652700','阿拉山口市','alashankoushi','4','833400',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3241,'652722','652700','精河县','jinghexian','4','833300',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3242,'652723','652700','温泉县','wenquanxian','4','833500',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3243,'652800','650000','巴音郭楞蒙古自治州','bayinguolengmengguzizhizhou','3','841000',NULL,NULL,'2017-02-14 17:05:52',NULL,NULL,NULL,0),(3244,'652801','652800','库尔勒市','kuerleshi','4','841000',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3245,'652822','652800','轮台县','luntaixian','4','841600',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3246,'652823','652800','尉犁县','weilixian','4','841500',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3247,'652824','652800','若羌县','ruoqiangxian','4','841800',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3248,'652825','652800','且末县','qiemoxian','4','841900',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3249,'652826','652800','焉耆回族自治县','yanqihuizuzizhixian','4','841100',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3250,'652827','652800','和静县','hejingxian','4','841300',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3251,'652828','652800','和硕县','heshuoxian','4','841200',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3252,'652829','652800','博湖县','bohuxian','4','841400',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3253,'652900','650000','阿克苏地区','akesudi','3','843000',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3254,'652901','652900','阿克苏市','akesushi','4','843000',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3255,'652922','652900','温宿县','wensuxian','4','843100',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3256,'652923','652900','库车县','kuchexian','4','842000',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3257,'652924','652900','沙雅县','shayaxian','4','842200',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3258,'652925','652900','新和县','xinhexian','4','842100',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3259,'652926','652900','拜城县','baichengxian','4','842300',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3260,'652927','652900','乌什县','wushenxian','4','843400',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3261,'652928','652900','阿瓦提县','awatixian','4','843200',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3262,'652929','652900','柯坪县','kepingxian','4','843600',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3263,'653000','650000','克孜勒苏柯尔克孜自治州','kezilesukeerkezizizhizhou','3','845350',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3264,'653001','653000','阿图什市','atushenshi','4','845350',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3265,'653022','653000','阿克陶县','aketaoxian','4','845550',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3266,'653023','653000','阿合奇县','aheqixian','4','843500',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3267,'653024','653000','乌恰县','wuqiaxian','4','845450',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3268,'653100','650000','喀什地区','kashendi','3','844000',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3269,'653101','653100','喀什市','kashenshi','4','844000',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3270,'653121','653100','疏附县','shufuxian','4','844100',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3271,'653122','653100','疏勒县','shulexian','4','844200',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3272,'653123','653100','英吉沙县','yingjishaxian','4','844500',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3273,'653124','653100','泽普县','zepuxian','4','844800',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3274,'653125','653100','莎车县','shachexian','4','844700',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3275,'653126','653100','叶城县','yechengxian','4','844900',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3276,'653127','653100','麦盖提县','maigaitixian','4','844600',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3277,'653128','653100','岳普湖县','yuepuhuxian','4','844400',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3278,'653129','653100','伽师县','jiashixian','4','844300',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3279,'653130','653100','巴楚县','bachuxian','4','843800',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3280,'653131','653100','塔什库尔干塔吉克自治县','tashenkuergantajikezizhixian','4','845250',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3281,'653200','650000','和田地区','hetiandi','3','848000',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3282,'653201','653200','和田市','hetianshi','4','848000',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3283,'653221','653200','和田县','hetianxian','4','848000',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3284,'653222','653200','墨玉县','moyuxian','4','848100',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3285,'653223','653200','皮山县','pishanxian','4','845150',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3286,'653224','653200','洛浦县','luopuxian','4','848200',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3287,'653225','653200','策勒县','celexian','4','848300',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3288,'653226','653200','于田县','yutianxian','4','848400',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3289,'653227','653200','民丰县','minfengxian','4','848500',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3290,'654000','650000','伊犁哈萨克自治州','yilihasakezizhizhou','3','835100',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3291,'654002','654000','伊宁市','yiningshi','4','835000',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3292,'654003','654000','奎屯市','kuitunshi','4','833200',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3293,'654004','654000','霍尔果斯市','huoerguosishi','4','835221',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3294,'654021','654000','伊宁县','yiningxian','4','835100',NULL,NULL,'2017-02-14 17:05:53',NULL,NULL,NULL,0),(3295,'654022','654000','察布查尔锡伯自治县','chabuchaerxibozizhixian','4','835300',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3296,'654023','654000','霍城县','huochengxian','4','835200',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3297,'654024','654000','巩留县','gongliuxian','4','835400',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3298,'654025','654000','新源县','xinyuanxian','4','835800',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3299,'654026','654000','昭苏县','zhaosuxian','4','835600',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3300,'654027','654000','特克斯县','tekesixian','4','835500',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3301,'654028','654000','尼勒克县','nilekexian','4','835700',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3302,'654200','650000','塔城地区','tachengdi','3','834700',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3303,'654201','654200','塔城市','tachengshi','4','834700',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3304,'654202','654200','乌苏市','wusushi','4','833000',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3305,'654221','654200','额敏县','eminxian','4','834600',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3306,'654223','654200','沙湾县','shawanxian','4','832100',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3307,'654224','654200','托里县','tuolixian','4','834500',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3308,'654225','654200','裕民县','yuminxian','4','834800',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3309,'654226','654200','和布克赛尔蒙古自治县','hebukesaiermengguzizhixian','4','834400',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3310,'654300','650000','阿勒泰地区','aletaidi','3','836500',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3311,'654301','654300','阿勒泰市','aletaishi','4','836500',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3312,'654321','654300','布尔津县','buerjinxian','4','836600',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3313,'654322','654300','富蕴县','fuyunxian','4','836100',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3314,'654323','654300','福海县','fuhaixian','4','836400',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3315,'654324','654300','哈巴河县','habahexian','4','836700',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3316,'654325','654300','青河县','qinghexian','4','836200',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3317,'654326','654300','吉木乃县','jimunaixian','4','836800',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3318,'659000','650000','直辖县级','zhixiaxianji','-1','91.132212',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3319,'659001','659000','石河子市','shihezishi','4','832000',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3320,'659002','659000','阿拉尔市','alaershi','4','843300',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3321,'659003','659000','图木舒克市','tumushukeshi','4','843806',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3322,'659004','659000','五家渠市','wujiaqushi','4','831300',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3323,'659005','659000','北屯市','beitunshi','4','836000',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3324,'659006','659000','铁门关市','tiemenguanshi','4','836000',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3325,'659007','659000','双河市','shuangheshi','4','833408',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3326,'710000','100000','台湾','taiwan','2','',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3327,'710100','710000','台北市','taibeishi','3','1',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3328,'710101','710100','松山区','songshan','4','105',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3329,'710102','710100','信义区','xinyi','4','110',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3330,'710103','710100','大安区','daan','4','106',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3331,'710104','710100','中山区','zhongshan','4','104',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3332,'710105','710100','中正区','zhongzheng','4','100',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3333,'710106','710100','大同区','datong','4','103',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3334,'710107','710100','万华区','wanhua','4','108',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3335,'710108','710100','文山区','wenshan','4','116',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3336,'710109','710100','南港区','nangang','4','115',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3337,'710110','710100','内湖区','neihu','4','114',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3338,'710111','710100','士林区','shilin','4','111',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3339,'710112','710100','北投区','beitou','4','112',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3340,'710200','710000','高雄市','gaoxiongshi','3','8',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3341,'710201','710200','盐埕区','yancheng','4','803',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3342,'710202','710200','鼓山区','gushan','4','804',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3343,'710203','710200','左营区','zuoying','4','813',NULL,NULL,'2017-02-14 17:05:54',NULL,NULL,NULL,0),(3344,'710204','710200','楠梓区','nanzi','4','811',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3345,'710205','710200','三民区','sanmin','4','807',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3346,'710206','710200','新兴区','xinxing','4','800',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3347,'710207','710200','前金区','qianjin','4','801',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3348,'710208','710200','苓雅区','lingya','4','802',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3349,'710209','710200','前镇区','qianzhen','4','806',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3350,'710210','710200','旗津区','qijin','4','805',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3351,'710211','710200','小港区','xiaogang','4','812',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3352,'710212','710200','凤山区','fengshan','4','830',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3353,'710213','710200','林园区','linyuan','4','832',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3354,'710214','710200','大寮区','daliao','4','831',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3355,'710215','710200','大树区','dashu','4','840',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3356,'710216','710200','大社区','dashe','4','815',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3357,'710217','710200','仁武区','renwu','4','814',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3358,'710218','710200','鸟松区','niaosong','4','833',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3359,'710219','710200','冈山区','gangshan','4','820',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3360,'710220','710200','桥头区','qiaotou','4','825',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3361,'710221','710200','燕巢区','yanchao','4','824',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3362,'710222','710200','田寮区','tianliao','4','823',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3363,'710223','710200','阿莲区','alian','4','822',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3364,'710224','710200','路竹区','luzhu','4','821',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3365,'710225','710200','湖内区','hunei','4','829',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3366,'710226','710200','茄萣区','qieding','4','852',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3367,'710227','710200','永安区','yongan','4','828',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3368,'710228','710200','弥陀区','mituo','4','827',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3369,'710229','710200','梓官区','ziguan','4','826',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3370,'710230','710200','旗山区','qishan','4','842',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3371,'710231','710200','美浓区','meinong','4','843',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3372,'710232','710200','六龟区','liugui','4','844',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3373,'710233','710200','甲仙区','jiaxian','4','847',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3374,'710234','710200','杉林区','shanlin','4','846',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3375,'710235','710200','内门区','neimen','4','845',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3376,'710236','710200','茂林区','maolin','4','851',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3377,'710237','710200','桃源区','taoyuan','4','848',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3378,'710238','710200','那玛夏区','neimaxia','4','849',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3379,'710300','710000','基隆市','jilongshi','3','2',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3380,'710301','710300','中正区','zhongzheng','4','202',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3381,'710302','710300','七堵区','qidu','4','206',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3382,'710303','710300','暖暖区','nuannuan','4','205',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3383,'710304','710300','仁爱区','renai','4','200',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3384,'710305','710300','中山区','zhongshan','4','203',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3385,'710306','710300','安乐区','anle','4','204',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3386,'710307','710300','信义区','xinyi','4','201',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3387,'710400','710000','台中市','taizhongshi','3','4',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3388,'710401','710400','中区','zhong','4','400',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3389,'710402','710400','东区','dong','4','401',NULL,NULL,'2017-02-14 17:05:55',NULL,NULL,NULL,0),(3390,'710403','710400','南区','nan','4','402',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3391,'710404','710400','西区','xi','4','403',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3392,'710405','710400','北区','bei','4','404',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3393,'710406','710400','西屯区','xitun','4','407',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3394,'710407','710400','南屯区','nantun','4','408',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3395,'710408','710400','北屯区','beitun','4','406',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3396,'710409','710400','丰原区','fengyuan','4','420',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3397,'710410','710400','东势区','dongshi','4','423',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3398,'710411','710400','大甲区','dajia','4','437',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3399,'710412','710400','清水区','qingshui','4','436',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3400,'710413','710400','沙鹿区','shalu','4','433',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3401,'710414','710400','梧栖区','wuqi','4','435',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3402,'710415','710400','后里区','houli','4','421',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3403,'710416','710400','神冈区','shengang','4','429',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3404,'710417','710400','潭子区','tanzi','4','427',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3405,'710418','710400','大雅区','daya','4','428',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3406,'710419','710400','新社区','xinshe','4','426',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3407,'710420','710400','石冈区','shigang','4','422',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3408,'710421','710400','外埔区','waipu','4','438',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3409,'710422','710400','大安区','daan','4','439',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3410,'710423','710400','乌日区','wuri','4','414',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3411,'710424','710400','大肚区','dadu','4','432',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3412,'710425','710400','龙井区','longjing','4','434',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3413,'710426','710400','雾峰区','wufeng','4','413',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3414,'710427','710400','太平区','taiping','4','411',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3415,'710428','710400','大里区','dali','4','412',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3416,'710429','710400','和平区','heping','4','424',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3417,'710500','710000','台南市','tainanshi','3','7',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3418,'710501','710500','东区','dong','4','701',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3419,'710502','710500','南区','nan','4','702',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3420,'710504','710500','北区','bei','4','704',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3421,'710506','710500','安南区','annan','4','709',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3422,'710507','710500','安平区','anping','4','708',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3423,'710508','710500','中西区','zhongxi','4','700',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3424,'710509','710500','新营区','xinying','4','730',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3425,'710510','710500','盐水区','yanshui','4','737',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3426,'710511','710500','白河区','baihe','4','732',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3427,'710512','710500','柳营区','liuying','4','736',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3428,'710513','710500','后壁区','houbi','4','731',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3429,'710514','710500','东山区','dongshan','4','733',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3430,'710515','710500','麻豆区','madou','4','721',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3431,'710516','710500','下营区','xiaying','4','735',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3432,'710517','710500','六甲区','liujia','4','734',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3433,'710518','710500','官田区','guantian','4','720',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3434,'710519','710500','大内区','danei','4','742',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3435,'710520','710500','佳里区','jiali','4','722',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3436,'710521','710500','学甲区','xuejia','4','726',NULL,NULL,'2017-02-14 17:05:56',NULL,NULL,NULL,0),(3437,'710522','710500','西港区','xigang','4','723',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3438,'710523','710500','七股区','qigu','4','724',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3439,'710524','710500','将军区','jiangjun','4','725',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3440,'710525','710500','北门区','beimen','4','727',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3441,'710526','710500','新化区','xinhua','4','712',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3442,'710527','710500','善化区','shanhua','4','741',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3443,'710528','710500','新市区','xinshi','4','744',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3444,'710529','710500','安定区','anding','4','745',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3445,'710530','710500','山上区','shanshang','4','743',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3446,'710531','710500','玉井区','yujing','4','714',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3447,'710532','710500','楠西区','nanxi','4','715',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3448,'710533','710500','南化区','nanhua','4','716',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3449,'710534','710500','左镇区','zuozhen','4','713',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3450,'710535','710500','仁德区','rende','4','717',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3451,'710536','710500','归仁区','guiren','4','711',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3452,'710537','710500','关庙区','guanmiao','4','718',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3453,'710538','710500','龙崎区','longqi','4','719',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3454,'710539','710500','永康区','yongkang','4','710',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3455,'710600','710000','新竹市','xinzhushi','3','3',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3456,'710601','710600','东区','dong','4','300',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3457,'710602','710600','北区','bei','4','',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3458,'710603','710600','香山区','xiangshan','4','',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3459,'710700','710000','嘉义市','jiayishi','3','6',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3460,'710701','710700','东区','dong','4','600',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3461,'710702','710700','西区','xi','4','600',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3462,'710800','710000','新北市','xinbeishi','3','2',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3463,'710801','710800','板桥区','banqiao','4','220',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3464,'710802','710800','三重区','sanzhong','4','241',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3465,'710803','710800','中和区','zhonghe','4','235',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3466,'710804','710800','永和区','yonghe','4','234',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3467,'710805','710800','新庄区','xinzhuang','4','242',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3468,'710806','710800','新店区','xindian','4','231',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3469,'710807','710800','树林区','shulin','4','238',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3470,'710808','710800','莺歌区','yingge','4','239',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3471,'710809','710800','三峡区','sanxia','4','237',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3472,'710810','710800','淡水区','danshui','4','251',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3473,'710811','710800','汐止区','xizhi','4','221',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3474,'710812','710800','瑞芳区','ruifang','4','224',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3475,'710813','710800','土城区','tucheng','4','236',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3476,'710814','710800','芦洲区','luzhou','4','247',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3477,'710815','710800','五股区','wugu','4','248',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3478,'710816','710800','泰山区','taishan','4','243',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3479,'710817','710800','林口区','linkou','4','244',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3480,'710818','710800','深坑区','shenkeng','4','222',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3481,'710819','710800','石碇区','shiding','4','223',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3482,'710820','710800','坪林区','pinglin','4','232',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3483,'710821','710800','三芝区','sanzhi','4','252',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3484,'710822','710800','石门区','shimen','4','253',NULL,NULL,'2017-02-14 17:05:57',NULL,NULL,NULL,0),(3485,'710823','710800','八里区','bali','4','249',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3486,'710824','710800','平溪区','pingxi','4','226',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3487,'710825','710800','双溪区','shuangxi','4','227',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3488,'710826','710800','贡寮区','gongliao','4','228',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3489,'710827','710800','金山区','jinshan','4','208',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3490,'710828','710800','万里区','wanli','4','207',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3491,'710829','710800','乌来区','wulai','4','233',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3492,'712200','710000','宜兰县','yilanxian','3','2',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3493,'712201','712200','宜兰市','yilanshi','4','260',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3494,'712221','712200','罗东镇','luodongzhen','4','265',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3495,'712222','712200','苏澳镇','suaozhen','4','270',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3496,'712223','712200','头城镇','touchengzhen','4','261',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3497,'712224','712200','礁溪乡','jiaoxixiang','4','262',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3498,'712225','712200','壮围乡','zhuangweixiang','4','263',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3499,'712226','712200','员山乡','yuanshanxiang','4','264',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3500,'712227','712200','冬山乡','dongshanxiang','4','269',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3501,'712228','712200','五结乡','wujiexiang','4','268',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3502,'712229','712200','三星乡','sanxingxiang','4','266',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3503,'712230','712200','大同乡','datongxiang','4','267',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3504,'712231','712200','南澳乡','nanaoxiang','4','272',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3505,'712300','710000','桃园县','taoyuanxian','3','3',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3506,'712301','712300','桃园市','taoyuanshi','4','330',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3507,'712302','712300','中坜市','zhonglishi','4','320',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3508,'712303','712300','平镇市','pingzhenshi','4','324',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3509,'712304','712300','八德市','badeshi','4','334',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3510,'712305','712300','杨梅市','yangmeishi','4','326',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3511,'712306','712300','芦竹市','luzhushi','4','338',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3512,'712321','712300','大溪镇','daxizhen','4','335',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3513,'712324','712300','大园乡','dayuanxiang','4','337',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3514,'712325','712300','龟山乡','guishanxiang','4','333',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3515,'712327','712300','龙潭乡','longtanxiang','4','325',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3516,'712329','712300','新屋乡','xinwuxiang','4','327',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3517,'712330','712300','观音乡','guanyinxiang','4','328',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3518,'712331','712300','复兴乡','fuxingxiang','4','336',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3519,'712400','710000','新竹县','xinzhuxian','3','3',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3520,'712401','712400','竹北市','zhubeishi','4','302',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3521,'712421','712400','竹东镇','zhudongzhen','4','310',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3522,'712422','712400','新埔镇','xinpuzhen','4','305',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3523,'712423','712400','关西镇','guanxizhen','4','306',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3524,'712424','712400','湖口乡','hukouxiang','4','303',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3525,'712425','712400','新丰乡','xinfengxiang','4','304',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3526,'712426','712400','芎林乡','xionglinxiang','4','307',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3527,'712427','712400','横山乡','hengshanxiang','4','312',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3528,'712428','712400','北埔乡','beipuxiang','4','314',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3529,'712429','712400','宝山乡','baoshanxiang','4','308',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3530,'712430','712400','峨眉乡','emeixiang','4','315',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3531,'712431','712400','尖石乡','jianshixiang','4','313',NULL,NULL,'2017-02-14 17:05:58',NULL,NULL,NULL,0),(3532,'712432','712400','五峰乡','wufengxiang','4','311',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3533,'712500','710000','苗栗县','miaolixian','3','3',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3534,'712501','712500','苗栗市','miaolishi','4','360',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3535,'712521','712500','苑里镇','yuanlizhen','4','358',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3536,'712522','712500','通霄镇','tongxiaozhen','4','357',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3537,'712523','712500','竹南镇','zhunanzhen','4','350',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3538,'712524','712500','头份镇','toufenzhen','4','351',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3539,'712525','712500','后龙镇','houlongzhen','4','356',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3540,'712526','712500','卓兰镇','zhuolanzhen','4','369',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3541,'712527','712500','大湖乡','dahuxiang','4','364',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3542,'712528','712500','公馆乡','gongguanxiang','4','363',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3543,'712529','712500','铜锣乡','tongluoxiang','4','366',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3544,'712530','712500','南庄乡','nanzhuangxiang','4','353',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3545,'712531','712500','头屋乡','touwuxiang','4','362',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3546,'712532','712500','三义乡','sanyixiang','4','367',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3547,'712533','712500','西湖乡','xihuxiang','4','368',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3548,'712534','712500','造桥乡','zaoqiaoxiang','4','361',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3549,'712535','712500','三湾乡','sanwanxiang','4','352',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3550,'712536','712500','狮潭乡','shitanxiang','4','354',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3551,'712537','712500','泰安乡','taianxiang','4','365',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3552,'712700','710000','彰化县','zhanghuaxian','3','5',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3553,'712701','712700','彰化市','zhanghuashi','4','500',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3554,'712721','712700','鹿港镇','lugangzhen','4','505',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3555,'712722','712700','和美镇','hemeizhen','4','508',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3556,'712723','712700','线西乡','xianxixiang','4','507',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3557,'712724','712700','伸港乡','shengangxiang','4','509',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3558,'712725','712700','福兴乡','fuxingxiang','4','506',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3559,'712726','712700','秀水乡','xiushuixiang','4','504',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3560,'712727','712700','花坛乡','huatanxiang','4','503',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3561,'712728','712700','芬园乡','fenyuanxiang','4','502',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3562,'712729','712700','员林镇','yuanlinzhen','4','510',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3563,'712730','712700','溪湖镇','xihuzhen','4','514',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3564,'712731','712700','田中镇','tianzhongzhen','4','520',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3565,'712732','712700','大村乡','dacunxiang','4','515',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3566,'712733','712700','埔盐乡','puyanxiang','4','516',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3567,'712734','712700','埔心乡','puxinxiang','4','513',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3568,'712735','712700','永靖乡','yongjingxiang','4','512',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3569,'712736','712700','社头乡','shetouxiang','4','511',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3570,'712737','712700','二水乡','ershuixiang','4','530',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3571,'712738','712700','北斗镇','beidouzhen','4','521',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3572,'712739','712700','二林镇','erlinzhen','4','526',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3573,'712740','712700','田尾乡','tianweixiang','4','522',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3574,'712741','712700','埤头乡','pitouxiang','4','523',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3575,'712742','712700','芳苑乡','fangyuanxiang','4','528',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3576,'712743','712700','大城乡','dachengxiang','4','527',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3577,'712744','712700','竹塘乡','zhutangxiang','4','525',NULL,NULL,'2017-02-14 17:05:59',NULL,NULL,NULL,0),(3578,'712745','712700','溪州乡','xizhouxiang','4','524',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3579,'712800','710000','南投县','nantouxian','3','5',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3580,'712801','712800','南投市','nantoushi','4','540',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3581,'712821','712800','埔里镇','pulizhen','4','545',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3582,'712822','712800','草屯镇','caotunzhen','4','542',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3583,'712823','712800','竹山镇','zhushanzhen','4','557',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3584,'712824','712800','集集镇','jijizhen','4','552',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3585,'712825','712800','名间乡','mingjianxiang','4','551',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3586,'712826','712800','鹿谷乡','luguxiang','4','558',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3587,'712827','712800','中寮乡','zhongliaoxiang','4','541',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3588,'712828','712800','鱼池乡','yuchixiang','4','555',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3589,'712829','712800','国姓乡','guoxingxiang','4','544',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3590,'712830','712800','水里乡','shuilixiang','4','553',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3591,'712831','712800','信义乡','xinyixiang','4','556',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3592,'712832','712800','仁爱乡','renaixiang','4','546',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3593,'712900','710000','云林县','yunlinxian','3','6',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3594,'712901','712900','斗六市','douliushi','4','640',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3595,'712921','712900','斗南镇','dounanzhen','4','630',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3596,'712922','712900','虎尾镇','huweizhen','4','632',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3597,'712923','712900','西螺镇','xiluozhen','4','648',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3598,'712924','712900','土库镇','tukuzhen','4','633',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3599,'712925','712900','北港镇','beigangzhen','4','651',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3600,'712926','712900','古坑乡','gukengxiang','4','646',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3601,'712927','712900','大埤乡','dapixiang','4','631',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3602,'712928','712900','莿桐乡','citongxiang','4','647',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3603,'712929','712900','林内乡','linneixiang','4','643',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3604,'712930','712900','二仑乡','erlunxiang','4','649',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3605,'712931','712900','仑背乡','lunbeixiang','4','637',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3606,'712932','712900','麦寮乡','mailiaoxiang','4','638',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3607,'712933','712900','东势乡','dongshixiang','4','635',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3608,'712934','712900','褒忠乡','baozhongxiang','4','634',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3609,'712935','712900','台西乡','taixixiang','4','636',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3610,'712936','712900','元长乡','yuanzhangxiang','4','655',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3611,'712937','712900','四湖乡','sihuxiang','4','654',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3612,'712938','712900','口湖乡','kouhuxiang','4','653',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3613,'712939','712900','水林乡','shuilinxiang','4','652',NULL,NULL,'2017-02-14 17:06:00',NULL,NULL,NULL,0),(3614,'713000','710000','嘉义县','jiayixian','3','6',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3615,'713001','713000','太保市','taibaoshi','4','612',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3616,'713002','713000','朴子市','pozishi','4','613',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3617,'713023','713000','布袋镇','budaizhen','4','625',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3618,'713024','713000','大林镇','dalinzhen','4','622',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3619,'713025','713000','民雄乡','minxiongxiang','4','621',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3620,'713026','713000','溪口乡','xikouxiang','4','623',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3621,'713027','713000','新港乡','xingangxiang','4','616',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3622,'713028','713000','六脚乡','liujiaoxiang','4','615',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3623,'713029','713000','东石乡','dongshixiang','4','614',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3624,'713030','713000','义竹乡','yizhuxiang','4','624',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3625,'713031','713000','鹿草乡','lucaoxiang','4','611',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3626,'713032','713000','水上乡','shuishangxiang','4','608',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3627,'713033','713000','中埔乡','zhongpuxiang','4','606',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3628,'713034','713000','竹崎乡','zhuqixiang','4','604',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3629,'713035','713000','梅山乡','meishanxiang','4','603',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3630,'713036','713000','番路乡','fanluxiang','4','602',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3631,'713037','713000','大埔乡','dapuxiang','4','607',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3632,'713038','713000','阿里山乡','alishanxiang','4','605',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3633,'713300','710000','屏东县','pingdongxian','3','9',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3634,'713301','713300','屏东市','pingdongshi','4','900',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3635,'713321','713300','潮州镇','chaozhouzhen','4','920',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3636,'713322','713300','东港镇','donggangzhen','4','928',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3637,'713323','713300','恒春镇','hengchunzhen','4','946',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3638,'713324','713300','万丹乡','wandanxiang','4','913',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3639,'713325','713300','长治乡','zhangzhixiang','4','908',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3640,'713326','713300','麟洛乡','linluoxiang','4','909',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3641,'713327','713300','九如乡','jiuruxiang','4','904',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3642,'713328','713300','里港乡','ligangxiang','4','905',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3643,'713329','713300','盐埔乡','yanpuxiang','4','907',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3644,'713330','713300','高树乡','gaoshuxiang','4','906',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3645,'713331','713300','万峦乡','wanluanxiang','4','923',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3646,'713332','713300','内埔乡','neipuxiang','4','912',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3647,'713333','713300','竹田乡','zhutianxiang','4','911',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3648,'713334','713300','新埤乡','xinpixiang','4','925',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3649,'713335','713300','枋寮乡','fangliaoxiang','4','940',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3650,'713336','713300','新园乡','xinyuanxiang','4','932',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3651,'713337','713300','崁顶乡','kandingxiang','4','924',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3652,'713338','713300','林边乡','linbianxiang','4','927',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3653,'713339','713300','南州乡','nanzhouxiang','4','926',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3654,'713340','713300','佳冬乡','jiadongxiang','4','931',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3655,'713341','713300','琉球乡','liuqiuxiang','4','929',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3656,'713342','713300','车城乡','chechengxiang','4','944',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3657,'713343','713300','满州乡','manzhouxiang','4','947',NULL,NULL,'2017-02-14 17:06:01',NULL,NULL,NULL,0),(3658,'713344','713300','枋山乡','fangshanxiang','4','941',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3659,'713345','713300','三地门乡','sandimenxiang','4','901',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3660,'713346','713300','雾台乡','wutaixiang','4','902',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3661,'713347','713300','玛家乡','majiaxiang','4','903',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3662,'713348','713300','泰武乡','taiwuxiang','4','921',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3663,'713349','713300','来义乡','laiyixiang','4','922',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3664,'713350','713300','春日乡','chunrixiang','4','942',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3665,'713351','713300','狮子乡','shizixiang','4','943',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3666,'713352','713300','牡丹乡','mudanxiang','4','945',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3667,'713400','710000','台东县','taidongxian','3','9',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3668,'713401','713400','台东市','taidongshi','4','950',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3669,'713421','713400','成功镇','chenggongzhen','4','961',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3670,'713422','713400','关山镇','guanshanzhen','4','956',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3671,'713423','713400','卑南乡','beinanxiang','4','954',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3672,'713424','713400','鹿野乡','luyexiang','4','955',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3673,'713425','713400','池上乡','chishangxiang','4','958',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3674,'713426','713400','东河乡','donghexiang','4','959',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3675,'713427','713400','长滨乡','zhangbinxiang','4','962',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3676,'713428','713400','太麻里乡','taimalixiang','4','963',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3677,'713429','713400','大武乡','dawuxiang','4','965',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3678,'713430','713400','绿岛乡','lvdaoxiang','4','951',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3679,'713431','713400','海端乡','haiduanxiang','4','957',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3680,'713432','713400','延平乡','yanpingxiang','4','953',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3681,'713433','713400','金峰乡','jinfengxiang','4','964',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3682,'713434','713400','达仁乡','darenxiang','4','966',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3683,'713435','713400','兰屿乡','lanyuxiang','4','952',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3684,'713500','710000','花莲县','hualianxian','3','9',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3685,'713501','713500','花莲市','hualianshi','4','970',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3686,'713521','713500','凤林镇','fenglinzhen','4','975',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3687,'713522','713500','玉里镇','yulizhen','4','981',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3688,'713523','713500','新城乡','xinchengxiang','4','971',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3689,'713524','713500','吉安乡','jianxiang','4','973',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3690,'713525','713500','寿丰乡','shoufengxiang','4','974',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3691,'713526','713500','光复乡','guangfuxiang','4','976',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3692,'713527','713500','丰滨乡','fengbinxiang','4','977',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3693,'713528','713500','瑞穗乡','ruisuixiang','4','978',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3694,'713529','713500','富里乡','fulixiang','4','983',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3695,'713530','713500','秀林乡','xiulinxiang','4','972',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3696,'713531','713500','万荣乡','wanrongxiang','4','979',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3697,'713532','713500','卓溪乡','zhuoxixiang','4','982',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3698,'713600','710000','澎湖县','penghuxian','3','8',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3699,'713601','713600','马公市','magongshi','4','880',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3700,'713621','713600','湖西乡','huxixiang','4','885',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3701,'713622','713600','白沙乡','baishaxiang','4','884',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3702,'713623','713600','西屿乡','xiyuxiang','4','881',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3703,'713624','713600','望安乡','wanganxiang','4','882',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3704,'713625','713600','七美乡','qimeixiang','4','883',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3705,'713700','710000','金门县','jinmenxian','3','8',NULL,NULL,'2017-02-14 17:06:02',NULL,NULL,NULL,0),(3706,'713701','713700','金城镇','jinchengzhen','4','893',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3707,'713702','713700','金湖镇','jinhuzhen','4','891',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3708,'713703','713700','金沙镇','jinshazhen','4','890',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3709,'713704','713700','金宁乡','jinningxiang','4','892',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3710,'713705','713700','烈屿乡','lieyuxiang','4','894',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3711,'713706','713700','乌丘乡','wuqiuxiang','4','896',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3712,'713800','710000','连江县','lianjiangxian','3','2',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3713,'713801','713800','南竿乡','nanganxiang','4','209',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3714,'713802','713800','北竿乡','beiganxiang','4','210',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3715,'713803','713800','莒光乡','juguangxiang','4','211',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3716,'713804','713800','东引乡','dongyinxiang','4','212',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3717,'810000','100000','香港特别行政区','xianggangtebiexingzheng','2','',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3718,'810100','810000','香港岛','xianggangdao','3','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3719,'810101','810100','中西区','zhongxi','4','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3720,'810102','810100','湾仔区','wanzi','4','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3721,'810103','810100','东区','dong','4','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3722,'810104','810100','南区','nan','4','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3723,'810200','810000','九龙','jiulong','3','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3724,'810201','810200','油尖旺区','youjianwang','4','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3725,'810202','810200','深水埗区','shenshuibu','4','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3726,'810203','810200','九龙城区','jiulongcheng','4','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3727,'810204','810200','黄大仙区','huangdaxian','4','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3728,'810205','810200','观塘区','guantang','4','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3729,'810300','810000','新界','xinjie','3','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3730,'810301','810300','荃湾区','quanwan','4','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3731,'810302','810300','屯门区','tunmen','4','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3732,'810303','810300','元朗区','yuanlang','4','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3733,'810304','810300','北区','bei','4','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3734,'810305','810300','大埔区','dapu','4','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3735,'810306','810300','西贡区','xigong','4','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3736,'810307','810300','沙田区','shatian','4','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3737,'810308','810300','葵青区','kuiqing','4','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3738,'810309','810300','离岛区','lidao','4','999077',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3739,'820000','100000','澳门特别行政区','aomentebiexingzheng','2','',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3740,'820100','820000','澳门半岛','aomenbandao','3','999078',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3741,'820101','820100','花地玛堂区','huadimatang','4','999078',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3742,'820102','820100','圣安多尼堂区','shenganduonitang','4','999078',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3743,'820103','820100','大堂区','datang','4','999078',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3744,'820104','820100','望德堂区','wangdetang','4','999078',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3745,'820105','820100','风顺堂区','fengshuntang','4','999078',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3746,'820200','820000','氹仔岛','dangzidao','3','999078',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3747,'820201','820200','嘉模堂区','jiamotang','4','999078',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3748,'820300','820000','路环岛','luhuandao','3','999078',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3749,'820301','820300','圣方济各堂区','shengfangjigetang','4','999078',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0),(3750,'900000','100000','钓鱼岛','diaoyudao','2','',NULL,NULL,'2017-02-14 17:06:03',NULL,NULL,NULL,0);

/*Table structure for table `sys_permission` */

DROP TABLE IF EXISTS `sys_permission`;

CREATE TABLE `sys_permission` (
  `id` varchar(64) NOT NULL COMMENT '权限ID',
  `name` varchar(256) DEFAULT NULL COMMENT '权限名',
  `description` varchar(64) DEFAULT NULL COMMENT '权限描述',
  `permission_code` varchar(20) DEFAULT NULL COMMENT '权限编号',
  `permission_type` varchar(32) DEFAULT NULL COMMENT '权限类型 0:目录 1：页面 2：按钮',
  `parent_id` varchar(64) DEFAULT '0' COMMENT '父级权限ID',
  `url` varchar(512) DEFAULT NULL COMMENT '权限对应的链接',
  `is_delete` int(1) DEFAULT NULL COMMENT '是否删除 0：未删除 1：已删除',
  PRIMARY KEY (`id`),
  UNIQUE KEY `permission_code_UNIQUE` (`permission_code`,`is_delete`),
  UNIQUE KEY `permission_type_unique` (`permission_type`,`is_delete`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sys_permission` */

insert  into `sys_permission`(`id`,`name`,`description`,`permission_code`,`permission_type`,`parent_id`,`url`,`is_delete`) values ('008e3e95-8347-4462-ad32-8d196cb9bb07','更新编辑文章','更新编辑的文章','A04','2','f6dec23b-617d-4bcd-b620-6a877c9fc5bc','',NULL),('00cc24fe-090b-4807-81c6-897d8d455876','保存新增目录','保存新增目录权限','F04','2','1f0e0127-32f6-4dd4-a49a-381b1ec4d295','',NULL),('014a3438-87bc-4c1c-a53a-5019be7ebee1','删除轮播图','删除轮播图权限','H07','2','50d367df-0f1e-4a0f-88e7-30f774a88e9f','',NULL),('09826703-3139-4c41-a57d-7213749baaf3','目录列表','目录管理页面权限','F02','1','1f0e0127-32f6-4dd4-a49a-381b1ec4d295','/adminManager/folder/list.html',NULL),('0a64115e-432e-4f31-bbea-4f3069ce65c1','编辑个人信息','编辑个人信息权限','U05','2','9b3ef746-9e67-430d-a934-0f8ed8d032c6','',NULL),('0ba07b76-b0ad-453e-b6e5-11f0d991afc7','新增角色权限','新增角色权限的权限','R09','2','442e400c-dd90-40eb-b3c9-d7ec0510b165','',NULL),('0e6274b4-56f5-458b-af4e-019965a3733a','权限列表','权限管理页面权限','P02','1','b06d328f-3f55-4f47-a4e7-6378704ac4e0','/adminManager/sysPermission/list.html',NULL),('13d07a6c-4212-45da-adf6-32f12d6afe5e','新增用户','新增用户权限','U03','2','9b3ef746-9e67-430d-a934-0f8ed8d032c6','',NULL),('19f8b032-3e3c-49e5-a71b-9e3d51a6086b','删除友情链接','删除友情链接权限','B07','2','923e2d78-54c5-411b-a803-533e1b6f6bef','',NULL),('1a4d64cd-10c1-48d3-a3c1-3b64a6c95de6','新增轮播图','新增轮播图权限','H03','2','50d367df-0f1e-4a0f-88e7-30f774a88e9f','',NULL),('1a5d23db-33c1-4e92-b263-9fd54b9bb32e','更新编辑系统配置','更新编辑系统配置权限','C04','2','604acbe1-c62c-4181-bfb1-4efb95b81b73','',NULL),('1ee56fb6-ead8-4b0a-a7ab-4e89c9a7f0a6','新增权限','新增权限的权限','P03','2','b06d328f-3f55-4f47-a4e7-6378704ac4e0','',NULL),('1f0e0127-32f6-4dd4-a49a-381b1ec4d295','目录管理','目录管理权限','F01','0','0','',NULL),('210858ee-760c-4070-a5a4-e667361e46dd','删除角色','删除角色权限','R07','2','756d46d3-cccb-45fb-9bb7-b267bfc12ece','',NULL),('21e2e638-6ff2-444a-99b7-d71b57d36eb5','审核文章','审核文章权限','A08','2','bbe3e74e-ee3b-43de-9e9f-1b826b260921','',NULL),('2bc93385-18b8-4e9c-a6ff-358c748c3c15','更新编辑权限','更新编辑权限的权限','P06','2','d124e786-f4db-4a02-b26b-130544c71ab0','',NULL),('2e050109-80a0-4cad-a302-e29421612f35','文章列表','文章管理页面','A02','1','bbe3e74e-ee3b-43de-9e9f-1b826b260921','/adminManager/article/list.html',NULL),('2fd313e5-c1b9-49f4-a440-9344aae0dccf','保存新增用户','保存新增用户权限','U07','2','13d07a6c-4212-45da-adf6-32f12d6afe5e','',NULL),('387ef7a5-d791-4f43-b3ea-546408a65f0d','更新编辑友情链接','更新编辑友情链接结果','B06','2','4d07d78e-a160-4466-8100-078c388df9fb','',NULL),('38e18301-d1b0-4349-886b-be2e80d21ea5','更新目录排序','更新目录排序权限','F08','2','1f0e0127-32f6-4dd4-a49a-381b1ec4d295','',NULL),('392ef53e-e6d1-4fec-9619-bda18e1684e9','上传文件','上传文件权限','C05','2','604acbe1-c62c-4181-bfb1-4efb95b81b73','',NULL),('3acc5f2a-b148-44e6-a08c-3c1ec61e223f','新增变更用户角色','新增变更用户角色权限','U11','2','5c8e7f32-9a27-41fc-b829-423b805ca76c','',NULL),('3ce16eba-abe2-421e-b971-db8bd605c460','修改密码','修改密码权限','U06','2','9b3ef746-9e67-430d-a934-0f8ed8d032c6','',NULL),('41a8ac6e-3971-4906-a908-c20e4849528f','隐藏显示目录','隐藏显示目录权限','F09','2','1f0e0127-32f6-4dd4-a49a-381b1ec4d295','',NULL),('442e400c-dd90-40eb-b3c9-d7ec0510b165','角色权限管理','角色权限管理权限','R08','2','756d46d3-cccb-45fb-9bb7-b267bfc12ece','',NULL),('4d07d78e-a160-4466-8100-078c388df9fb','编辑友情链接','编辑友情链接权限','B04','2','923e2d78-54c5-411b-a803-533e1b6f6bef','',NULL),('4d2bc708-2e91-4572-b714-3c1804453d10','删除文章','删除文章权限','A07','2','bbe3e74e-ee3b-43de-9e9f-1b826b260921','',NULL),('50d367df-0f1e-4a0f-88e7-30f774a88e9f','轮播图管理','轮播图管理权限','H01','0','0','',NULL),('535d700d-43ff-49d8-b5b9-ddf99f04fa72','角色列表','角色管理页面权限','R02','1','756d46d3-cccb-45fb-9bb7-b267bfc12ece','/adminManager/sysRole/list.html',NULL),('5959a0c4-9c92-4830-8df6-8193f56f8d64','删除任务','删除任务权限','J07','2','ee17082e-aa07-4b8a-b03c-8088ec393b6b','',NULL),('59743c9e-7940-4603-8782-4bfc65365d37','保存新增权限','保存新增权限的权限','P05','2','1ee56fb6-ead8-4b0a-a7ab-4e89c9a7f0a6','',NULL),('5b340fdf-a9dc-4861-9041-d819dee3e48b','更新编辑轮播图','更新编辑轮播图权限','H06','2','cdbce194-64d0-4773-aedf-edbf9e168520','',NULL),('5c8e7f32-9a27-41fc-b829-423b805ca76c','用户角色管理','用户角色管理权限','U10','2','9b3ef746-9e67-430d-a934-0f8ed8d032c6','',NULL),('604acbe1-c62c-4181-bfb1-4efb95b81b73','系统配置管理','系统配置管理权限','C01','0','0','',NULL),('662a3834-9a3a-4981-8d4c-bea8068474ff','新增文章','新增文章权限','A05','2','bbe3e74e-ee3b-43de-9e9f-1b826b260921','',NULL),('71cded1e-81b2-4db9-874e-8debc1a51e07','删除角色权限','删除角色权限的权限','R10','2','442e400c-dd90-40eb-b3c9-d7ec0510b165','',NULL),('756d46d3-cccb-45fb-9bb7-b267bfc12ece','角色管理','角色管理权限','R01','0','0','',NULL),('777d1c4d-45dd-492b-8d5e-a90057fccb08','保存新增角色','保存新增角色权限','R05','2','e48e6a26-e804-4c54-ba3f-a4094ac9e84c','',NULL),('7ed58526-02d3-4d5d-b6de-ce01dd6a34f7','隐藏显示文章','隐藏显示文章权限','A09','2','bbe3e74e-ee3b-43de-9e9f-1b826b260921','',NULL),('83fd8854-cabd-4267-851d-8802afe2ba47','更新编辑角色','更新编辑角色权限','R06','2','c3710484-2dea-427f-b7d5-c50aa0433cb5','',NULL),('89476bdb-f368-49e2-bd9e-4e4bb1f460fe','恢复任务','恢复任务权限','J06','2','ee17082e-aa07-4b8a-b03c-8088ec393b6b','',NULL),('8de3367d-4ac1-4c83-8136-dfde41032039','删除权限','删除权限的权限','P07','2','b06d328f-3f55-4f47-a4e7-6378704ac4e0','',NULL),('923e2d78-54c5-411b-a803-533e1b6f6bef','友情链接管理','友情链接管理权限','B01','0','0','',NULL),('95e380f8-324c-4569-bb6b-85c461a4259a','删除用户','删除用户权限','U09','2','9b3ef746-9e67-430d-a934-0f8ed8d032c6','',NULL),('9b3ef746-9e67-430d-a934-0f8ed8d032c6','用户管理','用户管理权限','U01','0','0','',NULL),('a2c1af1e-b0e7-4149-9f31-d63ffd96519b','编辑目录','编辑目录权限','F03','2','1f0e0127-32f6-4dd4-a49a-381b1ec4d295','',NULL),('b06d328f-3f55-4f47-a4e7-6378704ac4e0','权限管理','权限管理权限','P01','0','0','',NULL),('b270b755-21fb-4b03-9296-ab781e667822','编辑任务','编辑任务权限','J08','2','ee17082e-aa07-4b8a-b03c-8088ec393b6b','',NULL),('baa593c9-54ad-423f-95a8-96468b5b8907','删除目录','删除目录权限','F07','2','1f0e0127-32f6-4dd4-a49a-381b1ec4d295','',NULL),('bbe3e74e-ee3b-43de-9e9f-1b826b260921','文章管理','文章管理目录权限','A01','0','0','',NULL),('bddb070b-3c75-4c1e-ac4b-f88c7a571dd4','新增任务','新增任务权限','J03','2','ee17082e-aa07-4b8a-b03c-8088ec393b6b','',NULL),('c1ff0fce-d8d6-4120-ae92-576beacd253e','停止任务','停止任务权限','J05','2','ee17082e-aa07-4b8a-b03c-8088ec393b6b','',NULL),('c27eed37-b158-4f40-aeda-72e82453934d','新增有情连接','新增友情链接权限','B03','2','923e2d78-54c5-411b-a803-533e1b6f6bef','',NULL),('c3710484-2dea-427f-b7d5-c50aa0433cb5','编辑角色','编辑角色权限','R04','2','756d46d3-cccb-45fb-9bb7-b267bfc12ece','',NULL),('c88a237b-302b-4648-a4a6-1fa0f20b67f7','保存编辑个人信息','保存编辑个人信息权限','U12','2','0a64115e-432e-4f31-bbea-4f3069ce65c1','',NULL),('cd51e8d3-bb53-4f70-8fc4-5905b6c5dbe2','系统配置列表','系统配置页面权限','C02','1','604acbe1-c62c-4181-bfb1-4efb95b81b73','/adminManager/config/config.html',NULL),('cdbce194-64d0-4773-aedf-edbf9e168520','编辑轮播图','编辑轮播图权限','H04','2','50d367df-0f1e-4a0f-88e7-30f774a88e9f','',NULL),('d124e786-f4db-4a02-b26b-130544c71ab0','编辑权限','编辑权限的权限','P04','2','b06d328f-3f55-4f47-a4e7-6378704ac4e0','',NULL),('d833fe7b-92bd-416b-bea0-9fc6629678c6','编辑系统配置','编辑系统配置','C03','2','604acbe1-c62c-4181-bfb1-4efb95b81b73','',NULL),('d90a566b-2b9e-41da-8767-91b45647b513','更新编辑目录','更新编辑目录权限','F05','2','1f0e0127-32f6-4dd4-a49a-381b1ec4d295','',NULL),('d90e803f-03df-4446-9f9e-8a23131d311e','保存新增友情链接','保存新增友情链接结果权限','B05','2','c27eed37-b158-4f40-aeda-72e82453934d','',NULL),('db60709a-671f-4b1f-8334-2378154a4c40','友情链接列表','友情链接页面管理','B02','1','923e2d78-54c5-411b-a803-533e1b6f6bef','/adminManager/blogroll/list.html',NULL),('dcb68417-4bfe-4d1d-88ca-914c3aa6b978','更新编辑用户','更新编辑用户权限','U08','2','ed5b926e-b7d2-475f-a6f2-d67f8b6e5e45','',NULL),('e48e6a26-e804-4c54-ba3f-a4094ac9e84c','新增角色','新增角色权限','R03','2','756d46d3-cccb-45fb-9bb7-b267bfc12ece','',NULL),('e833375b-2fdb-40d1-9f6f-bf66ca3feefb','保存新增轮播图','保存新增轮播图权限','H05','2','1a4d64cd-10c1-48d3-a3c1-3b64a6c95de6','',NULL),('e9404aaa-e2ac-4f0b-8ab3-9984273edb41','轮播图列表','轮播图管理页面权限','H02','1','50d367df-0f1e-4a0f-88e7-30f774a88e9f','/adminManager/headline/list.html',NULL),('ea8a3c96-b7b1-4c48-a873-ccb4a07a3dd4','任务管理页面','任务管理页面权限','J02','1','ee17082e-aa07-4b8a-b03c-8088ec393b6b','/adminManager/job/list.html',NULL),('ebf0df3d-73a4-4b06-a5e1-61e80e1a4c59','用户列表','用户管理页面权限','U02','1','9b3ef746-9e67-430d-a934-0f8ed8d032c6','/adminManager/user/list.html',NULL),('ed5b926e-b7d2-475f-a6f2-d67f8b6e5e45','编辑用户','编辑用户权限','U04','2','9b3ef746-9e67-430d-a934-0f8ed8d032c6','',NULL),('ee17082e-aa07-4b8a-b03c-8088ec393b6b','任务管理','任务管理权限','J01','0','0','',NULL),('f6dec23b-617d-4bcd-b620-6a877c9fc5bc','编辑文章','编辑文章','A03','2','bbe3e74e-ee3b-43de-9e9f-1b826b260921','',NULL),('f703395f-0304-44fc-b9c2-cb8e294e421f','保存文章','保存文章权限','A06','2','662a3834-9a3a-4981-8d4c-bea8068474ff','',NULL),('fe66676a-3e88-4122-84c4-08336c56f914','执行任务','执行任务权限','J04','2','ee17082e-aa07-4b8a-b03c-8088ec393b6b','',NULL),('fe6b6f7b-edcc-4e0d-8b60-4547cd0f07dc','保存修改密码','保存修改密码权限','U13','2','3ce16eba-abe2-421e-b971-db8bd605c460','',NULL),('ff6039b3-a3a7-44dd-b099-753ee47518ad','查询目录','查询目录权限','F06','2','1f0e0127-32f6-4dd4-a49a-381b1ec4d295','',NULL);

/*Table structure for table `sys_role` */

DROP TABLE IF EXISTS `sys_role`;

CREATE TABLE `sys_role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(32) DEFAULT NULL COMMENT '角色名称',
  `type` varchar(10) DEFAULT NULL COMMENT '角色类型 超级管理,系统级,管理员级,普通级',
  `role_code` varchar(20) DEFAULT NULL COMMENT '角色编号 S>Q>M>G',
  `comment` varchar(255) DEFAULT NULL COMMENT '备注',
  `is_delete` int(1) DEFAULT NULL COMMENT '是否删除 0：未删除 1：已删除',
  PRIMARY KEY (`id`),
  UNIQUE KEY `Role_Code_Unique` (`role_code`,`is_delete`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sys_role` */

insert  into `sys_role`(`id`,`name`,`type`,`role_code`,`comment`,`is_delete`) values ('3e9e6879-b311-4460-9c11-8d64ac9aa509','超级管理员','0','S01','系统最大的管理员，管理所有的管理员',0),('d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','管理员','1','Q01','管理系统的角色',0);


DROP TABLE IF EXISTS `sys_role_permission`;

CREATE TABLE `sys_role_permission` (
  `id` varchar(64) NOT NULL,
  `rid` varchar(64) DEFAULT NULL COMMENT '角色ID',
  `pid` varchar(64) DEFAULT NULL COMMENT '权限ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sys_role_permission` */

insert  into `sys_role_permission`(`id`,`rid`,`pid`) values ('05a77f97-2fe5-4055-a9b2-3c70f8c5750a','3e9e6879-b311-4460-9c11-8d64ac9aa509','a2c1af1e-b0e7-4149-9f31-d63ffd96519b'),('05b33a22-c5b7-40a5-884f-aafea7a3086e','3e9e6879-b311-4460-9c11-8d64ac9aa509','e833375b-2fdb-40d1-9f6f-bf66ca3feefb'),('088df845-21f7-4b56-9ad8-be5bef92bff3','3e9e6879-b311-4460-9c11-8d64ac9aa509','535d700d-43ff-49d8-b5b9-ddf99f04fa72'),('0e3327a8-3e3a-46ca-a474-1e9f35818bf4','3e9e6879-b311-4460-9c11-8d64ac9aa509','2fd313e5-c1b9-49f4-a440-9344aae0dccf'),('0f60298c-0bac-4e94-a32d-8a369c39bed1','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','fe66676a-3e88-4122-84c4-08336c56f914'),('121bfded-b15f-4ae4-bab8-7a076e40a9e1','3e9e6879-b311-4460-9c11-8d64ac9aa509','f6dec23b-617d-4bcd-b620-6a877c9fc5bc'),('144b68d5-efb1-4e92-b21d-ae26aa98f7dc','3e9e6879-b311-4460-9c11-8d64ac9aa509','8de3367d-4ac1-4c83-8136-dfde41032039'),('15f5b49f-beb7-4758-8daf-66744a022e4a','3e9e6879-b311-4460-9c11-8d64ac9aa509','662a3834-9a3a-4981-8d4c-bea8068474ff'),('19cac0f3-aa46-4c64-b252-96d3f5d488ed','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','ff6039b3-a3a7-44dd-b099-753ee47518ad'),('1a477f81-b475-4915-be14-c292e3ac21b0','3e9e6879-b311-4460-9c11-8d64ac9aa509','c3710484-2dea-427f-b7d5-c50aa0433cb5'),('1a6a4332-f77a-4631-b80f-0983c1e1ce89','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','756d46d3-cccb-45fb-9bb7-b267bfc12ece'),('1f9b2d98-71a2-4347-a4f0-dff8b2156aa2','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','09826703-3139-4c41-a57d-7213749baaf3'),('217e04dc-fa68-4c77-9393-23c98231422c','3e9e6879-b311-4460-9c11-8d64ac9aa509','7ed58526-02d3-4d5d-b6de-ce01dd6a34f7'),('220e65c5-6ac1-406a-b4b4-05e91a83fd6f','3e9e6879-b311-4460-9c11-8d64ac9aa509','2bc93385-18b8-4e9c-a6ff-358c748c3c15'),('247fb6b1-74c1-4624-ad40-7f7db3207811','3e9e6879-b311-4460-9c11-8d64ac9aa509','ea8a3c96-b7b1-4c48-a873-ccb4a07a3dd4'),('24e58e03-8f1c-4799-ae11-93aabaccfed0','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','604acbe1-c62c-4181-bfb1-4efb95b81b73'),('25a161b2-601d-4197-9eb8-e2c082dabed1','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','3ce16eba-abe2-421e-b971-db8bd605c460'),('2afcc5a7-8824-4bad-bf99-e2d2eb6e6453','3e9e6879-b311-4460-9c11-8d64ac9aa509','e9404aaa-e2ac-4f0b-8ab3-9984273edb41'),('2d9c80d1-e31e-4ce7-8e1f-12357e6e6b9e','3e9e6879-b311-4460-9c11-8d64ac9aa509','5b340fdf-a9dc-4861-9041-d819dee3e48b'),('2f42bc5d-4b9e-42aa-ad63-3930d232fa8a','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','1f0e0127-32f6-4dd4-a49a-381b1ec4d295'),('3337ae90-7637-4125-a48c-51fd7e19d6cd','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','9b3ef746-9e67-430d-a934-0f8ed8d032c6'),('352b1a9a-d90c-458f-ab86-7aa0607c5d2c','3e9e6879-b311-4460-9c11-8d64ac9aa509','b270b755-21fb-4b03-9296-ab781e667822'),('37d5e0b5-ac63-4c00-85bd-9e61edc413b1','3e9e6879-b311-4460-9c11-8d64ac9aa509','fe6b6f7b-edcc-4e0d-8b60-4547cd0f07dc'),('3f15b53e-051f-4931-b4e2-c0c4352b7f74','3e9e6879-b311-4460-9c11-8d64ac9aa509','71cded1e-81b2-4db9-874e-8debc1a51e07'),('414b367e-1df0-4aea-9838-99df7407d000','3e9e6879-b311-4460-9c11-8d64ac9aa509','4d2bc708-2e91-4572-b714-3c1804453d10'),('42985ff5-6e56-4fe2-88f7-d537fddbe66f','3e9e6879-b311-4460-9c11-8d64ac9aa509','ee17082e-aa07-4b8a-b03c-8088ec393b6b'),('4462044e-f42d-440a-95f3-97b7ec50d550','3e9e6879-b311-4460-9c11-8d64ac9aa509','1f0e0127-32f6-4dd4-a49a-381b1ec4d295'),('4dccaa67-ab9a-4b98-ae21-deb52b9c033f','3e9e6879-b311-4460-9c11-8d64ac9aa509','50d367df-0f1e-4a0f-88e7-30f774a88e9f'),('4e87e024-538b-45c2-be40-9d9e672350bf','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','cd51e8d3-bb53-4f70-8fc4-5905b6c5dbe2'),('4eb9b7d6-9e8a-44ad-9aaa-68e01a9344da','3e9e6879-b311-4460-9c11-8d64ac9aa509','cd51e8d3-bb53-4f70-8fc4-5905b6c5dbe2'),('50bf2223-a891-4ee6-8b1d-230ff51ec1c1','3e9e6879-b311-4460-9c11-8d64ac9aa509','41a8ac6e-3971-4906-a908-c20e4849528f'),('512934ce-d4a3-4aac-b9ea-a5d90828c4a8','3e9e6879-b311-4460-9c11-8d64ac9aa509','c88a237b-302b-4648-a4a6-1fa0f20b67f7'),('5180bdc3-0cd4-49d7-b6d9-66c17b649602','3e9e6879-b311-4460-9c11-8d64ac9aa509','83fd8854-cabd-4267-851d-8802afe2ba47'),('5279dd80-37e8-4eba-9311-7832a94fb80b','3e9e6879-b311-4460-9c11-8d64ac9aa509','13d07a6c-4212-45da-adf6-32f12d6afe5e'),('538e464d-0f90-4de4-99ad-3ce42822fe50','3e9e6879-b311-4460-9c11-8d64ac9aa509','09826703-3139-4c41-a57d-7213749baaf3'),('56ec78a8-665a-4e1f-811c-ede4a23900bc','3e9e6879-b311-4460-9c11-8d64ac9aa509','e48e6a26-e804-4c54-ba3f-a4094ac9e84c'),('5ee311a9-cda6-413b-a38a-afe9638580aa','3e9e6879-b311-4460-9c11-8d64ac9aa509','38e18301-d1b0-4349-886b-be2e80d21ea5'),('5fc85b77-df6b-4a9e-87bc-6be6648d5ac9','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','ebf0df3d-73a4-4b06-a5e1-61e80e1a4c59'),('5fea32be-c017-43d0-9ffc-9ba6b19d4b62','3e9e6879-b311-4460-9c11-8d64ac9aa509','b06d328f-3f55-4f47-a4e7-6378704ac4e0'),('6355fc73-e587-4192-9fef-5f0aaf417997','3e9e6879-b311-4460-9c11-8d64ac9aa509','89476bdb-f368-49e2-bd9e-4e4bb1f460fe'),('64efa478-de61-447f-8481-d57f545529e8','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','662a3834-9a3a-4981-8d4c-bea8068474ff'),('65bca7fc-5334-4fba-bbcf-05e12660b50b','3e9e6879-b311-4460-9c11-8d64ac9aa509','777d1c4d-45dd-492b-8d5e-a90057fccb08'),('66212e19-bee3-485f-bd56-cccdefe1b057','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','c1ff0fce-d8d6-4120-ae92-576beacd253e'),('6633fd95-cde9-4050-9c5f-7678cf92ea2e','3e9e6879-b311-4460-9c11-8d64ac9aa509','c27eed37-b158-4f40-aeda-72e82453934d'),('68c0e426-c895-4a66-a433-2fbc3d284410','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','442e400c-dd90-40eb-b3c9-d7ec0510b165'),('6ba817a4-fe18-4d0f-9862-b62389250dc6','3e9e6879-b311-4460-9c11-8d64ac9aa509','4d07d78e-a160-4466-8100-078c388df9fb'),('6c20fc5c-9468-4e0e-8294-0d7f90fce0e7','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','0a64115e-432e-4f31-bbea-4f3069ce65c1'),('72469fd3-009d-4943-8bb1-e97fd3523021','3e9e6879-b311-4460-9c11-8d64ac9aa509','d833fe7b-92bd-416b-bea0-9fc6629678c6'),('72469fd3-009d-4943-8bb1-e97fd3523022','3e9e6879-b311-4460-9c11-8d64ac9aa509','d90a566b-2b9e-41da-8767-91b45647b513'),('72469fd3-009d-4943-8bb1-e97fd3523023','3e9e6879-b311-4460-9c11-8d64ac9aa509','d90e803f-03df-4446-9f9e-8a23131d311e'),('77bfcfd3-a23d-430c-9d5e-01f4e3aac400','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','ee17082e-aa07-4b8a-b03c-8088ec393b6b'),('79c8f20d-249f-43ea-a6e9-4390b338794a','3e9e6879-b311-4460-9c11-8d64ac9aa509','19f8b032-3e3c-49e5-a71b-9e3d51a6086b'),('7e07efc4-7d4c-4a58-b1b5-9bb6a571456a','3e9e6879-b311-4460-9c11-8d64ac9aa509','baa593c9-54ad-423f-95a8-96468b5b8907'),('7f812579-a319-4338-91d5-063396f2d2dd','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','535d700d-43ff-49d8-b5b9-ddf99f04fa72'),('84790441-84f6-42de-95aa-f2929725e95a','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','0e6274b4-56f5-458b-af4e-019965a3733a'),('86f751dc-297d-45b6-a3eb-f8698107158a','3e9e6879-b311-4460-9c11-8d64ac9aa509','ebf0df3d-73a4-4b06-a5e1-61e80e1a4c59'),('88b0fb97-44ba-4e5d-92ff-664e7714999b','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','5c8e7f32-9a27-41fc-b829-423b805ca76c'),('8aa6cea9-fa04-4467-ba06-dfc1e35d0d97','3e9e6879-b311-4460-9c11-8d64ac9aa509','1a5d23db-33c1-4e92-b263-9fd54b9bb32e'),('93538026-1442-4d34-834b-69680ec350a9','3e9e6879-b311-4460-9c11-8d64ac9aa509','c1ff0fce-d8d6-4120-ae92-576beacd253e'),('937d57c4-8feb-47d1-8642-43cb46fbfa7a','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','bbe3e74e-ee3b-43de-9e9f-1b826b260921'),('95786663-7bda-4aa2-846f-58fc9793666f','3e9e6879-b311-4460-9c11-8d64ac9aa509','442e400c-dd90-40eb-b3c9-d7ec0510b165'),('99a29a47-7bf3-49df-b3e1-cc68f9ebcfed','3e9e6879-b311-4460-9c11-8d64ac9aa509','3acc5f2a-b148-44e6-a08c-3c1ec61e223f'),('99d2edf8-e1de-42bd-b777-b8d6beba64dd','3e9e6879-b311-4460-9c11-8d64ac9aa509','cdbce194-64d0-4773-aedf-edbf9e168520'),('9c300989-3619-4722-b6c4-78ec8462e3be','3e9e6879-b311-4460-9c11-8d64ac9aa509','0e6274b4-56f5-458b-af4e-019965a3733a'),('9cee44ac-9efa-4a59-9da5-202d32c1e7be','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','89476bdb-f368-49e2-bd9e-4e4bb1f460fe'),('9d086695-0b51-415f-8b39-872b96e778fc','3e9e6879-b311-4460-9c11-8d64ac9aa509','3ce16eba-abe2-421e-b971-db8bd605c460'),('9e445048-c83a-474f-895b-1a6576da8235','3e9e6879-b311-4460-9c11-8d64ac9aa509','21e2e638-6ff2-444a-99b7-d71b57d36eb5'),('9ff7d52d-da14-4601-896e-2d31130692d5','3e9e6879-b311-4460-9c11-8d64ac9aa509','59743c9e-7940-4603-8782-4bfc65365d37'),('a0dd131a-99a4-4919-b9b8-1091d368bce1','3e9e6879-b311-4460-9c11-8d64ac9aa509','2e050109-80a0-4cad-a302-e29421612f35'),('a0e844e3-7d6f-419a-8c9e-49396c9ab4a4','3e9e6879-b311-4460-9c11-8d64ac9aa509','014a3438-87bc-4c1c-a53a-5019be7ebee1'),('a2878df0-57e7-4dd2-baa3-aadbd46e6754','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','b06d328f-3f55-4f47-a4e7-6378704ac4e0'),('a63d64a8-3644-4486-a8bc-04109843a5d2','3e9e6879-b311-4460-9c11-8d64ac9aa509','604acbe1-c62c-4181-bfb1-4efb95b81b73'),('ac4c36fe-3432-4314-9500-52eecb73ff84','3e9e6879-b311-4460-9c11-8d64ac9aa509','756d46d3-cccb-45fb-9bb7-b267bfc12ece'),('aca6b6aa-71ae-4cef-8929-caa8193be6fe','3e9e6879-b311-4460-9c11-8d64ac9aa509','bbe3e74e-ee3b-43de-9e9f-1b826b260921'),('b097cb32-3fc6-4ed3-882f-eae35113a3e6','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','2e050109-80a0-4cad-a302-e29421612f35'),('b1476bbf-3dd8-4baa-bfc1-f47649c48dcb','3e9e6879-b311-4460-9c11-8d64ac9aa509','0a64115e-432e-4f31-bbea-4f3069ce65c1'),('b2b29fcd-19a2-414c-87ef-3e6c84b6c292','3e9e6879-b311-4460-9c11-8d64ac9aa509','210858ee-760c-4070-a5a4-e667361e46dd'),('b4ecc621-2968-490d-9df1-c8b1df199c8b','3e9e6879-b311-4460-9c11-8d64ac9aa509','ff6039b3-a3a7-44dd-b099-753ee47518ad'),('b5df5840-c149-4dcf-9160-988f724b24fc','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','d833fe7b-92bd-416b-bea0-9fc6629678c6'),('bf9c5728-cc93-412b-9832-59a8ec30ba16','3e9e6879-b311-4460-9c11-8d64ac9aa509','db60709a-671f-4b1f-8334-2378154a4c40'),('c4b552c8-10be-47e8-8f1c-bb50ae9fb434','3e9e6879-b311-4460-9c11-8d64ac9aa509','d124e786-f4db-4a02-b26b-130544c71ab0'),('c5cc91b0-48bc-4622-8121-eb2f49804558','3e9e6879-b311-4460-9c11-8d64ac9aa509','1ee56fb6-ead8-4b0a-a7ab-4e89c9a7f0a6'),('c7a5a5bd-49f8-4314-bca3-adb394ce1aff','3e9e6879-b311-4460-9c11-8d64ac9aa509','008e3e95-8347-4462-ad32-8d196cb9bb07'),('c7c43ad1-b207-45c3-a460-abee75957d7d','3e9e6879-b311-4460-9c11-8d64ac9aa509','9b3ef746-9e67-430d-a934-0f8ed8d032c6'),('cab9824c-01b3-4073-a9aa-7467294db188','3e9e6879-b311-4460-9c11-8d64ac9aa509','95e380f8-324c-4569-bb6b-85c461a4259a'),('cc0ce125-aac8-434a-8597-f833a3be0fd7','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','db60709a-671f-4b1f-8334-2378154a4c40'),('cc6602f5-9bc1-4a82-a632-6d2bb0378133','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','50d367df-0f1e-4a0f-88e7-30f774a88e9f'),('ce37e5a9-d9da-4c07-a9f7-b3bbae10d721','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','ea8a3c96-b7b1-4c48-a873-ccb4a07a3dd4'),('d02f10c0-7d1d-4045-b3c9-ce86f56f5e3f','3e9e6879-b311-4460-9c11-8d64ac9aa509','5c8e7f32-9a27-41fc-b829-423b805ca76c'),('d3ccd358-b9df-43d8-a5f8-1e16269263ce','3e9e6879-b311-4460-9c11-8d64ac9aa509','00cc24fe-090b-4807-81c6-897d8d455876'),('dafceb6e-2cf5-403a-a9be-4549bce1365d','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','923e2d78-54c5-411b-a803-533e1b6f6bef'),('e5cc4af0-4906-4a9c-afa4-10a565c39e10','3e9e6879-b311-4460-9c11-8d64ac9aa509','1a4d64cd-10c1-48d3-a3c1-3b64a6c95de6'),('e6024e16-4d88-4ac2-9997-32edd2d10f65','3e9e6879-b311-4460-9c11-8d64ac9aa509','0ba07b76-b0ad-453e-b6e5-11f0d991afc7'),('e856ad11-0623-4d22-816e-34859851898b','3e9e6879-b311-4460-9c11-8d64ac9aa509','392ef53e-e6d1-4fec-9619-bda18e1684e9'),('e885b54c-fa8c-4fa5-9714-2c1e72b9925d','3e9e6879-b311-4460-9c11-8d64ac9aa509','bddb070b-3c75-4c1e-ac4b-f88c7a571dd4'),('e8972cc4-1259-441f-bcb2-55d0fd9bc987','3e9e6879-b311-4460-9c11-8d64ac9aa509','dcb68417-4bfe-4d1d-88ca-914c3aa6b978'),('ea4cd3b7-8bf5-443e-a726-002ac19bae3c','3e9e6879-b311-4460-9c11-8d64ac9aa509','387ef7a5-d791-4f43-b3ea-546408a65f0d'),('eaba9462-f18f-4634-aeab-3b48adb71815','3e9e6879-b311-4460-9c11-8d64ac9aa509','ed5b926e-b7d2-475f-a6f2-d67f8b6e5e45'),('f26c984d-4b74-4e4e-b92b-a565d4247489','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','d124e786-f4db-4a02-b26b-130544c71ab0'),('f66511e6-cea8-48c6-843a-81ac2cee7b4a','3e9e6879-b311-4460-9c11-8d64ac9aa509','923e2d78-54c5-411b-a803-533e1b6f6bef'),('f731f0ee-6372-48a0-bf59-17c79a886498','3e9e6879-b311-4460-9c11-8d64ac9aa509','f703395f-0304-44fc-b9c2-cb8e294e421f'),('f832bec5-535c-4145-9ffe-d53f86ed68b3','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66','e9404aaa-e2ac-4f0b-8ab3-9984273edb41'),('f95d56ce-8953-48ac-9a40-7328ca36b771','3e9e6879-b311-4460-9c11-8d64ac9aa509','5959a0c4-9c92-4830-8df6-8193f56f8d64'),('faf3a8c7-05fe-4195-b49a-88174308c4dd','3e9e6879-b311-4460-9c11-8d64ac9aa509','fe66676a-3e88-4122-84c4-08336c56f914');

/*Table structure for table `sys_user` */

DROP TABLE IF EXISTS `sys_user`;

CREATE TABLE `sys_user` (
  `id` varchar(64) NOT NULL COMMENT '主键id',
  `nick_name` varchar(20) DEFAULT NULL COMMENT '用户昵称',
  `username` varchar(128) DEFAULT NULL COMMENT '用户名',
  `email` varchar(128) DEFAULT NULL COMMENT '邮箱|登录帐号',
  `address` varchar(255) DEFAULT NULL COMMENT '地址',
  `sex` varchar(10) DEFAULT '保密' COMMENT '性别',
  `idcard` varchar(20) DEFAULT NULL COMMENT '身份证号',
  `phone` varchar(15) DEFAULT NULL COMMENT '联系方式',
  `password` varchar(32) NOT NULL COMMENT '密码',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `last_login_time` datetime DEFAULT NULL COMMENT '最后登录时间',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '1:有效，0:禁止登录',
  `create_name_id` varchar(64) DEFAULT NULL COMMENT '创建者ID',
  `is_delete` int(1) NOT NULL DEFAULT '0' COMMENT '是否删除 0：未删除 1： 已删除',
  PRIMARY KEY (`id`),
  UNIQUE KEY `Username_UNIQUE` (`username`,`is_delete`),
  UNIQUE KEY `phone_unique` (`phone`,`is_delete`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sys_user` */

insert  into `sys_user`(`id`,`nick_name`,`username`,`email`,`address`,`sex`,`idcard`,`phone`,`password`,`create_time`,`last_login_time`,`status`,`create_name_id`,`is_delete`) values ('234ed250-600e-4987-8d66-7ec58e5991c0','超级管理员','adminManager','1234567891@qq.com','','保密','','13333333333','e10adc3949ba59abbe56e057f20f883e','2018-06-07 22:26:15','2018-09-16 16:34:20',1,NULL,0),('e26536c6-4c02-467d-9b53-a89b8a61363b','管理员','admin','1234567890@qq.com','','保密','','13333333331','e10adc3949ba59abbe56e057f20f883e','2018-08-25 11:56:47','2018-09-14 19:19:00',1,NULL,0);

/*Table structure for table `sys_user_role` */

DROP TABLE IF EXISTS `sys_user_role`;

CREATE TABLE `sys_user_role` (
  `id` varchar(64) NOT NULL,
  `uid` varchar(64) DEFAULT NULL COMMENT '用户ID',
  `rid` varchar(64) DEFAULT NULL COMMENT '角色ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sys_user_role` */

insert  into `sys_user_role`(`id`,`uid`,`rid`) values ('234ed250-600e-4987-8d66-7ec58e599110','234ed250-600e-4987-8d66-7ec58e5991c0','3e9e6879-b311-4460-9c11-8d64ac9aa509'),('c0d9f588-ef69-484d-934d-0c931605e0c1','e26536c6-4c02-467d-9b53-a89b8a61363b','d3e61c3b-0b8a-4311-b18f-a7e9fde9fa66');

