const express  = require('express');
const mongoose = require('mongoose');
const authmiddleware = require('../middlewares/authmiddleware');
const {Account}  = require('../db');
const router = express.Router();

router.get('/balance', authmiddleware, async (req, res)=>{
    const account =  await Account.findOne({
        userId: req.userId
    })
    res.json({
        balance: account.balance
    })
})

router.post('/transaction', authmiddleware, async (req, res)=>{
    const session = await mongoose.startSession();
    session.startTransaction();
    const {amount, to} = req.body;
    const account = await Account.findOne({
        userId: req.userId
    }).session(session);
    if(account.balance < amount){
        return res.status(400).json({
            message: "Insufficient balance"
        })
    }
    const toAccount = await Account.findOne({
        userId: to
    }).session(session);
    if(!toAccount){
        await session.abortTransaction();
        return res.status(400).json({
            message: "Invalid account"
        })
    };
    await Account.updateOne({
        userId: req.userId
    },{
        $inc: {
            balance: -amount
        }
    }).session(session);
    await Account.updateOne({
        userId: to
    },{
        $inc: {
            balance: amount
        }
    }).session(session);
    await session.commitTransaction();
    res.json({
        message: "Transaction successful"
    });
})

module.exports = router;