## 编程语言

<details>
<summary>GO</summary>

* [Go GC 20 问](https://mp.weixin.qq.com/s/o2oMMh0PF5ZSoYD0XOBY2Q)
* [高频 golang 服务接口超时排查&性能调优](https://mp.weixin.qq.com/s/rDjTqqR0q4VTSQrYFzbR7w)
* [图解Go运行时调度器](https://tonybai.com/2020/03/21/illustrated-tales-of-go-runtime-scheduler/)
* [字节跳动在 Go 网络库上的实践](https://gocn.vip/topics/10372)

</details>

<details>
<summary>C++</summary>

* [C++11中的内存模型](https://www.codedump.info/post/20191214-cxx11-memory-model-1/)

</details>

---
## 疑难分析
* [惊魂48小时，阿里工程师如何紧急定位线上内存泄露？](https://mp.weixin.qq.com/s/DqUwcszyySlYwBolCLKI6g)
    * 提供了另一个角度来调查内存泄露：虚表。每个有虚函数的类都有个虚表，同一个类的所有对象都会指针指向同一个虚表（通常是每个对象的前8个字节），因此统计每个虚表指针出现的频度就可以知道这样的对象被分配了有多少，数量异常的话那么就存在内存泄露的可能。
* [How to Instrument UserLand Apps with eBPF](https://sematext.com/blog/ebpf-userland-apps/)
* [通过实例快速入门Systemtap](https://mp.weixin.qq.com/s/0cno0owlDdDNvioN4XbuDg)
* [TCP 常见故障排查](https://ms2008.github.io/2018/06/01/tcp-troubleshooting/)
* [三年之久的 etcd3 数据不一致 bug 分析](https://mp.weixin.qq.com/s/qittYHY2GUwhFtvsRDaIAQ)

----
## 性能优化
* [小米Talos GC性能调优实践](https://mp.weixin.qq.com/s/xrfaGBkaX8P_7AP8M_Ytcg)
* [Nginx vs Envoy vs Mosn 平滑升级原理解析](https://ms2008.github.io/2019/12/28/hot-upgrade/)
* [从零开始入门 K8s：etcd 性能优化实践](https://www.infoq.cn/article/S4V2cmNeKE186mQmkPVJ)
* [eBPF技术应用云原生网络实践系列之kubernetes网络](https://mp.weixin.qq.com/s/esIk-szcRC6eGkJxbpHcYw)
* [eBPF 在网易轻舟云原生的应用实践](https://mp.weixin.qq.com/s/vfq4dzqJwBCOUNGIPQbO8g)
* [挑战Redis单实例内存最大极限，“遭遇”NUMA陷阱！](https://mp.weixin.qq.com/s/NMYkAnrCIoifDpe42_vPUw)


---
## 运维
* [10 Ansible modules you need to know](https://opensource.com/article/19/9/must-know-ansible-modules)
* [AWS DevOps实践：一年5000万次部署是怎样一种概念？](http://www.yunweipai.com/archives/24630.html)
* [关于《三国志·战略版》的若干设计理念](https://thislinux.com/sanguozhi/)
* [网易资深工程师详解运维面经](https://mp.weixin.qq.com/s/rqLPUPFv9u995JU8jzLRcA)
* [一文读懂容器三大核心技术——Namespace，Cgroup和UnionFS](https://mp.weixin.qq.com/s/SPNIED7RUI61zdyVV5deGA)
* [Facebook 如何构建满足规模需求的精确时间服务？](https://www.infoq.cn/article/gL6CrvIAW9UAaKO7hisB)
* [rsync 用法教程](http://www.ruanyifeng.com/blog/2020/08/rsync.html)

---
## 云原生

* ![CNCF Cloud Native Landscape](https://landscape.cncf.io/images/landscape.png)
* [GitHub 超 32,000 Star！火了近十年的阿里开源项目 Apache Dubbo 云原生实践](https://mp.weixin.qq.com/s/CazUjRc12HGl923MWko9rw)
* [Next Borg：谷歌新一代Borg系统](https://zhuanlan.zhihu.com/p/140903645)

#### 微服务
* [蚂蚁金服 API Gateway Mesh 思考与实践](https://www.infoq.cn/article/azCFGyTDGakZqaLEEDMN)
* [微服务架构的理论基础 - 康威定律](https://my.oschina.net/u/4006148/blog/3162625)
* [阿里大神分享API网关在微服务架构中的应用！](https://mp.weixin.qq.com/s/l4z1wPzrkJymnNDlsgoPaA)
* [全面解析 Netflix 的微服务架构设计](https://www.infoq.cn/article/SWNSmqWvbAAzetL12xMG)
![](https://static001.infoq.cn/resource/image/03/cd/03881a006cc7461fa2de1b4b36790ecd.jpeg)
* [Docker 底层原理浅析](https://card.weibo.com/article/m/show/id/2309404571800766906614?_wb_client_=1)

---

## 数据库

* [读过本文才算真正了解 Cassandra 数据库](https://www.infoq.cn/article/j0mFQ1cNtskBk5rbDpvl)
* [性能提升2.58倍！阿里最快KV存储引擎揭秘](https://mp.weixin.qq.com/s/0IKxbt8MDH6Yqu1f00cwSA)
* [浅谈从Google Mesa到百度PALO](http://neoremind.com/2017/09/%E6%B5%85%E8%B0%88%E4%BB%8Egoogle-mesa%E5%88%B0%E7%99%BE%E5%BA%A6palo/comment-page-1/)
* [OLAP 任务的并发执行与调度](https://io-meter.com/2020/01/04/olap-distributed/)
* [悄悄告诉你MySQL MGR牛在哪?](https://mp.weixin.qq.com/s/NpcfIlp_PI3hArt22J6Bdw)

---
## 分布式系统
* [两万字深度介绍分布式系统原理！](https://mp.weixin.qq.com/s/9hR2OvZg4DfTv0dp6z5GJw)
* [腾讯 ZooKeeper 源码和实践揭秘](https://zhuanlan.zhihu.com/p/134549250)
* [Hermes：一个快速、容错、线性一致的复制协议](https://mp.weixin.qq.com/s/9gaNMn0neWbR_WiAaR08ug)
* [Hermes-A fast, fault-tolerant & linearizable replication protocol](https://hermes-protocol.com/)
* [Raft 论文](https://mp.weixin.qq.com/s/jsYO9cTgTLcN_HVZOy9xHg)

---
## 大数据
* [Apache Kylin 原理介绍与新架构分享（Kylin On Parquet）](https://mp.weixin.qq.com/s/fpjAnfwFCOIOU0dDqs1Q3g)
* [收藏！一张图帮你快速建立大数据知识体系](https://mp.weixin.qq.com/s/j8tP9nTmA7m_MW85MXnExA)
* [还在用笨重的ELK？日志系统新贵Loki 了解一下](https://mp.weixin.qq.com/s/SOKUI4umW1avUKpfKi5U9Q)
* [云原生下的日志新玩法: Grafana loki 源码解析](https://aleiwu.com/post/grafana-loki/)
* [推荐系统的112条实战经验](https://mp.weixin.qq.com/s/WD4kW2vFNkZXf_LqAhY_3Q)

---
## 网络
* [HTTP/3 原理实战](https://mp.weixin.qq.com/s/MHYMOYHqhrAbQ0xtTkV2ig)
* [NGINX
Cookbook](https://www.nginx.com/wp-content/uploads/2017/07/Complete-NGINX-Cookbook-2019.pdf)
* [Bro - 开源网络流量分析器](https://mp.weixin.qq.com/s/mL-vuxL7Otx_Ke31qQSSyw)
* [Creating a Wireshark dissector in Lua - part 1](https://mika-s.github.io/wireshark/lua/dissector/2017/11/04/creating-a-wireshark-dissector-in-lua-1.html)



---
## 杂

* [OKR 极简史](https://arthurchiao.github.io/blog/short-history-of-okr-zh/)
* [Vue 的数据响应式原理](https://www.infoq.cn/article/we3l33H5zGYyg6gC9hRi)
* [为什么 0.1 + 0.2 = 0.300000004](https://draveness.me/whys-the-design-floating-point-arithmetic/)
* [谷歌工程实践文档](https://jimmysong.io/eng-practices/)
* [时间轮在Kafka的实践](https://mp.weixin.qq.com/s/xIWKcWCV_eyH-vQOQWxGUw)
