# 2019 - 精选技术文章

## 1. 分布式系统
* [分布式系统如何保证一致性](https://mp.weixin.qq.com/s/Kz6lK-SavOvwifGQhbDqlA)
* [Go存储怎么写？深度解析etcd存储设计](https://mp.weixin.qq.com/s/qvqpUtTFI0cFf9LtTH4JfA)
* [天机阁——全链路跟踪系统设计与实现](https://mp.weixin.qq.com/s/RBPJFrj2mcTUjbm4aH9TRg)
    * 分布式跟踪系统
* [取代ZooKeeper！高并发下的分布式一致性开源组件StateSynchronizer](https://mp.weixin.qq.com/s/NTEG-A8zhxAhvxV223QTsw)
* [etcd 在超大规模数据场景下的性能优化](https://mp.weixin.qq.com/s/oNfNK9DlI24gVkC-T5O_dw)
* [开源Brooklin：近实时大规模数据流式传输，取代Kafka Mirror Make](https://mp.weixin.qq.com/s?__biz=MzU1NDA4NjU2MA==&mid=2247497390&idx=2&sn=394260d3bec2b12a6f27776202960014)
* [Dynamo：Amazon 的高可用键值仓库（存储）](https://arthurchiao.github.io/blog/amazon-dynamo-zh/)
* [Designs, Lessons and Advice from Building Large
Distributed Systems](https://www.cs.cornell.edu/projects/ladis2009/talks/dean-keynote-ladis2009.pdf)
~~~
L1 cache reference                      0.5 ns
Branch mispredict                       5 ns
L2 cache reference                      7 ns
Mutex lock/unlock                       25 ns
Main memory reference                   100 ns
Compress 1K bytes with Zippy            3,000 ns
Send 2K bytes over 1 Gbps network       20,000 ns
Read 1 MB sequentially from memory      250,000 ns
Round trip within same datacenter       500,000 ns
Disk seek                               10,000,000 ns
Read 1 MB sequentially from disk        20,000,000 ns
Send packet CA->Netherlands->CA         150,000,000 ns
~~~
* [开源服务网格框架 Kuma 可应用于任何平台](https://mp.weixin.qq.com/s/-hU8dB12miX-uEj8i2fPbg)
* [基于 Go 开源项目 MINIO 的对象存储方案在探探的实践](https://mp.weixin.qq.com/s?__biz=MjM5OTcxMzE0MQ==&mid=2653373017&idx=1&sn=4fed3a98754cebb8ee70c131dd6ca9b5&chksm=bce4a2438b932b554157fe965ba1ffc83154baca4b24d00571d365a5093a5c35398ae85d6feb&mpshare=1&scene=1&srcid=1012XxaZSQWCgWV5GBvUukeo&sharer_sharetime=1570864365370&sharer_shareid=1bdf7fdec1574a08d8a27f5a5eddb73f&rd2werd=1#wechat_redirect)
* [深入理解HBase架构](https://mp.weixin.qq.com/s/l6f-QqUGtIB9qHkckHzpOQ)
* [Lyft 基于 Flink 的大规模准实时数据分析平台实践](https://www.infoq.cn/article/VH38YGxDCDccPESBHQWQ)


### 1.1 文件存储
* [优雅的Bitcask/BeansDB](https://zhuanlan.zhihu.com/p/53682577)

### 1.2 分布式跟踪系统
* [Dapper，大规模分布式系统的跟踪系统](http://bigbully.github.io/Dapper-translation/)
* [Jaeger: open source, end-to-end distributed tracing](https://www.jaegertracing.io/)

### 1.3 负载均衡
* [QPS比Nginx提升60%，阿里Tengine负载均衡算法揭秘](https://mp.weixin.qq.com/s/3KZ99d94yqRDxEByn7nGWg)
* [nginx平滑的基于权重轮询算法分析](https://tenfy.cn/2018/11/12/smooth-weighted-round-robin/)
* [平滑的基于权重的轮询算法](https://colobu.com/2016/12/04/smooth-weighted-round-robin-algorithm/)

## 2. 性能分析

* [IO Visor Project
Report abuse](https://github.com/iovisor)
* [eBCC性能分析最佳实践（0） - 开启性能分析新篇章](https://mp.weixin.qq.com/s/jiQrRr4bPvni6uFmG51Hug)
* [Kernel analysis using eBPF](https://elinux.org/images/d/dc/Kernel-Analysis-Using-eBPF-Daniel-Thompson-Linaro.pdf)
* [Performance Analysis
Superpowers with Linux eBPF](http://www.brendangregg.com/Slides/Velocity2017_BPF_superpowers.pdf)
* [如何基于 Cilium 和 eBPF 打造可感知微服务的 Linux](https://arthurchiao.github.io/blog/how-to-make-linux-microservice-aware-with-cilium-zh/)
* [eBCC性能分析最佳实践（1） - 线上lstat, vfs_fstatat 开销高情景分析](https://mp.weixin.qq.com/s/3moM_N0WnF-i5KOiEgWkKQ)
* [Linux Load Average那些事儿](https://mp.weixin.qq.com/s/Z3WtdtehzvdacmY8Xns6GQ)
    * load average = 正在运行(running) + 已经ready且等待调度(runnable)的进程数 + 处于不可中断睡眠（ uninterruptible sleep D状态)
* [Web服务器如何实现高吞吐低延迟？Dropbox从操作系统到应用层优化指南](https://mp.weixin.qq.com/s/Jx4DZWvDBCpWGJeSq84Eog)
* [LWN: task在NUMA node之间如何高效迁移？看看阿里巴巴的解决方案](https://mp.weixin.qq.com/s/eEeMyFTUGmAqYB7WhiTK1w)
* [bpftrace (DTrace 2.0) for Linux 2018](https://mp.weixin.qq.com/s/IRGEcejPTxUhKmttVA3bjA)
* [FlameScope Pattern Recognition](https://mp.weixin.qq.com/s/vfL2F2Xg8iurARoknHZePA)
* [Cloudflare 边缘网络架构：无处不在的 BPF](https://arthurchiao.github.io/blog/cloudflare-arch-and-bpf-zh/)
* [如何利用工具，迅猛定位低效SQL？ | 1分钟系列](https://mp.weixin.qq.com/s/uenONvfT0ZcXl5-WIZtFHQ)
    * explain字段 type，Extra
* [Linux Perf Tools Tips](http://oliveryang.net/2016/07/linux-perf-tools-tips/)


## 3. 数据库

* [经典开源代码分析——Leveldb高效存储实现](https://mp.weixin.qq.com/s/DfCO3RCjkDmYkkMlS3msDg)
* [阿里云 Redis 开发规范](https://www.infoq.cn/article/K7dB5AFKI9mr5Ugbs_px)
* [memcache内核，一文搞定！](https://mp.weixin.qq.com/s/zh9fq_e2BgdIeR8RKtY6Sg)
* [网易 MyRocks 使用和优化实践](https://mp.weixin.qq.com/s?__biz=MzU1NTMyOTI4Mw==&mid=2247491101&idx=1&sn=33d69cae3a51dbf7534bb3cb017f5288&chksm=fbd4ac71cca3256760f6234addf8b5a9438c0167e24f250edd9f337141d63faa0c5f5428a975&mpshare=1&scene=1&srcid=&from=groupmessage&ascene=1&devicetype=android-28&version=2700043c&nettype=WIFI&abtest_cookie=BQABAAoACwASABMAFQAGACOXHgBWmR4A0JkeANyZHgD2mR4ADZoeAAAA&lang=zh_CN&pass_ticket=ZYdAAyK9UXH9c4cnO7qm5f7izEjha0hujlRNKE2b43bJT56zKCMJgaY6o+OSfGfm&wx_header=1)
    * 对比innodb有更少的存储空间，更好的写入性能
* [缓冲池(buffer pool)，这次彻底懂了！！！](https://mp.weixin.qq.com/s/nA6UHBh87U774vu4VvGhyw)
    * 新生代与老生代设计


### 3.1 NoSQL
* [Titan 的设计与实现](https://mp.weixin.qq.com/s/MYUof5t0hAnVkP9P1T1-Qg)
* [LevelDB Compaction 引发的 Data Inconsistency](https://zhuanlan.zhihu.com/p/60188395)

### 3.2 SQL
* [删库了，除了跑路还能怎么办？在线等！](https://mp.weixin.qq.com/s/kLbtiq8Qa_iOeAttkN9dpQ)
    * 如果是使用 delete 语句误删了数据行，可以用 Flashback 工具通过闪回把数据恢复回来。
    * 把 sql_safe_updates 参数设置为 on。这样一来，如果我们忘记在 delete 或者 update 语句中写 where 条件，或者 where 条件里面没有包含索引字段的话，这条语句的执行就会报错。
* [MySQL性能突发事件问题排查技巧](https://mp.weixin.qq.com/s/qCRfxIr1RoHd9i8-Hk8iuQ)
* [一文说尽MySQL事务及ACID特性的实现原理](https://mp.weixin.qq.com/s/yFms_F4h30LofGUkuv1b2g)
    * 原子性 Atomicity：语句要么全执行，要么全不执行，是事务最核心的特性。事务本身就是以原子性来定义的；实现主要基于 undo log。
    * 持久性 Durability：保证事务提交后不会因为宕机等原因导致数据丢失；实现主要基于 redo log。
    * 隔离性 Isolation：保证事务执行尽可能不受其他事务影响；InnoDB 默认的隔离级别是 RR，RR 的实现主要基于锁机制、数据的隐藏列、undo log 和类 next-key lock 机制。
    * 一致性 Consistency：事务追求的最终目标，一致性的实现既需要数据库层面的保障，也需要应用层面的保障。
* [InnoDB架构，一幅图秒懂！](https://mp.weixin.qq.com/s/zKHNaWY5AS0OMmag1mQTKQ)

## 4. 网络
* [TCP的困境与解决方案](https://mp.weixin.qq.com/s/AiYUB8dixAFR0j_zAcqWMg)
    * 早在1990年TCP便采用被称为AI/MD的滑动窗口发包模式，AI即逐步线性探测带宽，MD即在拥塞时指数递减滑动窗口，如每探测到拥塞或者丢包时将滑动窗口减小到原来的一半， 从而减慢发送速度
    * Riverbed公司开发的Highspeed TCP，其是在原来AI/MD的基础上，把MD的窗口减半改为减小1/8。
* [作为DBA,你有必要了解一下tcpdump](https://mp.weixin.qq.com/s?__biz=MzI4NjExMDA4NQ==&mid=2648451007&idx=1&sn=5f11121cc66e755c5fa95cbb6fe7bb39)
* [Linux下如何过滤、分割以及合并 pcap 文件](https://linux.cn/article-4762-1.html)
    * editcap
    * mergecap
* [浅谈SYNPROXY](https://mp.weixin.qq.com/s/CYD5FeKUNy2Jtv3PJYg70w)
* [你真的掌握 LVS、Nginx 及 HAProxy 的工作原理吗?](https://mp.weixin.qq.com/s/BQC2AeX24skfY1lPapAP_A)
* [腾讯正式发布 TCP 单边拥塞控制算法 TCPA，比 Google BBR 速度提升 40% (附安装教程)](https://mp.weixin.qq.com/s?__biz=MzI3MTI2NzkxMA==&mid=2247486370&idx=1&sn=59086cbd6f4394bad1f48c45c5fbde56&chksm=eac52a8bddb2a39d4415105484529d3fe4ab4ec1dc8a36d466f7ecc787f8e3e91801ba95e517&mpshare=1&scene=23&srcid=0311gYQDuE9yAaL9nby4ljrz#rd)
* [TCP协议笔记](https://www.codedump.info/post/20190227-tcp/)

![](https://www.codedump.info/media/imgs/20190227-tcp/tcp-finish.jpg)
![](https://www.codedump.info/media/imgs/20190227-tcp/congestion-flow-algo-fsm.png)

* [linux-network-performance-parameters](https://github.com/leandromoreira/linux-network-performance-parameters)
* [5G 的网络延迟时间 1 毫秒是怎么做到的？](https://www.zhihu.com/question/307958274/answer/712266324)
* [TCP queue 的一些问题](http://jaseywang.me/2014/07/20/tcp-queue-%E7%9A%84%E4%B8%80%E4%BA%9B%E9%97%AE%E9%A2%98/)
    * /proc/sys/net/ipv4/tcp_max_syn_backlog
    * /proc/sys/net/core/somaxconn
    * /proc/sys/net/ipv4/tcp_abort_on_overflow ：0 表示直接丢丢弃该 ACK，1 表示发送 RST 通知 client
* [SO_REUSEADDR & SO_REUSEPORT](https://stackoverflow.com/questions/14388706/socket-options-so-reuseaddr-and-so-reuseport-how-do-they-differ-do-they-mean-t)
* [连接跟踪模块导致的网络不可用](https://colobu.com/2019/07/30/network-issue-because-of-nf-conntrack/)


## 5. 并发编程
* [从计算机的角度理解volatile关键字](https://mp.weixin.qq.com/s/l6dbdilAwUhiqNO0O-K9Wg)
    * volatile可以保证可见性，有序性，但不能保证原子性
* [如何理解 C++11 原子变量（Atomic）的 Memory Order](http://blog.gssxgss.me/how-to-understand-cpp-atomic-memory-order-1/)
* [You Can Do Any Kind of Atomic Read-Modify-Write Operation](https://preshing.com/20150402/you-can-do-any-kind-of-atomic-read-modify-write-operation/)

## 6. 工具
* [基于 Go 的内置 Parser 打造轻量级规则引擎](http://xargin.com/rule-engine-on-go-parser/)
* [ClusterFuzz](https://google.github.io/clusterfuzz/)
* [Strace little book](https://nanxiao.gitbooks.io/strace-little-book/content/)
* [Vim查找替换及正则表达式的使用](https://tanqisen.github.io/blog/2013/01/13/vim-search-replace-regex/)

## 7. 编程语言
### 7.1 Go
* [实际项目为背景，带逛Go 1.12最新特性](https://zhuanlan.zhihu.com/p/57257136)
* [图解 Go 内存分配器](https://www.infoq.cn/article/IEhRLwmmIM7-11RYaLHR)
* [大规模Go项目几乎必踏的几个坑 - Dragonboat为例](https://zhuanlan.zhihu.com/p/53284649?utm_source=wechat_timeline&utm_medium=social&utm_oi=35700095320064&wechatShare=2&s_r=0&from=timeline&isappinstalled=0)
* [图解Golang的GC算法](https://mp.weixin.qq.com/s/_h0-8hma5y_FHKBeFuOOyw)
* [Go Stack Trace](https://colobu.com/2016/04/19/Stack-Traces-In-Go/)
* [High Performance Go Workshop](https://dave.cheney.net/high-performance-go-workshop/dotgo-paris.html)
~~~
The compiler implements a specific optimisation for this case

var m map[string]string
v, ok := m[string(bytes)]
This will avoid the conversion of the byte slice to a string for the map lookup. This is very specific, it won’t work if you do something like

key := string(bytes)
val, ok := m[key]
~~~

* [cacheline 对 Go 程序的影响](https://colobu.com/2019/01/24/cacheline-affects-performance-in-go/)
* [高性能 Go 服务的内存优化](https://www.jianshu.com/p/63404461e520)
* [如何分析golang程序的内存使用情况](https://www.jianshu.com/p/43b0e12043b9)
* [Garbage Collection In Go : Part I - Semantics](https://www.ardanlabs.com/blog/2018/12/garbage-collection-in-go-part1-semantics.html)
* [Golang Failpoint 的设计与实现](https://mp.weixin.qq.com/s/veIoupLjM4l5SUVC6h_Gkw)
* [HTTP/2 in GO](https://mp.weixin.qq.com/s?__biz=MzU4ODgyMDI0Mg==&mid=2247486533&idx=1&sn=ff63b2fcd9bf291f42b3b5c69444f622)
* [使用 go/analysis 包实现自定义的 linter](https://colobu.com/2019/06/14/using-go-analysis-to-write-a-custom-linter/)
* [请问sync.Pool有什么缺点？](https://mp.weixin.qq.com/s/kwVAGUZRlrUCL9kmA6bbDg)
* [关于Golang GC的一些误解--真的比Java算法更领先吗？](https://mp.weixin.qq.com/s/eDd212DhjIRGpytBkgfzAg)
* [深入理解Go-垃圾回收机制](https://segmentfault.com/a/1190000020086769)
* [一张图了解三色标记法](http://idiotsky.top/2017/08/16/gc-three-color/)
* [fasthttp best practices](https://github.com/valyala/fasthttp#fasthttp-best-practices)
* [Hi, 使用多年的go pprof检查内存泄漏的方法居然是错的?!](https://colobu.com/2019/08/20/use-pprof-to-compare-go-memory-usage/)
    * go tool pprof --http :9090 `--base base.heap` current.heap
* [Go语言(golang)新发布的1.13中的Error Wrapping深度分析](https://mp.weixin.qq.com/s/JHUd85I0CnwJC_nw6YzKdw)
* [Gin v1.4 中文文档](https://rsy.me/gin-chn-document/)
* [Uber Go语言编码规范](https://tonybai.com/2019/10/12/uber-go-style-guide/)
* [Fasthttp best practices](https://github.com/valyala/fasthttp#fasthttp-best-practices)
* [Go开源项目BigCache如何加速并发访问以及避免高额的GC开销](https://pengrl.com/p/35302/)
* [容器中某Go服务GC停顿经常超过100ms排查](https://mp.weixin.qq.com/s/Lk1EbiT7WprVOyX_dXYMyg)
    * sched_min_granularity_ns
    * [从几个问题开始理解CFS调度器](http://linuxperf.com/?p=42)
* [基于 Golang 的 SOFAMosn 深度剖析](https://mp.weixin.qq.com/s/NC3ju2ePTAZukHcTUQ2ntQ)
    * GODEBUG=madvdontneed=1


##### 7.1.1 Go Module
* [一键解决 go get golang.org/x 包失败](https://shockerli.net/post/go-get-golang-org-x-solution/)
* [goproxy](https://goproxy.io/)
* [Modules](https://github.com/golang/go/wiki/Modules)
* [跳出Go module的泥潭](https://colobu.com/2018/08/27/learn-go-module/)
* [初窥Go module](https://tonybai.com/2018/07/15/hello-go-module/)
* [使用Go Modules](https://www.4async.com/2019/03/using-go-modules/)
* [正在或即将被使用的Go依赖包管理方法：Go Modules，Go 1.13的标准特性](https://mp.weixin.qq.com/s?__biz=MzUzNTI3NjkwMw==&mid=2247483962&idx=1&sn=59aa0d6030f8a5e3cb44a04100bc3332)


### 7.2 C++
* [C++ 如何避免内存泄露](https://zhuanlan.zhihu.com/p/51898119)

### 7.3 Java
* [cpuflamegraphs.html - Java](http://www.brendangregg.com/FlameGraphs/cpuflamegraphs.html#Java)
* [java performance analysis on linux with flame graphs](https://www.slideshare.net/brendangregg/java-performance-analysis-on-linux-with-flame-graphs)
* [Java 火焰图](https://www.jianshu.com/p/bea2b6a1eb6e)

## 8. 数据结构与算法

* [Revisiting hash table performance](https://attractivechaos.wordpress.com/2018/01/13/revisiting-hash-table-performance/)

![](https://raw.githubusercontent.com/attractivechaos/udb2/master/__logs/180929-gcloud-a.png)

* **sparse set**
    * [Using Uninitialized Memory for Fun and Profit](https://research.swtch.com/sparse)
    * [google sparse set](https://github.com/google/codesearch/tree/master/sparse)


## 9. 杂
* [RESTful API 最佳实践](http://www.ruanyifeng.com/blog/2018/10/restful-api-best-practices.html)
* [阿里毕玄现身说法：程序员成长路线](https://mp.weixin.qq.com/s/nUtUu6e_bXHvb_06Pf_05g)
* [如何用30分钟快速优化家中Wi-Fi？阿里工程师有绝招](https://mp.weixin.qq.com/s/wIKZvXjDEzYL2_a1ePclBg)
* [Peter Norvig：自学编程，十年磨一剑](http://blog.jobbole.com/22905/)
* [好玩又实用，阿里巴巴开源混沌工程工具 ChaosBlade](https://mp.weixin.qq.com/s/5qJ4JNbhH7-OIoQQ_hVogQ)
* [比原生更快：在 Linux 内核中运行 WebAssembly](https://mp.weixin.qq.com/s/F6yAE3-l_LI8l1ls5yLHqw)
* [腾讯工程师的自我修炼](https://mp.weixin.qq.com/s/ReUoyZ3zW3nsV1rmI19XCA)
* [Linux异步IO新时代：io_uring](https://mp.weixin.qq.com/s/DNMWE_DqT5IiHdMVQ5CKBg)
* [彻底弄懂高内聚与低耦合](https://mp.weixin.qq.com/s/g3HqyCG9auqzgQpvyipwSg)
* [xargs 命令教程](http://www.ruanyifeng.com/blog/2019/08/xargs-tutorial.html)
* [使用 github，知道这些就够了](https://mp.weixin.qq.com/s/s_pNeT1lMlVDbjO37Fys4A)
* [漫画：什么是中台？](https://mp.weixin.qq.com/s/rF7_xJBq4NJP6CmkW3HPpQ)
* [CentOS 8 都发布了，你还不会用 nftables？](https://mp.weixin.qq.com/s/VPBgIqlTiFe7KwqF1Q4pCA)
* [HAProxy 的使用](https://mp.weixin.qq.com/s/20RTBWiQkzdcbicylqm1JA)
