# Changelog

## [2.11.3](https://github.com/italia/pa-website-validator/compare/v2.11.2...v2.11.3) (2024-10-08)


### Bug Fixes

* **C.SI.2.6:** feedback component check ([#533](https://github.com/italia/pa-website-validator/issues/533)) ([c590d5a](https://github.com/italia/pa-website-validator/commit/c590d5ae993fcf62221675ca193848f7030e5b33))
* **C.SI.5.2:** add Moransengo-Tonengo ([4fd97f3](https://github.com/italia/pa-website-validator/commit/4fd97f3ef0086c802c4ae37f56a11024d7ed7422))
* **C.SI.5.2:** add Rometta ([319a87d](https://github.com/italia/pa-website-validator/commit/319a87d141e0669b1d1aafd9386963ebbe6ccaec))
* wait for ajax in services loading ([#534](https://github.com/italia/pa-website-validator/issues/534)) ([2419e72](https://github.com/italia/pa-website-validator/commit/2419e729227b053b24cc7c9f2fc43c92015de25d))

## [2.11.2](https://github.com/italia/pa-website-validator/compare/v2.11.1...v2.11.2) (2024-09-20)


### Bug Fixes

* add "wcag-21" as valid string ([#530](https://github.com/italia/pa-website-validator/issues/530)) ([6798fcb](https://github.com/italia/pa-website-validator/commit/6798fcb7636a0527b5017836a191c2ac27d6a6bf))

## [2.11.1](https://github.com/italia/pa-website-validator/compare/v2.11.0...v2.11.1) (2024-08-29)


### Bug Fixes

* loop in school utils ([#526](https://github.com/italia/pa-website-validator/issues/526)) ([4a10222](https://github.com/italia/pa-website-validator/commit/4a10222e30c6a42afed1a5bebb273e55224f473d))

## [2.11.0](https://github.com/italia/pa-website-validator/compare/v2.10.1...v2.11.0) (2024-08-29)


### Features

* improve performance ([#519](https://github.com/italia/pa-website-validator/issues/519)) ([def50eb](https://github.com/italia/pa-website-validator/commit/def50eb69052fe6b6c4ed7d641e34f86279a59a8))


### Bug Fixes

* **C.SI.5.2:** add Santa Caterina d’Este domain ([3138a5d](https://github.com/italia/pa-website-validator/commit/3138a5d660e0ef46303d7cc2e39da2b492a3d9eb))

## [2.10.1](https://github.com/italia/pa-website-validator/compare/v2.10.0...v2.10.1) (2024-08-01)


### Bug Fixes

* **C.SC.1.3,C.SI.1.4:** ignore non-string contents ([28b5771](https://github.com/italia/pa-website-validator/commit/28b5771ecb24d36015f5538a28fc02f238febaf5))
* **C.SI.1.3:** increase timeout ([5b6dd80](https://github.com/italia/pa-website-validator/commit/5b6dd8046f64f1d55f708d43fd51ffb1e89c3afd))
* **C.SI.5.2:** remove `www` only at the beginning of a URL ([87dc14d](https://github.com/italia/pa-website-validator/commit/87dc14dcc56755769ee77821023cd55278d95836))

## [2.10.0](https://github.com/italia/pa-website-validator/compare/v2.9.0...v2.10.0) (2024-06-06)


### Features

* check for improvement plan ([#493](https://github.com/italia/pa-website-validator/issues/493)) ([ee1bbc6](https://github.com/italia/pa-website-validator/commit/ee1bbc6d63eab4e0ee52b4a5453cc0096c820279))

## [2.9.0](https://github.com/italia/pa-website-validator/compare/v2.8.5...v2.9.0) (2024-05-31)


### Features

* check WCAG 2.1 compliance ([68c037c](https://github.com/italia/pa-website-validator/commit/68c037c330c167949bafbf0db3c82e744939492c))


### Bug Fixes

* **C.SC.2.2:** add AGID unreachable check ([590c279](https://github.com/italia/pa-website-validator/commit/590c2792fef6d5e0baa5297e2fb4ac9c092993e9))
* **C.SI.1.5:** add “Anagrafe” and “PNRR” ([006bb24](https://github.com/italia/pa-website-validator/commit/006bb2406b4feda4bc9f39da9f71ded5cda10689))
* make domain check case insensitive ([b9c0b31](https://github.com/italia/pa-website-validator/commit/b9c0b31d1de4b5743ae0f384bcd989460faad7cb))

## [2.8.5](https://github.com/italia/pa-website-validator/compare/v2.8.4...v2.8.5) (2024-03-28)


### Bug Fixes

* **R.SC.2.2:** accept `'` character in legal notes ([fa2c268](https://github.com/italia/pa-website-validator/commit/fa2c2681542ade31dd2d35a9fa084cfbf28fd6d2))

## [2.8.4](https://github.com/italia/pa-website-validator/compare/v2.8.3...v2.8.4) (2024-03-28)


### Bug Fixes

* accept `'` character in legal notes ([8ffdfa9](https://github.com/italia/pa-website-validator/commit/8ffdfa9d7ef29cd93248aadf8ee5a7d3b32a6744))
* add timeout in button click wait for navigation ([#470](https://github.com/italia/pa-website-validator/issues/470)) ([793eb5a](https://github.com/italia/pa-website-validator/commit/793eb5ad68211ae3d787ce93ca2f03db93e1d8ce))
* **C.SI.5.2:** add Romentino domain ([3d03986](https://github.com/italia/pa-website-validator/commit/3d03986e05f9098479bbacada76e8133295b4d5a))
* check domain name only in accessibility page ([b8533ec](https://github.com/italia/pa-website-validator/commit/b8533ecaeb8c7dbc956e8620bafa0048b1dc4f21))
* increase heap memory ([ec2d961](https://github.com/italia/pa-website-validator/commit/ec2d9614b3bd8300e95f6b2c3f3a6ad3e571e87b))
* show error on accessibility audit if AGID is unreachable ([92ccb79](https://github.com/italia/pa-website-validator/commit/92ccb7959189f26bd4640d1dce8dd8f7e1071630))

## [2.8.3](https://github.com/italia/pa-website-validator/compare/v2.8.2...v2.8.3) (2024-03-07)


### Bug Fixes

* aggiunti font lowercase ([4157889](https://github.com/italia/pa-website-validator/commit/4157889234055fabbe46bf4d2215fabc67110104))
* **C.SI.1.7:** add extra allowed title for second level pages ([8c3c93e](https://github.com/italia/pa-website-validator/commit/8c3c93ee20958be8d12500bf08482bde05396137))
* **C.SI.5.2:** add Pieve di Bono-Prezzo and Predaia domains ([cd7b327](https://github.com/italia/pa-website-validator/commit/cd7b327bc2fd0efbc76e2de51b8cbf91411b7c5b))
* set Italian as preferred languange in internal browser ([cbbd157](https://github.com/italia/pa-website-validator/commit/cbbd1576210f652c5f097b00ace62ed3d684228e))

## [2.8.2](https://github.com/italia/pa-website-validator/compare/v2.8.1...v2.8.2) (2024-02-05)


### Bug Fixes

* **C.SC.1.5:** case insensitive match ([594da46](https://github.com/italia/pa-website-validator/commit/594da46355cd6f7c142e05e148d2817e291f17c0))
* **C.SI.5.2:** add missing domains ([fe73d2c](https://github.com/italia/pa-website-validator/commit/fe73d2cc2cdd0c05ddb5f9ca0561809a58711e72))
* **C.SI.5.2:** add missing domains ([6a5a22f](https://github.com/italia/pa-website-validator/commit/6a5a22fc313ed2687d325720187c82d44ec63467))
* handle non semantic versioning ([53661d5](https://github.com/italia/pa-website-validator/commit/53661d5ccdb0fefc481357dc230bce24a24e7e72))

## [2.8.1](https://github.com/italia/pa-website-validator/compare/v2.8.0...v2.8.1) (2023-12-21)


### Bug Fixes

* update allowed domains ([d0b7ffd](https://github.com/italia/pa-website-validator/commit/d0b7ffd9302747caad802a90b2f3e2b15b93dc16))
* use cheerio for html to text conversion ([3b1858c](https://github.com/italia/pa-website-validator/commit/3b1858cd7d6b056d60e626931546e8653a2633d5))

## [2.8.0](https://github.com/italia/pa-website-validator/compare/v2.7.6...v2.8.0) (2023-11-23)


### Features

* allow custom number of services to analyze ([8b6dfd6](https://github.com/italia/pa-website-validator/commit/8b6dfd60ecb13c4f5f151b8bfd8881374552143b))
* **app:** add version string in report filename ([b184f6a](https://github.com/italia/pa-website-validator/commit/b184f6aa95864113817614263628aa64c5142396))


### Bug Fixes

* aggiornati domini ([8d00ce8](https://github.com/italia/pa-website-validator/commit/8d00ce87d6b27d347fc20e9b2b95448aa704f428))
* **C.SI.2.1:** do not exclude external appointment booking links ([1643c5b](https://github.com/italia/pa-website-validator/commit/1643c5bbe66fe67c57cc79987ac34a463f62772a))
* do not load PDF files ([0f148e6](https://github.com/italia/pa-website-validator/commit/0f148e6e43d76868e370c0c99108384f1938a5c3))

## [2.7.6](https://github.com/italia/pa-website-validator/compare/v2.7.5...v2.7.6) (2023-10-27)


### Bug Fixes

* **C.SI.1.2:** lower threshold to 30% ([d4b7ec5](https://github.com/italia/pa-website-validator/commit/d4b7ec58ef5531bb6f8acfe6e9417efdfbb4d6e0))
* **C.SI.2.1:** do not check for links equality ([ef3b73e](https://github.com/italia/pa-website-validator/commit/ef3b73e23ccdc07164d78c10983741a39368012b))

## [2.7.5](https://github.com/italia/pa-website-validator/compare/v2.7.4...v2.7.5) (2023-10-25)


### Reverts

* "fix: browser2 close instead of disconnect" ([17dbc03](https://github.com/italia/pa-website-validator/commit/17dbc037fb3f45029a9a21ae5aee5298cf488247))

## [2.7.4](https://github.com/italia/pa-website-validator/compare/v2.7.3...v2.7.4) (2023-10-24)


### Bug Fixes

* browser2 close instead of disconnect ([3607db8](https://github.com/italia/pa-website-validator/commit/3607db875e3bf9c24fe14d1c127c59586f8da270))
* load host from redirected url ([71662bd](https://github.com/italia/pa-website-validator/commit/71662bd652d27762ddd953d3686ca1af9a0419d4))
* percentage round before the check and caching redirected page ([d9007bd](https://github.com/italia/pa-website-validator/commit/d9007bdf135ccfb2e8d5f803505e077511de1a15))

## [2.7.3](https://github.com/italia/pa-website-validator/compare/v2.7.2...v2.7.3) (2023-10-16)


### Bug Fixes

* add error message dataelement ([d7f7270](https://github.com/italia/pa-website-validator/commit/d7f7270e55728c3624f7cf9826771f1225203e41))
* change required from name to audienceType ([72cca61](https://github.com/italia/pa-website-validator/commit/72cca611bd58cae2307014c1379f286ee1dd5fc3))
* get redirected url ([14d032c](https://github.com/italia/pa-website-validator/commit/14d032ccdf958c829348f143cb75cf444fb1752c))
* remove extra backtick ([1e05e8f](https://github.com/italia/pa-website-validator/commit/1e05e8f8d3f5eee92864b3594784e92ec9264309))

## [2.7.2](https://github.com/italia/pa-website-validator/compare/v2.7.1...v2.7.2) (2023-09-29)


### Bug Fixes

* change audit domain, first and second pages ([58143a9](https://github.com/italia/pa-website-validator/commit/58143a9cd35f2c4c495a09e97999d912e5b094dd))
* check domain after page load ([#389](https://github.com/italia/pa-website-validator/issues/389)) ([3855ddf](https://github.com/italia/pa-website-validator/commit/3855ddf0d4ac6b989e94846b4cdf985b2b69bf03))
* click exception ([8bda399](https://github.com/italia/pa-website-validator/commit/8bda3997cb520d7b47377884037efb489e741b15))
* wait for networkIdle after click ([1d64a6e](https://github.com/italia/pa-website-validator/commit/1d64a6ef183fd8b8972533e98a689fcaa2b8f97b))

## [2.7.1](https://github.com/italia/pa-website-validator/compare/v2.7.0...v2.7.1) (2023-09-26)


### Bug Fixes

* audit descriptions ([fc24d35](https://github.com/italia/pa-website-validator/commit/fc24d35fd5bc8cd09b03b62b5a7e6e6417a5be69))
* axios get headers ([bff95a9](https://github.com/italia/pa-website-validator/commit/bff95a95f36e1fff3e49e19a2c33279e1e5e7ac7))
* **C.SI.5.2:** audit description ([1b02c2e](https://github.com/italia/pa-website-validator/commit/1b02c2e9790f00c7f8b860a5836b7c957f11f136))
* move check number of services after load instead of after select pages ([b554c18](https://github.com/italia/pa-website-validator/commit/b554c18ce94956b4b468c7fae58ff2b294719158))
* remove homepage ([4af1641](https://github.com/italia/pa-website-validator/commit/4af1641d723c7c24f9eb4869f5417fbb739f736d))
* scan variables ([bb192eb](https://github.com/italia/pa-website-validator/commit/bb192eb231f0432e3e905b8172a16013380abb6a))

## [2.7.0](https://github.com/italia/pa-website-validator/compare/v2.6.0...v2.7.0) (2023-09-22)


### Features

* add check number of services in audit municipality services ([be0238c](https://github.com/italia/pa-website-validator/commit/be0238c32bdc47487fefcd78b66d9bb53ea86fb8))
* add check number of services in audit municipality services ([58d19e0](https://github.com/italia/pa-website-validator/commit/58d19e00ffb26822e3f4f809fa0d8e2440a3bb94))
* add check on page url and name in first and second level pages ([a99548e](https://github.com/italia/pa-website-validator/commit/a99548e18daac75468cc2719102a37048b777de4))
* add check on page url and name in first and second level pages ([4fb3077](https://github.com/italia/pa-website-validator/commit/4fb30778978246bad6c1f522c3f83970a2ed7b65))
* add check pages in school ([f99236d](https://github.com/italia/pa-website-validator/commit/f99236d4c374113da03c064a7a57495ed69430a1))
* add check pages in school ([c6d78c0](https://github.com/italia/pa-website-validator/commit/c6d78c0e4b7daff09bae4d37d0d9b8f46443589b))
* add error handling in domain and feedback audit ([d3a1524](https://github.com/italia/pa-website-validator/commit/d3a1524982ae83d4586fad295d4d00509458df37))
* add link name and url for get first level page ([236a702](https://github.com/italia/pa-website-validator/commit/236a702995fb34ec5acc48514d0e17845ec0fcb6))
* add link name and url for get first level page ([53901e5](https://github.com/italia/pa-website-validator/commit/53901e5bc22a88ec0b0a6b3e33c8bc93bafcab69))
* add pager loading in municipality services ([eb1b17f](https://github.com/italia/pa-website-validator/commit/eb1b17f4fa7bf03fa3e8c5985ca5acbd040bf045))
* add primary page domain checks ([fa41bce](https://github.com/italia/pa-website-validator/commit/fa41bce5c8e948617313ac2ec098f31a05d8d74c))
* add primary page domain checks ([c5da288](https://github.com/italia/pa-website-validator/commit/c5da2887627eadd74b2b7dec0903fcc731b2749f))
* add primary, secondary and service pages in domain audit ([df82b3f](https://github.com/italia/pa-website-validator/commit/df82b3f3fb860562a177928ae1a4551227b0949f))
* add protocol timeout ([56b3b50](https://github.com/italia/pa-website-validator/commit/56b3b507c1c3fc6ed4d3184632b08fb018d963be))
* audit school first level page, check page redirect and page name ([40fcb92](https://github.com/italia/pa-website-validator/commit/40fcb920e44fb32af4d559a97f4888db8e0fe610))
* audit school first level page, check page redirect and page name ([f15b059](https://github.com/italia/pa-website-validator/commit/f15b05984e8f0d6b7fdb3faab42122d7008b691b))
* change error message ([339e692](https://github.com/italia/pa-website-validator/commit/339e692893f84327b4d02d6c4e71c8283f8a1f59))
* change municipality bootstrap check ([59c0066](https://github.com/italia/pa-website-validator/commit/59c0066481d6a04823e8d5bcf8c08c7ef7adfc87))
* refactory pages loading and data element error handling ([b5e09f9](https://github.com/italia/pa-website-validator/commit/b5e09f9d56428558714907c424f03f30e56e22cd))
* remove external link redirect from page retrieve ([0f44278](https://github.com/italia/pa-website-validator/commit/0f44278a5b74e77fec6a50d6fa0431805fb4ab90))
* remove external link redirect from page retrieve ([5093a14](https://github.com/italia/pa-website-validator/commit/5093a14822000448aebce8145038b4d973a5986a))
* second level pages load ([655c111](https://github.com/italia/pa-website-validator/commit/655c111f9fc3a08bfd0bd52982be686066c0fe78))
* second level pages load ([67991ea](https://github.com/italia/pa-website-validator/commit/67991ea2f80002366cdf7c81c3b5d6ecba3cfe2f))


### Bug Fixes

* add regular expression for drupal classes ([#370](https://github.com/italia/pa-website-validator/issues/370)) ([f69f01a](https://github.com/italia/pa-website-validator/commit/f69f01a18dc931624cb748be8ca6f024f393c14c))
* add vocabularies ([#371](https://github.com/italia/pa-website-validator/issues/371)) ([dd52af9](https://github.com/italia/pa-website-validator/commit/dd52af977de4054bbf7d8e9a39f3c06c1a477b81))
* audit configs ([ea04942](https://github.com/italia/pa-website-validator/commit/ea04942313a8db9bc70db19c175fdd0bbc929477))
* audit configs ([973f0a1](https://github.com/italia/pa-website-validator/commit/973f0a12e51225f9b79984bd6d6aa08fb0daf8f6))
* bootstrap audit description ([fdb63b4](https://github.com/italia/pa-website-validator/commit/fdb63b43a4b8804b41853c936ea2654a58cff0e3))
* change audit messages: municipality-domain, municipality-services ([8811b37](https://github.com/italia/pa-website-validator/commit/8811b37cd59948f4b4cc2d2464ecc4a3d78865bd))
* change check logic school and municipality ([d494bb5](https://github.com/italia/pa-website-validator/commit/d494bb5ee8797d4f45deccc9c680173bc44c12ee))
* change check logic school and municipality ([c1fb622](https://github.com/italia/pa-website-validator/commit/c1fb622e2849b2a77f31b777a81d78af6fb36c18))
* error column order ([5e574d1](https://github.com/italia/pa-website-validator/commit/5e574d1120bbb969b186c406730023cff5db5cc7))
* error column order ([7ef8c74](https://github.com/italia/pa-website-validator/commit/7ef8c748e8cdcab1466ce251ed25ff5f1f4ce904))
* error on link build ([3e27156](https://github.com/italia/pa-website-validator/commit/3e2715678eacb070bae9ed4ba09c1764b3486a17))
* merge conflicts ([3493eca](https://github.com/italia/pa-website-validator/commit/3493ecaecf500bd82f9e399f8c8391825a5ce148))
* remove backtick ([601c757](https://github.com/italia/pa-website-validator/commit/601c757aa53b2ec5a772ac072c7eb644ea267e56))
* replace waitForNavigation with waitForSelector all-topic ([2492ccc](https://github.com/italia/pa-website-validator/commit/2492ccc6bb5b4839698dd3b10e3412c85ba17f57))
* start from zero, min 2 clicks ([70e40a3](https://github.com/italia/pa-website-validator/commit/70e40a334998ba954986e6bfc7d8b51814506675))
* static checks ([127b19a](https://github.com/italia/pa-website-validator/commit/127b19a6944af7ef214898aea3ca55e5b81fc4b6))
* static checks ([b1abf41](https://github.com/italia/pa-website-validator/commit/b1abf4148c918db9d9e51aa8a70622e7a33c3b7c))
* static checks ([dfbd56b](https://github.com/italia/pa-website-validator/commit/dfbd56badba46b82b224d0f0b0171398fef01e51))
* Update allowedDomains.ts ([06a16b4](https://github.com/italia/pa-website-validator/commit/06a16b4cae3ad19deb488ec64b85ef0bf278386d))

## [2.6.0](https://github.com/italia/pa-website-validator/compare/v2.5.1...v2.6.0) (2023-08-04)


### Features

* add request interception for media requests ([d5d0c1f](https://github.com/italia/pa-website-validator/commit/d5d0c1f561b898c886a7e8e8e846a4cc4a13f3cf))
* add timeout error handling and goto retry tentative ([deeee0f](https://github.com/italia/pa-website-validator/commit/deeee0fcf73b68ead928bd2633fbd0ef5b123c7a))


### Bug Fixes

* change audience.name in audience.audienceType ([1dffa8b](https://github.com/italia/pa-website-validator/commit/1dffa8b969b663f002c185c71418eb470b67cb8a))
* error message for audit with page.goto ([71910b4](https://github.com/italia/pa-website-validator/commit/71910b4db89bcfa908815fddb9ad3e5161b67498))
* Update allowedDomains.ts ([422acdb](https://github.com/italia/pa-website-validator/commit/422acdbac13a48e145b71bc8e8fc53a4fdf55731))

## [2.5.1](https://github.com/italia/pa-website-validator/compare/v2.5.0...v2.5.1) (2023-07-11)


### Bug Fixes

* allow cookie domains starting with dot ([fa299e9](https://github.com/italia/pa-website-validator/commit/fa299e9b044a5e7bcd0362d791fd89a7e245a41a))
* **school:** do not check external pages ([f1161f6](https://github.com/italia/pa-website-validator/commit/f1161f60cdeed51be764e9ef8bc8fcec8357adfa))
* **scuole:** do not check external service pages ([a9ffa5a](https://github.com/italia/pa-website-validator/commit/a9ffa5a4282f14aadd6bee8921e985ec8cdf5d87))

## [2.5.0](https://github.com/italia/pa-website-validator/compare/v2.4.1...v2.5.0) (2023-07-04)


### Features

* check feedback component questions and answers at each click ([878c673](https://github.com/italia/pa-website-validator/commit/878c67368f2a3d8a6df1c7f76a16cb2ff53f49b4))
* check load cards when button clicked ([afc9563](https://github.com/italia/pa-website-validator/commit/afc95636cde2080f58a9fd87aac8d18f8600481b))


### Bug Fixes

* **scuole:** language detection ([cf11d10](https://github.com/italia/pa-website-validator/commit/cf11d10dd2726dfc57802b29a87c8d80bb989b18))

## [2.4.1](https://github.com/italia/pa-website-validator/compare/v2.4.0...v2.4.1) (2023-06-30)


### Bug Fixes

* **app:** set Puppeteer cache dir ([46b5f61](https://github.com/italia/pa-website-validator/commit/46b5f61bcafd002673c33862fb521afe1f5a6fc2))
* visibility check on display, visibility, boundingClientRect, offsetParent ([8b0e330](https://github.com/italia/pa-website-validator/commit/8b0e330d13321040f0a50ce735b86448ecd59f27))

## [2.4.0](https://github.com/italia/pa-website-validator/compare/v2.3.4...v2.4.0) (2023-06-29)


### Features

* allow subdomain in cookies ([d5f68a1](https://github.com/italia/pa-website-validator/commit/d5f68a1071325ef471890f671021d49181e0bc27))
* **scuole:** add support for German and Ladin language ([5090932](https://github.com/italia/pa-website-validator/commit/50909326d8718d52aca2b8ba27e66a4772f40c22))


### Bug Fixes

* check subdomain ([926aad7](https://github.com/italia/pa-website-validator/commit/926aad7593cf9a4f48447f7a964fd5f7c66c4535))
* improve error logging ([937f277](https://github.com/italia/pa-website-validator/commit/937f27751337026b60eba1e7547bb77fcf975cf2))
* increase HTTP response logs ([78e1723](https://github.com/italia/pa-website-validator/commit/78e17239aaa0d13bd9bdd876492e2568aec80069))
* remove break in click loop ([ec87d2b](https://github.com/italia/pa-website-validator/commit/ec87d2ba0d031bcb0834f4f8f1b39e519ed642e1))
* remove single process on puppeteer, remove visible from modal button search, merge logics in bootstrap audit ([1550be0](https://github.com/italia/pa-website-validator/commit/1550be0726ce42bbf685e4f834e272a54bc21cb7))
* remove wait for ajax response in load other cards, refactory feedback component check ([3aec60c](https://github.com/italia/pa-website-validator/commit/3aec60ca99cf062a74188e94cb9babbd05127dc4))
* removing get parameters during URL check ([d95d4a6](https://github.com/italia/pa-website-validator/commit/d95d4a68c3877ba3d45304bee4ff854efe8357ce))
* show correct URL in error message ([28ae46d](https://github.com/italia/pa-website-validator/commit/28ae46df7fbaad45f6c9bc83cff111789fb88fe4))

## [2.3.4](https://github.com/italia/pa-website-validator/compare/v2.3.3...v2.3.4) (2023-06-05)


### Bug Fixes

* increase output verbosity during page loading ([f044878](https://github.com/italia/pa-website-validator/commit/f0448783f24af5d722856f9ea7a3874fc3d60aae))
* revert internal URL check for schools ([e84262a](https://github.com/italia/pa-website-validator/commit/e84262a1174d798c3852098457176435efaed7fe))

## [2.3.3](https://github.com/italia/pa-website-validator/compare/v2.3.2...v2.3.3) (2023-05-12)


### Bug Fixes

* check content length in C.SI.1.3 and R.SC.1.2 ([b089866](https://github.com/italia/pa-website-validator/commit/b089866454ff8c892eb9978382c51342dad96bf3))

## [2.3.2](https://github.com/italia/pa-website-validator/compare/v2.3.1...v2.3.2) (2023-05-08)


### Bug Fixes

* process.exit in index.ts ([ff75f26](https://github.com/italia/pa-website-validator/commit/ff75f26ebbc7c6f228bb74733feb69aad06224e6))

## [2.3.1](https://github.com/italia/pa-website-validator/compare/v2.3.0...v2.3.1) (2023-04-26)


### Bug Fixes

* Fix release workflow ([23ff878](https://github.com/italia/pa-website-validator/commit/23ff87853814caf3f24f500b7983cfaa471a73f2))

## [2.3.0](https://github.com/italia/pa-website-validator/compare/v2.2.1...v2.3.0) (2023-04-26)


### Features

* puppeteer single process ([7bdace1](https://github.com/italia/pa-website-validator/commit/7bdace180f9d2bedc6c4f3d76356cca046fac781))

## [2.2.1](https://github.com/italia/pa-website-validator/compare/v2.2.0...v2.2.1) (2023-04-12)


### Bug Fixes

* follow A links ([#249](https://github.com/italia/pa-website-validator/issues/249)) ([1f1d0c1](https://github.com/italia/pa-website-validator/commit/1f1d0c1f8906bed5dca2ada8f7a4a2d0b1cb425a))
* indicate the child font when yellow result ([8840f7a](https://github.com/italia/pa-website-validator/commit/8840f7a870962c1b5cab52b711cc70b44e7a87f1))
* make local C.SC.2.2 and C.SI.3.2 informative ([68c6087](https://github.com/italia/pa-website-validator/commit/68c6087229ac52186593f2ddd433b6b76f4a7ec6))

## [2.2.0](https://github.com/italia/pa-website-validator/compare/v2.1.1...v2.2.0) (2023-04-03)


### Features

* parametro timeout per le richieste al sito ([#229](https://github.com/italia/pa-website-validator/issues/229)) ([bbd92ca](https://github.com/italia/pa-website-validator/commit/bbd92caca1c05564ca9f6013c9245a249ff8b478))


### Bug Fixes

* building internal url and replace hidden characters in string ([ee2a38b](https://github.com/italia/pa-website-validator/commit/ee2a38be1aea1efe69c75f74b0ab104beafeef82))
* increase default value of request timeout ([2f173cb](https://github.com/italia/pa-website-validator/commit/2f173cb6ad66adc06297e9443a3b9022a3ccdbb0))
* modifica caricamento span ([87d273e](https://github.com/italia/pa-website-validator/commit/87d273e61ba3911acd9d175f0b1a3bac89bc567d))
* selector p ([2b338f5](https://github.com/italia/pa-website-validator/commit/2b338f543b6a5a0bfaf28735a82f4136e4b68ca4))
* success logic ([b45594d](https://github.com/italia/pa-website-validator/commit/b45594df794383bac2806431affef5673bf2b29e))

## [2.1.1](https://github.com/italia/pa-website-validator/compare/v2.1.0...v2.1.1) (2023-03-13)


### Bug Fixes

* gestione eccezione con buttone non ajax, fix breadcrumb, fix visualizzazione voci secondo livello ([05eedac](https://github.com/italia/pa-website-validator/commit/05eedaca7b3f3b2cb9f49ff202de0ef2b955abe2))

## [2.1.0](https://github.com/italia/pa-website-validator/compare/v2.0.2...v2.1.0) (2023-03-13)


### Features

* colonna per JSON valido in audit metatag ([acc9845](https://github.com/italia/pa-website-validator/commit/acc984565a0f4ef41161adf501bce0143e957677))
* controllo se url è interno al sito per pagine di secondo livello di scuole ([46eac99](https://github.com/italia/pa-website-validator/commit/46eac993fbe228e35c6360c5c34fcb00b0c4d68f))


### Bug Fixes

* **C.SI.5.2:** logica di controllo per sottodomini ([75d3d89](https://github.com/italia/pa-website-validator/commit/75d3d89d4b52e3a838c52e89db7f4ea805f5f85c))
* caricamento pagine da paginatore per scuole ([ed2080c](https://github.com/italia/pa-website-validator/commit/ed2080c72d4cdabdf1af53b8183bf320cbc5cc47))
* eliminazione caratteri speciali durante controllo breadcrumb ([6db9447](https://github.com/italia/pa-website-validator/commit/6db94476a05b5960550454a4329f364a1fe86bd3))
* eliminazione caratteri speciali durante controllo breadcrumb ([948e390](https://github.com/italia/pa-website-validator/commit/948e39045cff969325a29a37cbaf2046f979816a))

## [2.0.2](https://github.com/italia/pa-website-validator/compare/v2.0.1...v2.0.2) (2023-03-06)


### Bug Fixes

* check url in page with and without www ([e948514](https://github.com/italia/pa-website-validator/commit/e948514ae5859801cd876c2ab3e50a752baa8576))
* minor fixes and packages update ([d750591](https://github.com/italia/pa-website-validator/commit/d75059162d0db9a905ae5c1fa4047f39b4ff77a5))

## [2.0.1](https://github.com/italia/pa-website-validator/compare/v2.0.0...v2.0.1) (2023-03-02)


### Bug Fixes

* **C.SI.2.1:** show correct audit result ([196c90b](https://github.com/italia/pa-website-validator/commit/196c90bd528503425f163127e08a25422dda2314))
* reword ([b6f6e5a](https://github.com/italia/pa-website-validator/commit/b6f6e5a941655638d2925ebaaf74441826248eee))

## [2.0.0](https://github.com/italia/pa-website-validator/compare/v1.2.0-pre.1...v2.0.0) (2023-03-01)


### Bug Fixes

* **app:** change option description ([ffeccec](https://github.com/italia/pa-website-validator/commit/ffeccecebcb0b257e615e0e38d68cb282f86eb7d))
* **app:** change option text ([5b309d3](https://github.com/italia/pa-website-validator/commit/5b309d3f5e2ef0f7a52fcbf66ab51ace81427ca7))
* **app:** change order of options ([6550e15](https://github.com/italia/pa-website-validator/commit/6550e151a5c21aa15c24e0b6b75c304b89916739))
* audit non eseguito se non viene trovata almeno una voce per sotto menù ([4f38ee1](https://github.com/italia/pa-website-validator/commit/4f38ee17d4bd8adda2f1023ebc0dab8cc127440d))
* **C.SI.2.1:** remove breadcrumb check ([3715139](https://github.com/italia/pa-website-validator/commit/371513985c9f9cb50ed89aee5e8441423a5cddac))
* cambiamento itemType a url per link di destinazione ([eb4b694](https://github.com/italia/pa-website-validator/commit/eb4b694f572cfbfc48c27c72445fc2af81bd7a39))
* gestione eccezione https.request ([66670f8](https://github.com/italia/pa-website-validator/commit/66670f82bc73ea869b9b3d85f10c2e876cd0f345))
* logica inizializzazione audit ([1d0665c](https://github.com/italia/pa-website-validator/commit/1d0665c50e87abb560d0d62a9edc8bef2492e7e8))
* modifica scrittura risultati ([43a4fad](https://github.com/italia/pa-website-validator/commit/43a4fadce6994454c64381343e111a88d8b5e231))
* static checks ([7d5995a](https://github.com/italia/pa-website-validator/commit/7d5995a02a5e651e09d4364fc7633fa8c1eb97a2))


### Miscellaneous Chores

* release 2.0.0 ([c279585](https://github.com/italia/pa-website-validator/commit/c279585e01f3d193db4f0921247765b132ca517c))

## [1.2.0-pre.1](https://github.com/italia/pa-website-validator/compare/v1.1.0...v1.2.0-pre.1) (2023-02-28)


### Features

* aggiornamento label audit servizi comuni & scuole ([c5a36dc](https://github.com/italia/pa-website-validator/commit/c5a36dcbaae8059e4abb84903191edab630f4cf1))
* aggiornamento label audits ([eb417b5](https://github.com/italia/pa-website-validator/commit/eb417b5ae4cdb5e4fc94c51f54b092dee5fa4ee0))
* aggiunta colonne aggiuntive ad audit contatti ([42759a5](https://github.com/italia/pa-website-validator/commit/42759a5fa303115c83e04cb926f0e5037c33f3ea))
* aggiunta controllo pagine di prenotazione apputamenti per audit di cookies e bootstrap ([792dfa4](https://github.com/italia/pa-website-validator/commit/792dfa405ad5ec48c7618e17ca9635084c32105c))
* **app:** add selection of accuracy level ([b9d9c14](https://github.com/italia/pa-website-validator/commit/b9d9c14fa91183e5296b70ff8b5538f158ca82f3))
* audit CSC13 ([5883c80](https://github.com/italia/pa-website-validator/commit/5883c800c636bfac0d0fc1d8239e03848148e07a))
* audit CSI21 ([2290d68](https://github.com/italia/pa-website-validator/commit/2290d6820b91e73d73e134fbc5db5cb5f64cf2f0))
* audit CSI25 ([6c7498c](https://github.com/italia/pa-website-validator/commit/6c7498c2c96685c7c3897376f9655f9941b8b2cb))
* audit CSI34 ([30686fe](https://github.com/italia/pa-website-validator/commit/30686fe404a18eced681fa141ad07095eb9ec1d2))
* audit CSI34 con data-elements ([364181f](https://github.com/italia/pa-website-validator/commit/364181f97c9e7e725a0d84e0f8b5941f1a353003))
* audit informativi in audit standard ([3eae28f](https://github.com/italia/pa-website-validator/commit/3eae28fabd045473b770c4a65b03550e550d9cb1))
* audit RSI11 ([22b5d09](https://github.com/italia/pa-website-validator/commit/22b5d0906915a7d5cc5fbe5caf9f7ddeefd99613))
* audit servizi scuole ([cfe960f](https://github.com/italia/pa-website-validator/commit/cfe960f89273ec9a21075f34936c6414c4fd7881))
* audit servizi scuole su servizi multipli con caricamento da pager ([bfc2d87](https://github.com/italia/pa-website-validator/commit/bfc2d87ce0740f30c86e6f6bb6fc44d5a1f9005b))
* audit servizi sui comuni - scansione servizi multipli ([71d33d9](https://github.com/italia/pa-website-validator/commit/71d33d914b93f78aebb05621e5d7280c5e813199))
* audit/CSC11 ([562fa56](https://github.com/italia/pa-website-validator/commit/562fa56445222ccd2d4593f1f5660c9774dc25dc))
* audit/CSC31 ([94dabd0](https://github.com/italia/pa-website-validator/commit/94dabd05252920183ecc20896308f2397873d0d8))
* audit/CSI22 ([db265b1](https://github.com/italia/pa-website-validator/commit/db265b1cc88efb47eaab93c5d483fc224ad15a95))
* audit/CSI24 ([eacf8a3](https://github.com/italia/pa-website-validator/commit/eacf8a385b76941fa97706b734c1cf484d0c0462))
* audit/CSI52 ([d4f704a](https://github.com/italia/pa-website-validator/commit/d4f704ae9e8375be5ce3bbb916ac47fbe8c123db))
* check cookies per pagine di eventi ([1496ffd](https://github.com/italia/pa-website-validator/commit/1496ffdd554ca76559d9e084453435bc4fd17dba))
* configurazioni per accuratezza scansioni ([af174fd](https://github.com/italia/pa-website-validator/commit/af174fd866aeb5c9c628c499341d915e7686546f))
* controllo di almno 3 caratteri in ogni testo di servizi ([4325a5a](https://github.com/italia/pa-website-validator/commit/4325a5a4ba6d8b1bcc45df1aa7a4afe6711d3909))
* controllo presenza componente contatti in pagina per audit assistenza contatti ([63c8942](https://github.com/italia/pa-website-validator/commit/63c89427f518758c8ead1d65090dd89efc7f03d1))
* error voices for second level pages ([927fa3f](https://github.com/italia/pa-website-validator/commit/927fa3f1cb87e5288422b0cb63927811493d720c))
* inizio nuove features audits ([c2b297d](https://github.com/italia/pa-website-validator/commit/c2b297d27f4201c7f5230318b4746fe77ad7cc7b))
* label release 3 ([b727c0d](https://github.com/italia/pa-website-validator/commit/b727c0d5172200960347e0e0041789b839a436cb))
* logica caricamento pagine di scuole ([0cff764](https://github.com/italia/pa-website-validator/commit/0cff76426509066858e9b05de0b59f3273657354))
* modifica label audit di comuni ([a259e0c](https://github.com/italia/pa-website-validator/commit/a259e0ca64a1039778aace6495a072d6d3fe4d58))
* modifica logica di controllo del componenete di feedback ([90e0588](https://github.com/italia/pa-website-validator/commit/90e0588336ba4172af96faef1723c03ec075a456))
* modifica logica di fallimento audit se data-element non trovati ([1ffe394](https://github.com/italia/pa-website-validator/commit/1ffe39424ac6b383723e26d2d4e60546439832a6))
* modifica messaggi dei cluster ([18ce09a](https://github.com/italia/pa-website-validator/commit/18ce09a29db1561246be83b674acf5b9c9ba6f94))
* modifiche audit licenza e attribuzione, dichiarazione accessibilità e disservizio ([f320ca0](https://github.com/italia/pa-website-validator/commit/f320ca0aaa558baa47e27bdaed1b7a41041c6a8f))
* modifiche del 30 01 ([e9f033d](https://github.com/italia/pa-website-validator/commit/e9f033dfcf6a63119698140050709fa86e4251b0))
* nuova visualizzazione risultati per audit bootstrap ([200f32b](https://github.com/italia/pa-website-validator/commit/200f32bbf472c59c63bb89643bb977ebc46a9f8b))
* refactory file di utils ([60e02e6](https://github.com/italia/pa-website-validator/commit/60e02e66ea84dc8f38857657188fe24edf790fcc))
* refactory risultati audit servizi scuole ([ae5b69f](https://github.com/italia/pa-website-validator/commit/ae5b69f45a0f5eb8cb281e0ef73d406195de444f))
* refactory risultati per audit cookie municipality ([5527b21](https://github.com/italia/pa-website-validator/commit/5527b21bc542d64fb24fdad83550a0f8313704ad))
* refactory scrittura risultati per audit bootstrap comuni ([53d0407](https://github.com/italia/pa-website-validator/commit/53d0407de84a9a3b21614f5905c5b407afcfab9c))
* refactory scrittura risultati per audit cookie scuole ([0434560](https://github.com/italia/pa-website-validator/commit/0434560613408bc796b63ef835422ecddeb6bf5f))
* refactory scrittura risultati per audit servizi comuni ([6bfe56e](https://github.com/italia/pa-website-validator/commit/6bfe56ef504faedb99c96e56c0a7025357c7d622))
* ricerca dei data-element per i menu dei servizi ([baaf1d6](https://github.com/italia/pa-website-validator/commit/baaf1d670e17f8068853f17720b48ab0a786b5c7))
* riscrittura risultati per audit bootstrap e link delle pagine analizzate come url ([bc1302d](https://github.com/italia/pa-website-validator/commit/bc1302d7a98776adb68cb33d632be6e52ffeb0a7))
* scansione per tutti gli elementi in pagina ([5f3a526](https://github.com/italia/pa-website-validator/commit/5f3a52646c7fafa1f22c41ea5b9c84a7d993442c))
* scuole voci di secondo livello ([f9fa51e](https://github.com/italia/pa-website-validator/commit/f9fa51eb0565aa088b2b63aa2386e529e685f88b))


### Bug Fixes

* add missing entries to EuroVoc ([7379780](https://github.com/italia/pa-website-validator/commit/7379780ee5c18e4618a61e0f9c077739f536c8f6))
* aggiornamento label per audit scuole ([0abfaac](https://github.com/italia/pa-website-validator/commit/0abfaacdcc40b365f6d2fb661997cdb85be7a6e5))
* audit accessibilità ([af9d4be](https://github.com/italia/pa-website-validator/commit/af9d4be0d615b60a94c8ddd6d88cb6709a485c7a))
* build url negli url di servizi ([5422303](https://github.com/italia/pa-website-validator/commit/5422303b7ff57de1a06e4c930ae34e0e35125a87))
* caricamento pagine custom ([c633a23](https://github.com/italia/pa-website-validator/commit/c633a234ea32d3b27ae1c2913ed01498c86ac725))
* caricamento pagine di prenotazione appuntamenti dalla pagina di primo livello servizi, bugfix ([97cb585](https://github.com/italia/pa-website-validator/commit/97cb585ecf0a3cb380d817c8f669a97237aba07e))
* condizione gialla per vocabolari controllati ([0ebac69](https://github.com/italia/pa-website-validator/commit/0ebac69f931713dcc5d2db98f5418eaebb6673cd))
* config audit per comuni ([d3f9c9d](https://github.com/italia/pa-website-validator/commit/d3f9c9d2832e4849f79e480b18d40b079e1c66a2))
* css classes ([0eb9e11](https://github.com/italia/pa-website-validator/commit/0eb9e1174be7fc9e7c4f67af0e61c538a2761eba))
* fix messaggi errati audit ([515769a](https://github.com/italia/pa-website-validator/commit/515769afb19c8b15e60126ed5bb02c6226807905))
* fix minori ([43f5471](https://github.com/italia/pa-website-validator/commit/43f5471ac4b94daa2e3466011008ec93b416229c))
* fix sui messaggi di errore ([8935bad](https://github.com/italia/pa-website-validator/commit/8935badec2e6a26a431e397f1dc2b35eacde80fe))
* label ([fe41535](https://github.com/italia/pa-website-validator/commit/fe415350e5524553f172118b269b1fc70ca246e1))
* look for `&lt;a&gt;` tags instead of `<li>` in C.SC.1.5 ([95cadba](https://github.com/italia/pa-website-validator/commit/95cadba143b64712cdb4e3680ab24b4832b516a3))
* messaggio rosso audit di cookies ([1389ad1](https://github.com/italia/pa-website-validator/commit/1389ad128a51bd0844ae5022b89068dded3d0f69))
* messaggio rosso audit licenza e attribuzione e static checks ([2e1ca63](https://github.com/italia/pa-website-validator/commit/2e1ca636b4993e26c121f4ae35d79c1653cd6f05))
* minor ([cb6bf73](https://github.com/italia/pa-website-validator/commit/cb6bf730c34f7daf91a9f27b757427429a0c112b))
* minor fix ([09c59db](https://github.com/italia/pa-website-validator/commit/09c59dbe02260003fe382dfed9aada5dd7ba8ba7))
* modifica della scrittura dei risultati per audit appuntamenti ([24ebf64](https://github.com/italia/pa-website-validator/commit/24ebf6470d2a5e514bcf45516667939d3a0f5f4a))
* modifica di accuracy da max to high, modifica del valore del suggested a 5 pagine, aggiornamento readme, set di accuracy dentro il metodo run ([5e0b720](https://github.com/italia/pa-website-validator/commit/5e0b720192644c7c5bccbbd3f0d8ed61a59343dd))
* modifica messaggi di errore per audits dello strumento di valutazione ([e7278ad](https://github.com/italia/pa-website-validator/commit/e7278adbc8085c53bda2f01cca8071c1fade1d59))
* modifica messaggio di errore per audit di accessibilità per comuni ([ef91c0d](https://github.com/italia/pa-website-validator/commit/ef91c0d55c97d0f1c00811e5864b912a0baab625))
* modificata la descrizione ([1469402](https://github.com/italia/pa-website-validator/commit/14694020a8ceadfae4def65363cab7f9defe0f8f))
* modifiche di caricamento delle pagine di terzo livello per eventi ([8b666d1](https://github.com/italia/pa-website-validator/commit/8b666d1d0167fc76bdfacd8166fbef3b01bef808))
* modifiche labels ([7580332](https://github.com/italia/pa-website-validator/commit/7580332dbf04c87b9ba466d48190eb616df8d066))
* non esecuzione per audit menu primo livello scuole ([3dd50f9](https://github.com/italia/pa-website-validator/commit/3dd50f95b380e9c6c0842d9a7ee5138732301d4f))
* ordinamento risultato, colonna si nasconde se non ci sono risultati, label per menu secondo livello ([62da1a1](https://github.com/italia/pa-website-validator/commit/62da1a1fdb81743de32e3d05139c82cd2a7402b0))
* rimozione campo 'Elemento controllato' in audit CMS ([643f7ff](https://github.com/italia/pa-website-validator/commit/643f7ffdb33883fd0c8dc31da6df68962c0ba32c))
* rinominazione metodi di utils ([7c401c4](https://github.com/italia/pa-website-validator/commit/7c401c49e2ab816a20002a7e2dd8ed7331272760))
* show correct failure message in C.SI.2.1 ([7ad4bf8](https://github.com/italia/pa-website-validator/commit/7ad4bf8e21608cee7b0c5663f1f7969a7792e4c3))
* sistemazione configurazioni e static checks ([52cc3d3](https://github.com/italia/pa-website-validator/commit/52cc3d3c1b599108d3e32c8200385a6ab4e6b2c0))
* static checks ([9c7e0e0](https://github.com/italia/pa-website-validator/commit/9c7e0e0bf0517d05b11ec55158376c86cc70935a))
* static checks ([e4dae58](https://github.com/italia/pa-website-validator/commit/e4dae58bcedcbda677d39ad0a9183dfa518a36e2))
* static checks ([3bef635](https://github.com/italia/pa-website-validator/commit/3bef63539d783c5c5284007ae382d2680dbe3135))
* static checks ([4cf9015](https://github.com/italia/pa-website-validator/commit/4cf901571416cde273c9e57c222b2ae53a7b1b72))
* static checks ([17740eb](https://github.com/italia/pa-website-validator/commit/17740eb725ee2849ceeee73abf11e7ef94647db5))
* static checks ([d95e00b](https://github.com/italia/pa-website-validator/commit/d95e00beff0def4030852e302151ed5ecb1d7aab))
* static checks e refactoring codice ([f08591f](https://github.com/italia/pa-website-validator/commit/f08591f4ccb0484ca9bbf3367f6e560ba6178b84))
* update C.SI.1.4 audit description ([ca20a9e](https://github.com/italia/pa-website-validator/commit/ca20a9e50ee690c4bdd042aec9cad88da539ee1d))
* voci di secondo livello per comuni ([e702141](https://github.com/italia/pa-website-validator/commit/e702141c01b902b00fca0f6f313376dba8d48af0))


### Miscellaneous Chores

* merge work on new features ([f745703](https://github.com/italia/pa-website-validator/commit/f745703516f15e2a05c3be1c7438bc5acd7cbbee))

## [1.1.0](https://github.com/italia/pa-website-validator/compare/v1.0.13...v1.1.0) (2022-12-07)


### Features

* cache loadPageData ([#71](https://github.com/italia/pa-website-validator/issues/71)) ([b72b188](https://github.com/italia/pa-website-validator/commit/b72b1886ce7a7ab81069adf7d7d0f411d945a555))
* verify fonts on all headers and paragraphs ([1cebac3](https://github.com/italia/pa-website-validator/commit/1cebac39fb255064c2597625a3213d0fda05cf70))


### Bug Fixes

* calculation of the 30% of the schools' second level menu items ([177008a](https://github.com/italia/pa-website-validator/commit/177008a6edb7d55ffffab0c24b6813d582902ae3))
* change percentage calculation in C.SC.1.5 ([#128](https://github.com/italia/pa-website-validator/issues/128)) ([c0ce054](https://github.com/italia/pa-website-validator/commit/c0ce054871eec4b907ce25d8cb3d7bbbeb1f5b30))
* check full CSS comment header in CMS theme version audit ([34e4822](https://github.com/italia/pa-website-validator/commit/34e482228bc33bf88fa652613d41a0b3e8926c40))
* don’t count header in C.SC.1.5 ([a45f981](https://github.com/italia/pa-website-validator/commit/a45f9810ad10ab6e6cd5f740f062b958f309fb79))
* remove C.SE.5.1 and C.SE.5.2 ([c0ce054](https://github.com/italia/pa-website-validator/commit/c0ce054871eec4b907ce25d8cb3d7bbbeb1f5b30))
* remove item position check in C.SC.1.5 ([c0ce054](https://github.com/italia/pa-website-validator/commit/c0ce054871eec4b907ce25d8cb3d7bbbeb1f5b30))
* typos in domain list ([188843c](https://github.com/italia/pa-website-validator/commit/188843c7e75740dad985769be4b6d56619816019))
* update audit messages ([d00a07a](https://github.com/italia/pa-website-validator/commit/d00a07a4343749faac9e253ff72c500fa9edab79))
* wait until page is completely loaded ([6756449](https://github.com/italia/pa-website-validator/commit/6756449240c89a4976bfd8dcf7e2f61f9b322788))

## [1.0.13](https://github.com/italia/pa-website-validator/compare/v1.0.12...v1.0.13) (2022-11-11)


### Bug Fixes

* modifica prelievo url di scansione da origin a href ([10da2ea](https://github.com/italia/pa-website-validator/commit/10da2ea2625162bd7bfdddfbd2ae87c2e9032bab))

## [1.0.12](https://github.com/italia/pa-website-validator/compare/v1.0.11...v1.0.12) (2022-11-10)


### Bug Fixes

* aggiunto user-agent header versione tema comuni ([585d7db](https://github.com/italia/pa-website-validator/commit/585d7dba3f8adb97afc24dfcf158304cac998236))
* C.SI.1.3 “Categoria del servizio” ([799b6f8](https://github.com/italia/pa-website-validator/commit/799b6f811e533abe78e95da9a6f99512c359121a))
* fix hostname in verifica esistenza url ([359f9a3](https://github.com/italia/pa-website-validator/commit/359f9a37e0f7b6492749dc4ebde083fc679b5735))
* integrazione Axios per verifica esistenza url ([f0fbde5](https://github.com/italia/pa-website-validator/commit/f0fbde5a9bb5c729959aab201ec09082ac447778))

## [1.0.11](https://github.com/italia/pa-website-validator/compare/v1.0.10...v1.0.11) (2022-11-10)


### Bug Fixes

* aggiunto header user-agent nelle request per retrieve CSS ([a8ca690](https://github.com/italia/pa-website-validator/commit/a8ca690922a8abc74caa5e4b41d92c063d1d1490))
* C.SC.1.5 “I luoghi” ([b17f4e7](https://github.com/italia/pa-website-validator/commit/b17f4e7ad711e8120286a64a3faf1619c443b76a))
* C.SC.1.5 “Le persone” ([19e3a25](https://github.com/italia/pa-website-validator/commit/19e3a25183d89f846640d981e9dc2030d9e0e098))
* C.SC.1.5 order ([35a4e63](https://github.com/italia/pa-website-validator/commit/35a4e63e5e48d9785c9d49266343638c0f8bd0bf))
* C.SI.1.6 “Vivere [nome del Comune]” ([f9d169b](https://github.com/italia/pa-website-validator/commit/f9d169b42a41899c0b1b9edeac88755c06e19edf))
* C.SI.2.1 warning becomes a failure ([b63bba0](https://github.com/italia/pa-website-validator/commit/b63bba04275a315610cc8066e4d14d553b7b807e))
* C.SI.2.4 allow “mailto:” ([b9b7ccc](https://github.com/italia/pa-website-validator/commit/b9b7ccc93da7a0f35dc4b691f18f9c07bef33b0d))
* follow redirects ([16bc98a](https://github.com/italia/pa-website-validator/commit/16bc98aad0bf407f91306d906193e1faa00c3208))
* report if no CMS theme is used ([c86d92a](https://github.com/italia/pa-website-validator/commit/c86d92a7856a5b70824bf2dce3313c664e4567ac))
* show name of detected CMS ([8bb45b6](https://github.com/italia/pa-website-validator/commit/8bb45b67957dc8051124f5ff54bea0943c02a771))
* suite di cifratura aggiornati con standardName ([9b98564](https://github.com/italia/pa-website-validator/commit/9b98564e1d18980c547ab29a5f67392366f8bd68))
