ts_styleguide_prompts = {
    "project_structure": """
    Желаемая структура в директории src:
    1) Adapters
    Адаптеры для компонентов помещаются в каталог с названием компонента.
    2) API 
    Содержит функции получение данных. ДОЛЖЕН содержать запросы API или подписки RabbitMQ
    3) App 
    Основной компонент приложения, точка входа.
    4) Assets
    Необязательно. Может использоваться для хранения вспомогательных элементов приложения
    (изображения, шрифты). Нельзя использовать для хранения контента не относящегося к интерфейсу.
    Нельзя хранить SVG иконки
    5) Components
    Содержит компоненты приложения в предметной области UI
    6) Containers
    Содержит компоненты приложения в предметной области приложения.
    7) Facades
    Содержит универсальные хуки: предоставляющие взаимодействие с одним разделом модели.
    8) Mock
    Содержит файлы конфигурации Mock-сервера. В качестве Mock-сервера МОГУТ выступать: json-server, для него используются файлы формата *.json ; Swagger, с форматом *.yaml | *.yml.
    9) Models
    Общее состояние приложения
    10) Pages
    Содержит компоненты представляющие один экран
    11) Shared
    Содержит общие типы для всего приложения. Общие утилиты.
    12) index.css
    Глобальные стили приложения
    13) main.tsx
    Точка входа в приложение
    14) routing.tsx
    Конфигурация маршрутизации
    """,
    "naming": """
    Не должно быть однобуквенных имен переменных.
    В названиях переменных не должно быть аббревиатур.
    Имена переменных должны быть осмысленными.
    Функции обработки событий должны начинаться с глагола handle, нельзя использовать on
    Именования атрибутов компонента должны быть прилагательными или существительными и отвечать на вопрос «Что?», «Какой?».
    PascalCase - используется в названиях компонентов, классов, типов, интерфейсов, enum
    camelCase - используется в названиях функций, методов, переменных
    snake_case - используется в типах представляющих ответ API, в названиях CSS селекторов
    UPPER_SNAKE_CASE - используется для констант, которые используются как определения. Содержат не вычисленные значения.
    #ident - Приватные идентификаторы никогда не используются.
    Идентификаторы не должны использовать $, за исключением случаев, когда требуется соглашение об именах для третьих сторон.
    Параметры типа, такие как в Array<T>, могут использовать один заглавный символ (T) или UpperCamelCase.
    Идентификаторы не должны использовать _ как префикс или суффикс.
    """,
    "file_structure": """
    Файлы состоят из элементов, расположенных в следующем порядке::
    1) Информация об авторских правах, если присутствует
    2) JSDoc с @fileoverview, если присутствует
    3) Импорт, если присутствует
    4) Реализация файла
    Ровно одна пустая строка отделяет каждый присутствующий раздел.
    """,
    "imports": """
    Нужно использовать относительные импорты (./foo), а не абсолютные path/to/foo при обращении к файлам внутри одного и того же проекта.
    Используйте named import для символов, часто используемых в файле, или для символов с понятными названиями
    Используйтеnamespace imports при использовании множества различных символов из больших API
    Используйте names exports во всем коде
    Не используйте default exports
    """,
    "general": """
    Всегда используйте const или let для объявления переменных. По умолчанию используйте const, если только переменная не нуждается в переназначении. Никогда не используйте var.
    Каждое объявление локальной переменной объявляет только одну переменную: такие объявления, как let a = 1, b = 2;, не используются.
    Не используйте конструктор Array(), вместо этого используйте []
    Не используйте конструктор Object(), вместо этого используйте {}
    Избегайте присваивания переменных внутри управляющих операторов
    Используйте for (... of someArr) для итерации по массивам. Использование Array.prototype.forEach и чистый for loop также разрешено
    Все switch операторы должны содержать default group, даже если она не содержит кода. Default group по умолчанию должна быть последней.
    Всегда используйте тройное равенство (===) и не используйте неравенство (!==).
    Type assertions должны использовать синтаксис as вместо синтаксиса угловых скобок.
    Не определяйте новые декораторы. Используйте только декораторы, определенные в рамках фреймворков
    TypeScript код не должен создавать обертки для примитивных типов
    Код не должен использовать const enum; используйте простой enum вместо.
    Инструкции отладчика не должны включаться в код для производства.
    Не используйте ключевое слово with
    Не используйте non-standard ECMAScript или Web Platform features.
    """,
    "classes": """
    Объявления классов не должны заканчиваться точкой с запятой
    В объявлениях методов класса не должно использоваться точка с запятой для разделения отдельных объявлений методов
    Объявления методов должны быть отделены от окружающего кода одной пустой строкой
    Избегайте private static методов
    Нельзя использовать this в статическом контексте
    При вызове конструктора должны использоваться круглые скобки, даже если аргументы не передаются
    Конструктор должен быть отделен от окружающего кода сверху и снизу одной пустой строкой
    Не используйте private fields (также известные как private identifiers)
    Отмечайте свойства, которые никогда не переназначаются вне конструктора с помощью модификатора readonly
    Если член класса не является параметром, инициализируйте его там, где он объявлен
    Getters не должны изменять наблюдаемое состояние
    """,
    "functions": """
    Используйте объявления функций вместо стрелочных функций
    Функции, вложенные в другие методы или функции, могут использовать объявления функций или стрелочные функции, как уместно. В методах телах, в частности, стрелочные функции предпочтительнее.
    Не используйте function expressions. Используйте стрелочные функции вместо этого.
    Обработчики событий могут использовать стрелочные функции, когда нет необходимости удалять обработчик
    Используйте rest параметр вместо доступа к arguments
    Никогда не называйте локальную переменную или параметр arguments
    Никогда не используйте this для доступа к глобальному объекту, контексту eval, цели события или не нужным вызовам или apply()
    """,
    "exceptions": """
    Всегда используйте new Error() при создании исключений, вместо простого вызова Error()
    Только бросайте исключения, не используйте Promise.reject
    При обработке ошибок код должен предполагать, что все брошенные ошибки являются экземплярами Error.
    Исключения не должны защитно обрабатываться, если не известно, что вызываемый API бросает исключения, нарушающие вышеуказанное правило
    Пустые блоки catch запрещены
    """,
    "types": """
    Не указывайте типы для тривиально выводимых типов: переменные или параметры, инициализированные строкой, числом, логическим значением, литералом RegExp или выражением new.
    Указывайте типы возвращаемых значений для всех функций.
    Псевдонимы типов не должны включать |null или |undefined в объединенный тип
    Используйте интерфейсы для определения структурных типов, а не классы
    При объявлении типов для объектов используйте интерфейсы вместо псевдонима типа.
    В TypeScript, предоставьте значимое название для ключа.
    Никогда не используйте тип any.
    Используйте тип tuple вместо Pair type.
    Никогда не используйте типы String, Boolean, Number. Используйте lowercase версии: string, boolean, number.
    """,
}
