import { useAntdThemeToken } from "@/hooks"
import { css } from "@emotion/react"
import { memo } from "react"

interface AdminLogoProps {
    size?: number
    colorful?: boolean
}

function AdminLogo(props: AdminLogoProps) {
    const { size = 50, colorful = false } = props
    const { colorPrimary } = useAntdThemeToken()
    return (
        <div
            css={css`
                color: ${colorful ? colorPrimary : "#333"};
                .dark & {
                    color: ${colorful ? colorPrimary : "#f1f1f1"};
                }
            `}
        >
            <svg
                version="1.0"
                xmlns="http://www.w3.org/2000/svg"
                width={size + "px"}
                height={size + "px"}
                viewBox="0 0 300.000000 294.000000"
                preserveAspectRatio="xMidYMid meet"
                fill="currentColor"
            >
                <g
                    transform="translate(0.000000,294.000000) scale(0.100000,-0.100000)"
                    fill="currentColor"
                    stroke="none"
                >
                    <path d="M1305 2823 c-269 -34 -586 -199 -777 -403 -183 -195 -300 -430 -355 -715 -27 -143 -23 -349 12 -500 47 -209 128 -382 257 -552 196 -260 526 -457 865 -519 105 -19 325 -21 438 -5 267 39 535 171 716 350 181 181 316 439 370 709 26 125 30 329 10 457 -27 168 -132 438 -204 519 l-32 37 -67 -42 -67 -41 55 -110 c110 -219 150 -395 141 -613 -19 -435 -246 -797 -615 -980 -167 -83 -309 -115 -506 -115 -266 0 -493 73 -725 233 -74 51 -221 188 -221 206 0 12 51 18 320 36 118 8 386 27 595 41 389 27 538 31 636 19 54 -6 57 -6 92 28 49 45 54 105 14 164 -47 69 -126 72 -197 8 -23 -21 -40 -23 -225 -34 -295 -18 -781 -50 -1133 -76 -112 -9 -208 -13 -213 -10 -5 4 -16 19 -24 35 -17 32 -20 30 115 103 60 32 75 36 200 46 242 20 363 30 520 41 85 6 209 15 275 20 523 41 582 44 618 27 48 -23 88 -21 128 6 57 38 74 98 44 157 -38 74 -134 95 -195 43 -32 -26 -35 -27 -349 -49 -174 -13 -379 -27 -456 -33 -242 -19 -345 -24 -345 -18 0 3 19 17 43 30 23 13 98 55 167 94 l125 70 145 11 c483 37 468 37 517 12 132 -66 242 86 139 194 -51 55 -111 57 -176 7 -21 -16 -47 -21 -150 -26 -69 -3 -138 -8 -155 -10 -16 -2 -91 -7 -165 -11 -74 -4 -138 -9 -142 -10 -5 -1 -23 -2 -41 -3 -33 -1 -54 -12 -527 -286 -113 -65 -250 -144 -305 -176 -68 -39 -102 -54 -106 -46 -11 20 -43 156 -39 160 10 8 360 206 480 272 69 38 148 82 175 98 37 23 68 32 123 37 61 6 78 12 103 35 31 30 45 79 34 115 -13 42 -64 88 -105 95 -49 8 -105 -16 -125 -55 -10 -20 -65 -56 -192 -128 -98 -55 -249 -141 -336 -191 -87 -50 -163 -91 -168 -91 -23 0 16 226 63 370 62 190 219 417 374 540 261 208 592 297 912 245 102 -17 262 -65 333 -100 l46 -23 77 49 c42 27 76 53 76 58 0 16 -154 90 -261 125 -176 59 -285 76 -466 75 -87 -1 -171 -4 -188 -6z" />
                    <path d="M2497 2620 c-172 -29 -367 -136 -528 -288 -38 -35 -69 -60 -69 -54 0 19 -71 35 -137 29 -102 -8 -252 -91 -265 -146 -2 -11 8 -14 42 -12 61 2 155 -24 216 -61 49 -29 53 -34 63 -89 13 -66 7 -116 -20 -171 -11 -21 -19 -42 -19 -48 0 -32 139 17 213 76 61 47 107 122 107 174 0 23 9 28 103 58 157 50 274 119 382 227 73 73 99 107 133 175 53 109 54 125 5 134 -50 8 -166 6 -226 -4z m84 -122 c22 -41 -18 -81 -59 -59 -28 15 -34 49 -12 71 22 22 56 16 71 -12z m-136 -40 c15 -14 28 -38 32 -60 4 -30 1 -41 -20 -62 -74 -74 -192 36 -131 122 21 30 83 30 119 0z" />
                </g>
            </svg>
        </div>
    )
}

export default memo(AdminLogo)
