# Frontend

This is the frontend project for the application. It contains the HTML, CSS, and JavaScript files for the different pages.

## Project Structure

The project has the following structure:

```
frontend
├── css
│   └── styles.css
├── js
│   ├── home.js
│   ├── configuration.js
│   └── about.js
├── home.html
├── configuration.html
├── about.html
└── README.md
```

- `css/styles.css`: This file contains the styles for the frontend pages. It is used to apply consistent themes, colors, fonts, etc. to the pages.

- `js/home.js`: This file contains the JavaScript code for the home page. It handles the functionality of the navbar, podcasts panel, textbox, and generate button.

- `js/configuration.js`: This file contains the JavaScript code for the configuration page. It builds the configuration UI for the YAML configuration and handles the save button functionality.

- `js/about.js`: This file contains the JavaScript code for the about page. It does not have any specific functionality mentioned in the requirements.

- `home.html`: This file is the HTML template for the home page. It includes the navbar, title, podcasts panel, textbox, and generate button. It also includes the necessary CSS and JavaScript files.

- `configuration.html`: This file is the HTML template for the configuration page. It includes the title and the configuration UI for the YAML configuration. It also includes the necessary CSS and JavaScript files.

- `about.html`: This file is the HTML template for the about page. It includes the title and the text description. It also includes the necessary CSS and JavaScript files.

- `README.md`: This file contains the documentation for the frontend project. It provides information about the project structure and how to run or build the project.

## How to Run the Project

To run the frontend project, follow these steps:

1. Clone the repository.
2. Open the `home.html` file in a web browser to access the home page.
3. Use the navigation bar to navigate to different pages (home, configuration, about).
4. Interact with the different elements on each page as described in the requirements.

```

This file is intentionally left blank.