import pytest
from openlibrary.utils.lccn import normalize_lccn


def test_normalize_lccn_prenormalized():
    prenormalized = '94200274'
    assert normalize_lccn(prenormalized) == prenormalized


lccns = [
    ('96-39190', '96039190'),
    ('agr 62000298', 'agr62000298'),
    ('agr 62-298', 'agr62000298'),
    ('agr62000298', 'agr62000298'),
    ('agr 62-298 Revised', 'agr62000298'),
]


# Cases from https://www.loc.gov/marc/lccn-namespace.html
lccns += [
    ('n78-89035', 'n78089035'),
    ('n 78890351 ', 'n78890351'),
    (' 85000002 ', '85000002'),
    ('85-2 ', '85000002'),
    ('2001-000002', '2001000002'),
    ('75-425165//r75', '75425165'),
    (' 79139101 /AC/r932', '79139101'),
]


@pytest.mark.parametrize('raw,norm', lccns)
def test_normalize_lccn(raw, norm):
    assert normalize_lccn(raw) == norm
