from socket import socket, AF_INET, SOCK_DGRAM, SOL_UDP, SO_BROADCAST
import re

re_loc = re.compile(r'^(ia\d+\.us\.archive\.org):(/\d+/items/(.*))$')


class FindItemError(Exception):
    pass


def find_item(ia):
    s = socket(AF_INET, SOCK_DGRAM, SOL_UDP)
    s.setblocking(1)
    s.settimeout(2.0)
    s.setsockopt(1, SO_BROADCAST, 1)
    s.sendto(ia, ('<broadcast>', 8010))
    for attempt in range(5):
        (loc, address) = s.recvfrom(1024)
        m = re_loc.match(loc)

        ia_host = m.group(1)
        ia_path = m.group(2)
        if m.group(3) == ia:
            return (ia_host, ia_path)
    raise FindItemError
