from .. import code
from io import StringIO
import web
import datetime


def test_tarindex_path():
    assert code.get_tarindex_path(0, "") == "items/covers_0000/covers_0000_00.index"
    assert (
        code.get_tarindex_path(0, "s") == "items/s_covers_0000/s_covers_0000_00.index"
    )
    assert (
        code.get_tarindex_path(0, "m") == "items/m_covers_0000/m_covers_0000_00.index"
    )
    assert (
        code.get_tarindex_path(0, "l") == "items/l_covers_0000/l_covers_0000_00.index"
    )

    assert code.get_tarindex_path(99, "") == "items/covers_0000/covers_0000_99.index"
    assert code.get_tarindex_path(100, "") == "items/covers_0001/covers_0001_00.index"

    assert code.get_tarindex_path(1, "") == "items/covers_0000/covers_0000_01.index"
    assert code.get_tarindex_path(21, "") == "items/covers_0000/covers_0000_21.index"
    assert code.get_tarindex_path(321, "") == "items/covers_0003/covers_0003_21.index"
    assert code.get_tarindex_path(4321, "") == "items/covers_0043/covers_0043_21.index"


def test_parse_tarindex():
    f = StringIO("")

    offsets, sizes = code.parse_tarindex(f)
    assert list(offsets) == [0 for i in range(10000)]
    assert list(sizes) == [0 for i in range(10000)]

    f = StringIO("0000010000.jpg\t0\t10\n0000010002.jpg\t512\t20\n")

    offsets, sizes = code.parse_tarindex(f)
    assert (offsets[0], sizes[0]) == (0, 10)
    assert (offsets[1], sizes[1]) == (0, 0)
    assert (offsets[2], sizes[2]) == (512, 20)
    assert (offsets[42], sizes[42]) == (0, 0)


class Test_cover:
    def test_get_tar_filename(self, monkeypatch):
        offsets = {}
        sizes = {}

        def _get_tar_index(index, size):
            array_offsets = [offsets.get(i, 0) for i in range(10000)]
            array_sizes = [sizes.get(i, 0) for i in range(10000)]
            return array_offsets, array_sizes

        monkeypatch.setattr(code, "get_tar_index", _get_tar_index)
        f = code.cover().get_tar_filename

        assert f(42, "s") is None

        offsets[42] = 1234
        sizes[42] = 567

        assert f(42, "s") == "s_covers_0000_00.tar:1234:567"
        assert f(30042, "s") == "s_covers_0000_03.tar:1234:567"

        d = code.cover().get_details(42, "s")
        assert isinstance(d, web.storage)
        assert d == {
            "id": 42,
            "filename_s": "s_covers_0000_00.tar:1234:567",
            "created": datetime.datetime(2010, 1, 1),
        }
