# Copyright 2022-2023 Intel Corporation.
#
# This software and the related documents are Intel copyrighted materials, and
# your use of them is governed by the express license under which they were
# provided to you ("License"). Unless the License provides otherwise, you may
# not use, modify, copy, publish, distribute, disclose or transmit this
# software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express
# or implied warranties, other than those that are expressly stated in
# the License.

include(compiler_source.cmake)

include(ProcessorCount)
ProcessorCount(PARALLEL_PROCESSES)

set(NPU_COMPILER_BINARY_DIR "${NPU_PLUGIN_PREFIX_DIR}/build-cid")
file(MAKE_DIRECTORY ${NPU_COMPILER_BINARY_DIR})

set(NPU_COMPILER_INCLUDE_DIR "${NPU_PLUGIN_SOURCE_DIR}/src/vpux_driver_compiler/include")
file(MAKE_DIRECTORY ${NPU_COMPILER_INCLUDE_DIR})

set(THREADING "TBB" CACHE STRING "Build NPU Compiler with specific THREADING option")

list(APPEND NPU_COMPILER_CMAKE_FLAGS -DCMAKE_TOOLCHAIN_FILE:FILEPATH=${CMAKE_TOOLCHAIN_FILE})
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DCMAKE_MAKE_PROGRAM:FILEPATH=${CMAKE_MAKE_PROGRAM})
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DBUILD_COMPILER_FOR_DRIVER=ON)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DBUILD_SHARED_LIBS=OFF)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DCMAKE_BUILD_TYPE=Release)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DENABLE_CLANG_FORMAT=OFF)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DENABLE_GAPI_PREPROCESSING=OFF)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DENABLE_HETERO=OFF)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DENABLE_INTEL_CPU=OFF)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DENABLE_INTEL_GNA=OFF)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DENABLE_INTEL_GPU=OFF)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DENABLE_IR_V7_READER=OFF)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DENABLE_MULTI=OFF)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DENABLE_OV_IR_FRONTEND=ON)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DENABLE_OV_ONNX_FRONTEND=OFF)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DENABLE_OV_PADDLE_FRONTEND=OFF)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DENABLE_OV_TF_FRONTEND=OFF)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DENABLE_OV_TF_LITE_FRONTEND=OFF)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DENABLE_PYTHON=OFF)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DENABLE_TEMPLATE=OFF)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DENABLE_TESTS=OFF)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DENABLE_WHEEL=OFF)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DENABLE_NCC_STYLE=OFF)
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DTHREADING=${THREADING})
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DOPENVINO_EXTRA_MODULES=${NPU_PLUGIN_SOURCE_DIR})
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DOUTPUT_ROOT=${NPU_COMPILER_BINARY_DIR})

# TODO: Temporary WA for building LLVM from plugin source
list(APPEND NPU_COMPILER_CMAKE_FLAGS -DLLVM_ENABLE_ZLIB=OFF)

# TODO: Temporary WA for buidling NPU tools that tries to find gflags dependency in system
list(APPEND NPU_COMPILER_CMAKE_FLAGS -Dgflags_DIR=${CMAKE_CURRENT_SOURCE_DIR}/openvino_modules)

ExternalProject_Add(
  npu_compiler_build
  DOWNLOAD_COMMAND ""
  DEPENDS npu_plugin_source openvino_source
  PREFIX ${OPENVINO_PREFIX_DIR}
  SOURCE_DIR ${OPENVINO_SOURCE_DIR}
  BINARY_DIR ${NPU_COMPILER_BINARY_DIR}
  CMAKE_ARGS ${NPU_COMPILER_CMAKE_FLAGS}
  BUILD_COMMAND
      ${CMAKE_COMMAND}
      --build ${NPU_COMPILER_BINARY_DIR}
      --target npu_driver_compiler
      --parallel ${PARALLEL_PROCESSES}
  INSTALL_COMMAND
    cp ${NPU_COMPILER_BINARY_DIR}/bin/intel64/Release/libnpu_driver_compiler.so
       ${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/
  BUILD_BYPRODUCTS
    ${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/libnpu_driver_compiler.so)

set(NPU_COMPILER_DEPENDENCY npu_compiler_build)
list(APPEND NPU_COMPILER_LIBS ${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/libnpu_driver_compiler.so)
